# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel

from databricks_jobs.models.sql_alert_output import SqlAlertOutput
from databricks_jobs.models.sql_dashboard_output import SqlDashboardOutput
from databricks_jobs.models.sql_query_output import SqlQueryOutput


class SqlOutput(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    query_output: Optional[SqlQueryOutput] = None
    dashboard_output: Optional[SqlDashboardOutput] = None
    alert_output: Optional[SqlAlertOutput] = None
    __properties = ["query_output", "dashboard_output", "alert_output"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SqlOutput:
        """Create an instance of SqlOutput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of query_output
        if self.query_output:
            _dict["query_output"] = self.query_output.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dashboard_output
        if self.dashboard_output:
            _dict["dashboard_output"] = self.dashboard_output.to_dict()
        # override the default output from pydantic by calling `to_dict()` of alert_output
        if self.alert_output:
            _dict["alert_output"] = self.alert_output.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SqlOutput:
        """Create an instance of SqlOutput from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SqlOutput.parse_obj(obj)

        _obj = SqlOutput.parse_obj(
            {
                "query_output": SqlQueryOutput.from_dict(obj.get("query_output"))
                if obj.get("query_output") is not None
                else None,
                "dashboard_output": SqlDashboardOutput.from_dict(
                    obj.get("dashboard_output")
                )
                if obj.get("dashboard_output") is not None
                else None,
                "alert_output": SqlAlertOutput.from_dict(obj.get("alert_output"))
                if obj.get("alert_output") is not None
                else None,
            }
        )
        return _obj
