# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field, StrictStr

from databricks_jobs.models.sql_task_alert import SqlTaskAlert
from databricks_jobs.models.sql_task_dashboard import SqlTaskDashboard
from databricks_jobs.models.sql_task_query import SqlTaskQuery


class SqlTask(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    query: Optional[SqlTaskQuery] = None
    dashboard: Optional[SqlTaskDashboard] = None
    alert: Optional[SqlTaskAlert] = None
    parameters: Optional[Dict[str, Any]] = Field(
        None,
        description="Parameters to be used for each run of this job. The SQL alert task does not support custom parameters.",
    )
    warehouse_id: StrictStr = Field(
        ...,
        description="The canonical identifier of the SQL warehouse. Only serverless and pro SQL warehouses are supported.",
    )
    __properties = ["query", "dashboard", "alert", "parameters", "warehouse_id"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SqlTask:
        """Create an instance of SqlTask from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of query
        if self.query:
            _dict["query"] = self.query.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dashboard
        if self.dashboard:
            _dict["dashboard"] = self.dashboard.to_dict()
        # override the default output from pydantic by calling `to_dict()` of alert
        if self.alert:
            _dict["alert"] = self.alert.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SqlTask:
        """Create an instance of SqlTask from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return SqlTask.parse_obj(obj)

        _obj = SqlTask.parse_obj(
            {
                "query": SqlTaskQuery.from_dict(obj.get("query"))
                if obj.get("query") is not None
                else None,
                "dashboard": SqlTaskDashboard.from_dict(obj.get("dashboard"))
                if obj.get("dashboard") is not None
                else None,
                "alert": SqlTaskAlert.from_dict(obj.get("alert"))
                if obj.get("alert") is not None
                else None,
                "parameters": obj.get("parameters"),
                "warehouse_id": obj.get("warehouse_id"),
            }
        )
        return _obj
