# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictStr


class TerminationParameter(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    username: Optional[StrictStr] = Field(
        None, description="The username of the user who terminated the cluster."
    )
    aws_api_error_code: Optional[StrictStr] = Field(
        None,
        description="The AWS provided error code describing why cluster nodes could not be provisioned. For example, `InstanceLimitExceeded` indicates that the limit of EC2 instances for a specific instance type has been exceeded. For reference, see: <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/query-api-troubleshooting.html>.",
    )
    aws_instance_state_reason: Optional[StrictStr] = Field(
        None,
        description="The AWS provided state reason describing why the driver node was terminated. For example, `Client.VolumeLimitExceeded` indicates that the limit of EBS volumes or total EBS volume storage has been exceeded. For reference, see <https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_StateReason.html>.",
    )
    aws_spot_request_status: Optional[StrictStr] = Field(
        None,
        description="Describes why a spot request could not be fulfilled. For example, `price-too-low` indicates that the max price was lower than the current spot price. For reference, see: <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html#spot-instance-bid-status-understand>.",
    )
    aws_spot_request_fault_code: Optional[StrictStr] = Field(
        None,
        description="Provides additional details when a spot request fails. For example `InsufficientFreeAddressesInSubnet` indicates the subnet does not have free IP addresses to accommodate the new instance. For reference, see <https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-spot-instance-requests.html>.",
    )
    aws_impaired_status_details: Optional[StrictStr] = Field(
        None,
        description="The AWS provided status check which failed and induced a node loss. This status may correspond to a failed instance or system check. For reference, see <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html>.",
    )
    aws_instance_status_event: Optional[StrictStr] = Field(
        None,
        description="The AWS provided scheduled event (for example reboot) which induced a node loss. For reference, see <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html>.",
    )
    aws_error_message: Optional[StrictStr] = Field(
        None,
        description="Human-readable context of various failures from AWS. This field is unstructured, and its exact format is subject to change.",
    )
    databricks_error_message: Optional[StrictStr] = Field(
        None,
        description="Additional context that may explain the reason for cluster termination. This field is unstructured, and its exact format is subject to change.",
    )
    inactivity_duration_min: Optional[StrictStr] = Field(
        None,
        description="An idle cluster was shut down after being inactive for this duration.",
    )
    instance_id: Optional[StrictStr] = Field(
        None, description="The ID of the instance that was hosting the Spark driver."
    )
    instance_pool_id: Optional[StrictStr] = Field(
        None, description="The ID of the instance pool the cluster is using."
    )
    instance_pool_error_code: Optional[StrictStr] = Field(
        None,
        description="The [error code](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/clusters#clusterterminationreasonpoolclusterterminationcode) for cluster failures specific to a pool.",
    )
    azure_error_code: Optional[StrictStr] = Field(
        None,
        description="The Azure provided error code describing why cluster nodes could not be provisioned. For reference, see: [https://docs.microsoft.com/azure/virtual-machines/windows/error-messages](https://docs.microsoft.com/azure/virtual-machines/windows/error-messages).",
    )
    azure_error_message: Optional[StrictStr] = Field(
        None,
        description="Human-readable context of various failures from Azure. This field is unstructured, and its exact format is subject to change.",
    )
    __properties = [
        "username",
        "aws_api_error_code",
        "aws_instance_state_reason",
        "aws_spot_request_status",
        "aws_spot_request_fault_code",
        "aws_impaired_status_details",
        "aws_instance_status_event",
        "aws_error_message",
        "databricks_error_message",
        "inactivity_duration_min",
        "instance_id",
        "instance_pool_id",
        "instance_pool_error_code",
        "azure_error_code",
        "azure_error_message",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TerminationParameter:
        """Create an instance of TerminationParameter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TerminationParameter:
        """Create an instance of TerminationParameter from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TerminationParameter.parse_obj(obj)

        _obj = TerminationParameter.parse_obj(
            {
                "username": obj.get("username"),
                "aws_api_error_code": obj.get("aws_api_error_code"),
                "aws_instance_state_reason": obj.get("aws_instance_state_reason"),
                "aws_spot_request_status": obj.get("aws_spot_request_status"),
                "aws_spot_request_fault_code": obj.get("aws_spot_request_fault_code"),
                "aws_impaired_status_details": obj.get("aws_impaired_status_details"),
                "aws_instance_status_event": obj.get("aws_instance_status_event"),
                "aws_error_message": obj.get("aws_error_message"),
                "databricks_error_message": obj.get("databricks_error_message"),
                "inactivity_duration_min": obj.get("inactivity_duration_min"),
                "instance_id": obj.get("instance_id"),
                "instance_pool_id": obj.get("instance_pool_id"),
                "instance_pool_error_code": obj.get("instance_pool_error_code"),
                "azure_error_code": obj.get("azure_error_code"),
                "azure_error_message": obj.get("azure_error_message"),
            }
        )
        return _obj
