# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import List, Optional

from pydantic import BaseModel, Field

from databricks_jobs.models.webhook_notifications_on_start_inner import (
    WebhookNotificationsOnStartInner,
)


class WebhookNotifications(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    on_start: Optional[List[WebhookNotificationsOnStartInner]] = Field(
        None,
        description="An optional list of notification IDs to call when the run starts. A maximum of 3 destinations can be specified for the `on_start` property.",
    )
    on_success: Optional[List[WebhookNotificationsOnStartInner]] = Field(
        None,
        description="An optional list of notification IDs to call when the run completes successfully. A maximum of 3 destinations can be specified for the `on_success` property.",
    )
    on_failure: Optional[List[WebhookNotificationsOnStartInner]] = Field(
        None,
        description="An optional list of notification IDs to call when the run fails. A maximum of 3 destinations can be specified for the `on_failure` property.",
    )
    __properties = ["on_start", "on_success", "on_failure"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WebhookNotifications:
        """Create an instance of WebhookNotifications from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in on_start (list)
        _items = []
        if self.on_start:
            for _item in self.on_start:
                if _item:
                    _items.append(_item.to_dict())
            _dict["on_start"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in on_success (list)
        _items = []
        if self.on_success:
            for _item in self.on_success:
                if _item:
                    _items.append(_item.to_dict())
            _dict["on_success"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in on_failure (list)
        _items = []
        if self.on_failure:
            for _item in self.on_failure:
                if _item:
                    _items.append(_item.to_dict())
            _dict["on_failure"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WebhookNotifications:
        """Create an instance of WebhookNotifications from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return WebhookNotifications.parse_obj(obj)

        _obj = WebhookNotifications.parse_obj(
            {
                "on_start": [
                    WebhookNotificationsOnStartInner.from_dict(_item)
                    for _item in obj.get("on_start")
                ]
                if obj.get("on_start") is not None
                else None,
                "on_success": [
                    WebhookNotificationsOnStartInner.from_dict(_item)
                    for _item in obj.get("on_success")
                ]
                if obj.get("on_success") is not None
                else None,
                "on_failure": [
                    WebhookNotificationsOnStartInner.from_dict(_item)
                    for _item in obj.get("on_failure")
                ]
                if obj.get("on_failure") is not None
                else None,
            }
        )
        return _obj
