# Brief Introduction for "benco init base"


`benco init base` and `benco init` behave similarly. They both generate necessary training, testing, and robustness testing scripts in the current working directory. 

They also provide a `MyModel.py` file to demonstrate a typical development pattern.

Our design pattern encourages you to appropriately **modify** the training script to meet your **personalized needs**, as long as you understand the functionality of the code. Feel free to modify the Python and shell scripts generated by `benco init`!

## Quick Start
You can simply start training a single-layer convolutional model with the following command.

>Currently, you may need to properly configure the dataset according to the README on the [homepage](https://github.com/scu-zjz/IMDLBenCo) before it can run correctly.

```shell
sh train_mymodel.sh
```


Once the model is saved, you can test its performance and robustness with the following command.

```shell
sh test_mymodel.sh
```

```shell
sh test_robust_mymodel.sh
```