/*
 Highcharts JS v10.3.2 (2022-11-28)

 Boost module

 (c) 2010-2021 Highsoft AS
 Author: Torstein Honsi

 License: www.highcharts.com/license

*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/boost",["highcharts"],function(x){a(x);a.Highcharts=x;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function x(a,g,c,P){a.hasOwnProperty(g)||(a[g]=P.apply(null,c),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:g,module:a[g]}})))}a=a?a._modules:{};x(a,"Extensions/Boost/Boostables.js",
[],function(){return"area areaspline arearange column columnrange bar line scatter heatmap bubble treemap".split(" ")});x(a,"Extensions/Boost/BoostableMap.js",[a["Extensions/Boost/Boostables.js"]],function(a){var g={};a.forEach(function(a){g[a]=!0});return g});x(a,"Extensions/Boost/BoostChart.js",[a["Extensions/Boost/BoostableMap.js"],a["Core/Utilities.js"]],function(a,g){function c(b){var e=b.series,g=b.boost=b.boost||{},p=b.options.boost||{},c=F(p.seriesThreshold,50);if(e.length>=c)return!0;if(1===
e.length)return!1;p=p.allowForce;if("undefined"===typeof p)for(p=!0,c=0,b=b.xAxis;c<b.length;c++){var k=b[c];if(F(k.min,-Infinity)>F(k.dataMin,-Infinity)||F(k.max,Infinity)<F(k.dataMax,Infinity)){p=!1;break}}if("undefined"!==typeof g.forceChartBoost){if(p)return g.forceChartBoost;g.forceChartBoost=void 0}for(var t=c=b=0;t<e.length;t++){var G=e[t];k=G.options;0!==k.boostThreshold&&!1!==G.visible&&"heatmap"!==G.type&&(a[G.type]&&++b,u(G.processedXData,k.data,G.points)>=(k.boostThreshold||Number.MAX_VALUE)&&
++c)}g.forceChartBoost=p&&(b===e.length&&0<c||5<c);return g.forceChartBoost}function t(b){e(b,"predraw",function(){b.boost=b.boost||{};b.boost.forceChartBoost=void 0;b.boosted=!1;b.boost.clear&&b.boost.clear();b.boost.canvas&&b.boost.wgl&&c(b)&&b.boost.wgl.allocateBuffer(b);b.boost.markerGroup&&b.xAxis&&0<b.xAxis.length&&b.yAxis&&0<b.yAxis.length&&b.boost.markerGroup.translate(b.xAxis[0].pos,b.yAxis[0].pos)});e(b,"render",function(){b.boost&&b.boost.wgl&&c(b)&&b.boost.wgl.render(b)});var a=-1,g=-1;
e(b.pointer,"afterGetHoverData",function(){var e=b.hoverSeries;b.boost=b.boost||{};if(b.boost.markerGroup&&e){var u=b.inverted?e.yAxis:e.xAxis;e=b.inverted?e.xAxis:e.yAxis;if(u&&u.pos!==a||e&&e.pos!==g)b.boost.markerGroup.translate(u.pos,e.pos),a=u.pos,g=e.pos}})}function u(){for(var b=[],e=0;e<arguments.length;e++)b[e]=arguments[e];var a=-Number.MAX_VALUE;b.forEach(function(b){if("undefined"!==typeof b&&null!==b&&"undefined"!==typeof b.length&&0<b.length)return a=b.length,!0});return a}var e=g.addEvent,
F=g.pick,k=[];return{compose:function(b,e){e&&-1===k.indexOf(b)&&(k.push(b),b.prototype.callbacks.push(t));return b},getBoostClipRect:function(b,e){var a={x:b.plotLeft,y:b.plotTop,width:b.plotWidth,height:b.plotHeight};e===b&&(e=b.inverted?b.xAxis:b.yAxis,1>=e.length?(a.y=Math.min(e[0].pos,a.y),a.height=e[0].pos-b.plotTop+e[0].len):a.height=b.plotHeight);return a},isChartSeriesBoosting:c}});x(a,"Extensions/Boost/WGLDrawMode.js",[],function(){return{area:"LINES",arearange:"LINES",areaspline:"LINES",
column:"LINES",columnrange:"LINES",bar:"LINES",line:"LINE_STRIP",scatter:"POINTS",heatmap:"TRIANGLES",treemap:"TRIANGLES",bubble:"POINTS"}});x(a,"Extensions/Boost/WGLShader.js",[a["Core/Utilities.js"]],function(a){var g=a.clamp,c=a.error,t=a.pick;return function(){function a(a){this.errors=[];this.uLocations={};(this.gl=a)&&this.createShader()}a.prototype.bind=function(){this.gl&&this.shaderProgram&&this.gl.useProgram(this.shaderProgram)};a.prototype.createShader=function(){var a=this,g=this.stringToProgram("#version 100\n#define LN10 2.302585092994046\nprecision highp float;\nattribute vec4 aVertexPosition;\nattribute vec4 aColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform mat4 uPMatrix;\nuniform float pSize;\nuniform float translatedThreshold;\nuniform bool hasThreshold;\nuniform bool skipTranslation;\nuniform float xAxisTrans;\nuniform float xAxisMin;\nuniform float xAxisMinPad;\nuniform float xAxisPointRange;\nuniform float xAxisLen;\nuniform bool  xAxisPostTranslate;\nuniform float xAxisOrdinalSlope;\nuniform float xAxisOrdinalOffset;\nuniform float xAxisPos;\nuniform bool  xAxisCVSCoord;\nuniform bool  xAxisIsLog;\nuniform bool  xAxisReversed;\nuniform float yAxisTrans;\nuniform float yAxisMin;\nuniform float yAxisMinPad;\nuniform float yAxisPointRange;\nuniform float yAxisLen;\nuniform bool  yAxisPostTranslate;\nuniform float yAxisOrdinalSlope;\nuniform float yAxisOrdinalOffset;\nuniform float yAxisPos;\nuniform bool  yAxisCVSCoord;\nuniform bool  yAxisIsLog;\nuniform bool  yAxisReversed;\nuniform bool  isBubble;\nuniform bool  bubbleSizeByArea;\nuniform float bubbleZMin;\nuniform float bubbleZMax;\nuniform float bubbleZThreshold;\nuniform float bubbleMinSize;\nuniform float bubbleMaxSize;\nuniform bool  bubbleSizeAbs;\nuniform bool  isInverted;\nfloat bubbleRadius(){\nfloat value = aVertexPosition.w;\nfloat zMax = bubbleZMax;\nfloat zMin = bubbleZMin;\nfloat radius = 0.0;\nfloat pos = 0.0;\nfloat zRange = zMax - zMin;\nif (bubbleSizeAbs){\nvalue = value - bubbleZThreshold;\nzMax = max(zMax - bubbleZThreshold, zMin - bubbleZThreshold);\nzMin = 0.0;\n}\nif (value < zMin){\nradius = bubbleZMin / 2.0 - 1.0;\n} else {\npos = zRange > 0.0 ? (value - zMin) / zRange : 0.5;\nif (bubbleSizeByArea && pos > 0.0){\npos = sqrt(pos);\n}\nradius = ceil(bubbleMinSize + pos * (bubbleMaxSize - bubbleMinSize)) / 2.0;\n}\nreturn radius * 2.0;\n}\nfloat translate(float val,\nfloat pointPlacement,\nfloat localA,\nfloat localMin,\nfloat minPixelPadding,\nfloat pointRange,\nfloat len,\nbool  cvsCoord,\nbool  isLog,\nbool  reversed\n){\nfloat sign = 1.0;\nfloat cvsOffset = 0.0;\nif (cvsCoord) {\nsign *= -1.0;\ncvsOffset = len;\n}\nif (isLog) {\nval = log(val) / LN10;\n}\nif (reversed) {\nsign *= -1.0;\ncvsOffset -= sign * len;\n}\nreturn sign * (val - localMin) * localA + cvsOffset + \n(sign * minPixelPadding);\n}\nfloat xToPixels(float value) {\nif (skipTranslation){\nreturn value;// + xAxisPos;\n}\nreturn translate(value, 0.0, xAxisTrans, xAxisMin, xAxisMinPad, xAxisPointRange, xAxisLen, xAxisCVSCoord, xAxisIsLog, xAxisReversed);// + xAxisPos;\n}\nfloat yToPixels(float value, float checkTreshold) {\nfloat v;\nif (skipTranslation){\nv = value;// + yAxisPos;\n} else {\nv = translate(value, 0.0, yAxisTrans, yAxisMin, yAxisMinPad, yAxisPointRange, yAxisLen, yAxisCVSCoord, yAxisIsLog, yAxisReversed);// + yAxisPos;\nif (v > yAxisLen) {\nv = yAxisLen;\n}\n}\nif (checkTreshold > 0.0 && hasThreshold) {\nv = min(v, translatedThreshold);\n}\nreturn v;\n}\nvoid main(void) {\nif (isBubble){\ngl_PointSize = bubbleRadius();\n} else {\ngl_PointSize = pSize;\n}\nvColor = aColor;\nif (skipTranslation && isInverted) {\ngl_Position = uPMatrix * vec4(aVertexPosition.y + yAxisPos, aVertexPosition.x + xAxisPos, 0.0, 1.0);\n} else if (isInverted) {\ngl_Position = uPMatrix * vec4(yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, xToPixels(aVertexPosition.x) + xAxisPos, 0.0, 1.0);\n} else {\ngl_Position = uPMatrix * vec4(xToPixels(aVertexPosition.x) + xAxisPos, yToPixels(aVertexPosition.y, aVertexPosition.z) + yAxisPos, 0.0, 1.0);\n}\n}",
"vertex"),c=this.stringToProgram("precision highp float;\nuniform vec4 fillColor;\nvarying highp vec2 position;\nvarying highp vec4 vColor;\nuniform sampler2D uSampler;\nuniform bool isCircle;\nuniform bool hasColor;\nvoid main(void) {\nvec4 col = fillColor;\nvec4 tcol = texture2D(uSampler, gl_PointCoord.st);\nif (hasColor) {\ncol = vColor;\n}\nif (isCircle) {\ncol *= tcol;\nif (tcol.r < 0.0) {\ndiscard;\n} else {\ngl_FragColor = col;\n}\n} else {\ngl_FragColor = col;\n}\n}","fragment"),b=function(b){return a.gl.getUniformLocation(a.shaderProgram,
b)};if(!g||!c)return this.shaderProgram=!1,this.handleErrors(),!1;this.shaderProgram=this.gl.createProgram();this.gl.attachShader(this.shaderProgram,g);this.gl.attachShader(this.shaderProgram,c);this.gl.linkProgram(this.shaderProgram);if(!this.gl.getProgramParameter(this.shaderProgram,this.gl.LINK_STATUS))return this.errors.push(this.gl.getProgramInfoLog(this.shaderProgram)),this.handleErrors(),this.shaderProgram=!1;this.gl.useProgram(this.shaderProgram);this.gl.bindAttribLocation(this.shaderProgram,
0,"aVertexPosition");this.pUniform=b("uPMatrix");this.psUniform=b("pSize");this.fcUniform=b("fillColor");this.isBubbleUniform=b("isBubble");this.bubbleSizeAbsUniform=b("bubbleSizeAbs");this.bubbleSizeAreaUniform=b("bubbleSizeByArea");this.uSamplerUniform=b("uSampler");this.skipTranslationUniform=b("skipTranslation");this.isCircleUniform=b("isCircle");this.isInverted=b("isInverted");return!0};a.prototype.handleErrors=function(){this.errors.length&&c("[highcharts boost] shader error - "+this.errors.join("\n"))};
a.prototype.stringToProgram=function(a,g){var e=this.gl.createShader("vertex"===g?this.gl.VERTEX_SHADER:this.gl.FRAGMENT_SHADER);this.gl.shaderSource(e,a);this.gl.compileShader(e);return this.gl.getShaderParameter(e,this.gl.COMPILE_STATUS)?e:(this.errors.push("when compiling "+g+" shader:\n"+this.gl.getShaderInfoLog(e)),!1)};a.prototype.destroy=function(){this.gl&&this.shaderProgram&&(this.gl.deleteProgram(this.shaderProgram),this.shaderProgram=!1)};a.prototype.fillColorUniform=function(){return this.fcUniform};
a.prototype.getProgram=function(){return this.shaderProgram};a.prototype.pointSizeUniform=function(){return this.psUniform};a.prototype.perspectiveUniform=function(){return this.pUniform};a.prototype.reset=function(){this.gl&&this.shaderProgram&&(this.gl.uniform1i(this.isBubbleUniform,0),this.gl.uniform1i(this.isCircleUniform,0))};a.prototype.setBubbleUniforms=function(a,c,k,b){void 0===b&&(b=1);var e=a.options,u=Number.MAX_VALUE,p=-Number.MAX_VALUE;if(this.gl&&this.shaderProgram&&a.is("bubble")){var F=
a.getPxExtremes();u=t(e.zMin,g(c,!1===e.displayNegative?e.zThreshold:-Number.MAX_VALUE,u));p=t(e.zMax,Math.max(p,k));this.gl.uniform1i(this.isBubbleUniform,1);this.gl.uniform1i(this.isCircleUniform,1);this.gl.uniform1i(this.bubbleSizeAreaUniform,"width"!==a.options.sizeBy);this.gl.uniform1i(this.bubbleSizeAbsUniform,a.options.sizeByAbsoluteValue);this.setUniform("bubbleMinSize",F.minPxSize*b);this.setUniform("bubbleMaxSize",F.maxPxSize*b);this.setUniform("bubbleZMin",u);this.setUniform("bubbleZMax",
p);this.setUniform("bubbleZThreshold",a.options.zThreshold)}};a.prototype.setColor=function(a){this.gl&&this.shaderProgram&&this.gl.uniform4f(this.fcUniform,a[0]/255,a[1]/255,a[2]/255,a[3])};a.prototype.setDrawAsCircle=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isCircleUniform,a?1:0)};a.prototype.setInverted=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.isInverted,a)};a.prototype.setPMatrix=function(a){this.gl&&this.shaderProgram&&this.gl.uniformMatrix4fv(this.pUniform,
!1,a)};a.prototype.setPointSize=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1f(this.psUniform,a)};a.prototype.setSkipTranslation=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.skipTranslationUniform,!0===a?1:0)};a.prototype.setTexture=function(a){this.gl&&this.shaderProgram&&this.gl.uniform1i(this.uSamplerUniform,a)};a.prototype.setUniform=function(a,g){this.gl&&this.shaderProgram&&(a=this.uLocations[a]=this.uLocations[a]||this.gl.getUniformLocation(this.shaderProgram,
a),this.gl.uniform1f(a,g))};return a}()});x(a,"Extensions/Boost/WGLVertexBuffer.js",[],function(){return function(){function a(a,c,t){this.buffer=!1;this.iterator=0;this.vertAttribute=this.preAllocated=!1;this.components=t||2;this.dataComponents=t;this.gl=a;this.shader=c}a.prototype.allocate=function(a){this.iterator=-1;this.preAllocated=new Float32Array(4*a)};a.prototype.bind=function(){if(!this.buffer)return!1;this.gl.vertexAttribPointer(this.vertAttribute,this.components,this.gl.FLOAT,!1,0,0)};
a.prototype.build=function(a,c,t){var g;this.data=a||[];if(!(this.data&&0!==this.data.length||this.preAllocated))return this.destroy(),!1;this.components=t||this.components;this.buffer&&this.gl.deleteBuffer(this.buffer);this.preAllocated||(g=new Float32Array(this.data));this.buffer=this.gl.createBuffer();this.gl.bindBuffer(this.gl.ARRAY_BUFFER,this.buffer);this.gl.bufferData(this.gl.ARRAY_BUFFER,this.preAllocated||g,this.gl.STATIC_DRAW);this.vertAttribute=this.gl.getAttribLocation(this.shader.getProgram(),
c);this.gl.enableVertexAttribArray(this.vertAttribute);return!0};a.prototype.destroy=function(){this.buffer&&(this.gl.deleteBuffer(this.buffer),this.vertAttribute=this.buffer=!1);this.iterator=0;this.components=this.dataComponents||2;this.data=[]};a.prototype.push=function(a,c,t,u){this.preAllocated&&(this.preAllocated[++this.iterator]=a,this.preAllocated[++this.iterator]=c,this.preAllocated[++this.iterator]=t,this.preAllocated[++this.iterator]=u)};a.prototype.render=function(a,c,t){var g=this.preAllocated?
this.preAllocated.length:this.data.length;if(!this.buffer||!g)return!1;if(!a||a>g||0>a)a=0;if(!c||c>g)c=g;if(a>=c)return!1;this.gl.drawArrays(this.gl[t||"POINTS"],a/this.components,(c-a)/this.components);return!0};return a}()});x(a,"Extensions/Boost/WGLRenderer.js",[a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Extensions/Boost/WGLDrawMode.js"],a["Extensions/Boost/WGLShader.js"],a["Extensions/Boost/WGLVertexBuffer.js"]],function(a,g,c,x,u,e){var t=a.parse,k=g.doc,b=g.win,
P=c.isNumber,ta=c.isObject,p=c.merge,L=c.objectEach,M=c.pick,y={column:!0,columnrange:!0,bar:!0,area:!0,areaspline:!0,arearange:!0},G={scatter:!0,bubble:!0},z=["webgl","experimental-webgl","moz-webgl","webkit-3d"];return function(){function c(a){this.data=[];this.height=0;this.isInited=!1;this.markerData=[];this.series=[];this.textureHandles={};this.width=0;this.postRenderCallback=a;this.settings={pointSize:1,lineWidth:1,fillColor:"#AA00AA",useAlpha:!0,usePreallocated:!1,useGPUTranslations:!1,debug:{timeRendering:!1,
timeSeriesProcessing:!1,timeSetup:!1,timeBufferCopy:!1,timeKDTree:!1,showSkipSummary:!1}}}c.orthoMatrix=function(a,b){return[2/a,0,0,0,0,-(2/b),0,0,0,0,-2,0,-1,1,-1,1]};c.seriesPointCount=function(a){if(a.boosted){var l=!!a.options.stacking;var b=a.xData||a.options.xData||a.processedXData;l=(l?a.data:b||a.options.data).length;"treemap"===a.type?l*=12:"heatmap"===a.type?l*=6:y[a.type]&&(l*=2);return l}return 0};c.prototype.getPixelRatio=function(){return this.settings.pixelRatio||b.devicePixelRatio||
1};c.prototype.setOptions=function(a){"pixelRatio"in a||(a.pixelRatio=1);p(!0,this.settings,a)};c.prototype.allocateBuffer=function(a){var l=this.vbuffer,b=0;this.settings.usePreallocated&&(a.series.forEach(function(a){a.boosted&&(b+=c.seriesPointCount(a))}),l&&l.allocate(b))};c.prototype.allocateBufferForSingleSeries=function(a){var l=this.vbuffer,b=0;this.settings.usePreallocated&&(a.boosted&&(b=c.seriesPointCount(a)),l&&l.allocate(b))};c.prototype.clear=function(){var a=this.gl;a&&a.clear(a.COLOR_BUFFER_BIT|
a.DEPTH_BUFFER_BIT)};c.prototype.pushSeriesData=function(a,b){var l=this,c=this.data,e=this.settings,f=this.vbuffer,n=a.pointArrayMap&&"low,high"===a.pointArrayMap.join(","),q=a.chart,r=a.options,O=!!r.stacking,ea=r.data,d=a.xAxis.getExtremes(),T=d.min,g=d.max;d=a.yAxis.getExtremes();var k=d.min,u=d.max,p=a.xData||r.xData||a.processedXData,G=a.yData||r.yData||a.processedYData,z=a.zData||r.zData||a.processedZData,x=a.yAxis,M=a.xAxis,F=!p||0===p.length,H=r.connectNulls;d=a.points||!1;var v=O?a.data:
p||ea,W={x:Number.MAX_VALUE,y:0},Q={x:-Number.MAX_VALUE,y:0},h="undefined"===typeof q.index,m=y[a.type],Aa=r.zoneAxis||"y",ca=r.zones||!1,Y=r.threshold,da=this.getPixelRatio(),ua=a.chart.plotWidth,ha=!1,ia=!1,aa,U,ya=0,P=!1,D,A,I,ja,B=-1,S=!1,Z=!1,N,L=!1,ra=!1,C=!1,va=!1,wa=!0,sa=!0,K=!1,E=!1,ba=0;if(!(r.boostData&&0<r.boostData.length)){r.gapSize&&(E="value"!==r.gapUnit?r.gapSize*a.closestPointRange:r.gapSize);if(ca){var ka=[];ca.forEach(function(a,b){if(a.color){var h=t(a.color).rgba;h[0]/=255;
h[1]/=255;h[2]/=255;ka[b]=h;K||"undefined"!==typeof a.value||(K=h)}});K||(p=a.pointAttribs&&a.pointAttribs().fill||a.color,K=t(p).rgba,K[0]/=255,K[1]/=255,K[2]/=255)}q.inverted&&(ua=a.chart.plotHeight);a.closestPointRangePx=Number.MAX_VALUE;var V=function(a){a&&(b.colorData.push(a[0]),b.colorData.push(a[1]),b.colorData.push(a[2]),b.colorData.push(a[3]))},R=function(a,h,m,n,l){void 0===n&&(n=1);V(l);1===da||e.useGPUTranslations&&!b.skipTranslation||(a*=da,h*=da,n*=da);e.usePreallocated&&f?(f.push(a,
h,m?1:0,n),ba+=4):(c.push(a),c.push(h),c.push(m?da:0),c.push(n))},Ca=function(){b.segments.length&&(b.segments[b.segments.length-1].to=c.length||ba)},za=function(){b.segments.length&&b.segments[b.segments.length-1].from===(c.length||ba)||(Ca(),b.segments.push({from:c.length||ba}))},Da=function(a,h,b,f,m){V(m);R(a+b,h);V(m);R(a,h);V(m);R(a,h+f);V(m);R(a,h+f);V(m);R(a+b,h+f);V(m);R(a+b,h)};za();if(d&&0<d.length)b.skipTranslation=!0,b.drawMode="TRIANGLES",d[0].node&&d[0].node.levelDynamic&&d.sort(function(a,
h){if(a.node){if(a.node.levelDynamic>h.node.levelDynamic)return 1;if(a.node.levelDynamic<h.node.levelDynamic)return-1}return 0}),d.forEach(function(h){var b=h.plotY;if("undefined"!==typeof b&&!isNaN(b)&&null!==h.y&&h.shapeArgs){var f=h.shapeArgs;b=f.x;b=void 0===b?0:b;var m=f.y;m=void 0===m?0:m;var n=f.width;n=void 0===n?0:n;f=f.height;f=void 0===f?0:f;var l=q.styledMode?h.series.colorAttribs(h):l=h.series.pointAttribs(h);h=l["stroke-width"]||0;C=t(l.fill).rgba;C[0]/=255;C[1]/=255;C[2]/=255;a.is("treemap")&&
(h=h||1,U=t(l.stroke).rgba,U[0]/=255,U[1]/=255,U[2]/=255,Da(b,m,n,f,U),h/=2);a.is("heatmap")&&q.inverted&&(b=M.len-b,m=x.len-m,n=-n,f=-f);Da(b+h,m+h,n-2*h,f-2*h,C)}});else{for(d=function(){I=v[++B];if("undefined"===typeof I)return"continue";if(h)return"break";var f=ea&&ea[B];!F&&ta(f,!0)&&f.color&&(C=t(f.color).rgba,C[0]/=255,C[1]/=255,C[2]/=255);F?(D=I[0],A=I[1],v[B+1]&&(Z=v[B+1][0]),v[B-1]&&(S=v[B-1][0]),3<=I.length&&(ja=I[2],I[2]>b.zMax&&(b.zMax=I[2]),I[2]<b.zMin&&(b.zMin=I[2]))):(D=I,A=G[B],v[B+
1]&&(Z=v[B+1]),v[B-1]&&(S=v[B-1]),z&&z.length&&(ja=z[B],z[B]>b.zMax&&(b.zMax=z[B]),z[B]<b.zMin&&(b.zMin=z[B])));if(!H&&(null===D||null===A))return za(),"continue";Z&&Z>=T&&Z<=g&&(L=!0);S&&S>=T&&S<=g&&(ra=!0);n?(F&&(A=I.slice(1,3)),N=A[0],A=A[1]):O&&(D=I.x,A=I.stackY,N=A-I.y);null!==k&&"undefined"!==typeof k&&null!==u&&"undefined"!==typeof u&&(wa=A>=k&&A<=u);D>g&&Q.x<g&&(Q.x=D,Q.y=A);D<T&&W.x>T&&(W.x=D,W.y=A);if(null===A&&H)return"continue";if(null===A||!wa&&!L&&!ra)return za(),"continue";(Z>=T||D>=
T)&&(S<=g||D<=g)&&(va=!0);if(!va&&!L&&!ra)return"continue";E&&D-S>E&&za();if(ca){var l;ca.some(function(a,h){var b=ca[h-1];return"x"===Aa?"undefined"!==typeof a.value&&D<=a.value?(ka[h]&&(!b||D>=b.value)&&(l=ka[h]),!0):!1:"undefined"!==typeof a.value&&A<=a.value?(ka[h]&&(!b||A>=b.value)&&(l=ka[h]),!0):!1});C=l||K||C}if(!e.useGPUTranslations&&(b.skipTranslation=!0,D=M.toPixels(D,!0),A=x.toPixels(A,!0),D>ua&&"POINTS"===b.drawMode))return"continue";b.hasMarkers&&va&&!1!==ha&&(a.closestPointRangePx=Math.min(a.closestPointRangePx,
Math.abs(D-ha)));if(!e.useGPUTranslations&&!e.usePreallocated&&ha&&1>Math.abs(D-ha)&&ia&&1>Math.abs(A-ia))return e.debug.showSkipSummary&&++ya,"continue";if(m){aa=N;if(!1===N||"undefined"===typeof N)aa=0>A?A:0;n||O||(aa=Math.max(null===Y?k:Y,k));e.useGPUTranslations||(aa=x.toPixels(aa,!0));R(D,aa,0,0,C)}r.step&&!sa&&R(D,ia,0,2,C);R(D,A,0,"bubble"===a.type?ja||1:2,C);ha=D;ia=A;P=!0;sa=!1};B<v.length-1&&"break"!==d(););e.debug.showSkipSummary&&console.log("skipped points:",ya);d=function(a,h){e.useGPUTranslations||
(b.skipTranslation=!0,a.x=M.toPixels(a.x,!0),a.y=x.toPixels(a.y,!0));h?l.data=[a.x,a.y,0,2].concat(l.data):R(a.x,a.y,0,2)};P||!1===H||"line_strip"!==a.drawMode||(W.x<Number.MAX_VALUE&&d(W,!0),Q.x>-Number.MAX_VALUE&&d(Q))}Ca()}};c.prototype.pushSeries=function(a){var b=this.markerData,l=this.series,c=this.settings;0<l.length&&l[l.length-1].hasMarkers&&(l[l.length-1].markerTo=b.length);c.debug.timeSeriesProcessing&&console.time("building "+a.type+" series");b={segments:[],markerFrom:b.length,colorData:[],
series:a,zMin:Number.MAX_VALUE,zMax:-Number.MAX_VALUE,hasMarkers:a.options.marker?!1!==a.options.marker.enabled:!1,showMarkers:!0,drawMode:x[a.type]||"LINE_STRIP"};a.index>=l.length?l.push(b):l[a.index]=b;this.pushSeriesData(a,b);c.debug.timeSeriesProcessing&&console.timeEnd("building "+a.type+" series")};c.prototype.flush=function(){var a=this.vbuffer;this.data=[];this.markerData=[];this.series=[];a&&a.destroy()};c.prototype.setXAxis=function(a){var b=this.shader;if(b){var c=this.getPixelRatio();
b.setUniform("xAxisTrans",a.transA*c);b.setUniform("xAxisMin",a.min);b.setUniform("xAxisMinPad",a.minPixelPadding*c);b.setUniform("xAxisPointRange",a.pointRange);b.setUniform("xAxisLen",a.len*c);b.setUniform("xAxisPos",a.pos*c);b.setUniform("xAxisCVSCoord",!a.horiz);b.setUniform("xAxisIsLog",!!a.logarithmic);b.setUniform("xAxisReversed",!!a.reversed)}};c.prototype.setYAxis=function(a){var b=this.shader;if(b){var c=this.getPixelRatio();b.setUniform("yAxisTrans",a.transA*c);b.setUniform("yAxisMin",
a.min);b.setUniform("yAxisMinPad",a.minPixelPadding*c);b.setUniform("yAxisPointRange",a.pointRange);b.setUniform("yAxisLen",a.len*c);b.setUniform("yAxisPos",a.pos*c);b.setUniform("yAxisCVSCoord",!a.horiz);b.setUniform("yAxisIsLog",!!a.logarithmic);b.setUniform("yAxisReversed",!!a.reversed)}};c.prototype.setThreshold=function(a,b){var c=this.shader;c&&(c.setUniform("hasThreshold",a),c.setUniform("translatedThreshold",b))};c.prototype.renderChart=function(b){var l=this,w=this.gl,k=this.settings,p=this.shader,
f=this.vbuffer,n=this.getPixelRatio();if(b)this.width=b.chartWidth*n,this.height=b.chartHeight*n;else return!1;var q=this.height,r=this.width;if(!(w&&p&&r&&q))return!1;k.debug.timeRendering&&console.time("gl rendering");w.canvas.width=r;w.canvas.height=q;p.bind();w.viewport(0,0,r,q);p.setPMatrix(c.orthoMatrix(r,q));1<k.lineWidth&&!g.isMS&&w.lineWidth(k.lineWidth);f&&(f.build(this.data,"aVertexPosition",4),f.bind());p.setInverted(b.inverted);this.series.forEach(function(c,g){var d=c.series.options,
r=d.marker,q="undefined"!==typeof d.lineWidth?d.lineWidth:1,O=d.threshold,u=P(O),z=c.series.yAxis.getThreshold(O);O=M(d.marker?d.marker.enabled:null,c.series.xAxis.isRadial?!0:null,c.series.closestPointRangePx>2*((d.marker?d.marker.radius:10)||10));r=l.textureHandles[r&&r.symbol||c.series.symbol]||l.textureHandles.circle;if(0!==c.segments.length&&c.segments[0].from!==c.segments[0].to&&(r.isReady&&(w.bindTexture(w.TEXTURE_2D,r.handle),p.setTexture(r.handle)),b.styledMode?r=c.series.markerGroup&&c.series.markerGroup.getStyle("fill"):
(r="POINTS"===c.drawMode&&c.series.pointAttribs&&c.series.pointAttribs().fill||c.series.color,d.colorByPoint&&(r=c.series.chart.options.colors[g])),c.series.fillOpacity&&d.fillOpacity&&(r=(new a(r)).setOpacity(M(d.fillOpacity,1)).get()),r=t(r).rgba,k.useAlpha||(r[3]=1),"LINES"===c.drawMode&&k.useAlpha&&1>r[3]&&(r[3]/=10),"add"===d.boostBlending?(w.blendFunc(w.SRC_ALPHA,w.ONE),w.blendEquation(w.FUNC_ADD)):"mult"===d.boostBlending||"multiply"===d.boostBlending?w.blendFunc(w.DST_COLOR,w.ZERO):"darken"===
d.boostBlending?(w.blendFunc(w.ONE,w.ONE),w.blendEquation(w.FUNC_MIN)):w.blendFuncSeparate(w.SRC_ALPHA,w.ONE_MINUS_SRC_ALPHA,w.ONE,w.ONE_MINUS_SRC_ALPHA),p.reset(),0<c.colorData.length?(p.setUniform("hasColor",1),g=new e(w,p),g.build(c.colorData,"aColor",4),g.bind()):w.disableVertexAttribArray(w.getAttribLocation(p.getProgram(),"aColor")),p.setColor(r),l.setXAxis(c.series.xAxis),l.setYAxis(c.series.yAxis),l.setThreshold(u,z),"POINTS"===c.drawMode&&p.setPointSize(2*M(d.marker&&d.marker.radius,.5)*
n),p.setSkipTranslation(c.skipTranslation),"bubble"===c.series.type&&p.setBubbleUniforms(c.series,c.zMin,c.zMax,n),p.setDrawAsCircle(G[c.series.type]||!1),f)){if(0<q||"LINE_STRIP"!==c.drawMode)for(q=0;q<c.segments.length;q++)f.render(c.segments[q].from,c.segments[q].to,c.drawMode);if(c.hasMarkers&&O)for(p.setPointSize(2*M(d.marker&&d.marker.radius,5)*n),p.setDrawAsCircle(!0),q=0;q<c.segments.length;q++)f.render(c.segments[q].from,c.segments[q].to,"POINTS")}});k.debug.timeRendering&&console.timeEnd("gl rendering");
this.postRenderCallback&&this.postRenderCallback(this);this.flush()};c.prototype.render=function(a){var b=this;this.clear();if(a.renderer.forExport)return this.renderChart(a);this.isInited?this.renderChart(a):setTimeout(function(){b.render(a)},1)};c.prototype.setSize=function(a,b){var e=this.shader;!e||this.width===a&&this.height===b||(this.width=a,this.height=b,e.bind(),e.setPMatrix(c.orthoMatrix(a,b)))};c.prototype.init=function(a,b){var c=this,g=this.settings;this.isInited=!1;if(!a)return!1;g.debug.timeSetup&&
console.time("gl setup");for(var l=0;l<z.length&&!(this.gl=a.getContext(z[l],{}));++l);var f=this.gl;if(f)b||this.flush();else return!1;f.enable(f.BLEND);f.blendFunc(f.SRC_ALPHA,f.ONE_MINUS_SRC_ALPHA);f.disable(f.DEPTH_TEST);f.depthFunc(f.LESS);a=this.shader=new u(f);if(!a)return!1;this.vbuffer=new e(f,a);a=function(a,b){var n={isReady:!1,texture:k.createElement("canvas"),handle:f.createTexture()},e=n.texture.getContext("2d");c.textureHandles[a]=n;n.texture.width=512;n.texture.height=512;e.mozImageSmoothingEnabled=
!1;e.webkitImageSmoothingEnabled=!1;e.msImageSmoothingEnabled=!1;e.imageSmoothingEnabled=!1;e.strokeStyle="rgba(255, 255, 255, 0)";e.fillStyle="#FFF";b(e);try{f.activeTexture(f.TEXTURE0),f.bindTexture(f.TEXTURE_2D,n.handle),f.texImage2D(f.TEXTURE_2D,0,f.RGBA,f.RGBA,f.UNSIGNED_BYTE,n.texture),f.texParameteri(f.TEXTURE_2D,f.TEXTURE_WRAP_S,f.CLAMP_TO_EDGE),f.texParameteri(f.TEXTURE_2D,f.TEXTURE_WRAP_T,f.CLAMP_TO_EDGE),f.texParameteri(f.TEXTURE_2D,f.TEXTURE_MAG_FILTER,f.LINEAR),f.texParameteri(f.TEXTURE_2D,
f.TEXTURE_MIN_FILTER,f.LINEAR),f.bindTexture(f.TEXTURE_2D,null),n.isReady=!0}catch(ma){}};a("circle",function(a){a.beginPath();a.arc(256,256,256,0,2*Math.PI);a.stroke();a.fill()});a("square",function(a){a.fillRect(0,0,512,512)});a("diamond",function(a){a.beginPath();a.moveTo(256,0);a.lineTo(512,256);a.lineTo(256,512);a.lineTo(0,256);a.lineTo(256,0);a.fill()});a("triangle",function(a){a.beginPath();a.moveTo(0,512);a.lineTo(256,0);a.lineTo(512,512);a.lineTo(0,512);a.fill()});a("triangle-down",function(a){a.beginPath();
a.moveTo(0,0);a.lineTo(256,512);a.lineTo(512,0);a.lineTo(0,0);a.fill()});this.isInited=!0;g.debug.timeSetup&&console.timeEnd("gl setup");return!0};c.prototype.destroy=function(){var a=this.gl,b=this.shader,c=this.vbuffer;this.flush();c&&c.destroy();b&&b.destroy();a&&(L(this.textureHandles,function(b){b.handle&&a.deleteTexture(b.handle)}),a.canvas.width=1,a.canvas.height=1)};return c}()});x(a,"Extensions/Boost/BoostSeries.js",[a["Extensions/Boost/BoostableMap.js"],a["Extensions/Boost/Boostables.js"],
a["Extensions/Boost/BoostChart.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Utilities.js"],a["Extensions/Boost/WGLRenderer.js"]],function(a,g,c,x,u,e,F){function k(a,b){var h=b.boost;a&&h&&h.target&&h.canvas&&!ma(b.chart)&&a.allocateBufferForSingleSeries(b)}function b(a){return pa(a&&a.options&&a.options.boost&&a.options.boost.enabled,!0)}function t(a,b){var h=a.constructor,f=a.seriesGroup||b.group,c=a.chartWidth,m=a.chartHeight,e=a,n="undefined"!==typeof SVGForeignObjectElement;e=ma(a)?
a:b;var d=e.boost=e.boost||{};n=!1;Q||(Q=T.createElement("canvas"));d.target||(d.canvas=Q,a.renderer.forExport||!n?(e.renderTarget=d.target=a.renderer.image("",0,0,c,m).addClass("highcharts-boost-canvas").add(f),d.clear=function(){d.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},d.copy=function(){d.resize();d.target.attr({href:d.canvas.toDataURL("image/png")})}):(d.targetFo=a.renderer.createElement("foreignObject").add(f),
e.renderTarget=d.target=T.createElement("canvas"),d.targetCtx=d.target.getContext("2d"),d.targetFo.element.appendChild(d.target),d.clear=function(){d.target.width=d.canvas.width;d.target.height=d.canvas.height},d.copy=function(){d.target.width=d.canvas.width;d.target.height=d.canvas.height;d.targetCtx.drawImage(d.canvas,0,0)}),d.resize=function(){c=a.chartWidth;m=a.chartHeight;(d.targetFo||d.target).attr({x:0,y:0,width:c,height:m}).css({pointerEvents:"none",mixedBlendMode:"normal",opacity:1});e instanceof
h&&e.boost.markerGroup.translate(a.plotLeft,a.plotTop)},d.clipRect=a.renderer.clipRect(),(d.targetFo||d.target).clip(d.clipRect),e instanceof h&&(e.boost.markerGroup=e.renderer.g().add(f).translate(b.xAxis.pos,b.yAxis.pos)));d.canvas.width=c;d.canvas.height=m;d.clipRect&&d.clipRect.attr(O(a,e));d.resize();d.clear();d.wgl||(d.wgl=new F(function(a){a.settings.debug.timeBufferCopy&&console.time("buffer copy");d.copy();a.settings.debug.timeBufferCopy&&console.timeEnd("buffer copy")}),d.wgl.init(d.canvas)||
oa("[highcharts boost] - unable to init WebGL renderer"),d.wgl.setOptions(a.options.boost||{}),e instanceof h&&d.wgl.allocateBuffer(a));d.wgl.setSize(c,m);return d.wgl}function P(a){var b=a.points;if(b){var h=void 0,c=void 0;for(c=0;c<b.length;c+=1)(h=b[c])&&h.destroyElements&&h.destroyElements()}["graph","area","tracker"].forEach(function(b){var h=a[b];h&&(a[b]=h.destroy())});a.getZonesGraphs&&a.getZonesGraphs([["graph","highcharts-graph"]]).forEach(function(b){var h=a[b[0]];h&&(a[b[0]]=h.destroy())})}
function p(a,b,c,f,d,e){d=d||0;f=f||3E3;for(var h=d+f,m=!0;m&&d<h&&d<a.length;)m=b(a[d],d),++d;m&&(d<a.length?e?p(a,b,c,f,d,e):na.requestAnimationFrame?na.requestAnimationFrame(function(){p(a,b,c,f,d)}):setTimeout(p,0,a,b,c,f,d):c&&c())}function L(a){a.boost=a.boost||{getPoint:function(b){return l(a,b)}};var b=a.boost.altered=[];["allowDG","directTouch","stickyTracking"].forEach(function(c){b.push({prop:c,val:a[c],own:Object.hasOwnProperty.call(a,c)})});a.allowDG=!1;a.directTouch=!1;a.stickyTracking=
!0;a.finishedAnimating=!0;a.labelBySeries&&(a.labelBySeries=a.labelBySeries.destroy())}function M(a){var b=a.boost;b&&((b.altered||[]).forEach(function(b){b.own?a[b.prop]=b.val:delete a[b.prop]}),b.clear&&b.clear())}function y(a,b){var c=a.options,f=a.xAxis&&a.xAxis.options,d=a.yAxis&&a.yAxis.options;a=a.colorAxis&&a.colorAxis.options;return c.data.length>(c.boostThreshold||Number.MAX_VALUE)&&X(d.min)&&X(d.max)&&(!b||X(f.min)&&X(f.max))&&(!a||X(a.min)&&X(a.max))}function G(){var a=this,b=a.chart;
b.boost&&b.boost.markerGroup===a.markerGroup&&(a.markerGroup=null);b.hoverPoints&&(b.hoverPoints=b.hoverPoints.filter(function(b){return b.series===a}));b.hoverPoint&&b.hoverPoint.series===a&&(b.hoverPoint=null)}function z(){var a=this.boost;a&&a.canvas&&a.target&&(a.wgl&&a.wgl.clear(),a.clear&&a.clear())}function W(a){var b=a.boost;b&&b.canvas&&b.target&&b.wgl&&!ma(a.chart)&&b.wgl.render(a.chart)}function l(a,b){var c=a.options,f=a.xAxis,d=a.pointClass;if(b instanceof d)return b;c=a.xData||c.xData||
a.processedXData||!1;d=(new d).init(a,a.options.data[b.i],c?c[b.i]:void 0);d.category=pa(f.categories?f.categories[d.x]:d.x,d.x);d.dist=b.dist;d.distX=b.distX;d.plotX=b.plotX;d.plotY=b.plotY;d.index=b.i;d.percentage=b.percentage;d.isInside=a.isPointInside(d);return d}function ea(){function a(a,b){var c="undefined"===typeof d.index,h=!1,n=!0;if("undefined"===typeof a)return!0;if(!c){if(M){var q=a[0];var m=a[1]}else q=a,m=r[b];if(B)M&&(m=a.slice(1,3)),h=m[0],m=m[1];else if(G){q=a.x;m=a.stackY;h=m-a.y;
var g=a.percentage}y||(n=(m||0)>=T&&m<=v);if(null!==m&&q>=l&&q<=O&&n)if(a=f.toPixels(q,!0),w){if("undefined"===typeof E||a===J){B||(h=m);if("undefined"===typeof ba||m>K)K=m,ba=b;if("undefined"===typeof E||h<na)na=h,E=b}F&&a===J||("undefined"!==typeof E&&(m=e.toPixels(K,!0),H=e.toPixels(na,!0),V(a,m,ba,g),H!==m&&V(a,H,E,g)),E=ba=void 0,J=a)}else m=Math.ceil(e.toPixels(m,!0)),V(a,m,b,g)}return!c}var b=this,c=this.options||{},d=this.chart,f=this.xAxis,e=this.yAxis,n=c.xData||this.processedXData,r=c.yData||
this.processedYData,g=c.data,q=f.getExtremes(),l=q.min,O=q.max;q=e.getExtremes();var T=q.min,v=q.max,u={},w=!!this.sampling,z=!1!==c.enableMouseTracking;q=c.threshold;var B=this.pointArrayMap&&"low,high"===this.pointArrayMap.join(","),G=!!c.stacking,x=this.cropStart||0,y=this.requireSorting,M=!n,F="x"===c.findNearestPointBy,C=this.xData||this.options.xData||this.processedXData||!1;c=!1;var J,H=e.getThreshold(q),na,K,E,ba;c=t(d,this);d.boosted=!0;if(this.visible){(this.points||this.graph)&&P(this);
ma(d)?(this.markerGroup&&this.markerGroup!==d.boost.markerGroup&&this.markerGroup.destroy(),this.markerGroup=d.boost.markerGroup,this.boost&&this.boost.target&&(this.renderTarget=this.boost.target=this.boost.target.destroy())):(d.boost&&this.markerGroup===d.boost.markerGroup&&(this.markerGroup=void 0),this.markerGroup=this.plotGroup("markerGroup","markers",!0,1,d.seriesGroup));var ka=this.points=[],V=function(a,b,c,h){a=Math.ceil(a);qa=F?a:a+","+b;z&&!u[qa]&&(u[qa]=!0,d.inverted&&(a=f.len-a,b=e.len-
b),ka.push({x:C?C[x+c]:!1,clientX:a,plotX:a,plotY:b,i:x+c,percentage:h}))};this.buildKDTree=Fa;c&&(k(c,this),c.pushSeries(this),W(this));var R=c.settings;c=function(){Ga(b,"renderedCanvas");delete b.buildKDTree;b.buildKDTree();R.debug.timeKDTree&&console.timeEnd("kd tree building")};d.renderer.forExport||(R.debug.timeKDTree&&console.time("kd tree building"),p(G?this.data:n||g,a,c))}}function w(a){var b=this.series,c=this.plotX||0,d=this.plotY||0,f=b.chart.inverted;b.boosted&&f&&(this.plotX=b.yAxis.len-
d,this.plotY=b.xAxis.len-c);var e=a.apply(this,[].slice.call(arguments,1));b.boosted&&f&&(this.plotX=c,this.plotY=d);return e}function la(a){var b=!0;this.chart.options&&this.chart.options.boost&&(b="undefined"===typeof this.chart.options.boost.enabled?!0:this.chart.options.boost.enabled);if(!b||!this.boosted)return a.call(this);this.chart.boosted=!0;if(a=t(this.chart,this))k(a,this),a.pushSeries(this);W(this)}function xa(c,d,f){function e(c){var d=this.options.stacking&&("translate"===f||"generatePoints"===
f);this.boosted&&!d&&b(this.chart)&&"heatmap"!==this.type&&"treemap"!==this.type&&a[this.type]&&0!==this.options.boostThreshold?"render"===f&&this.renderCanvas&&this.renderCanvas():c.call(this)}H(c,f,e);"translate"===f&&["column","arearange","columnrange","heatmap","treemap"].forEach(function(a){d[a]&&H(d[a].prototype,f,e)})}function f(a){return this.boosted&&y(this)?{}:a.apply(this,[].slice.call(arguments,1))}function n(a,b){var c=b.plotX||0,d=b.plotY||0,f=this.chart.inverted;this.boosted&&f&&(b.plotX=
this.yAxis.len-d,b.plotY=this.xAxis.len-c);var e=a.apply(this,[].slice.call(arguments,1));this.boosted&&f&&(b.plotX=c,b.plotY=d);return e}function q(c){var d=this,f=this.options.data,e=function(a){return d.forceCrop?!1:ma(d.chart)||(a?a.length:0)>=(d.options.boostThreshold||Number.MAX_VALUE)};b(this.chart)&&a[this.type]?(e(f)&&"heatmap"!==this.type&&"treemap"!==this.type&&!this.options.stacking&&y(this,!0)||(c.apply(this,[].slice.call(arguments,1)),f=this.processedXData),(this.boosted=e(f))?(f=void 0,
this.options.data&&this.options.data.length&&(f=this.getFirstValidPoint(this.options.data),X(f)||Ha(f)||oa(12,!1,this.chart)),L(this)):M(this)):c.apply(this,[].slice.call(arguments,1))}function r(a){var b=a.apply(this,[].slice.call(arguments,1));return this.boost&&b?this.boost.getPoint(b):b}var O=c.getBoostClipRect,ma=c.isChartSeriesBoosting,d=x.getOptions,T=u.doc,Fa=u.noop,na=u.win,J=e.addEvent,oa=e.error,fa=e.extend,Ga=e.fireEvent,Ha=e.isArray,X=e.isNumber,pa=e.pick,H=e.wrap,v=[],qa,Q;return{compose:function(a,
b,c){var e=a.prototype.pointClass;-1===v.indexOf(e)&&(v.push(e),H(e.prototype,"haloPath",w));if(-1===v.indexOf(a)){v.push(a);J(a,"destroy",G);J(a,"hide",z);var h=a.prototype;c&&(h.renderCanvas=ea);H(h,"getExtremes",f);H(h,"markerAttribs",n);H(h,"processData",q);H(h,"searchPoint",r);["translate","generatePoints","drawTracker","drawPoints","render"].forEach(function(a){return xa(h,b,a)})}if(-1===v.indexOf(d)){v.push(d);var l=d().plotOptions;g.forEach(function(a){var c=l[a];c&&(c.boostThreshold=5E3,
c.boostData=[],b[a].prototype.fillOpacity=!0)})}if(c){var m=b.area,p=b.areaspline,k=b.bubble;c=b.column;e=b.heatmap;var t=b.scatter,O=b.treemap;m&&-1===v.indexOf(m)&&(v.push(m),fa(m.prototype,{fill:!0,fillOpacity:!0,sampling:!0}));p&&-1===v.indexOf(p)&&(v.push(p),fa(p.prototype,{fill:!0,fillOpacity:!0,sampling:!0}));k&&-1===v.indexOf(k)&&(v.push(k),m=k.prototype,delete m.buildKDTree,H(m,"markerAttribs",function(a){return this.boosted?!1:a.apply(this,[].slice.call(arguments,1))}));c&&-1===v.indexOf(c)&&
(v.push(c),fa(c.prototype,{fill:!0,sampling:!0}));t&&-1===v.indexOf(t)&&(v.push(t),t.prototype.fill=!0);[e,O].forEach(function(a){a&&-1===v.indexOf(a)&&(v.push(a),H(a.prototype,"drawPoints",la))})}return a},destroyGraphics:P,getPoint:l}});x(a,"Extensions/BoostCanvas.js",[a["Extensions/Boost/BoostChart.js"],a["Extensions/Boost/BoostSeries.js"],a["Core/Chart/Chart.js"],a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Series/Series.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],
function(a,g,c,x,u,e,F,k){var b=a.getBoostClipRect,t=a.isChartSeriesBoosting,P=g.destroyGraphics,p=x.parse,L=u.doc,M=u.noop,y=F.seriesTypes,G=k.addEvent,z=k.extend,W=k.fireEvent,l=k.isNumber,ea=k.merge,w=k.pick,la=k.wrap,xa;return function(){u.seriesTypes.heatmap&&la(u.seriesTypes.heatmap.prototype,"drawPoints",function(){var a=this.chart,b=this.getContext(),c=this.chart.inverted,e=this.xAxis,g=this.yAxis;b?(this.points.forEach(function(f){var d=f.plotY;if("undefined"!==typeof d&&!isNaN(d)&&null!==
f.y&&b){var n=f.shapeArgs||{};d=n.x;d=void 0===d?0:d;var q=n.y;q=void 0===q?0:q;var r=n.width;r=void 0===r?0:r;n=n.height;n=void 0===n?0:n;f=a.styledMode?f.series.colorAttribs(f):f.series.pointAttribs(f);b.fillStyle=f.fill;c?b.fillRect(g.len-q+e.left,e.len-d+g.top,-n,-r):b.fillRect(d+e.left,q+g.top,r,n)}}),this.canvasToSVG()):this.chart.showLoading("Your browser doesn't support HTML5 canvas, <br>please use a modern browser")});z(e.prototype,{getContext:function(){var a=this.chart,c=t(a)?a:this,e=
c===a?a.seriesGroup:a.seriesGroup||this.group,g=a.chartWidth,l=a.chartHeight,p=function(a,b,c,d,f,e,n){a.call(this,c,b,d,f,e,n)},d=c.boost=c.boost||{};var k=d.targetCtx;d.canvas||(d.canvas=L.createElement("canvas"),d.target=a.renderer.image("",0,0,g,l).addClass("highcharts-boost-canvas").add(e),k=d.targetCtx=d.canvas.getContext("2d"),a.inverted&&["moveTo","lineTo","rect","arc"].forEach(function(a){la(k,a,p)}),d.copy=function(){d.target.attr({href:d.canvas.toDataURL("image/png")})},d.clear=function(){k.clearRect(0,
0,d.canvas.width,d.canvas.height);c===d.target&&d.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="})},d.clipRect=a.renderer.clipRect(),d.target.clip(d.clipRect));d.canvas.width!==g&&(d.canvas.width=g);d.canvas.height!==l&&(d.canvas.height=l);d.target.attr({x:0,y:0,width:g,height:l,style:"pointer-events: none",href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="});
d.clipRect&&d.clipRect.attr(b(a,c));return k},canvasToSVG:function(){t(this.chart)?this.boost&&this.boost.clear&&this.boost.clear():this.boost&&this.boost.copy?this.boost.copy():this.chart.boost&&this.chart.boost.copy&&this.chart.boost.copy()},cvsLineTo:function(a,b,c){a.lineTo(b,c)},renderCanvas:function(){var a=this,b=a.options,c=a.chart,e=this.xAxis,g=this.yAxis,t=(c.options.boost||{}).timeRendering||!1,d=0,y=a.processedXData,F=a.processedYData,L=b.data,J=e.getExtremes(),oa=J.min,fa=J.max;J=g.getExtremes();
var la=J.min,ta=J.max,X={},pa,H=!!a.sampling,v=b.marker&&b.marker.radius,qa=this.cvsDrawPoint,Q=b.lineWidth?this.cvsLineTo:void 0,h=v&&1>=v?this.cvsMarkerSquare:this.cvsMarkerCircle,m=this.cvsStrokeBatch||1E3,Aa=!1!==b.enableMouseTracking,ca;J=b.threshold;var Y=g.getThreshold(J),da=l(J),ua=Y,ha=this.fill,ia=a.pointArrayMap&&"low,high"===a.pointArrayMap.join(","),aa=!!b.stacking,U=a.cropStart||0;J=c.options.loading;var ya=a.requireSorting,Ba,D=b.connectNulls,A=!y,I,ja,B,S,Z,N=aa?a.data:y||L,Ea=a.fillOpacity?
x.parse(a.color).setOpacity(w(b.fillOpacity,.75)).get():a.color,ra=function(){ha?(E.fillStyle=Ea,E.fill()):(E.strokeStyle=a.color,E.lineWidth=b.lineWidth,E.stroke())},C=function(b,f,e,g){0===d&&(E.beginPath(),Q&&(E.lineJoin="round"));c.scroller&&"highcharts-navigator-series"===a.options.className?(f+=c.scroller.top,e&&(e+=c.scroller.top)):f+=c.plotTop;b+=c.plotLeft;Ba?E.moveTo(b,f):qa?qa(E,b,f,e,ca):Q?Q(E,b,f):h&&h.call(a,E,b,f,v,g);d+=1;d===m&&(ra(),d=0);ca={clientX:b,plotY:f,yBottom:e}},va="x"===
b.findNearestPointBy,wa=this.xData||this.options.xData||this.processedXData||!1,sa=function(a,b,d){Z=va?a:a+","+b;Aa&&!X[Z]&&(X[Z]=!0,c.inverted&&(a=e.len-a,b=g.len-b),K.push({x:wa?wa[U+d]:!1,clientX:a,plotX:a,plotY:b,i:U+d}))};y=this.boost||{};y.target&&y.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="});(this.points||this.graph)&&P(this);a.plotGroup("group","series",a.visible?"visible":"hidden",b.zIndex,c.seriesGroup);
a.markerGroup=a.group;G(a,"destroy",function(){a.markerGroup=null});var K=this.points=[];var E=this.getContext();a.buildKDTree=M;y.clear&&y.clear();this.visible&&(99999<L.length&&(c.options.loading=ea(J,{labelStyle:{backgroundColor:p("#ffffff").setOpacity(.75).get(),padding:"1em",borderRadius:"0.5em"},style:{backgroundColor:"none",opacity:1}}),k.clearTimeout(xa),c.showLoading("Drawing..."),c.options.loading=J),t&&console.time("canvas rendering"),u.eachAsync(N,function(b,d){var f=!1,h=!1,n=!1,r=!1,
l="undefined"===typeof c.index,m=!0;if(!l){if(A){var q=b[0];var k=b[1];N[d+1]&&(n=N[d+1][0]);N[d-1]&&(r=N[d-1][0])}else q=b,k=F[d],N[d+1]&&(n=N[d+1]),N[d-1]&&(r=N[d-1]);n&&n>=oa&&n<=fa&&(f=!0);r&&r>=oa&&r<=fa&&(h=!0);if(ia){A&&(k=b.slice(1,3));var p=k[0];k=k[1]}else aa&&(q=b.x,k=b.stackY,p=k-b.y);b=null===k;ya||(m=k>=la&&k<=ta);if(!b&&(q>=oa&&q<=fa&&m||f||h))if(q=Math.round(e.toPixels(q,!0)),H){if("undefined"===typeof B||q===pa){ia||(p=k);if("undefined"===typeof S||k>ja)ja=k,S=d;if("undefined"===
typeof B||p<I)I=p,B=d}q!==pa&&("undefined"!==typeof B&&(k=g.toPixels(ja,!0),Y=g.toPixels(I,!0),C(q,da?Math.min(k,ua):k,da?Math.max(Y,ua):Y,d),sa(q,k,S),Y!==k&&sa(q,Y,B)),B=S=void 0,pa=q)}else k=Math.round(g.toPixels(k,!0)),C(q,k,Y,d),sa(q,k,d);Ba=b&&!D;0===d%5E4&&(a.boost&&a.boost.copy?a.boost.copy():a.chart.boost&&a.chart.boost.copy&&a.chart.boost.copy())}return!l},function(){var b=c.loadingDiv,d=c.loadingShown;ra();a.canvasToSVG();t&&console.timeEnd("canvas rendering");W(a,"renderedCanvas");d&&
(z(b.style,{transition:"opacity 250ms",opacity:0}),c.loadingShown=!1,xa=setTimeout(function(){b.parentNode&&b.parentNode.removeChild(b);c.loadingDiv=c.loadingSpan=null},250));delete a.buildKDTree;a.buildKDTree()},c.renderer.forExport?Number.MAX_VALUE:void 0))}});y.scatter.prototype.cvsMarkerCircle=function(a,b,c,e){a.moveTo(b,c);a.arc(b,c,e,0,2*Math.PI,!1)};y.scatter.prototype.cvsMarkerSquare=function(a,b,c,e){a.rect(b-e,c-e,2*e,2*e)};y.scatter.prototype.fill=!0;y.bubble&&(y.bubble.prototype.cvsMarkerCircle=
function(a,b,c,e,g){a.moveTo(b,c);a.arc(b,c,this.radii&&this.radii[g],0,2*Math.PI,!1)},y.bubble.prototype.cvsStrokeBatch=1);z(y.area.prototype,{cvsDrawPoint:function(a,b,c,e,g){g&&b!==g.clientX&&(a.moveTo(g.clientX,g.yBottom),a.lineTo(g.clientX,g.plotY),a.lineTo(b,c),a.lineTo(b,e))},fill:!0,fillOpacity:!0,sampling:!0});z(y.column.prototype,{cvsDrawPoint:function(a,b,c,e){a.rect(b-1,c,1,e-c)},fill:!0,sampling:!0});c.prototype.callbacks.push(function(a){G(a,"predraw",function(){var a=this.boost||{};
a.target&&a.target.attr({href:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII="});a.canvas&&a.canvas.getContext("2d").clearRect(0,0,a.canvas.width,a.canvas.height)});G(a,"render",function(){a.boost&&a.boost.copy&&a.boost.copy()})})}});x(a,"Extensions/Boost/NamedColors.js",[],function(){return{defaultHTMLColorMap:{aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",
blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",
darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",feldspar:"#d19275",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",
lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslateblue:"#8470ff",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",
mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",
papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",
violet:"#ee82ee",violetred:"#d02090",wheat:"#f5deb3",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"}}});x(a,"Extensions/Boost/Boost.js",[a["Extensions/Boost/BoostChart.js"],a["Extensions/Boost/BoostSeries.js"],a["Core/Globals.js"],a["Extensions/BoostCanvas.js"],a["Extensions/Boost/NamedColors.js"],a["Core/Utilities.js"]],function(a,g,c,x,u,e){function t(){var a=!1;if("undefined"!==typeof b.WebGLRenderingContext){var c=P.createElement("canvas");for(var e=0;e<L.length;++e)try{if(a=c.getContext(L[e]),
"undefined"!==typeof a&&null!==a)return!0}catch(z){}}return!1}var k=this&&this.__assign||function(){k=Object.assign||function(a){for(var b,c=1,e=arguments.length;c<e;c++){b=arguments[c];for(var g in b)Object.prototype.hasOwnProperty.call(b,g)&&(a[g]=b[g])}return a};return k.apply(this,arguments)},b=c.win,P=c.doc,ta=e.error,p=[],L=["webgl","experimental-webgl","moz-webgl","webkit-3d"];c={compose:function(b,c,e,z){var y=t();y||("undefined"!==typeof x?x():ta(26));z&&-1===p.indexOf(z)&&(p.push(z),z.names=
k(k({},z.names),u.defaultHTMLColorMap));a.compose(b,y);g.compose(c,e,y)},hasWebGLSupport:t};"";return c});x(a,"masters/modules/boost.src.js",[a["Core/Globals.js"],a["Extensions/Boost/Boost.js"]],function(a,g){a.hasWebGLSupport=g.hasWebGLSupport;g.compose(a.Chart,a.Series,a.seriesTypes,a.Color)})});
//# sourceMappingURL=boost.js.map