/*
 Highstock JS v10.3.2 (2022-11-28)

 Highcharts Stock as a plugin for Highcharts

 (c) 2010-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(C){a(C);a.Highcharts=C;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function C(a,q,y,r){a.hasOwnProperty(q)||(a[q]=r.apply(null,y),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:q,module:a[q]}})))}a=a?a._modules:{};C(a,"Core/Axis/BrokenAxis.js",
[a["Core/Axis/Stacking/StackItem.js"],a["Core/Utilities.js"]],function(a,q){var E=q.addEvent,r=q.find,w=q.fireEvent,B=q.isArray,v=q.isNumber,z=q.pick,t;(function(n){function e(){"undefined"!==typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function t(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)}function m(){var f=this.brokenAxis;if(f&&f.hasBreaks){for(var c=this.tickPositions,u=this.tickPositions.info,l=[],d=0;d<c.length;d++)f.isInAnyBreak(c[d])||
l.push(c[d]);this.tickPositions=l;this.tickPositions.info=u}}function c(){this.brokenAxis||(this.brokenAxis=new F(this))}function J(){var f=this.options.connectNulls,c=this.points,u=this.xAxis,l=this.yAxis;if(this.isDirty)for(var d=c.length;d--;){var h=c[d],b=!(null===h.y&&!1===f)&&(u&&u.brokenAxis&&u.brokenAxis.isInAnyBreak(h.x,!0)||l&&l.brokenAxis&&l.brokenAxis.isInAnyBreak(h.y,!0));h.visible=b?!1:!1!==h.options.visible}}function f(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,
z(this.pointArrayMap,["y"]))}function D(f,c){var u=this,l=u.points,d,h,b,p;if(f&&f.brokenAxis&&f.brokenAxis.hasBreaks){var k=f.brokenAxis;c.forEach(function(A){d=k&&k.breakArray||[];h=f.isXAxis?f.min:z(u.options.threshold,f.min);l.forEach(function(k){p=z(k["stack"+A.toUpperCase()],k[A]);d.forEach(function(d){if(v(h)&&v(p)){b=!1;if(h<d.from&&p>d.to||h>d.from&&p<d.from)b="pointBreak";else if(h<d.from&&p>d.from&&p<d.to||h>d.from&&p>d.to&&p<d.from)b="pointInBreak";b&&w(f,b,{point:k,brk:d})}})})})}}function L(){var f=
this.currentDataGrouping,c=f&&f.gapSize;f=this.points.slice();var u=this.yAxis,l=this.options.gapSize,d=f.length-1,h;if(l&&0<d)for("value"!==this.options.gapUnit&&(l*=this.basePointRange),c&&c>l&&c>=this.basePointRange&&(l=c),h=void 0;d--;)h&&!1!==h.visible||(h=f[d+1]),c=f[d],!1!==h.visible&&!1!==c.visible&&(h.x-c.x>l&&(h=(c.x+h.x)/2,f.splice(d+1,0,{isNull:!0,x:h}),u.stacking&&this.options.stacking&&(h=u.stacking.stacks[this.stackKey][h]=new a(u,u.options.stackLabels,!1,h,this.stack),h.total=0)),
h=c);return this.getGraphPath(f)}var q=[];n.compose=function(a,n){-1===q.indexOf(a)&&(q.push(a),a.keepProps.push("brokenAxis"),E(a,"init",c),E(a,"afterInit",e),E(a,"afterSetTickPositions",m),E(a,"afterSetOptions",t));if(-1===q.indexOf(n)){q.push(n);var u=n.prototype;u.drawBreaks=D;u.gappedPath=L;E(n,"afterGeneratePoints",J);E(n,"afterRender",f)}return a};var F=function(){function f(f){this.hasBreaks=!1;this.axis=f}f.isInBreak=function(f,c){var l=f.repeat||Infinity,d=f.from,h=f.to-f.from;c=c>=d?(c-
d)%l:l-(d-c)%l;return f.inclusive?c<=h:c<h&&0!==c};f.lin2Val=function(c){var u=this.brokenAxis;u=u&&u.breakArray;if(!u||!v(c))return c;var l;for(l=0;l<u.length;l++){var d=u[l];if(d.from>=c)break;else d.to<c?c+=d.len:f.isInBreak(d,c)&&(c+=d.len)}return c};f.val2Lin=function(c){var u=this.brokenAxis;u=u&&u.breakArray;if(!u||!v(c))return c;var l=c,d;for(d=0;d<u.length;d++){var h=u[d];if(h.to<=c)l-=h.len;else if(h.from>=c)break;else if(f.isInBreak(h,c)){l-=c-h.from;break}}return l};f.prototype.findBreakAt=
function(f,c){return r(c,function(l){return l.from<f&&f<l.to})};f.prototype.isInAnyBreak=function(c,u){var l=this.axis,d=l.options.breaks||[],h=d.length,b;if(h&&v(c)){for(;h--;)if(f.isInBreak(d[h],c)){var p=!0;b||(b=z(d[h].showPoints,!l.isXAxis))}var k=p&&u?p&&!b:p}return k};f.prototype.setBreaks=function(c,u){var l=this,d=l.axis,h=B(c)&&!!c.length;d.isDirty=l.hasBreaks!==h;l.hasBreaks=h;d.options.breaks=d.userOptions.breaks=c;d.forceRedraw=!0;d.series.forEach(function(b){b.isDirty=!0});h||d.val2lin!==
f.val2Lin||(delete d.val2lin,delete d.lin2val);h&&(d.userOptions.ordinal=!1,d.lin2val=f.lin2Val,d.val2lin=f.val2Lin,d.setExtremes=function(b,p,k,A,h){if(l.hasBreaks){for(var M=this.options.breaks||[],f;f=l.findBreakAt(b,M);)b=f.to;for(;f=l.findBreakAt(p,M);)p=f.from;p<b&&(p=b)}d.constructor.prototype.setExtremes.call(this,b,p,k,A,h)},d.setAxisTranslation=function(){d.constructor.prototype.setAxisTranslation.call(this);l.unitLength=void 0;if(l.hasBreaks){var b=d.options.breaks||[],p=[],k=[],A=z(d.pointRangePadding,
0),h=0,c,K=d.userMin||d.min,H=d.userMax||d.max,u;b.forEach(function(b){c=b.repeat||Infinity;v(K)&&v(H)&&(f.isInBreak(b,K)&&(K+=b.to%c-K%c),f.isInBreak(b,H)&&(H-=H%c-b.from%c))});b.forEach(function(b){I=b.from;c=b.repeat||Infinity;if(v(K)&&v(H)){for(;I-c>K;)I-=c;for(;I<K;)I+=c;for(u=I;u<H;u+=c)p.push({value:u,move:"in"}),p.push({value:u+b.to-b.from,move:"out",size:b.breakSize})}});p.sort(function(b,p){return b.value===p.value?("in"===b.move?0:1)-("in"===p.move?0:1):b.value-p.value});var a=0;var I=
K;p.forEach(function(b){a+="in"===b.move?1:-1;1===a&&"in"===b.move&&(I=b.value);0===a&&v(I)&&(k.push({from:I,to:b.value,len:b.value-I-(b.size||0)}),h+=b.value-I-(b.size||0))});l.breakArray=k;v(K)&&v(H)&&v(d.min)&&(l.unitLength=H-K-h+A,w(d,"afterBreaks"),d.staticScale?d.transA=d.staticScale:l.unitLength&&(d.transA*=(H-d.min+A)/l.unitLength),A&&(d.minPixelPadding=d.transA*(d.minPointOffset||0)),d.min=K,d.max=H)}});z(u,!0)&&d.chart.redraw()};return f}();n.Additions=F})(t||(t={}));return t});C(a,"masters/modules/broken-axis.src.js",
[a["Core/Globals.js"],a["Core/Axis/BrokenAxis.js"]],function(a,q){q.compose(a.Axis,a.Series)});C(a,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}});C(a,"Extensions/DataGrouping/ApproximationDefaults.js",[a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Core/Utilities.js"]],function(a,q){function E(a){var e=a.length;a=r(a);t(a)&&e&&(a=v(a/e));return a}function r(a){var e=a.length;if(!e&&a.hasNulls)var n=null;else if(e)for(n=0;e--;)n+=a[e];return n}var w=q.arrayMax,
B=q.arrayMin,v=q.correctFloat,z=q.extend,t=q.isNumber;q={average:E,averages:function(){var a=[];[].forEach.call(arguments,function(e){a.push(E(e))});return"undefined"===typeof a[0]?void 0:a},close:function(a){return a.length?a[a.length-1]:a.hasNulls?null:void 0},high:function(a){return a.length?w(a):a.hasNulls?null:void 0},hlc:function(n,e,g){n=a.high(n);e=a.low(e);g=a.close(g);if(t(n)||t(e)||t(g))return[n,e,g]},low:function(a){return a.length?B(a):a.hasNulls?null:void 0},ohlc:function(n,e,g,m){n=
a.open(n);e=a.high(e);g=a.low(g);m=a.close(m);if(t(n)||t(e)||t(g)||t(m))return[n,e,g,m]},open:function(a){return a.length?a[0]:a.hasNulls?null:void 0},range:function(n,e){n=a.low(n);e=a.high(e);if(t(n)||t(e))return[n,e];if(null===n&&null===e)return null},sum:r};z(a,q);return q});C(a,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S",
"%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},
hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}});C(a,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Core/Utilities.js"]],function(a,q){function E(a){var c=this,e=c.series;e.forEach(function(f){f.groupPixelWidth=void 0});e.forEach(function(f){f.groupPixelWidth=
c.getGroupPixelWidth&&c.getGroupPixelWidth();f.groupPixelWidth&&(f.hasProcessed=!0);f.applyGrouping(!!a.hasExtremesChanged)})}function r(){for(var e=this.series,c=e.length,t=0,f=!1,D,g;c--;)if(g=e[c].options.dataGrouping)if(t=Math.max(t,n(g.groupPixelWidth,a.common.groupPixelWidth)),D=(e[c].processedXData||e[c].data).length,e[c].groupPixelWidth||D>this.chart.plotSizeX/t||D&&g.forced)f=!0;return f?t:0}function w(){this.series.forEach(function(a){a.hasProcessed=!1})}function B(a,c){var e;c=n(c,!0);
a||(a={forced:!1,units:null});if(this instanceof g)for(e=this.series.length;e--;)this.series[e].update({dataGrouping:a},!1);else this.chart.options.series.forEach(function(f){f.dataGrouping="boolean"===typeof a?a:t(a,f.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0);c&&this.chart.redraw()}var v=q.addEvent,z=q.extend,t=q.merge,n=q.pick,e=[],g;return{compose:function(a){g=a;-1===e.indexOf(a)&&(e.push(a),v(a,"afterSetScale",w),v(a,"postProcessData",E),z(a.prototype,{applyGrouping:E,getGroupPixelWidth:r,
setDataGrouping:B}))}}});C(a,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",[a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Core/Axis/DateTimeAxis.js"],a["Core/Defaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,y,r,w,B){function v(a){var c=this.chart,d=this.options.dataGrouping,h=!1!==this.allowDG&&d&&F(d.enabled,c.options.isStock),b=this.visible||!c.options.chart.ignoreHiddenSeries,p=this.currentDataGrouping,
k=!1;h&&!this.requireSorting&&(this.requireSorting=k=!0);a=!1===!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!a)||!h;k&&(this.requireSorting=!1);if(!a){this.destroyGroupedData();var A=d.groupAll?this.xData:this.processedXData,M=d.groupAll?this.yData:this.processedYData;h=c.plotSizeX;a=this.xAxis;var N=a.options.ordinal,K=this.groupPixelWidth;k=void 0;if(K&&A&&A.length){this.isDirty=k=!0;this.points=null;var H=a.getExtremes();var e=H.min;H=H.max;N=N&&a.ordinal&&a.ordinal.getGroupIntervalFactor(e,
H,this)||1;h=a.getTimeTicks(y.Additions.prototype.normalizeTimeTickInterval(K*(H-e)/h*N,d.units||q.units),Math.min(e,A[0]),Math.max(H,A[A.length-1]),a.options.startOfWeek,A,this.closestPointRange);K=m.groupData.apply(this,[A,M,h,d.approximation]);A=K.groupedXData;M=K.groupedYData;N=0;d&&d.smoothed&&A.length&&(d.firstAnchor="firstPoint",d.anchor="middle",d.lastAnchor="lastPoint",f(32,!1,c,{"dataGrouping.smoothed":"use dataGrouping.anchor"}));c=A;var D=this.options.dataGrouping;e=this.currentDataGrouping&&
this.currentDataGrouping.gapSize;if(D&&this.xData&&e&&this.groupMap){var I=c.length-1;var t=D.anchor;var u=F(D.firstAnchor,t);D=F(D.lastAnchor,t);if(t&&"start"!==t){var g=e*{middle:.5,end:1}[t];for(t=c.length-1;t--&&0<t;)c[t]+=g}if(u&&"start"!==u&&this.xData[0]>=c[0]){t=this.groupMap[0].start;g=this.groupMap[0].length;var n=void 0;L(t)&&L(g)&&(n=t+(g-1));c[0]={middle:c[0]+.5*e,end:c[0]+e,firstPoint:this.xData[0],lastPoint:n&&this.xData[n]}[u]}D&&"start"!==D&&e&&c[I]>=H-e&&(H=this.groupMap[this.groupMap.length-
1].start,c[I]={middle:c[I]+.5*e,end:c[I]+e,firstPoint:H&&this.xData[H],lastPoint:this.xData[this.xData.length-1]}[D])}for(H=1;H<h.length;H++)h.info.segmentStarts&&-1!==h.info.segmentStarts.indexOf(H)||(N=Math.max(h[H]-h[H-1],N));H=h.info;H.gapSize=N;this.closestPointRange=h.info.totalRange;this.groupMap=K.groupMap;if(b){b=A;if(J(b[0])&&L(a.min)&&L(a.dataMin)&&b[0]<a.min){if(!J(a.options.min)&&a.min<=a.dataMin||a.min===a.dataMin)a.min=Math.min(b[0],a.min);a.dataMin=Math.min(b[0],a.dataMin)}if(J(b[b.length-
1])&&L(a.max)&&L(a.dataMax)&&b[b.length-1]>a.max){if(!J(a.options.max)&&L(a.dataMax)&&a.max>=a.dataMax||a.max===a.dataMax)a.max=Math.max(b[b.length-1],a.max);a.dataMax=Math.max(b[b.length-1],a.dataMax)}}d.groupAll&&(this.allGroupedData=M,d=this.cropData(A,M,a.min,a.max,1),A=d.xData,M=d.yData,this.cropStart=d.start);this.processedXData=A;this.processedYData=M}else this.groupMap=null;this.hasGroupedData=k;this.currentDataGrouping=H;this.preventGraphAnimation=(p&&p.totalRange)!==(H&&H.totalRange)}}function z(){this.groupedData&&
(this.groupedData.forEach(function(a,f){a&&(this.groupedData[f]=a.destroy?a.destroy():null)},this),this.groupedData.length=0)}function t(){x.apply(this);this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null}function n(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")?"sum":"average"}function e(f,c,d,h){var b=this,p=b.data,k=b.options&&b.options.data,A=[],M=[],N=[],K=f.length,H=!!c,l=[],e=b.pointArrayMap,I=e&&e.length,t=["x"].concat(e||
["y"]),D=this.options.dataGrouping&&this.options.dataGrouping.groupAll,g=0,u=0;h="function"===typeof h?h:h&&a[h]?a[h]:a[b.getDGApproximation&&b.getDGApproximation()||"average"];if(I)for(var n=e.length;n--;)l.push([]);else l.push([]);n=I||1;for(var m=0;m<=K;m++)if(!(f[m]<d[0])){for(;"undefined"!==typeof d[g+1]&&f[m]>=d[g+1]||m===K;){var x=d[g];b.dataGroupInfo={start:D?u:b.cropStart+u,length:l[0].length};var v=h.apply(b,l);b.pointClass&&!J(b.dataGroupInfo.options)&&(b.dataGroupInfo.options=E(b.pointClass.prototype.optionsToObject.call({series:b},
b.options.data[b.cropStart+u])),t.forEach(function(p){delete b.dataGroupInfo.options[p]}));"undefined"!==typeof v&&(A.push(x),M.push(v),N.push(b.dataGroupInfo));u=m;for(x=0;x<n;x++)l[x].length=0,l[x].hasNulls=!1;g+=1;if(m===K)break}if(m===K)break;if(e){x=b.options.dataGrouping&&b.options.dataGrouping.groupAll?m:b.cropStart+m;v=p&&p[x]||b.pointClass.prototype.applyOptions.apply({series:b},[k[x]]);var q=void 0;for(x=0;x<I;x++)q=v[e[x]],L(q)?l[x].push(q):null===q&&(l[x].hasNulls=!0)}else x=H?c[m]:null,
L(x)?l[0].push(x):null===x&&(l[0].hasNulls=!0)}return{groupedXData:A,groupedYData:M,groupMap:N}}function g(a){a=a.options;var f=this.type,d=this.chart.options.plotOptions,h=this.useCommonDataGrouping&&q.common,b=q.seriesSpecific,p=r.defaultOptions.plotOptions[f].dataGrouping;if(d&&(b[f]||h)){var k=this.chart.rangeSelector;p||(p=E(q.common,b[f]));a.dataGrouping=E(h,p,d.series&&d.series.dataGrouping,d[f].dataGrouping,this.userOptions.dataGrouping,!a.isInternal&&k&&L(k.selected)&&k.buttonOptions[k.selected].dataGrouping)}}
var m=w.series.prototype,c=B.addEvent,J=B.defined,f=B.error,D=B.extend,L=B.isNumber,E=B.merge,F=B.pick,x=m.generatePoints,G=[];return{compose:function(a){var l=a.prototype.pointClass;-1===G.indexOf(l)&&(G.push(l),c(l,"update",function(){if(this.dataGroup)return f(24,!1,this.series.chart),!1}));-1===G.indexOf(a)&&(G.push(a),c(a,"afterSetOptions",g),c(a,"destroy",z),D(a.prototype,{applyGrouping:v,destroyGroupedData:z,generatePoints:t,getDGApproximation:n,groupData:e}))},groupData:e}});C(a,"Extensions/DataGrouping/DataGrouping.js",
[a["Extensions/DataGrouping/DataGroupingAxisComposition.js"],a["Extensions/DataGrouping/DataGroupingDefaults.js"],a["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],a["Core/FormatUtilities.js"],a["Core/Utilities.js"]],function(a,q,y,r,w){function B(a){var e=this.chart,c=e.time,g=a.labelConfig,f=g.series,D=f.tooltipOptions,L=f.options.dataGrouping,r=f.xAxis,F=D.xDateFormat,x=D[a.isFooter?"footerFormat":"headerFormat"];if(r&&"datetime"===r.options.type&&L&&n(g.key)){var w=f.currentDataGrouping;
L=L.dateTimeLabelFormats||q.common.dateTimeLabelFormats;if(w)if(D=L[w.unitName],1===w.count)F=D[0];else{F=D[1];var u=D[2]}else!F&&L&&r.dateTime&&(F=r.dateTime.getXDateFormat(g.x,D.dateTimeLabelFormats));F=c.dateFormat(F,g.key);u&&(F+=c.dateFormat(u,g.key+w.totalRange-1));f.chart.styledMode&&(x=this.styledModeFormat(x));a.text=v(x,{point:t(g.point,{key:F}),series:f},e);a.preventDefault()}}var v=r.format,z=w.addEvent,t=w.extend,n=w.isNumber,e=[];r={compose:function(t,m,c){a.compose(t);y.compose(m);
-1===e.indexOf(c)&&(e.push(c),z(c,"headerFormatter",B))},groupData:y.groupData};"";"";return r});C(a,"masters/modules/datagrouping.src.js",[a["Core/Globals.js"],a["Extensions/DataGrouping/ApproximationDefaults.js"],a["Extensions/DataGrouping/ApproximationRegistry.js"],a["Extensions/DataGrouping/DataGrouping.js"]],function(a,q,y,r){a.dataGrouping={approximationDefaults:q,approximations:y};r.compose(a.Axis,a.Series,a.Tooltip)});C(a,"Series/DataModifyComposition.js",[a["Core/Axis/Axis.js"],a["Core/Series/Point.js"],
a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,q,y,r){var w=q.prototype.tooltipFormatter,B=r.addEvent,v=r.arrayMax,z=r.arrayMin,t=r.correctFloat,n=r.defined,e=r.isArray,g=r.isNumber,m=r.isString,c=r.pick,J;(function(a){function f(b,k,d){this.isXAxis||(this.series.forEach(function(p){"compare"===b&&"boolean"!==typeof k?p.setCompare(k,!1):"cumulative"!==b||m(k)||p.setCumulative(k,!1)}),c(d,!0)&&this.chart.redraw())}function L(b){var p=this,d=p.series.chart.numberFormatter,h=function(k){b=
b.replace("{point."+k+"}",(0<p[k]&&"change"===k?"+":"")+d(p[k],c(p.series.tooltipOptions.changeDecimals,2)))};n(p.change)&&h("change");n(p.cumulativeSum)&&h("cumulativeSum");return w.apply(this,[b])}function J(){var p=this.options.compare;if("percent"===p||"value"===p||this.options.cumulative){var k=new b(this);"percent"===p||"value"===p?k.initCompare(p):k.initCumulative()}this.dataModify=k}function q(p){p=p.dataExtremes;var k=p.activeYData;if(this.dataModify&&p){var d=void 0;this.options.compare?
d=[this.dataModify.modifyValue(p.dataMin),this.dataModify.modifyValue(p.dataMax)]:this.options.cumulative&&e(k)&&2<=k.length&&(d=b.getCumulativeExtremes(k));d&&(p.dataMin=z(d),p.dataMax=v(d))}}function x(b,k){this.options.compare=this.userOptions.compare=b;this.update({},c(k,!0));!this.dataModify||"value"!==b&&"percent"!==b?this.points.forEach(function(b){delete b.change}):this.dataModify.initCompare(b)}function r(){if(this.xAxis&&this.processedYData&&this.dataModify){var b=this.processedXData,k=
this.processedYData,d=k.length,h=!0===this.options.compareStart?0:1,a=-1,f;this.pointArrayMap&&(a=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(f=0;f<d-h;f++){var c=k[f]&&-1<a?k[f][a]:k[f];if(g(c)&&0!==c&&b[f+h]>=(this.xAxis.min||0)){this.dataModify.compareValue=c;break}}}}function u(b,k){this.setModifier("compare",b,k)}function l(b,k){b=c(b,!1);this.options.cumulative=this.userOptions.cumulative=b;this.update({},c(k,!0));this.dataModify?this.dataModify.initCumulative():
this.points.forEach(function(b){delete b.cumulativeSum})}function d(b,k){this.setModifier("cumulative",b,k)}var h=[];a.compose=function(b,k,A){if(-1===h.indexOf(b)){h.push(b);var p=b.prototype;p.setCompare=x;p.setCumulative=l;B(b,"afterInit",J);B(b,"afterGetExtremes",q);B(b,"afterProcessData",r)}-1===h.indexOf(k)&&(h.push(k),k=k.prototype,k.setCompare=u,k.setModifier=f,k.setCumulative=d);-1===h.indexOf(A)&&(h.push(A),A.prototype.tooltipFormatter=L);return b};var b=function(){function b(b){this.series=
b}b.prototype.modifyValue=function(){return 0};b.getCumulativeExtremes=function(b){var p=Infinity,k=-Infinity;b.reduce(function(b,d){d=b+d;p=Math.min(p,d,b);k=Math.max(k,d,b);return d});return[p,k]};b.prototype.initCompare=function(b){this.modifyValue=function(p,k){null===p&&(p=0);var d=this.compareValue;return"undefined"!==typeof p&&"undefined"!==typeof d?(p="value"===b?p-d:p/d*100-(100===this.series.options.compareBase?0:100),"undefined"!==typeof k&&(k=this.series.points[k])&&(k.change=p),p):0}};
b.prototype.initCumulative=function(){this.modifyValue=function(b,p){null===b&&(b=0);if(void 0!==b&&void 0!==p){var k=0<p?this.series.points[p-1]:null;k&&k.cumulativeSum&&(b=t(k.cumulativeSum+b));if(p=this.series.points[p])p.cumulativeSum=b;return b}return 0}};return b}();a.Additions=b})(J||(J={}));"";return J});C(a,"Core/Axis/NavigatorAxisComposition.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,q){function E(){this.navigatorAxis||(this.navigatorAxis=new g(this))}function r(a){var c=
this.chart.options,e=c.navigator,f=this.navigatorAxis,t=c.chart.zooming.pinchType,g=c.rangeSelector;c=c.chart.zooming.type;this.isXAxis&&(e&&e.enabled||g&&g.enabled)&&("y"===c?a.zoomed=!1:(!w&&"xy"===c||w&&"xy"===t)&&this.options.range&&(e=f.previousZoom,z(a.newMin)?f.previousZoom=[this.min,this.max]:e&&(a.newMin=e[0],a.newMax=e[1],f.previousZoom=void 0)));"undefined"!==typeof a.zoomed&&a.preventDefault()}var w=a.isTouchDevice,B=q.addEvent,v=q.correctFloat,z=q.defined,t=q.isNumber,n=q.pick,e=[],g=
function(){function a(a){this.axis=a}a.compose=function(a){-1===e.indexOf(a)&&(e.push(a),a.keepProps.push("navigatorAxis"),B(a,"init",E),B(a,"zoom",r))};a.prototype.destroy=function(){this.axis=void 0};a.prototype.toFixedRange=function(a,e,f,D){var c=this.axis,g=c.chart;a=n(f,c.translate(a,!0,!c.horiz));e=n(D,c.translate(e,!0,!c.horiz));g=g&&g.fixedRange;c=(c.pointRange||0)/2;var m=g&&(e-a)/g;z(f)||(a=v(a+c));z(D)||(e=v(e-c));.7<m&&1.3>m&&(D?a=e-g:e=a+g);t(a)&&t(e)||(a=e=void 0);return{min:a,max:e}};
return a}();return g});C(a,"Stock/Navigator/NavigatorDefaults.js",[a["Core/Color/Color.js"],a["Core/Series/SeriesRegistry.js"]],function(a,q){a=a.parse;q=q.seriesTypes;q={height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:a("#6685c2").setOpacity(.3).get(),outlineColor:"#cccccc",outlineWidth:1,series:{type:"undefined"===typeof q.areaspline?"line":"areaspline",fillOpacity:.05,
lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},
threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#999999"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}};"";return q});C(a,"Stock/Navigator/NavigatorSymbols.js",[],function(){return{"navigator-handle":function(a,
q,y,r,w){void 0===w&&(w={});a=w.width?w.width/2:y;q=Math.round(a/3)+.5;r=w.height||r;return[["M",-a-1,.5],["L",a,.5],["L",a,r+.5],["L",-a-1,r+.5],["L",-a-1,.5],["M",-q,4],["L",-q,r-3],["M",q-1,4],["L",q-1,r-3]]}}});C(a,"Stock/Navigator/NavigatorComposition.js",[a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Axis/NavigatorAxisComposition.js"],a["Stock/Navigator/NavigatorDefaults.js"],a["Stock/Navigator/NavigatorSymbols.js"],a["Core/Renderer/RendererRegistry.js"],a["Core/Utilities.js"]],function(a,
q,y,r,w,B,v){function z(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function t(){var d=this.legend,b=this.navigator;if(b){var p=d&&d.options;var k=b.xAxis;var a=b.yAxis;var f=b.scrollbarHeight;this.inverted?(b.left=b.opposite?this.chartWidth-f-b.height:this.spacing[3]+f,b.top=this.plotTop+f):(b.left=u(k.left,this.plotLeft+f),b.top=b.navigatorOptions.top||this.chartHeight-b.height-f-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(p&&"bottom"===
p.verticalAlign&&"proximate"!==p.layout&&p.enabled&&!p.floating?d.legendHeight+u(p.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));k&&a&&(this.inverted?k.options.left=a.options.left=b.left:k.options.top=a.options.top=b.top,k.setAxisSize(),a.setAxisSize())}}function n(a){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new d(this),u(a.redraw,!0)&&this.redraw(a.animation))}function e(){var a=this.options;if(a.navigator.enabled||
a.scrollbar.enabled)this.scroller=this.navigator=new d(this)}function g(){var d=this.options,b=d.navigator,p=d.rangeSelector;if((b&&b.enabled||p&&p.enabled)&&(!L&&"x"===d.chart.zooming.type||L&&"x"===d.chart.zooming.pinchType))return!1}function m(d){var b=d.navigator;b&&d.xAxis[0]&&(d=d.xAxis[0].getExtremes(),b.render(d.min,d.max))}function c(d){var b=d.options.navigator||{},p=d.options.scrollbar||{};this.navigator||this.scroller||!b.enabled&&!p.enabled||(G(!0,this.options.navigator,b),G(!0,this.options.scrollbar,
p),delete d.options.navigator,delete d.options.scrollbar)}function J(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}var f=a.defaultOptions,D=a.setOptions,L=q.isTouchDevice,E=B.getRendererType,F=v.addEvent,x=v.extend,G=v.merge,u=v.pick,l=[],d;return{compose:function(a,b,p,k){y.compose(a);d=p;-1===l.indexOf(b)&&(l.push(b),b.prototype.callbacks.push(m),F(b,"afterAddSeries",z),F(b,"afterSetChartSize",t),F(b,"afterUpdate",n),F(b,"beforeRender",e),F(b,"beforeShowResetZoom",
g),F(b,"update",c));-1===l.indexOf(k)&&(l.push(k),F(k,"afterUpdate",J));-1===l.indexOf(E)&&(l.push(E),x(E().prototype.symbols,w));-1===l.indexOf(D)&&(l.push(D),x(f,{navigator:r}))}}});C(a,"Core/Axis/ScrollbarAxis.js",[a["Core/Utilities.js"]],function(a){var q=a.addEvent,y=a.defined,r=a.pick;return function(){function a(){}a.compose=function(w,v){if(-1===a.composed.indexOf(w))a.composed.push(w);else return w;var z=function(a){var t=r(a.options&&a.options.min,a.min),e=r(a.options&&a.options.max,a.max);
return{axisMin:t,axisMax:e,scrollMin:y(a.dataMin)?Math.min(t,a.min,a.dataMin,r(a.threshold,Infinity)):t,scrollMax:y(a.dataMax)?Math.max(e,a.max,a.dataMax,r(a.threshold,-Infinity)):e}};q(w,"afterInit",function(){var a=this;a.options&&a.options.scrollbar&&a.options.scrollbar.enabled&&(a.options.scrollbar.vertical=!a.horiz,a.options.startOnTick=a.options.endOnTick=!1,a.scrollbar=new v(a.chart.renderer,a.options.scrollbar,a.chart),q(a.scrollbar,"changed",function(t){var e=z(a),g=e.axisMax,m=e.scrollMin,
c=e.scrollMax-m;y(e.axisMin)&&y(g)&&(a.horiz&&!a.reversed||!a.horiz&&a.reversed?(e=m+c*this.to,m+=c*this.from):(e=m+c*(1-this.from),m+=c*(1-this.to)),this.shouldUpdateExtremes(t.DOMType)?a.setExtremes(m,e,!0,"mousemove"!==t.DOMType&&"touchmove"!==t.DOMType,t):this.setRange(this.from,this.to))}))});q(w,"afterRender",function(){var a=z(this),n=a.scrollMin,e=a.scrollMax;a=this.scrollbar;var g=this.axisTitleMargin+(this.titleOffset||0),m=this.chart.scrollbarsOffsets,c=this.options.margin||0;a&&(this.horiz?
(this.opposite||(m[1]+=g),a.position(this.left,this.top+this.height+2+m[1]-(this.opposite?c:0),this.width,this.height),this.opposite||(m[1]+=c),g=1):(this.opposite&&(m[0]+=g),a.position(a.options.opposite?this.left+this.width+2+m[0]-(this.opposite?0:c):this.opposite?0:c,this.top,this.width,this.height),this.opposite&&(m[0]+=c),g=0),m[g]+=a.size+a.options.margin,isNaN(n)||isNaN(e)||!y(this.min)||!y(this.max)||this.min===this.max?a.setRange(0,1):(m=(this.min-n)/(e-n),n=(this.max-n)/(e-n),this.horiz&&
!this.reversed||!this.horiz&&this.reversed?a.setRange(m,n):a.setRange(1-n,1-m)))});q(w,"afterGetOffset",function(){var a=this.scrollbar&&!this.scrollbar.options.opposite;a=this.horiz?2:a?3:1;var n=this.scrollbar;n&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[a]+=n.size+n.options.margin)});return w};a.composed=[];return a}()});C(a,"Stock/Scrollbar/ScrollbarDefaults.js",[a["Core/Globals.js"]],function(a){return{height:a.isTouchDevice?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,
margin:10,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:1,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"#333333",trackBackgroundColor:"#f2f2f2",trackBorderColor:"#f2f2f2",trackBorderWidth:1}});C(a,"Stock/Scrollbar/Scrollbar.js",[a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Axis/ScrollbarAxis.js"],a["Stock/Scrollbar/ScrollbarDefaults.js"],a["Core/Utilities.js"]],
function(a,q,y,r,w){var B=a.defaultOptions,v=w.addEvent,z=w.correctFloat,t=w.defined,n=w.destroyObjectProperties,e=w.fireEvent,g=w.merge,m=w.pick,c=w.removeEvent;a=function(){function a(a,c,e){this._events=[];this.chart=void 0;this.from=this.chartY=this.chartX=0;this.scrollbar=this.renderer=this.options=this.group=void 0;this.scrollbarButtons=[];this.scrollbarGroup=void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=0;this.track=
void 0;this.trackBorderWidth=1;this.userOptions=void 0;this.y=this.x=0;this.init(a,c,e)}a.compose=function(f){y.compose(f,a)};a.swapXY=function(a,c){c&&a.forEach(function(a){for(var f=a.length,c,e=0;e<f;e+=2)c=a[e+1],"number"===typeof c&&(a[e+1]=a[e+2],a[e+2]=c)});return a};a.prototype.addEvents=function(){var a=this.options.inverted?[1,0]:[0,1],c=this.scrollbarButtons,e=this.scrollbarGroup.element,g=this.track.element,m=this.mouseDownHandler.bind(this),x=this.mouseMoveHandler.bind(this),n=this.mouseUpHandler.bind(this);
a=[[c[a[0]].element,"click",this.buttonToMinClick.bind(this)],[c[a[1]].element,"click",this.buttonToMaxClick.bind(this)],[g,"click",this.trackClick.bind(this)],[e,"mousedown",m],[e.ownerDocument,"mousemove",x],[e.ownerDocument,"mouseup",n]];q.hasTouch&&a.push([e,"touchstart",m],[e.ownerDocument,"touchmove",x],[e.ownerDocument,"touchend",n]);a.forEach(function(a){v.apply(null,a)});this._events=a};a.prototype.buttonToMaxClick=function(a){var f=(this.to-this.from)*m(this.options.step,.2);this.updatePosition(this.from+
f,this.to+f);e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.buttonToMinClick=function(a){var f=z(this.to-this.from)*m(this.options.step,.2);this.updatePosition(z(this.from-f),z(this.to-f));e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.cursorToScrollbarPosition=function(a){var f=this.options;f=f.minWidth>this.calculatedWidth?f.minWidth:0;return{chartX:(a.chartX-this.x-this.xOffset)/(this.barWidth-f),chartY:(a.chartY-
this.y-this.yOffset)/(this.barWidth-f)}};a.prototype.destroy=function(){var a=this,c=a.chart.scroller;a.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(f){a[f]&&a[f].destroy&&(a[f]=a[f].destroy())});c&&a===c.scrollbar&&(c.scrollbar=null,n(c.scrollbarButtons))};a.prototype.drawScrollbarButton=function(f){var c=this.renderer,e=this.scrollbarButtons,g=this.options,m=this.size,n=c.g().add(this.group);e.push(n);n=c.rect().addClass("highcharts-scrollbar-button").add(n);
this.chart.styledMode||n.attr({stroke:g.buttonBorderColor,"stroke-width":g.buttonBorderWidth,fill:g.buttonBackgroundColor});n.attr(n.crisp({x:-.5,y:-.5,width:m+1,height:m+1,r:g.buttonBorderRadius},n.strokeWidth()));n=c.path(a.swapXY([["M",m/2+(f?-1:1),m/2-3],["L",m/2+(f?-1:1),m/2+3],["L",m/2+(f?2:-2),m/2]],g.vertical)).addClass("highcharts-scrollbar-arrow").add(e[f]);this.chart.styledMode||n.attr({fill:g.buttonArrowColor})};a.prototype.init=function(a,c,e){this.scrollbarButtons=[];this.renderer=a;
this.userOptions=c;this.options=g(r,B.scrollbar,c);this.chart=e;this.size=m(this.options.size,this.options.height);c.enabled&&(this.render(),this.addEvents())};a.prototype.mouseDownHandler=function(a){a=this.chart.pointer.normalize(a);a=this.cursorToScrollbarPosition(a);this.chartX=a.chartX;this.chartY=a.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=!0};a.prototype.mouseMoveHandler=function(a){var c=this.chart.pointer.normalize(a),f=this.options.vertical?"chartY":"chartX",g=this.initPositions||
[];!this.grabbedCenter||a.touches&&0===a.touches[0][f]||(c=this.cursorToScrollbarPosition(c)[f],f=this[f],f=c-f,this.hasDragged=!0,this.updatePosition(g[0]+f,g[1]+f),this.hasDragged&&e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a}))};a.prototype.mouseUpHandler=function(a){this.hasDragged&&e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null};a.prototype.position=
function(a,c,e,g){var f=this.options.vertical,n=this.rendered?"animate":"attr",m=g,u=0;this.group.show();this.x=a;this.y=c+this.trackBorderWidth;this.width=e;this.height=g;this.xOffset=m;this.yOffset=u;f?(this.width=this.yOffset=e=u=this.size,this.xOffset=m=0,this.barWidth=g-2*e,this.x=a+=this.options.margin):(this.height=this.xOffset=g=m=this.size,this.barWidth=e-2*g,this.y+=this.options.margin);this.group[n]({translateX:a,translateY:this.y});this.track[n]({width:e,height:g});this.scrollbarButtons[1][n]({translateX:f?
0:e-m,translateY:f?g-u:0})};a.prototype.removeEvents=function(){this._events.forEach(function(a){c.apply(null,a)});this._events.length=0};a.prototype.render=function(){var c=this.renderer,e=this.options,g=this.size,m=this.chart.styledMode,n=c.g("scrollbar").attr({zIndex:e.zIndex}).hide().add();this.group=n;this.track=c.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:e.trackBorderRadius||0,height:g,width:g}).add(n);m||this.track.attr({fill:e.trackBackgroundColor,stroke:e.trackBorderColor,
"stroke-width":e.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=c.g().add(n);this.scrollbar=c.rect().addClass("highcharts-scrollbar-thumb").attr({height:g,width:g,r:e.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=c.path(a.swapXY([["M",-3,g/4],["L",-3,2*g/3],["M",0,g/4],["L",0,2*g/3],["M",3,g/4],["L",3,2*g/3]],e.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);m||(this.scrollbar.attr({fill:e.barBackgroundColor,
stroke:e.barBorderColor,"stroke-width":e.barBorderWidth}),this.scrollbarRifles.attr({stroke:e.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)};a.prototype.setRange=function(a,c){var e=this.options,f=e.vertical,g=e.minWidth,n=this.barWidth,m=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?
"attr":"animate";if(t(n)){var u=n*Math.min(c,1);a=Math.max(a,0);var l=Math.ceil(n*a);this.calculatedWidth=u=z(u-l);u<g&&(l=(n-g+u)*a,u=g);g=Math.floor(l+this.xOffset+this.yOffset);n=u/2-.5;this.from=a;this.to=c;f?(this.scrollbarGroup[m]({translateY:g}),this.scrollbar[m]({height:u}),this.scrollbarRifles[m]({translateY:n}),this.scrollbarTop=g,this.scrollbarLeft=0):(this.scrollbarGroup[m]({translateX:g}),this.scrollbar[m]({width:u}),this.scrollbarRifles[m]({translateX:n}),this.scrollbarLeft=g,this.scrollbarTop=
0);12>=u?this.scrollbarRifles.hide():this.scrollbarRifles.show();!1===e.showFull&&(0>=a&&1<=c?this.group.hide():this.group.show());this.rendered=!0}};a.prototype.shouldUpdateExtremes=function(a){return m(this.options.liveRedraw,q.svg&&!q.isTouchDevice&&!this.chart.boosted)||"mouseup"===a||"touchend"===a||!t(a)};a.prototype.trackClick=function(a){var c=this.chart.pointer.normalize(a),f=this.to-this.from,g=this.y+this.scrollbarTop,n=this.x+this.scrollbarLeft;this.options.vertical&&c.chartY>g||!this.options.vertical&&
c.chartX>n?this.updatePosition(this.from+f,this.to+f):this.updatePosition(this.from-f,this.to-f);e(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.update=function(a){this.destroy();this.init(this.chart.renderer,g(!0,this.options,a),this.chart)};a.prototype.updatePosition=function(a,c){1<c&&(a=z(1-z(c-a)),c=1);0>a&&(c=z(c-a),a=0);this.from=a;this.to=c};a.defaultOptions=r;return a}();B.scrollbar=g(!0,a.defaultOptions,B.scrollbar);return a});C(a,"Stock/Navigator/Navigator.js",
[a["Core/Axis/Axis.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Core/Axis/NavigatorAxisComposition.js"],a["Stock/Navigator/NavigatorComposition.js"],a["Stock/Scrollbar/Scrollbar.js"],a["Core/Utilities.js"]],function(a,q,y,r,w,B,v){function z(a){for(var b=[],p=1;p<arguments.length;p++)b[p-1]=arguments[p];b=[].filter.call(b,x);if(b.length)return Math[a].apply(0,b)}var t=q.defaultOptions,n=y.hasTouch,e=y.isTouchDevice,g=v.addEvent,m=v.clamp,c=v.correctFloat,J=v.defined,f=v.destroyObjectProperties,
D=v.erase,E=v.extend,C=v.find,F=v.isArray,x=v.isNumber,G=v.merge,u=v.pick,l=v.removeEvent,d=v.splat;return function(){function h(b){this.zoomedMin=this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.rendered=this.range=this.outlineHeight=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=this.left=this.height=this.handles=this.chart=this.baseSeries=void 0;this.init(b)}h.compose=function(b,a,k){w.compose(b,
a,h,k)};h.prototype.drawHandle=function(b,a,k,d){var p=this.navigatorOptions.handles.height;this.handles[a][d](k?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(b,10)+.5-p)}:{translateX:Math.round(this.left+parseInt(b,10)),translateY:Math.round(this.top+this.height/2-p/2-1)})};h.prototype.drawOutline=function(b,a,k,d){var p=this.navigatorOptions.maskInside,h=this.outline.strokeWidth(),A=h/2,c=h%2/2;h=this.outlineHeight;var e=this.scrollbarHeight||0,f=this.size,
l=this.left-e,g=this.top;k?(l-=A,k=g+a+c,a=g+b+c,c=[["M",l+h,g-e-c],["L",l+h,k],["L",l,k],["L",l,a],["L",l+h,a],["L",l+h,g+f+e]],p&&c.push(["M",l+h,k-A],["L",l+h,a+A])):(b+=l+e-c,a+=l+e-c,g+=A,c=[["M",l,g],["L",b,g],["L",b,g+h],["L",a,g+h],["L",a,g],["L",l+f+2*e,g]],p&&c.push(["M",b-A,g],["L",a+A,g]));this.outline[d]({d:c})};h.prototype.drawMasks=function(b,a,k,d){var p=this.left,h=this.top,A=this.height;if(k){var c=[p,p,p];var e=[h,h+b,h+a];var f=[A,A,A];var l=[b,a-b,this.size-a]}else c=[p,p+b,p+
a],e=[h,h,h],f=[b,a-b,this.size-a],l=[A,A,A];this.shades.forEach(function(b,a){b[d]({x:c[a],y:e[a],width:f[a],height:l[a]})})};h.prototype.renderElements=function(){var b=this,a=b.navigatorOptions,d=a.maskInside,h=b.chart,c=h.renderer,e={cursor:h.inverted?"ns-resize":"ew-resize"},f=b.navigatorGroup=c.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!d,d,!d].forEach(function(p,d){var k=c.rect().addClass("highcharts-navigator-mask"+(1===d?"-inside":"-outside")).add(f);h.styledMode||(k.attr({fill:p?
a.maskFill:"rgba(0,0,0,0)"}),1===d&&k.css(e));b.shades[d]=k});b.outline=c.path().addClass("highcharts-navigator-outline").add(f);h.styledMode||b.outline.attr({"stroke-width":a.outlineWidth,stroke:a.outlineColor});if(a.handles&&a.handles.enabled){var l=a.handles,g=l.height,n=l.width;[0,1].forEach(function(a){b.handles[a]=c.symbol(l.symbols[a],-n/2-1,0,n,g,l);h.inverted&&b.handles[a].attr({rotation:90,rotationOriginX:Math.floor(-n/2),rotationOriginY:(g+n)/2});b.handles[a].attr({zIndex:7-a}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+
["left","right"][a]).add(f);h.styledMode||b.handles[a].attr({fill:l.backgroundColor,stroke:l.borderColor,"stroke-width":l.lineWidth}).css(e)})}};h.prototype.update=function(b){(this.series||[]).forEach(function(b){b.baseSeries&&delete b.baseSeries.navigatorSeries});this.destroy();G(!0,this.chart.options.navigator,b);this.init(this.chart)};h.prototype.render=function(b,a,d,h){var p=this.chart,k=this.xAxis,A=k.pointRange||0,e=k.navigatorAxis.fake?p.xAxis[0]:k,f=this.navigatorEnabled,l=this.rendered,
g=p.inverted,n=p.xAxis[0].minRange,t=p.xAxis[0].options.maxRange,v=this.scrollbarHeight,q;if(!this.hasDragged||J(d)){b=c(b-A/2);a=c(a+A/2);if(!x(b)||!x(a))if(l)d=0,h=u(k.width,e.width);else return;this.left=u(k.left,p.plotLeft+v+(g?p.plotWidth:0));var r=this.size=q=u(k.len,(g?p.plotHeight:p.plotWidth)-2*v);p=g?v:q+2*v;d=u(d,k.toPixels(b,!0));h=u(h,k.toPixels(a,!0));x(d)&&Infinity!==Math.abs(d)||(d=0,h=p);b=k.toValue(d,!0);a=k.toValue(h,!0);var w=Math.abs(c(a-b));w<n?this.grabbedLeft?d=k.toPixels(a-
n-A,!0):this.grabbedRight&&(h=k.toPixels(b+n+A,!0)):J(t)&&c(w-A)>t&&(this.grabbedLeft?d=k.toPixels(a-t-A,!0):this.grabbedRight&&(h=k.toPixels(b+t+A,!0)));this.zoomedMax=m(Math.max(d,h),0,r);this.zoomedMin=m(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(d,h),0,r);this.range=this.zoomedMax-this.zoomedMin;r=Math.round(this.zoomedMax);d=Math.round(this.zoomedMin);f&&(this.navigatorGroup.attr({visibility:"inherit"}),l=l&&!this.hasDragged?"animate":"attr",this.drawMasks(d,r,g,l),this.drawOutline(d,
r,g,l),this.navigatorOptions.handles.enabled&&(this.drawHandle(d,0,g,l),this.drawHandle(r,1,g,l)));this.scrollbar&&(g?(g=this.top-v,e=this.left-v+(f||!e.opposite?0:(e.titleOffset||0)+e.axisTitleMargin),v=q+2*v):(g=this.top+(f?this.height:-v),e=this.left-v),this.scrollbar.position(e,g,p,v),this.scrollbar.setRange(this.zoomedMin/(q||1),this.zoomedMax/(q||1)));this.rendered=!0}};h.prototype.addMouseEvents=function(){var b=this,a=b.chart,d=a.container,h=[],c,e;b.mouseMoveHandler=c=function(a){b.onMouseMove(a)};
b.mouseUpHandler=e=function(a){b.onMouseUp(a)};h=b.getPartsEvents("mousedown");h.push(g(a.renderTo,"mousemove",c),g(d.ownerDocument,"mouseup",e));n&&(h.push(g(a.renderTo,"touchmove",c),g(d.ownerDocument,"touchend",e)),h.concat(b.getPartsEvents("touchstart")));b.eventsToUnbind=h;b.series&&b.series[0]&&h.push(g(b.series[0].xAxis,"foundExtremes",function(){a.navigator.modifyNavigatorAxisExtremes()}))};h.prototype.getPartsEvents=function(b){var a=this,d=[];["shades","handles"].forEach(function(p){a[p].forEach(function(k,
h){d.push(g(k.element,b,function(b){a[p+"Mousedown"](b,h)}))})});return d};h.prototype.shadesMousedown=function(b,a){b=this.chart.pointer.normalize(b);var p=this.chart,d=this.xAxis,h=this.zoomedMin,c=this.size,e=this.range,f=this.left,l=b.chartX;p.inverted&&(l=b.chartY,f=this.top);if(1===a)this.grabbedCenter=l,this.fixedWidth=e,this.dragOffset=l-h;else{b=l-f-e/2;if(0===a)b=Math.max(0,b);else if(2===a&&b+e>=c)if(b=c-e,this.reversedExtremes){b-=e;var g=this.getUnionExtremes().dataMin}else var n=this.getUnionExtremes().dataMax;
b!==h&&(this.fixedWidth=e,a=d.navigatorAxis.toFixedRange(b,b+e,g,n),J(a.min)&&p.xAxis[0].setExtremes(Math.min(a.min,a.max),Math.max(a.min,a.max),!0,null,{trigger:"navigator"}))}};h.prototype.handlesMousedown=function(b,a){this.chart.pointer.normalize(b);b=this.chart;var p=b.xAxis[0],d=this.reversedExtremes;0===a?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=d?p.min:p.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=d?p.max:p.min);b.fixedRange=
null};h.prototype.onMouseMove=function(b){var a=this,d=a.chart,h=a.navigatorSize,c=a.range,f=a.dragOffset,l=d.inverted,g=a.left;b.touches&&0===b.touches[0].pageX||(b=d.pointer.normalize(b),d=b.chartX,l&&(g=a.top,d=b.chartY),a.grabbedLeft?(a.hasDragged=!0,a.render(0,0,d-g,a.otherHandlePos)):a.grabbedRight?(a.hasDragged=!0,a.render(0,0,a.otherHandlePos,d-g)):a.grabbedCenter&&(a.hasDragged=!0,d<f?d=f:d>h+f-c&&(d=h+f-c),a.render(0,0,d-f,d-f+c)),a.hasDragged&&a.scrollbar&&u(a.scrollbar.options.liveRedraw,
y.svg&&!e&&!this.chart.boosted)&&(b.DOMType=b.type,setTimeout(function(){a.onMouseUp(b)},0)))};h.prototype.onMouseUp=function(b){var a=this.chart,d=this.xAxis,h=this.scrollbar,c=b.DOMEvent||b,e=a.inverted,f=this.rendered&&!this.hasDragged?"animate":"attr";if(this.hasDragged&&(!h||!h.hasDragged)||"scrollbar"===b.trigger){h=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var l=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var g=this.fixedExtreme;this.zoomedMax===this.size&&
(g=this.reversedExtremes?h.dataMin:h.dataMax);0===this.zoomedMin&&(l=this.reversedExtremes?h.dataMax:h.dataMin);d=d.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,l,g);J(d.min)&&a.xAxis[0].setExtremes(Math.min(d.min,d.max),Math.max(d.min,d.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:c})}"mousemove"!==b.DOMType&&"touchmove"!==b.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=
this.hasDragged=this.dragOffset=null);this.navigatorEnabled&&x(this.zoomedMin)&&x(this.zoomedMax)&&(a=Math.round(this.zoomedMin),b=Math.round(this.zoomedMax),this.shades&&this.drawMasks(a,b,e,f),this.outline&&this.drawOutline(a,b,e,f),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(a,0,e,f),this.drawHandle(b,1,e,f)))};h.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(b){b()}),this.eventsToUnbind=
void 0);this.removeBaseSeriesEvents()};h.prototype.removeBaseSeriesEvents=function(){var b=this.baseSeries||[];this.navigatorEnabled&&b[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&b.forEach(function(b){l(b,"updatedData",this.updatedDataHandler)},this),b[0].xAxis&&l(b[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))};h.prototype.init=function(b){var d=b.options,k=d.navigator||{},h=k.enabled,c=d.scrollbar||{},e=c.enabled;d=h&&k.height||0;var f=e&&c.height||0;this.handles=[];this.shades=
[];this.chart=b;this.setBaseSeries();this.height=d;this.scrollbarHeight=f;this.scrollbarEnabled=e;this.navigatorEnabled=h;this.navigatorOptions=k;this.scrollbarOptions=c;this.outlineHeight=d+f;this.opposite=u(k.opposite,!(h||!b.inverted));var l=this;h=l.baseSeries;c=b.xAxis.length;e=b.yAxis.length;var n=h&&h[0]&&h[0].xAxis||b.xAxis[0]||{options:{}};b.isDirtyBox=!0;l.navigatorEnabled?(l.xAxis=new a(b,G({breaks:n.options.breaks,ordinal:n.options.ordinal},k.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",
isX:!0,type:"datetime",index:c,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},b.inverted?{offsets:[f,0,-f,0],width:d}:{offsets:[0,-f,0,f],height:d})),l.yAxis=new a(b,G(k.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:e,isInternal:!0,reversed:u(k.yAxis&&k.yAxis.reversed,b.yAxis[0]&&b.yAxis[0].reversed,!1),zoomEnabled:!1},b.inverted?{width:d}:{height:d})),h||k.series.data?l.updateNavigatorSeries(!1):0===b.series.length&&
(l.unbindRedraw=g(b,"beforeRedraw",function(){0<b.series.length&&!l.series&&(l.setBaseSeries(),l.unbindRedraw())})),l.reversedExtremes=b.inverted&&!l.xAxis.reversed||!b.inverted&&l.xAxis.reversed,l.renderElements(),l.addMouseEvents()):(l.xAxis={chart:b,navigatorAxis:{fake:!0},translate:function(a,d){var p=b.xAxis[0],k=p.getExtremes(),h=p.len-2*f,c=z("min",p.options.min,k.dataMin);p=z("max",p.options.max,k.dataMax)-c;return d?a*p/h+c:h*(a-c)/p},toPixels:function(b){return this.translate(b)},toValue:function(b){return this.translate(b,
!0)}},l.xAxis.navigatorAxis.axis=l.xAxis,l.xAxis.navigatorAxis.toFixedRange=r.prototype.toFixedRange.bind(l.xAxis.navigatorAxis));b.options.scrollbar.enabled&&(b.scrollbar=l.scrollbar=new B(b.renderer,G(b.options.scrollbar,{margin:l.navigatorEnabled?0:10,vertical:b.inverted}),b),g(l.scrollbar,"changed",function(b){var a=l.size,d=a*this.to;a*=this.from;l.hasDragged=l.scrollbar.hasDragged;l.render(0,0,a,d);this.shouldUpdateExtremes(b.DOMType)&&setTimeout(function(){l.onMouseUp(b)})}));l.addBaseSeriesEvents();
l.addChartEvents()};h.prototype.getUnionExtremes=function(b){var a=this.chart.xAxis[0],d=this.xAxis,h=d.options,c=a.options,e;b&&null===a.dataMin||(e={dataMin:u(h&&h.min,z("min",c.min,a.dataMin,d.dataMin,d.min)),dataMax:u(h&&h.max,z("max",c.max,a.dataMax,d.dataMax,d.max))});return e};h.prototype.setBaseSeries=function(b,a){var d=this.chart,p=this.baseSeries=[];b=b||d.options&&d.options.navigator.baseSeries||(d.series.length?C(d.series,function(b){return!b.options.isInternal}).index:0);(d.series||
[]).forEach(function(a,d){a.options.isInternal||!a.options.showInNavigator&&(d!==b&&a.options.id!==b||!1===a.options.showInNavigator)||p.push(a)});this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,a)};h.prototype.updateNavigatorSeries=function(a,p){var b=this,h=b.chart,c=b.baseSeries,e={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},
f=b.series=(b.series||[]).filter(function(a){var d=a.baseSeries;return 0>c.indexOf(d)?(d&&(l(d,"updatedData",b.updatedDataHandler),delete d.navigatorSeries),a.chart&&a.destroy(),!1):!0}),g,n,m=b.navigatorOptions.series,I;c&&c.length&&c.forEach(function(a){var k=a.navigatorSeries,l=E({color:a.color,visible:a.visible},F(m)?t.navigator.series:m);k&&!1===b.navigatorOptions.adaptToUpdatedData||(e.name="Navigator "+c.length,g=a.options||{},I=g.navigatorOptions||{},l.dataLabels=d(l.dataLabels),n=G(g,e,l,
I),n.pointRange=u(l.pointRange,I.pointRange,t.plotOptions[n.type||"line"].pointRange),l=I.data||l.data,b.hasNavigatorData=b.hasNavigatorData||!!l,n.data=l||g.data&&g.data.slice(0),k&&k.options?k.update(n,p):(a.navigatorSeries=h.initSeries(n),a.navigatorSeries.baseSeries=a,f.push(a.navigatorSeries)))});if(m.data&&(!c||!c.length)||F(m))b.hasNavigatorData=!1,m=d(m),m.forEach(function(a,d){e.name="Navigator "+(f.length+1);n=G(t.navigator.series,{color:h.series[d]&&!h.series[d].options.isInternal&&h.series[d].color||
h.options.colors[d]||h.options.colors[0]},e,a);n.data=a.data;n.data&&(b.hasNavigatorData=!0,f.push(h.initSeries(n)))});a&&this.addBaseSeriesEvents()};h.prototype.addBaseSeriesEvents=function(){var a=this,d=this,k=d.baseSeries||[];k[0]&&k[0].xAxis&&k[0].eventsToUnbind.push(g(k[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes));k.forEach(function(b){b.eventsToUnbind.push(g(b,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)}));b.eventsToUnbind.push(g(b,"hide",function(){this.navigatorSeries&&
this.navigatorSeries.setVisible(!1,!1)}));!1!==a.navigatorOptions.adaptToUpdatedData&&b.xAxis&&b.eventsToUnbind.push(g(b,"updatedData",a.updatedDataHandler));b.eventsToUnbind.push(g(b,"remove",function(){this.navigatorSeries&&(D(d.series,this.navigatorSeries),J(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})};h.prototype.getBaseSeriesMin=function(a){return this.baseSeries.reduce(function(a,b){return Math.min(a,b.xData&&b.xData.length?b.xData[0]:a)},
a)};h.prototype.modifyNavigatorAxisExtremes=function(){var a=this.xAxis;if("undefined"!==typeof a.getExtremes){var d=this.getUnionExtremes(!0);!d||d.dataMin===a.min&&d.dataMax===a.max||(a.min=d.dataMin,a.max=d.dataMax)}};h.prototype.modifyBaseAxisExtremes=function(){var a=this.chart.navigator,d=this.getExtremes(),k=d.dataMin,h=d.dataMax;d=d.max-d.min;var c=a.stickToMin,e=a.stickToMax,f=u(this.options.overscroll,0),l=a.series&&a.series[0],g=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==
this.eventArgs.trigger){if(c){var n=k;var m=n+d}e&&(m=h+f,c||(n=Math.max(k,m-d,a.getBaseSeriesMin(l&&l.xData?l.xData[0]:-Number.MAX_VALUE))));g&&(c||e)&&x(n)&&(this.min=this.userMin=n,this.max=this.userMax=m)}a.stickToMin=a.stickToMax=null};h.prototype.updatedDataHandler=function(){var a=this.chart.navigator,d=this.navigatorSeries;a.stickToMax=u(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,a.reversedExtremes?0===Math.round(a.zoomedMin):Math.round(a.zoomedMax)>=Math.round(a.size));
a.stickToMin=a.shouldStickToMin(this,a);d&&!a.hasNavigatorData&&(d.options.pointStart=this.xData[0],d.setData(this.options.data,!1,null,!1))};h.prototype.shouldStickToMin=function(a,d){d=d.getBaseSeriesMin(a.xData[0]);var b=a.xAxis;a=b.max;var p=b.min;b=b.options.range;return x(a)&&x(p)?b&&0<a-d?a-d<b:p<=d:!1};h.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(g(this.chart,"redraw",function(){var a=this.navigator,d=a&&(a.baseSeries&&a.baseSeries[0]&&
a.baseSeries[0].xAxis||this.xAxis[0]);d&&a.render(d.min,d.max)}),g(this.chart,"getMargins",function(){var a=this.navigator,d=a.opposite?"plotTop":"marginBottom";this.inverted&&(d=a.opposite?"marginRight":"plotLeft");this[d]=(this[d]||0)+(a.navigatorEnabled||!this.inverted?a.outlineHeight:0)+a.navigatorOptions.margin}))};h.prototype.destroy=function(){var a=this;this.removeEvents();this.xAxis&&(D(this.chart.xAxis,this.xAxis),D(this.chart.axes,this.xAxis));this.yAxis&&(D(this.chart.yAxis,this.yAxis),
D(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(a){a.destroy&&a.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(b){a[b]&&a[b].destroy&&a[b].destroy();a[b]=null});[this.handles].forEach(function(a){f(a)})};return h}()});C(a,"Stock/RangeSelector/RangeSelectorDefaults.js",[],function(){return{lang:{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"\u2192"},rangeSelector:{allButtonsEnabled:!1,
buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#335cad",cursor:"pointer"},labelStyle:{color:"#666666"}}}});
C(a,"Stock/RangeSelector/RangeSelectorComposition.js",[a["Core/Defaults.js"],a["Stock/RangeSelector/RangeSelectorDefaults.js"],a["Core/Utilities.js"]],function(a,q,y){function r(){var a=this.range,d=a.type,h=this.max,b=this.chart.time,p=function(a,p){var h="year"===d?"FullYear":"Month",k=new b.Date(a),c=b.get(h,k);b.set(h,k,c+p);c===b.get(h,k)&&b.set("Date",k,0);return k.getTime()-a};if(E(a)){var k=h-a;var c=a}else a&&(k=h+p(h,-(a.count||1)),this.chart&&(this.chart.fixedRange=h-k));var e=F(this.dataMin,
Number.MIN_VALUE);E(k)||(k=e);k<=e&&(k=e,"undefined"===typeof c&&(c=p(k,a.count)),this.newMax=Math.min(k+c,F(this.dataMax,Number.MAX_VALUE)));E(h)?!E(a)&&a&&a._offsetMin&&(k+=a._offsetMin):k=void 0;return k}function w(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new u(this))}function B(){var a=this.axes,d=this.rangeSelector;d&&(E(d.deferredYTDClick)&&(d.clickButton(d.deferredYTDClick),delete d.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),
this.getAxisMargins(),d.render(),a=d.options.verticalAlign,d.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))}function v(a){var d,h,b,p,k=a.rangeSelector,e=function(){k&&(d=a.xAxis[0].getExtremes(),h=a.legend,p=k&&k.options.verticalAlign,E(d.min)&&k.render(d.min,d.max),h.display&&"top"===p&&p===h.options.verticalAlign&&(b=C(a.spacingBox),b.y="vertical"===h.options.layout?a.plotTop:b.y+k.getHeight(),h.group.placed=!1,h.align(b)))};k&&(D(x,function(b){return b[0]===
a})||x.push([a,[c(a.xAxis[0],"afterSetExtremes",function(a){k&&k.render(a.min,a.max)}),c(a,"redraw",e)]]),e())}function z(){for(var a=0,d=x.length;a<d;++a){var h=x[a];if(h[0]===this){h[1].forEach(function(a){return a()});x.splice(a,1);break}}}function t(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))}function n(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?
this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))}function e(a){var d=a.options.rangeSelector;a=this.extraBottomMargin;var h=this.extraTopMargin,b=this.rangeSelector;d&&d.enabled&&!J(b)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=b=new u(this));this.extraTopMargin=this.extraBottomMargin=!1;b&&(v(this),d=d&&d.verticalAlign||b.options&&b.options.verticalAlign,b.options.floating||("bottom"===d?this.extraBottomMargin=!0:"middle"!==d&&(this.extraTopMargin=
!0)),this.extraBottomMargin!==a||this.extraTopMargin!==h)&&(this.isDirtyBox=!0)}var g=a.defaultOptions,m=a.setOptions,c=y.addEvent,J=y.defined,f=y.extend,D=y.find,E=y.isNumber,C=y.merge,F=y.pick,x=[],G=[],u;return{compose:function(a,d,h){u=h;-1===G.indexOf(a)&&(G.push(a),a.prototype.minFromRange=r);-1===G.indexOf(d)&&(G.push(d),c(d,"afterGetContainer",w),c(d,"beforeRender",B),c(d,"destroy",z),c(d,"getMargins",t),c(d,"render",n),c(d,"update",e),d.prototype.callbacks.push(v));-1===G.indexOf(m)&&(f(g,
{rangeSelector:q.rangeSelector}),f(g.lang,q.lang))}}});C(a,"Stock/RangeSelector/RangeSelector.js",[a["Core/Axis/Axis.js"],a["Core/Defaults.js"],a["Core/Globals.js"],a["Stock/RangeSelector/RangeSelectorComposition.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,q,y,r,w,B){function v(a){if(-1!==a.indexOf("%L"))return"text";var d="aAdewbBmoyY".split("").some(function(b){return-1!==a.indexOf("%"+b)}),h="HkIlMS".split("").some(function(b){return-1!==a.indexOf("%"+b)});return d&&
h?"datetime-local":d?"date":h?"time":"text"}var z=q.defaultOptions,t=B.addEvent,n=B.createElement,e=B.css,g=B.defined,m=B.destroyObjectProperties,c=B.discardElement,J=B.extend,f=B.fireEvent,D=B.isNumber,E=B.merge,C=B.objectEach,F=B.pad,x=B.pick,G=B.pInt,u=B.splat;q=function(){function l(a){this.buttons=void 0;this.buttonOptions=l.prototype.defaultButtons;this.initialButtonGroupWidth=0;this.options=void 0;this.chart=a;this.init(a)}l.compose=function(a,h){r.compose(a,h,l)};l.prototype.clickButton=function(d,
h){var b=this.chart,p=this.buttonOptions[d],k=b.xAxis[0],c=b.scroller&&b.scroller.getUnionExtremes()||k||{},e=p.type,l=p.dataGrouping,n=c.dataMin,m=c.dataMax,v=k&&Math.round(Math.min(k.max,x(m,k.max)));c=p._range;var r,I=!0;if(null!==n&&null!==m){b.fixedRange=c;this.setSelected(d);l&&(this.forcedDataGrouping=!0,a.prototype.setDataGrouping.call(k||{chart:this.chart},l,!1),this.frozenStates=p.preserveDataGrouping);if("month"===e||"year"===e)if(k){e={range:p,max:v,chart:b,dataMin:n,dataMax:m};var q=
k.minFromRange.call(e);D(e.newMax)&&(v=e.newMax);I=!1}else c=p;else if(c)q=Math.max(v-c,n),v=Math.min(q+c,m),I=!1;else if("ytd"===e)if(k){if("undefined"===typeof m||"undefined"===typeof n)n=Number.MAX_VALUE,m=Number.MIN_VALUE,b.series.forEach(function(a){if(a=a.xData)n=Math.min(a[0],n),m=Math.max(a[a.length-1],m)}),h=!1;e=this.getYTDExtremes(m,n,b.time.useUTC);q=r=e.min;v=e.max}else{this.deferredYTDClick=d;return}else"all"===e&&k&&(b.navigator&&b.navigator.baseSeries[0]&&(b.navigator.baseSeries[0].xAxis.options.range=
void 0),q=n,v=m);I&&p._offsetMin&&g(q)&&(q+=p._offsetMin);p._offsetMax&&g(v)&&(v+=p._offsetMax);this.dropdown&&(this.dropdown.selectedIndex=d+1);if(k)k.setExtremes(q,v,x(h,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:p});else{var w=u(b.options.xAxis)[0];var z=w.range;w.range=c;var B=w.min;w.min=r;t(b,"load",function(){w.range=z;w.min=B})}f(this,"afterBtnClick")}};l.prototype.setSelected=function(a){this.selected=this.options.selected=a};l.prototype.init=function(a){var d=this,b=a.options.rangeSelector,
p=b.buttons||d.defaultButtons.slice(),k=b.selected,c=function(){var a=d.minInput,b=d.maxInput;a&&a.blur&&f(a,"blur");b&&b.blur&&f(b,"blur")};d.chart=a;d.options=b;d.buttons=[];d.buttonOptions=p;this.eventsToUnbind=[];this.eventsToUnbind.push(t(a.container,"mousedown",c));this.eventsToUnbind.push(t(a,"resize",c));p.forEach(d.computeButtonRange);"undefined"!==typeof k&&p[k]&&this.clickButton(k,!1);this.eventsToUnbind.push(t(a,"load",function(){a.xAxis&&a.xAxis[0]&&t(a.xAxis[0],"setExtremes",function(b){this.max-
this.min!==a.fixedRange&&"rangeSelectorButton"!==b.trigger&&"updatedData"!==b.trigger&&d.forcedDataGrouping&&!d.frozenStates&&this.setDataGrouping(!1,!1)})}))};l.prototype.updateButtonStates=function(){var a=this,h=this.chart,b=this.dropdown,p=h.xAxis[0],k=Math.round(p.max-p.min),c=!p.hasVisibleSeries,e=h.scroller&&h.scroller.getUnionExtremes()||p,f=e.dataMin,g=e.dataMax;h=a.getYTDExtremes(g,f,h.time.useUTC);var l=h.min,n=h.max,m=a.selected,v=a.options.allButtonsEnabled,t=a.buttons,u=D(m);a.buttonOptions.forEach(function(d,
h){var e=d._range,A=d.type,M=d.count||1,K=t[h],I=d._offsetMax-d._offsetMin,q=h===m,r=e>g-f,w=e<p.minRange;d=0;var H=!1,x=!1;e=e===k;("month"===A||"year"===A)&&k+36E5>=864E5*{month:28,year:365}[A]*M-I&&k-36E5<=864E5*{month:31,year:366}[A]*M+I?e=!0:"ytd"===A?(e=n-l+I===k,H=!q):"all"===A&&(e=p.max-p.min>=g-f,x=!q&&u&&e);A=!v&&(r||w||x||c);M=q&&e||e&&!u&&!H||q&&a.frozenStates;A?d=3:M&&(u=!0,d=2);K.state!==d&&(K.setState(d),b&&(b.options[h+1].disabled=A,2===d&&(b.selectedIndex=h+1)),0===d&&m===h&&a.setSelected())})};
l.prototype.computeButtonRange=function(a){var d=a.type,b=a.count||1,p={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(p[d])a._range=p[d]*b;else if("month"===d||"year"===d)a._range=864E5*{month:30,year:365}[d]*b;a._offsetMin=x(a.offsetMin,0);a._offsetMax=x(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin};l.prototype.getInputValue=function(a){a="min"===a?this.minInput:this.maxInput;var d=this.chart.options.rangeSelector,b=this.chart.time;return a?("text"===a.type&&d.inputDateParser||
this.defaultInputDateParser)(a.value,b.useUTC,b):0};l.prototype.setInputValue=function(a,h){var b=this.options,d=this.chart.time,k="min"===a?this.minInput:this.maxInput;a="min"===a?this.minDateBox:this.maxDateBox;if(k){var c=k.getAttribute("data-hc-time");c=g(c)?Number(c):void 0;g(h)&&(g(c)&&k.setAttribute("data-hc-time-previous",c),k.setAttribute("data-hc-time",h),c=h);k.value=d.dateFormat(this.inputTypeFormats[k.type]||b.inputEditDateFormat,c);a&&a.attr({text:d.dateFormat(b.inputDateFormat,c)})}};
l.prototype.setInputExtremes=function(a,h,b){if(a="min"===a?this.minInput:this.maxInput){var d=this.inputTypeFormats[a.type],k=this.chart.time;d&&(h=k.dateFormat(d,h),a.min!==h&&(a.min=h),b=k.dateFormat(d,b),a.max!==b&&(a.max=b))}};l.prototype.showInput=function(a){var d="min"===a?this.minDateBox:this.maxDateBox;if((a="min"===a?this.minInput:this.maxInput)&&d&&this.inputGroup){var b="text"===a.type,p=this.inputGroup,k=p.translateX;p=p.translateY;var c=this.options.inputBoxWidth;e(a,{width:b?d.width+
(c?-2:20)+"px":"auto",height:b?d.height-2+"px":"auto",border:"2px solid silver"});b&&c?e(a,{left:k+d.x+"px",top:p+"px"}):e(a,{left:Math.min(Math.round(d.x+k-(a.offsetWidth-d.width)/2),this.chart.chartWidth-a.offsetWidth)+"px",top:p-(a.offsetHeight-d.height)/2+"px"})}};l.prototype.hideInput=function(a){(a="min"===a?this.minInput:this.maxInput)&&e(a,{top:"-9999em",border:0,width:"1px",height:"1px"})};l.prototype.defaultInputDateParser=function(a,c,b){var d=a.split("/").join("-").split(" ").join("T");
-1===d.indexOf("T")&&(d+="T00:00");if(c)d+="Z";else{var k;if(k=y.isSafari)k=d,k=!(6<k.length&&(k.lastIndexOf("-")===k.length-6||k.lastIndexOf("+")===k.length-6));k&&(k=(new Date(d)).getTimezoneOffset()/60,d+=0>=k?"+".concat(F(-k),":00"):"-".concat(F(k),":00"))}d=Date.parse(d);D(d)||(a=a.split("-"),d=Date.UTC(G(a[0]),G(a[1])-1,G(a[2])));b&&c&&D(d)&&(d+=b.getTimezoneOffset(d));return d};l.prototype.drawInput=function(a){function d(){var d=c.maxInput,p=c.minInput,k=b.xAxis[0],h=b.scroller&&b.scroller.xAxis?
b.scroller.xAxis:k,e=h.dataMin;h=h.dataMax;var f=c.getInputValue(a);f!==Number(t.getAttribute("data-hc-time-previous"))&&D(f)&&(t.setAttribute("data-hc-time-previous",f),m&&d&&D(e)?f>Number(d.getAttribute("data-hc-time"))?f=void 0:f<e&&(f=e):p&&D(h)&&(f<Number(p.getAttribute("data-hc-time"))?f=void 0:f>h&&(f=h)),"undefined"!==typeof f&&k.setExtremes(m?f:k.min,m?k.max:f,void 0,void 0,{trigger:"rangeSelectorInput"}))}var b=this.chart,p=this.div,k=this.inputGroup,c=this,f=b.renderer.style||{},g=b.renderer,
l=b.options.rangeSelector,m="min"===a,u=z.lang[m?"rangeSelectorFrom":"rangeSelectorTo"]||"";u=g.label(u,0).addClass("highcharts-range-label").attr({padding:u?2:0,height:u?l.inputBoxHeight:0}).add(k);g=g.label("",0).addClass("highcharts-range-input").attr({padding:2,width:l.inputBoxWidth,height:l.inputBoxHeight,"text-align":"center"}).on("click",function(){c.showInput(a);c[a+"Input"].focus()});b.styledMode||g.attr({stroke:l.inputBoxBorderColor,"stroke-width":1});g.add(k);var t=n("input",{name:a,className:"highcharts-range-selector"},
void 0,p);t.setAttribute("type",v(l.inputDateFormat||"%b %e, %Y"));b.styledMode||(u.css(E(f,l.labelStyle)),g.css(E({color:"#333333"},f,l.inputStyle)),e(t,J({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:f.fontSize,fontFamily:f.fontFamily,top:"-9999em"},l.inputStyle)));t.onfocus=function(){c.showInput(a)};t.onblur=function(){t===y.doc.activeElement&&d();c.hideInput(a);c.setInputValue(a);t.blur()};var I=!1;t.onchange=
function(){I||(d(),c.hideInput(a),t.blur())};t.onkeypress=function(a){13===a.keyCode&&d()};t.onkeydown=function(a){I=!0;38!==a.keyCode&&40!==a.keyCode||d()};t.onkeyup=function(){I=!1};return{dateBox:g,input:t,label:u}};l.prototype.getPosition=function(){var a=this.chart,c=a.options.rangeSelector;a="top"===c.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+c.buttonPosition.y,inputTop:a+c.inputPosition.y-10}};l.prototype.getYTDExtremes=function(a,c,b){var d=this.chart.time,k=new d.Date(a),
h=d.get("FullYear",k);b=b?d.Date.UTC(h,0,1):+new d.Date(h,0,1);c=Math.max(c,b);k=k.getTime();return{max:Math.min(a||k,k),min:c}};l.prototype.render=function(a,c){var b=this.chart,d=b.renderer,k=b.container,h=b.options,e=h.rangeSelector,f=x(h.chart.style&&h.chart.style.zIndex,0)+1;h=e.inputEnabled;if(!1!==e.enabled){this.rendered||(this.group=d.g("range-selector-group").attr({zIndex:7}).add(),this.div=n("div",void 0,{position:"relative",height:0,zIndex:f}),this.buttonOptions.length&&this.renderButtons(),
k.parentNode&&k.parentNode.insertBefore(this.div,k),h&&(this.inputGroup=d.g("input-group").add(this.group),d=this.drawInput("min"),this.minDateBox=d.dateBox,this.minLabel=d.label,this.minInput=d.input,d=this.drawInput("max"),this.maxDateBox=d.dateBox,this.maxLabel=d.label,this.maxInput=d.input));if(h&&(this.setInputValue("min",a),this.setInputValue("max",c),a=b.scroller&&b.scroller.getUnionExtremes()||b.xAxis[0]||{},g(a.dataMin)&&g(a.dataMax)&&(b=b.xAxis[0].minRange||0,this.setInputExtremes("min",
a.dataMin,Math.min(a.dataMax,this.getInputValue("max"))-b),this.setInputExtremes("max",Math.max(a.dataMin,this.getInputValue("min"))+b,a.dataMax)),this.inputGroup)){var l=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(a){if(a){var b=a.getBBox().width;b&&(a.attr({x:l}),l+=b+e.inputSpacing)}})}this.alignElements();this.rendered=!0}};l.prototype.renderButtons=function(){var a=this,c=this.buttons,b=this.options,p=z.lang,k=this.chart.renderer,e=E(b.buttonTheme),g=e&&e.states,
l=e.width||28;delete e.width;delete e.states;this.buttonGroup=k.g("range-selector-buttons").add(this.group);var m=this.dropdown=n("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:.0001},this.div);t(m,"touchstart",function(){m.style.fontSize="16px"});[[y.isMS?"mouseover":"mouseenter"],[y.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(b){var d=b[0],k=b[1];t(m,d,function(){var b=c[a.currentButtonIndex()];b&&f(b.element,
k||d)})});this.zoomText=k.label(p&&p.rangeSelectorZoom||"",0).attr({padding:b.buttonTheme.padding,height:b.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup);this.chart.styledMode||(this.zoomText.css(b.labelStyle),e["stroke-width"]=x(e["stroke-width"],0));n("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,m);this.buttonOptions.forEach(function(b,d){n("option",{textContent:b.title||b.text},void 0,m);c[d]=k.button(b.text,0,0,function(k){var c=b.events&&b.events.click,
p;c&&(p=c.call(b,k));!1!==p&&a.clickButton(d);a.isActive=!0},e,g&&g.hover,g&&g.select,g&&g.disabled).attr({"text-align":"center",width:l}).add(a.buttonGroup);b.title&&c[d].attr("title",b.title)})};l.prototype.alignElements=function(){var a=this,c=this.buttonGroup,b=this.buttons,p=this.chart,k=this.group,e=this.inputGroup,f=this.options,g=this.zoomText,l=p.options,n=l.exporting&&!1!==l.exporting.enabled&&l.navigation&&l.navigation.buttonOptions;l=f.buttonPosition;var m=f.inputPosition,t=f.verticalAlign,
u=function(b,d){return n&&a.titleCollision(p)&&"top"===t&&"right"===d.align&&d.y-b.getBBox().height-12<(n.y||0)+(n.height||0)+p.spacing[0]?-40:0},v=p.plotLeft;if(k&&l&&m){var q=l.x-p.spacing[3];if(c){this.positionButtons();if(!this.initialButtonGroupWidth){var r=0;g&&(r+=g.getBBox().width+5);b.forEach(function(a,d){r+=a.width;d!==b.length-1&&(r+=f.buttonSpacing)});this.initialButtonGroupWidth=r}v-=p.spacing[3];this.updateButtonStates();g=u(c,l);this.alignButtonGroup(g);k.placed=c.placed=p.hasLoaded}c=
0;e&&(c=u(e,m),"left"===m.align?q=v:"right"===m.align&&(q=-Math.max(p.axisOffset[1],-c)),e.align({y:m.y,width:e.getBBox().width,align:m.align,x:m.x+q-2},!0,p.spacingBox),e.placed=p.hasLoaded);this.handleCollision(c);k.align({verticalAlign:t},!0,p.spacingBox);e=k.alignAttr.translateY;c=k.getBBox().height+20;u=0;"bottom"===t&&(u=(u=p.legend&&p.legend.options)&&"bottom"===u.verticalAlign&&u.enabled&&!u.floating?p.legend.legendHeight+x(u.margin,10):0,c=c+u-20,u=e-c-(f.floating?0:f.y)-(p.titleOffset?p.titleOffset[2]:
0)-10);if("top"===t)f.floating&&(u=0),p.titleOffset&&p.titleOffset[0]&&(u=p.titleOffset[0]),u+=p.margin[0]-p.spacing[0]||0;else if("middle"===t)if(m.y===l.y)u=e;else if(m.y||l.y)u=0>m.y||0>l.y?u-Math.min(m.y,l.y):e-c;k.translate(f.x,f.y+Math.floor(u));l=this.minInput;m=this.maxInput;e=this.dropdown;f.inputEnabled&&l&&m&&(l.style.marginTop=k.translateY+"px",m.style.marginTop=k.translateY+"px");e&&(e.style.marginTop=k.translateY+"px")}};l.prototype.alignButtonGroup=function(a,c){var b=this.chart,d=
this.buttonGroup,k=this.options.buttonPosition,e=b.plotLeft-b.spacing[3],h=k.x-b.spacing[3];"right"===k.align?h+=a-e:"center"===k.align&&(h-=e/2);d&&d.align({y:k.y,width:x(c,this.initialButtonGroupWidth),align:k.align,x:h},!0,b.spacingBox)};l.prototype.positionButtons=function(){var a=this.buttons,c=this.chart,b=this.options,p=this.zoomText,k=c.hasLoaded?"animate":"attr",e=b.buttonPosition,f=c=c.plotLeft;p&&"hidden"!==p.visibility&&(p[k]({x:x(c+e.x,c)}),f+=e.x+p.getBBox().width+5);p=0;for(e=this.buttonOptions.length;p<
e;++p)if("hidden"!==a[p].visibility)a[p][k]({x:f}),f+=a[p].width+b.buttonSpacing;else a[p][k]({x:c})};l.prototype.handleCollision=function(a){var d=this,b=this.chart,c=this.buttonGroup,k=this.inputGroup,e=this.options,f=e.buttonPosition,g=e.dropdown,l=e.inputPosition;e=function(){var a=0;d.buttons.forEach(function(b){b=b.getBBox();b.width>a&&(a=b.width)});return a};var m=function(b){if(k&&c){var d=k.alignAttr.translateX+k.alignOptions.x-a+k.getBBox().x+2,p=k.alignOptions.width,e=c.alignAttr.translateX+
c.getBBox().x;return e+b>d&&d+p>e&&f.y<l.y+k.getBBox().height}return!1},n=function(){k&&c&&k.attr({translateX:k.alignAttr.translateX+(b.axisOffset[1]>=-a?0:-a),translateY:k.alignAttr.translateY+c.getBBox().height+10})};if(c){if("always"===g){this.collapseButtons(a);m(e())&&n();return}"never"===g&&this.expandButtons()}k&&c?l.align===f.align||m(this.initialButtonGroupWidth+20)?"responsive"===g?(this.collapseButtons(a),m(e())&&n()):n():"responsive"===g&&this.expandButtons():c&&"responsive"===g&&(this.initialButtonGroupWidth>
b.plotWidth?this.collapseButtons(a):this.expandButtons())};l.prototype.collapseButtons=function(a){var d=this.buttons,b=this.buttonOptions,c=this.chart,k=this.dropdown,e=this.options,f=this.zoomText,g=c.userOptions.rangeSelector&&c.userOptions.rangeSelector.buttonTheme||{},l=function(a){return{text:a?""+a+" \u25be":"\u25be",width:"auto",paddingLeft:x(e.buttonTheme.paddingLeft,g.padding,8),paddingRight:x(e.buttonTheme.paddingRight,g.padding,8)}};f&&f.hide();var m=!1;b.forEach(function(a,b){b=d[b];
2!==b.state?b.hide():(b.show(),b.attr(l(a.text)),m=!0)});m||(k&&(k.selectedIndex=0),d[0].show(),d[0].attr(l(this.zoomText&&this.zoomText.textStr)));b=e.buttonPosition.align;this.positionButtons();"right"!==b&&"center"!==b||this.alignButtonGroup(a,d[this.currentButtonIndex()].getBBox().width);this.showDropdown()};l.prototype.expandButtons=function(){var a=this.buttons,c=this.buttonOptions,b=this.options,p=this.zoomText;this.hideDropdown();p&&p.show();c.forEach(function(d,c){c=a[c];c.show();c.attr({text:d.text,
width:b.buttonTheme.width||28,paddingLeft:x(b.buttonTheme.paddingLeft,"unset"),paddingRight:x(b.buttonTheme.paddingRight,"unset")});2>c.state&&c.setState(0)});this.positionButtons()};l.prototype.currentButtonIndex=function(){var a=this.dropdown;return a&&0<a.selectedIndex?a.selectedIndex-1:0};l.prototype.showDropdown=function(){var a=this.buttonGroup,c=this.buttons,b=this.chart,p=this.dropdown;if(a&&p){var k=a.translateX;a=a.translateY;c=c[this.currentButtonIndex()].getBBox();e(p,{left:b.plotLeft+
k+"px",top:a+.5+"px",width:c.width+"px",height:c.height+"px"});this.hasVisibleDropdown=!0}};l.prototype.hideDropdown=function(){var a=this.dropdown;a&&(e(a,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)};l.prototype.getHeight=function(){var a=this.options,c=this.group,b=a.y,p=a.buttonPosition.y,k=a.inputPosition.y;if(a.height)return a.height;this.alignElements();a=c?c.getBBox(!0).height+13+b:0;c=Math.min(k,p);if(0>k&&0>p||0<k&&0<p)a+=Math.abs(c);return a};l.prototype.titleCollision=
function(a){return!(a.options.title.text||a.options.subtitle.text)};l.prototype.update=function(a){var d=this.chart;E(!0,d.options.rangeSelector,a);this.destroy();this.init(d);this.render()};l.prototype.destroy=function(){var a=this,e=a.minInput,b=a.maxInput;a.eventsToUnbind&&(a.eventsToUnbind.forEach(function(a){return a()}),a.eventsToUnbind=void 0);m(a.buttons);e&&(e.onfocus=e.onblur=e.onchange=null);b&&(b.onfocus=b.onblur=b.onchange=null);C(a,function(b,d){b&&"chart"!==d&&(b instanceof w?b.destroy():
b instanceof window.HTMLElement&&c(b));b!==l.prototype[d]&&(a[d]=null)},this)};return l}();J(q.prototype,{defaultButtons:[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],inputTypeFormats:{"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",
time:"%H:%M:%S"}});"";return q});C(a,"Core/Axis/OrdinalAxis.js",[a["Core/Axis/Axis.js"],a["Core/Globals.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,q,y,r){var w=r.addEvent,B=r.correctFloat,v=r.css,z=r.defined,t=r.error,n=r.pick,e=r.timeUnits,g=[],m;(function(a){function c(a,d,c,h,f,g,l){void 0===f&&(f=[]);void 0===g&&(g=0);var b={},k=this.options.tickPixelInterval,p=this.chart.time,m=[],n,u,A=0,v=[],q=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!f||3>f.length||
"undefined"===typeof d)return p.getTimeTicks.apply(p,arguments);var r=f.length;for(n=0;n<r;n++){var w=n&&f[n-1]>c;f[n]<d&&(A=n);if(n===r-1||f[n+1]-f[n]>5*g||w){if(f[n]>q){for(u=p.getTimeTicks(a,f[A],f[n],h);u.length&&u[0]<=q;)u.shift();u.length&&(q=u[u.length-1]);m.push(v.length);v=v.concat(u)}A=n+1}if(w)break}if(u){u=u.info;if(l&&u.unitRange<=e.hour){n=v.length-1;for(A=1;A<n;A++)if(p.dateFormat("%d",v[A])!==p.dateFormat("%d",v[A-1])){b[v[A]]="day";var x=!0}x&&(b[v[0]]="day");u.higherRanks=b}u.segmentStarts=
m;v.info=u}else t(12,!1,this.chart);if(l&&z(k)){u=v.length;p=[];A=[];n=void 0;for(x=u;x--;)m=this.translate(v[x]),n&&(A[x]=n-m),p[x]=n=m;A.sort();A=A[Math.floor(A.length/2)];A<.6*k&&(A=null);x=v[u-1]>c?u-1:u;for(n=void 0;x--;)m=p[x],u=Math.abs(n-m),n&&u<.8*k&&(null===A||u<.8*A)?(b[v[x]]&&!b[v[x+1]]?(u=x+1,n=m):u=x,v.splice(u,1)):n=m}return v}function f(a){var b=this.ordinal.positions;if(!b)return a;var d=b.length-1;if(0>a)a=b[0];else if(a>d)a=b[d];else{d=Math.floor(a);var c=a-d}return"undefined"!==
typeof c&&"undefined"!==typeof b[d]?b[d]+(c?c*(b[d+1]-b[d]):0):a}function m(a){var b=this.ordinal,d=b.positions;if(!d)return a;var c=(a-(this.old?this.old.min:this.min))*(this.old?this.old.transA:this.transA)+this.minPixelPadding;0<c&&c<this.left+this.len||(b.extendedOrdinalPositions||(b.extendedOrdinalPositions=b.getExtendedPositions()),d=b.extendedOrdinalPositions);if(d&&d.length){a=b.getIndexOfPoint(c,d);b=B(a%1);if(0<=a&&a<d.length-1)return d[Math.floor(a)]+b*(d[Math.ceil(a)]-d[Math.floor(a)]);
b=d.length;c=d[0];d=d[b-1];var e=(d-c)/(b-1);return 0>a?c+e*a:d+e*(a-b)}return a}function r(b,d){var c=a.Additions.findIndexOf(b,d,!0);return b[c]===d?c:c+(d-b[c])/(b[c+1]-b[c])}function E(){this.ordinal||(this.ordinal=new a.Additions(this))}function F(){this.isXAxis&&z(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&z(this.userMin)&&
(this.min+=this.options.overscroll))}function x(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)}function G(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))}function u(a){var b=this.xAxis[0],d=b.options.overscroll,c=a.originalEvent.chartX,e=this.options.chart.panning,f=!1;if(e&&"y"!==e.type&&b.options.ordinal&&b.series.length){var h=this.mouseDownX,
g=b.getExtremes(),l=g.dataMax,n=g.min,m=g.max,u=this.hoverPoints,t=b.closestPointRange||b.ordinal&&b.ordinal.overscrollPointsRange;h=(h-c)/(b.translationSlope*(b.ordinal.slope||t));t=b.ordinal.getExtendedPositions();t={ordinal:{positions:t,extendedOrdinalPositions:t}};var q=b.index2val,r=b.val2lin,x=void 0,w=x=void 0,z=void 0;t.ordinal.positions?1<Math.abs(h)&&(u&&u.forEach(function(a){a.setState()}),0>h?(w=t,z=b.ordinal.positions?b:t):(w=b.ordinal.positions?b:t,z=t),x=z.ordinal.positions,l>x[x.length-
1]&&x.push(l),this.fixedRange=m-n,x=b.navigatorAxis.toFixedRange(void 0,void 0,q.apply(w,[r.apply(w,[n,!0])+h]),q.apply(z,[r.apply(z,[m,!0])+h])),x.min>=Math.min(g.dataMin,n)&&x.max<=Math.max(l,m)+d&&b.setExtremes(x.min,x.max,!0,!1,{trigger:"pan"}),this.mouseDownX=c,v(this.container,{cursor:"move"})):f=!0}else f=!0;f||e&&/y/.test(e.type)?d&&(b.max=b.dataMax+d):a.preventDefault()}function l(){var a=this.xAxis;a&&a.options.ordinal&&(delete a.ordinal.index,delete a.ordinal.extendedOrdinalPositions)}
function d(a,d){var b=this.ordinal,c=b.positions,e=b.slope,f=b.extendedOrdinalPositions;if(!c)return a;var p=c.length;if(c[0]<=a&&c[p-1]>=a)a=r(c,a);else{f||(f=b.getExtendedPositions&&b.getExtendedPositions(),b.extendedOrdinalPositions=f);if(!f||!f.length)return a;p=f.length;e||(e=(f[p-1]-f[0])/p);c=r(f,c[0]);a>=f[0]&&a<=f[p-1]?a=r(f,a)-c:a<f[0]?(a=f[0]-a,a=-c-a/e):(a-=f[p-1],a=a/e+p-c)}return d?a:e*(a||0)+b.offset}a.compose=function(a,e,k){if(-1===g.indexOf(a)){g.push(a);var b=a.prototype;b.getTimeTicks=
c;b.index2val=f;b.lin2val=m;b.val2lin=d;b.ordinal2lin=b.val2lin;w(a,"afterInit",E);w(a,"foundExtremes",F);w(a,"afterSetScale",x);w(a,"initialAxisTranslation",G)}-1===g.indexOf(k)&&(g.push(k),w(k,"pan",u));-1===g.indexOf(e)&&(g.push(e),w(e,"updatedData",l));return a};var h=function(){function a(a){this.index={};this.axis=a}a.prototype.beforeSetTickPositions=function(){var a=this.axis,b=a.ordinal,d=a.getExtremes(),c=d.min,e=d.max,f=a.isXAxis&&!!a.options.breaks;d=a.options.ordinal;var h=a.chart.options.chart.ignoreHiddenSeries,
g,l,m=[],u=Number.MAX_VALUE,t=!1,v=!1,q=!1;if(d||f){var x=0;a.series.forEach(function(a,b){g=[];0<b&&"highcharts-navigator-series"!==a.options.id&&1<a.processedXData.length&&(v=x!==a.processedXData[1]-a.processedXData[0]);x=a.processedXData[1]-a.processedXData[0];a.boosted&&(q=a.boosted);if(!(h&&!1===a.visible||!1===a.takeOrdinalPosition&&!f)&&(m=m.concat(a.processedXData),r=m.length,m.sort(function(a,b){return a-b}),u=Math.min(u,n(a.closestPointRange,u)),r)){for(b=0;b<r-1;)m[b]!==m[b+1]&&g.push(m[b+
1]),b++;g[0]!==m[0]&&g.unshift(m[0]);m=g}});v&&q&&(m.pop(),m.shift());var r=m.length;if(2<r){var w=m[1]-m[0];for(l=r-1;l--&&!t;)m[l+1]-m[l]!==w&&(t=!0);!a.options.keepOrdinalPadding&&(m[0]-c>w||e-m[m.length-1]>w)&&(t=!0)}else a.options.overscroll&&(2===r?u=m[1]-m[0]:1===r?(u=a.options.overscroll,m=[m[0],m[0]+u]):u=b.overscrollPointsRange);t||a.forceOrdinal?(a.options.overscroll&&(b.overscrollPointsRange=u,m=m.concat(b.getOverscrollPositions())),b.positions=m,w=a.ordinal2lin(Math.max(c,m[0]),!0),l=
Math.max(a.ordinal2lin(Math.min(e,m[m.length-1]),!0),1),b.slope=e=(e-c)/(l-w),b.offset=c-w*e):(b.overscrollPointsRange=n(a.closestPointRange,b.overscrollPointsRange),b.positions=a.ordinal.slope=b.offset=void 0)}a.isOrdinal=d&&t;b.groupIntervalFactor=null};a.findIndexOf=function(a,b,d){for(var c=0,e=a.length-1,f;c<e;)f=Math.ceil((c+e)/2),a[f]<=b?c=f:e=f-1;return a[c]===b?c:d?c:-1};a.prototype.getExtendedPositions=function(){var a=this,b=a.axis,d=b.constructor.prototype,c=b.chart,e=b.series[0].currentDataGrouping,
f=e?e.count+e.unitName:"raw",h=b.options.overscroll,g=b.getExtremes(),l=void 0,m=a.index;m||(m=a.index={});if(!m[f]){var n={series:[],chart:c,forceOrdinal:!1,getExtremes:function(){return{min:g.dataMin,max:g.dataMax+h}},getGroupPixelWidth:d.getGroupPixelWidth,getTimeTicks:d.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:d.ordinal2lin,getIndexOfPoint:d.getIndexOfPoint,val2lin:d.val2lin};n.ordinal.axis=n;b.series.forEach(function(b){l={xAxis:n,
xData:b.xData.slice(),chart:c,destroyGroupedData:q.noop,getProcessedData:y.prototype.getProcessedData,applyGrouping:y.prototype.applyGrouping};l.xData=l.xData.concat(a.getOverscrollPositions());l.options={dataGrouping:e?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[e.unitName,[e.count]]]}:{enabled:!1}};n.series.push(l);b.processData.apply(l)});l.closestPointRange!==l.basePointRange&&l.currentDataGrouping&&(n.forceOrdinal=!0);b.ordinal.beforeSetTickPositions.apply({axis:n});
m[f]=n.ordinal.positions}return m[f]};a.prototype.getGroupIntervalFactor=function(a,b,d){d=d.processedXData;var c=d.length,e=[];var f=this.groupIntervalFactor;if(!f){for(f=0;f<c-1;f++)e[f]=d[f+1]-d[f];e.sort(function(a,b){return a-b});e=e[Math.floor(c/2)];a=Math.max(a,d[0]);b=Math.min(b,d[c-1]);this.groupIntervalFactor=f=c*e/(b-a)}return f};a.prototype.getIndexOfPoint=function(b,d){var c=this.axis,e=this.positions?this.positions[0]:0,f=c.series[0].points&&c.series[0].points[0]&&c.series[0].points[0].plotX||
c.minPixelPadding;1<c.series.length&&c.series.forEach(function(a){a.points&&z(a.points[0])&&z(a.points[0].plotX)&&a.points[0].plotX<f&&(f=a.points[0].plotX)});b=(b-f)/(c.translationSlope*(this.slope||c.closestPointRange||this.overscrollPointsRange));return a.findIndexOf(d,e)+b};a.prototype.getOverscrollPositions=function(){var a=this.axis,b=a.options.overscroll,d=this.overscrollPointsRange,c=[],e=a.dataMax;if(z(d))for(;e<=a.dataMax+b;)e+=d,c.push(e);return c};a.prototype.postProcessTickInterval=function(a){var b=
this.axis,d=this.slope;return d?b.options.breaks?b.closestPointRange||a:a/(d/b.closestPointRange):a};return a}();a.Additions=h})(m||(m={}));return m});C(a,"Series/HLC/HLCPoint.js",[a["Core/Series/SeriesRegistry.js"]],function(a){var q=this&&this.__extends||function(){var a=function(r,q){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,v){a.__proto__=v}||function(a,v){for(var q in v)v.hasOwnProperty(q)&&(a[q]=v[q])};return a(r,q)};return function(q,w){function r(){this.constructor=
q}a(q,w);q.prototype=null===w?Object.create(w):(r.prototype=w.prototype,new r)}}();return function(a){function r(){var q=null!==a&&a.apply(this,arguments)||this;q.close=void 0;q.high=void 0;q.low=void 0;q.options=void 0;q.plotClose=void 0;q.series=void 0;return q}q(r,a);return r}(a.seriesTypes.column.prototype.pointClass)});C(a,"Series/HLC/HLCSeriesDefaults.js",[],function(){"";return{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},
threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}});C(a,"Series/HLC/HLCSeries.js",[a["Series/HLC/HLCPoint.js"],a["Series/HLC/HLCSeriesDefaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,y,r){var w=this&&this.__extends||function(){var a=function(n,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,e){a.__proto__=e}||function(a,e){for(var c in e)e.hasOwnProperty(c)&&(a[c]=e[c])};return a(n,e)};return function(n,e){function g(){this.constructor=
n}a(n,e);n.prototype=null===e?Object.create(e):(g.prototype=e.prototype,new g)}}(),B=y.seriesTypes.column,v=r.extend,z=r.merge;r=function(a){function n(){var e=null!==a&&a.apply(this,arguments)||this;e.data=void 0;e.options=void 0;e.points=void 0;e.yData=void 0;return e}w(n,a);n.prototype.extendStem=function(a,g,m){var c=a[0];a=a[1];"number"===typeof c[2]&&(c[2]=Math.max(m+g,c[2]));"number"===typeof a[2]&&(a[2]=Math.min(m-g,a[2]))};n.prototype.getPointPath=function(a,g){g=g.strokeWidth();var e=a.series,
c=g%2/2,n=Math.round(a.plotX)-c,f=Math.round(a.shapeArgs.width/2),v=[["M",n,Math.round(a.yBottom)],["L",n,Math.round(a.plotHigh)]];null!==a.close&&(a=Math.round(a.plotClose)+c,v.push(["M",n,a],["L",n+f,a]),e.extendStem(v,g/2,a));return v};n.prototype.drawSinglePoint=function(a){var e=a.series,m=e.chart,c=a.graphic;"undefined"!==typeof a.plotY&&(c||(a.graphic=c=m.renderer.path().add(e.group)),m.styledMode||c.attr(e.pointAttribs(a,a.selected&&"select")),e=e.getPointPath(a,c),c[c?"animate":"attr"]({d:e}).addClass(a.getClassName(),
!0))};n.prototype.drawPoints=function(){this.points.forEach(this.drawSinglePoint)};n.prototype.init=function(){a.prototype.init.apply(this,arguments);this.options.stacking=void 0};n.prototype.pointAttribs=function(e,g){e=a.prototype.pointAttribs.call(this,e,g);delete e.fill;return e};n.prototype.toYData=function(a){return[a.high,a.low,a.close]};n.prototype.translate=function(){var e=this,g=e.yAxis,m=this.pointArrayMap&&this.pointArrayMap.slice()||[],c=m.map(function(a){return"plot".concat(a.charAt(0).toUpperCase()+
a.slice(1))});c.push("yBottom");m.push("low");a.prototype.translate.apply(e);e.points.forEach(function(a){m.forEach(function(f,m){f=a[f];null!==f&&(e.dataModify&&(f=e.dataModify.modifyValue(f)),a[c[m]]=g.toPixels(f,!0))});a.tooltipPos[1]=a.plotHigh+g.pos-e.chart.plotTop})};n.defaultOptions=z(B.defaultOptions,q);return n}(B);v(r.prototype,{pointClass:a,animate:null,directTouch:!1,pointArrayMap:["high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});
y.registerSeriesType("hlc",r);return r});C(a,"Series/OHLC/OHLCPoint.js",[a["Core/Series/SeriesRegistry.js"]],function(a){var q=this&&this.__extends||function(){var a=function(q,w){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,v){a.__proto__=v}||function(a,v){for(var q in v)v.hasOwnProperty(q)&&(a[q]=v[q])};return a(q,w)};return function(q,w){function r(){this.constructor=q}a(q,w);q.prototype=null===w?Object.create(w):(r.prototype=w.prototype,new r)}}();return function(a){function r(){var q=
null!==a&&a.apply(this,arguments)||this;q.open=void 0;q.options=void 0;q.plotOpen=void 0;q.series=void 0;return q}q(r,a);r.prototype.getClassName=function(){return a.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")};r.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)};r.prototype.resolveColor=function(){a.prototype.resolveColor.call(this);this.resolveUpColor()};
r.prototype.getZone=function(){var q=a.prototype.getZone.call(this);this.resolveUpColor();return q};r.prototype.applyOptions=function(){a.prototype.applyOptions.apply(this,arguments);this.resolveColor&&this.resolveColor();return this};return r}(a.seriesTypes.hlc.prototype.pointClass)});C(a,"Series/OHLC/OHLCSeriesDefaults.js",[],function(){"";return{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'}}});
C(a,"Series/OHLC/OHLCSeries.js",[a["Series/OHLC/OHLCPoint.js"],a["Series/OHLC/OHLCSeriesDefaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,y,r){function w(a){a=a.options;var c=a.dataGrouping;c&&a.useOhlcData&&"highcharts-navigator-series"!==a.id&&(c.approximation="ohlc")}function B(a){a=a.options;a.useOhlcData&&"highcharts-navigator-series"!==a.id&&n(this,{pointValKey:m.prototype.pointValKey,pointArrayMap:m.prototype.pointArrayMap,toYData:m.prototype.toYData})}var v=
this&&this.__extends||function(){var a=function(c,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var e in c)c.hasOwnProperty(e)&&(a[e]=c[e])};return a(c,e)};return function(c,e){function f(){this.constructor=c}a(c,e);c.prototype=null===e?Object.create(e):(f.prototype=e.prototype,new f)}}(),z=y.seriesTypes.hlc,t=r.addEvent,n=r.extend,e=r.merge,g=[],m=function(a){function c(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=
void 0;c.points=void 0;return c}v(c,a);c.compose=function(a){for(var c=1;c<arguments.length;c++);-1===g.indexOf(a)&&(g.push(a),t(a,"afterSetOptions",w),t(a,"init",B))};c.prototype.getPointPath=function(c,e){var f=a.prototype.getPointPath.call(this,c,e);e=e.strokeWidth();var g=e%2/2,m=Math.round(c.plotX)-g,n=Math.round(c.shapeArgs.width/2);null!==c.open&&(c=Math.round(c.plotOpen)+g,f.push(["M",m,c],["L",m-n,c]),a.prototype.extendStem.call(this,f,e/2,c));return f};c.prototype.pointAttribs=function(c,
e){e=a.prototype.pointAttribs.call(this,c,e);var f=this.options;delete e.fill;!c.options.color&&f.upColor&&c.open<c.close&&(e.stroke=f.upColor);return e};c.prototype.toYData=function(a){return[a.open,a.high,a.low,a.close]};c.defaultOptions=e(z.defaultOptions,q);return c}(z);n(m.prototype,{pointClass:a,pointArrayMap:["open","high","low","close"]});y.registerSeriesType("ohlc",m);return m});C(a,"Series/Candlestick/CandlestickSeriesDefaults.js",[a["Core/Defaults.js"],a["Core/Utilities.js"]],function(a,
q){"";return{states:{hover:{lineWidth:2}},threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}});C(a,"Series/Candlestick/CandlestickSeries.js",[a["Series/Candlestick/CandlestickSeriesDefaults.js"],a["Core/Defaults.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q,y,r){var w=this&&this.__extends||function(){var a=function(e,g){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var e in c)c.hasOwnProperty(e)&&
(a[e]=c[e])};return a(e,g)};return function(e,g){function m(){this.constructor=e}a(e,g);e.prototype=null===g?Object.create(g):(m.prototype=g.prototype,new m)}}(),B=q.defaultOptions;q=y.seriesTypes;var v=q.column,z=q.ohlc,t=r.merge;r=function(n){function e(){var a=null!==n&&n.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}w(e,n);e.prototype.pointAttribs=function(a,e){var c=v.prototype.pointAttribs.call(this,a,e),g=this.options,f=a.open<a.close,m=g.lineColor||this.color,
n=a.color||this.color;c["stroke-width"]=g.lineWidth;c.fill=a.options.color||(f?g.upColor||n:n);c.stroke=a.options.lineColor||(f?g.upLineColor||m:m);e&&(a=g.states[e],c.fill=a.color||c.fill,c.stroke=a.lineColor||c.stroke,c["stroke-width"]=a.lineWidth||c["stroke-width"]);return c};e.prototype.drawPoints=function(){for(var a=this.chart,e=this.yAxis.reversed,c=0,n=this.points;c<n.length;c++){var f=n[c],q=f.graphic,v=!q;if("undefined"!==typeof f.plotY){q||(f.graphic=q=a.renderer.path().add(this.group));
this.chart.styledMode||q.attr(this.pointAttribs(f,f.selected&&"select")).shadow(this.options.shadow);var t=q.strokeWidth()%2/2;var r=Math.round(f.plotX)-t;var x=f.plotOpen;var w=f.plotClose;var u=Math.min(x,w);x=Math.max(x,w);var l=Math.round(f.shapeArgs.width/2);w=e?x!==f.yBottom:Math.round(u)!==Math.round(f.plotHigh);var d=e?Math.round(u)!==Math.round(f.plotHigh):x!==f.yBottom;u=Math.round(u)+t;x=Math.round(x)+t;t=[];t.push(["M",r-l,x],["L",r-l,u],["L",r+l,u],["L",r+l,x],["Z"],["M",r,u],["L",r,
w?Math.round(e?f.yBottom:f.plotHigh):u],["M",r,x],["L",r,d?Math.round(e?f.plotHigh:f.yBottom):x]);q[v?"attr":"animate"]({d:t}).addClass(f.getClassName(),!0)}}};e.defaultOptions=t(z.defaultOptions,B.plotOptions,{tooltip:z.defaultOptions.tooltip},a);return e}(z);y.registerSeriesType("candlestick",r);return r});C(a,"Series/Flags/FlagsPoint.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,q){var y=this&&this.__extends||function(){var a=function(q,v){a=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,q){a.__proto__=q}||function(a,q){for(var n in q)q.hasOwnProperty(n)&&(a[n]=q[n])};return a(q,v)};return function(q,v){function r(){this.constructor=q}a(q,v);q.prototype=null===v?Object.create(v):(r.prototype=v.prototype,new r)}}(),r=q.isNumber;return function(a){function q(){var q=null!==a&&a.apply(this,arguments)||this;q.options=void 0;q.series=void 0;q.ttBelow=!1;return q}y(q,a);q.prototype.isValid=function(){return r(this.y)||"undefined"===typeof this.y};
q.prototype.hasNewShapeType=function(){var a=this.options.shape||this.series.options.shape;return this.graphic&&a&&a!==this.graphic.symbolKey};return q}(a.seriesTypes.column.prototype.pointClass)});C(a,"Series/Flags/FlagsSeriesDefaults.js",[],function(){"";return{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd6eb"}},style:{fontSize:"11px",
fontWeight:"bold"}}});C(a,"Series/Flags/FlagsSymbols.js",[a["Core/Renderer/RendererRegistry.js"]],function(a){var q;(function(q){function r(a,q,t,n,e){var g=e&&e.anchorX||a;e=e&&e.anchorY||q;var m=this.circle(g-1,e-1,2,2);m.push(["M",g,e],["L",a,q+n],["L",a,q],["L",a+t,q],["L",a+t,q+n],["L",a,q+n],["Z"]);return m}function w(a,q){a[q+"pin"]=function(t,n,e,g,m){var c=m&&m.anchorX;m=m&&m.anchorY;"circle"===q&&g>e&&(t-=Math.round((g-e)/2),e=g);var r=a[q](t,n,e,g);if(c&&m){var f=c;"circle"===q?f=t+e/2:
(t=r[0],e=r[1],"M"===t[0]&&"L"===e[0]&&(f=(t[1]+e[1])/2));r.push(["M",f,n>m?n:n+g],["L",c,m]);r=r.concat(a.circle(c-1,m-1,2,2))}return r}}var B=[];q.compose=function(q){if(-1===B.indexOf(q)){B.push(q);var v=q.prototype.symbols;v.flag=r;w(v,"circle");w(v,"square")}var t=a.getRendererType();B.indexOf(t)&&(B.push(t),v=q.prototype.symbols,q=t.prototype.symbols,q.circlepin=v.circlepin,q.flag=v.flag.bind(v),q.squarepin=v.squarepin)}})(q||(q={}));return q});C(a,"Series/OnSeriesComposition.js",[a["Series/Column/ColumnSeries.js"],
a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,q,y){var r=a.prototype,w=q.prototype,B=y.defined,v=y.stableSort,z;(function(a){function n(a){return w.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this,a)}function e(){r.translate.apply(this);var a=this,c=a.options,e=a.chart,f=a.points,g=c.onSeries,n=(g=g&&e.get(g))&&g.options.step,q=g&&g.points,t=e.inverted,x=a.xAxis,w=a.yAxis;e=f.length-1;var u;c=c.onKey||"y";var l=q&&q.length,d=0,h;if(g&&g.visible&&l){d=
(g.pointXOffset||0)+(g.barW||0)/2;var b=g.currentDataGrouping;var p=q[l-1].x+(b?b.totalRange:0);v(f,function(a,b){return a.x-b.x});for(c="plot"+c[0].toUpperCase()+c.substr(1);l--&&f[e];){var k=q[l];b=f[e];b.y=k.y;if(k.x<=b.x&&"undefined"!==typeof k[c]){if(b.x<=p&&(b.plotY=k[c],k.x<b.x&&!n&&(h=q[l+1])&&"undefined"!==typeof h[c])){var A=(b.x-k.x)/(h.x-k.x);b.plotY+=A*(h[c]-k[c]);b.y+=A*(h.y-k.y)}e--;l++;if(0>e)break}}}f.forEach(function(b,c){b.plotX+=d;if("undefined"===typeof b.plotY||t)0<=b.plotX&&
b.plotX<=x.len?t?(b.plotY=x.translate(b.x,0,1,0,1),b.plotX=B(b.y)?w.translate(b.y,0,0,0,1):0):b.plotY=(x.opposite?0:a.yAxis.len)+x.offset:b.shapeArgs={};if((u=f[c-1])&&u.plotX===b.plotX){"undefined"===typeof u.stackIndex&&(u.stackIndex=0);var e=u.stackIndex+1}b.stackIndex=e});this.onSeries=g}var g=[];a.compose=function(a){if(-1===g.indexOf(a)){g.push(a);var c=a.prototype;c.getPlotBox=n;c.translate=e}return a};a.getPlotBox=n;a.translate=e})(z||(z={}));return z});C(a,"Series/Flags/FlagsSeries.js",[a["Series/Flags/FlagsPoint.js"],
a["Series/Flags/FlagsSeriesDefaults.js"],a["Series/Flags/FlagsSymbols.js"],a["Core/Globals.js"],a["Series/OnSeriesComposition.js"],a["Core/Renderer/RendererUtilities.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,q,y,r,w,B,v,z,t){var n=this&&this.__extends||function(){var a=function(c,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var e in c)c.hasOwnProperty(e)&&(a[e]=c[e])};
return a(c,e)};return function(c,e){function f(){this.constructor=c}a(c,e);c.prototype=null===e?Object.create(e):(f.prototype=e.prototype,new f)}}();r=r.noop;var e=B.distribute,g=v.series,m=v.seriesTypes.column,c=t.addEvent,E=t.defined;B=t.extend;var f=t.merge,D=t.objectEach,C=t.wrap;t=function(a){function t(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}n(t,a);t.prototype.animate=function(a){a&&this.setClip()};t.prototype.drawPoints=function(){var a=
this.points,c=this.chart,g=c.renderer,l=c.inverted,d=this.options,h=d.y,b=this.yAxis,p={},k=[],n;for(n=a.length;n--;){var m=a[n];var q=(l?m.plotY:m.plotX)>this.xAxis.len;var t=m.plotX;var r=m.stackIndex;var v=m.options.shape||d.shape;var w=m.plotY;"undefined"!==typeof w&&(w=m.plotY+h-("undefined"!==typeof r&&r*d.stackDistance));m.anchorX=r?void 0:m.plotX;var B=r?void 0:m.plotY;var y="flag"!==v;r=m.graphic;"undefined"!==typeof w&&0<=t&&!q?(r&&m.hasNewShapeType()&&(r=r.destroy()),r||(r=m.graphic=g.label("",
null,null,v,null,null,d.useHTML).addClass("highcharts-point").add(this.markerGroup),m.graphic.div&&(m.graphic.div.point=m),r.isNew=!0),r.attr({align:y?"center":"left",width:d.width,height:d.height,"text-align":d.textAlign}),c.styledMode||r.attr(this.pointAttribs(m)).css(f(d.style,m.style)).shadow(d.shadow),0<t&&(t-=r.strokeWidth()%2),v={y:w,anchorY:B},d.allowOverlapX&&(v.x=t,v.anchorX=m.anchorX),r.attr({text:m.options.title||d.title||"A"})[r.isNew?"attr":"animate"](v),d.allowOverlapX||(p[m.plotX]?
p[m.plotX].size=Math.max(p[m.plotX].size,r.width):p[m.plotX]={align:y?.5:0,size:r.width,target:t,anchorX:t}),m.tooltipPos=[t,w+b.pos-c.plotTop]):r&&(m.graphic=r.destroy())}if(!d.allowOverlapX){var F=100;D(p,function(a){a.plotX=a.anchorX;k.push(a);F=Math.max(a.size,F)});e(k,l?b.len:this.xAxis.len,F);for(c=0;c<a.length;c++)g=a[c],h=g.plotX,(h=(l=g.graphic)&&p[h])&&l&&(E(h.pos)?l[l.isNew?"attr":"animate"]({x:h.pos+(h.align||0)*h.size,anchorX:g.anchorX}).show().isNew=!1:l.hide().isNew=!0)}d.useHTML&&
this.markerGroup&&C(this.markerGroup,"on",function(a){return z.prototype.on.apply(a.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})};t.prototype.drawTracker=function(){var e=this.points;a.prototype.drawTracker.call(this);for(var f=function(a){var d=a.graphic;d&&(a.unbindMouseOver&&a.unbindMouseOver(),a.unbindMouseOver=c(d.element,"mouseover",function(){0<a.stackIndex&&!a.raised&&(a._y=d.y,d.attr({y:a._y-8}),a.raised=!0);for(var c=0;c<e.length;c++){var b=e[c];b!==a&&b.raised&&
b.graphic&&(b.graphic.attr({y:b._y}),b.raised=!1)}}))},g=0;g<e.length;g++)f(e[g])};t.prototype.pointAttribs=function(a,c){var e=this.options,f=a&&a.color||this.color,d=e.lineColor,h=a&&a.lineWidth;a=a&&a.fillColor||e.fillColor;c&&(a=e.states[c].fillColor,d=e.states[c].lineColor,h=e.states[c].lineWidth);return{fill:a||f,stroke:d||f,"stroke-width":h||e.lineWidth||0}};t.prototype.setClip=function(){g.prototype.setClip.apply(this,arguments);!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup&&
this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])};t.compose=y.compose;t.defaultOptions=f(m.defaultOptions,q);return t}(m);w.compose(t);B(t.prototype,{allowDG:!1,forceCrop:!0,invertible:!1,noSharedTooltip:!0,pointClass:a,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],buildKDTree:r,init:g.prototype.init});v.registerSeriesType("flags",t);"";return t});C(a,"Core/Chart/StockChart.js",[a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/FormatUtilities.js"],a["Core/Defaults.js"],
a["Stock/Navigator/NavigatorDefaults.js"],a["Stock/RangeSelector/RangeSelectorDefaults.js"],a["Stock/Scrollbar/ScrollbarDefaults.js"],a["Core/Series/Series.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(a,q,y,r,w,B,v,z,t,n){function e(a,c){return"xAxis"===a?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:"yAxis"===a?{labels:{y:-2},opposite:u(c.opposite,!0),showLastLabel:!(!c.categories&&"category"!==c.type),
title:{text:null}}:{}}function g(a,c){return"xAxis"===a?(a={type:"datetime",categories:void 0},u(c.navigator&&c.navigator.enabled,w.enabled,!0)&&(a.startOnTick=!1,a.endOnTick=!1),a):{}}var m=this&&this.__extends||function(){var a=function(d,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d])};return a(d,b)};return function(d,b){function c(){this.constructor=d}a(d,b);d.prototype=null===b?Object.create(b):
(c.prototype=b.prototype,new c)}}(),c=y.format,E=r.getOptions;y=n.addEvent;var f=n.clamp,D=n.defined,C=n.extend,O=n.find,F=n.isNumber,x=n.isString,G=n.merge,u=n.pick,l=n.splat;n=function(a){function d(){return null!==a&&a.apply(this,arguments)||this}m(d,a);d.prototype.init=function(b,d){var c=E(),f=b.xAxis,h=b.yAxis,p=u(b.navigator&&b.navigator.enabled,w.enabled,!0);b.xAxis=b.yAxis=void 0;p=G({chart:{panning:{enabled:!0,type:"x"},zooming:{pinchType:"x"}},navigator:{enabled:p},scrollbar:{enabled:u(v.enabled,
!0)},rangeSelector:{enabled:u(B.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:u(c.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},b,{isStock:!0});b.xAxis=f;b.yAxis=h;p.xAxis=l(b.xAxis||{}).map(function(a,d){return G(e("xAxis",a),c.xAxis,c.xAxis&&c.xAxis[d],a,g("xAxis",b))});p.yAxis=l(b.yAxis||{}).map(function(a,b){return G(e("yAxis",a),c.yAxis,c.yAxis&&c.yAxis[b],a)});a.prototype.init.call(this,p,d)};d.prototype.createAxis=function(b,d){d.axis=G(e(b,d.axis),d.axis,g(b,this.userOptions));
return a.prototype.createAxis.call(this,b,d)};return d}(q);(function(a){a.stockChart=function(d,b,c){return new a(d,b,c)}})(n||(n={}));y(z,"setOptions",function(a){var d;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?d={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(d={marker:{enabled:!1,radius:2}}),d&&(a.plotOptions[this.type]=G(a.plotOptions[this.type],d)))});y(a,"autoLabelAlign",function(a){var d=this.chart,b=this.options;d=d._labelPanes=d._labelPanes||{};
var c=this.options.labels;this.chart.options.isStock&&"yAxis"===this.coll&&(b=b.top+","+b.height,!d[b]&&c.enabled&&(15===c.x&&(c.x=0),"undefined"===typeof c.align&&(c.align="right"),d[b]=this,a.align="right",a.preventDefault()))});y(a,"destroy",function(){var a=this.chart,c=this.options&&this.options.top+","+this.options.height;c&&a._labelPanes&&a._labelPanes[c]===this&&delete a._labelPanes[c]});y(a,"getPlotLinePath",function(a){function c(a){var c="xAxis"===a?"yAxis":"xAxis";a=b.options[c];return F(a)?
[e[c][a]]:x(a)?[e.get(a)]:d.map(function(a){return a[c]})}var b=this,d=this.isLinked&&!this.series?this.linkedParent.series:this.series,e=b.chart,g=e.renderer,l=b.left,m=b.top,n,q,r,t,v=[],w=[],z=a.translatedValue,B=a.value,y=a.force;if(e.options.isStock&&!1!==a.acrossPanes&&"xAxis"===b.coll||"yAxis"===b.coll){a.preventDefault();w=c(b.coll);var E=b.isXAxis?e.yAxis:e.xAxis;E.forEach(function(a){if(D(a.options.id)?-1===a.options.id.indexOf("navigator"):1){var c=a.isXAxis?"yAxis":"xAxis";c=D(a.options[c])?
e[c][a.options[c]]:e[c][0];b===c&&w.push(a)}});var C=w.length?[]:[b.isXAxis?e.yAxis[0]:e.xAxis[0]];w.forEach(function(a){-1!==C.indexOf(a)||O(C,function(b){return b.pos===a.pos&&b.len===a.len})||C.push(a)});var G=u(z,b.translate(B,void 0,void 0,a.old));F(G)&&(b.horiz?C.forEach(function(a){var c;q=a.pos;t=q+a.len;n=r=Math.round(G+b.transB);"pass"!==y&&(n<l||n>l+b.width)&&(y?n=r=f(n,l,l+b.width):c=!0);c||v.push(["M",n,q],["L",r,t])}):C.forEach(function(a){var c;n=a.pos;r=n+a.len;q=t=Math.round(m+b.height-
G);"pass"!==y&&(q<m||q>m+b.height)&&(y?q=t=f(q,m,m+b.height):c=!0);c||v.push(["M",n,q],["L",r,t])}));a.path=0<v.length?g.crispPolyLine(v,a.lineWidth||1):null}});t.prototype.crispPolyLine=function(a,c){for(var b=0;b<a.length;b+=2){var d=a[b],e=a[b+1];d[1]===e[1]&&(d[1]=e[1]=Math.round(d[1])-c%2/2);d[2]===e[2]&&(d[2]=e[2]=Math.round(d[2])+c%2/2)}return a};y(a,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});y(a,"afterDrawCrosshair",function(a){var d,b;if(this.crosshair&&
this.crosshair.label&&this.crosshair.label.enabled&&this.cross&&F(this.min)&&F(this.max)){var e=this.chart,f=this.logarithmic,g=this.crosshair.label,l=this.horiz,m=this.opposite,n=this.left,q=this.top,r=this.crossLabel,t=g.format,v="",w="inside"===this.options.tickPosition,x=!1!==this.crosshair.snap,z=0,y=a.e||this.cross&&this.cross.e;a=a.point;var B=this.min,E=this.max;f&&(B=f.lin2log(B),E=f.lin2log(E));f=l?"center":m?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";
r||(r=this.crossLabel=e.renderer.label("",0,void 0,g.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(a&&a.series?a.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:g.align||f,padding:u(g.padding,8),r:u(g.borderRadius,3),zIndex:2}).add(this.labelGroup),e.styledMode||r.attr({fill:g.backgroundColor||a&&a.series&&a.series.color||"#666666",stroke:g.borderColor||"","stroke-width":g.borderWidth||0}).css(C({color:"#ffffff",fontWeight:"normal",fontSize:"11px",
textAlign:"center"},g.style||{})));l?(f=x?(a.plotX||0)+n:y.chartX,q+=m?0:this.height):(f=m?this.width+n:0,q=x?(a.plotY||0)+q:y.chartY);t||g.formatter||(this.dateTime&&(v="%b %d, %Y"),t="{value"+(v?":"+v:"")+"}");v=x?this.isXAxis?a.x:a.y:this.toValue(l?y.chartX:y.chartY);x=a&&a.series?a.series.isPointInside(a):F(v)&&v>B&&v<E;y="";t?y=c(t,{value:v},e):g.formatter&&F(v)&&(y=g.formatter.call(this,v));r.attr({text:y,x:f,y:q,visibility:x?"inherit":"hidden"});g=r.getBBox();if(F(r.y))if(l){if(w&&!m||!w&&
m)q=r.y-g.height}else q=r.y-g.height/2;l?(d=n-g.x,b=n+this.width-g.x):(d="left"===this.labelAlign?n:0,b="right"===this.labelAlign?n+this.width:e.chartWidth);r.translateX<d&&(z=d-r.translateX);r.translateX+g.width>=b&&(z=-(r.translateX+g.width-b));r.attr({x:f+z,y:q,anchorX:l?f:this.opposite?0:e.chartWidth,anchorY:l?this.opposite?e.chartHeight:0:q+g.height/2})}});z.prototype.forceCropping=function(){var a=this.chart,c=this.options.dataGrouping;return!1!==this.allowDG&&c&&u(c.enabled,a.options.isStock)};
y(q,"update",function(a){a=a.options;"scrollbar"in a&&this.navigator&&(G(!0,this.options.scrollbar,a.scrollbar),this.navigator.update({}),delete a.scrollbar)});return n});C(a,"masters/modules/stock.src.js",[a["Core/Globals.js"],a["Series/DataModifyComposition.js"],a["Stock/Navigator/Navigator.js"],a["Stock/RangeSelector/RangeSelector.js"],a["Stock/Scrollbar/Scrollbar.js"],a["Core/Axis/OrdinalAxis.js"],a["Series/OHLC/OHLCSeries.js"],a["Series/Flags/FlagsSeries.js"],a["Core/Chart/StockChart.js"]],function(a,
q,y,r,w,B,v,z,t){a.Navigator=y;a.RangeSelector=r;a.Scrollbar=w;a.StockChart=a.stockChart=t.stockChart;q.compose(a.Series,a.Axis,a.Point);z.compose(a.Renderer);y.compose(a.Axis,a.Chart,a.Series);v.compose(a.Series);B.compose(a.Axis,a.Series,a.Chart);r.compose(a.Axis,a.Chart);w.compose(a.Axis)})});
//# sourceMappingURL=stock.js.map