# © 2023 SolarWinds Worldwide, LLC. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at:http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.

"""This module provides a SolarWinds-specific exporter.

The exporter translates OpenTelemetry spans into SolarWinds Observability events so that the instrumentation data
generated by an OpenTelemetry-based agent can be processed by the SolarWinds backend.
"""

import logging

from opentelemetry.sdk.trace.export import SpanExporter

logger = logging.getLogger(__name__)


class SolarWindsSpanExporter(SpanExporter):
    """SolarWinds custom span exporter. No-op as of version 4.0.0. Will be completely removed in a future release."""

    def __init__(
        self,
        *args,
        **kw_args,
    ) -> None:
        super().__init__(*args, **kw_args)
        logger.warning(
            "SolarWindsSpanExporter is no-op as of version 4.0.0 and will be completely removed in a future release. Please update configuration to use OTel Python HTTP or gRPC OTLP exporter."
        )
