# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.access_token_response import AccessTokenResponse
from ..types.grant_type import GrantType
from ..types.message_response import MessageResponse
from .raw_client import AsyncRawAccessTokensClient, RawAccessTokensClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AccessTokensClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAccessTokensClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAccessTokensClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAccessTokensClient
        """
        return self._raw_client

    def revoke(
        self, *, client_id: str, client_secret: str, token: str, request_options: typing.Optional[RequestOptions] = None
    ) -> MessageResponse:
        """
        Revoke an existing token immediately.

        Parameters
        ----------
        client_id : str

        client_secret : str

        token : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.access_tokens.revoke(client_id='client_id', client_secret='client_secret', token='token', )
        """
        _response = self._raw_client.revoke(
            client_id=client_id, client_secret=client_secret, token=token, request_options=request_options
        )
        return _response.data

    def create(
        self,
        *,
        client_id: str,
        client_secret: str,
        grant_type: GrantType,
        entity_user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AccessTokenResponse:
        """
        Create a new access token based on client ID and client secret.

        Parameters
        ----------
        client_id : str

        client_secret : str

        grant_type : GrantType

        entity_user_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccessTokenResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.access_tokens.create(client_id='client_id', client_secret='client_secret', grant_type="client_credentials", )
        """
        _response = self._raw_client.create(
            client_id=client_id,
            client_secret=client_secret,
            grant_type=grant_type,
            entity_user_id=entity_user_id,
            request_options=request_options,
        )
        return _response.data


class AsyncAccessTokensClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAccessTokensClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAccessTokensClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAccessTokensClient
        """
        return self._raw_client

    async def revoke(
        self, *, client_id: str, client_secret: str, token: str, request_options: typing.Optional[RequestOptions] = None
    ) -> MessageResponse:
        """
        Revoke an existing token immediately.

        Parameters
        ----------
        client_id : str

        client_secret : str

        token : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.access_tokens.revoke(client_id='client_id', client_secret='client_secret', token='token', )
        asyncio.run(main())
        """
        _response = await self._raw_client.revoke(
            client_id=client_id, client_secret=client_secret, token=token, request_options=request_options
        )
        return _response.data

    async def create(
        self,
        *,
        client_id: str,
        client_secret: str,
        grant_type: GrantType,
        entity_user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AccessTokenResponse:
        """
        Create a new access token based on client ID and client secret.

        Parameters
        ----------
        client_id : str

        client_secret : str

        grant_type : GrantType

        entity_user_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccessTokenResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.access_tokens.create(client_id='client_id', client_secret='client_secret', grant_type="client_credentials", )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            client_id=client_id,
            client_secret=client_secret,
            grant_type=grant_type,
            entity_user_id=entity_user_id,
            request_options=request_options,
        )
        return _response.data
