# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .connections.client import AsyncConnectionsClient, ConnectionsClient
from .ledger_accounts.client import AsyncLedgerAccountsClient, LedgerAccountsClient
from .payables.client import AsyncPayablesClient, PayablesClient
from .raw_client import AsyncRawAccountingClient, RawAccountingClient
from .receivables.client import AsyncReceivablesClient, ReceivablesClient
from .synced_records.client import AsyncSyncedRecordsClient, SyncedRecordsClient
from .tax_rates.client import AsyncTaxRatesClient, TaxRatesClient


class AccountingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAccountingClient(client_wrapper=client_wrapper)
        self.payables = PayablesClient(client_wrapper=client_wrapper)

        self.receivables = ReceivablesClient(client_wrapper=client_wrapper)

        self.connections = ConnectionsClient(client_wrapper=client_wrapper)

        self.synced_records = SyncedRecordsClient(client_wrapper=client_wrapper)

        self.tax_rates = TaxRatesClient(client_wrapper=client_wrapper)

        self.ledger_accounts = LedgerAccountsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAccountingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAccountingClient
        """
        return self._raw_client


class AsyncAccountingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAccountingClient(client_wrapper=client_wrapper)
        self.payables = AsyncPayablesClient(client_wrapper=client_wrapper)

        self.receivables = AsyncReceivablesClient(client_wrapper=client_wrapper)

        self.connections = AsyncConnectionsClient(client_wrapper=client_wrapper)

        self.synced_records = AsyncSyncedRecordsClient(client_wrapper=client_wrapper)

        self.tax_rates = AsyncTaxRatesClient(client_wrapper=client_wrapper)

        self.ledger_accounts = AsyncLedgerAccountsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAccountingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAccountingClient
        """
        return self._raw_client
