# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.accounting_connection_list import AccountingConnectionList
from ...types.accounting_connection_response import AccountingConnectionResponse
from ...types.accounting_message_response import AccountingMessageResponse
from .raw_client import AsyncRawConnectionsClient, RawConnectionsClient


class ConnectionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawConnectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawConnectionsClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> AccountingConnectionList:
        """
        Get all connections

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingConnectionList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.accounting.connections.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def create(self, *, request_options: typing.Optional[RequestOptions] = None) -> AccountingConnectionResponse:
        """
        Create new connection

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingConnectionResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.accounting.connections.create()
        """
        _response = self._raw_client.create(request_options=request_options)
        return _response.data

    def get_by_id(
        self, connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AccountingConnectionResponse:
        """
        Get connection by id

        Parameters
        ----------
        connection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingConnectionResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.accounting.connections.get_by_id(connection_id='connection_id', )
        """
        _response = self._raw_client.get_by_id(connection_id, request_options=request_options)
        return _response.data

    def disconnect_by_id(
        self, connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AccountingConnectionResponse:
        """
        Disconnect

        Parameters
        ----------
        connection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingConnectionResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.accounting.connections.disconnect_by_id(connection_id='connection_id', )
        """
        _response = self._raw_client.disconnect_by_id(connection_id, request_options=request_options)
        return _response.data

    def sync_by_id(
        self, connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AccountingMessageResponse:
        """
        Parameters
        ----------
        connection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingMessageResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.accounting.connections.sync_by_id(connection_id='connection_id', )
        """
        _response = self._raw_client.sync_by_id(connection_id, request_options=request_options)
        return _response.data


class AsyncConnectionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawConnectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawConnectionsClient
        """
        return self._raw_client

    async def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> AccountingConnectionList:
        """
        Get all connections

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingConnectionList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.accounting.connections.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def create(self, *, request_options: typing.Optional[RequestOptions] = None) -> AccountingConnectionResponse:
        """
        Create new connection

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingConnectionResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.accounting.connections.create()
        asyncio.run(main())
        """
        _response = await self._raw_client.create(request_options=request_options)
        return _response.data

    async def get_by_id(
        self, connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AccountingConnectionResponse:
        """
        Get connection by id

        Parameters
        ----------
        connection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingConnectionResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.accounting.connections.get_by_id(connection_id='connection_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(connection_id, request_options=request_options)
        return _response.data

    async def disconnect_by_id(
        self, connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AccountingConnectionResponse:
        """
        Disconnect

        Parameters
        ----------
        connection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingConnectionResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.accounting.connections.disconnect_by_id(connection_id='connection_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.disconnect_by_id(connection_id, request_options=request_options)
        return _response.data

    async def sync_by_id(
        self, connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AccountingMessageResponse:
        """
        Parameters
        ----------
        connection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingMessageResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.accounting.connections.sync_by_id(connection_id='connection_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.sync_by_id(connection_id, request_options=request_options)
        return _response.data
