# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.accounting_receivable import AccountingReceivable
from ...types.accounting_receivable_list import AccountingReceivableList
from .raw_client import AsyncRawReceivablesClient, RawReceivablesClient


class ReceivablesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawReceivablesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawReceivablesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawReceivablesClient
        """
        return self._raw_client

    def get(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AccountingReceivableList:
        """
        Returns a list of invoices that exist in the entity's accounting system. This requires that an accounting connection has been previously established. Refer to the [Accounting integration guide](https://docs.monite.com/accounting/integration/index) for details.

        This endpoint only provides read-only access to the accounting system's data but does not pull those invoices into Monite. You can use it to review the data in the accounting system and find out which of those invoices already exist or do not exist in Monite.

        Data is actual as of the date and time of the last accounting synchronization, which is specified by the `last_pull` value in the response from `GET /accounting_connections/{connection_id}`. To make sure you are accessing the most up-to-date accounting data, you can use `POST /accounting_connections/{connection_id}/sync` to trigger on-demand synchronization before getting the invoice list.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of results per page.

        offset : typing.Optional[int]
            Number of results to skip before selecting items to return.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingReceivableList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.accounting.receivables.get()
        """
        _response = self._raw_client.get(limit=limit, offset=offset, request_options=request_options)
        return _response.data

    def get_by_id(
        self, invoice_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AccountingReceivable:
        """
        Returns information about an individual invoice that exists in the entity's accounting system. This invoice may or may not also exist in Monite.

        Parameters
        ----------
        invoice_id : str
            An internal ID of the invoice in the accounting system. You can get these IDs from `GET /accounting/receivables`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingReceivable
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.accounting.receivables.get_by_id(invoice_id='invoice_id', )
        """
        _response = self._raw_client.get_by_id(invoice_id, request_options=request_options)
        return _response.data


class AsyncReceivablesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawReceivablesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawReceivablesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawReceivablesClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AccountingReceivableList:
        """
        Returns a list of invoices that exist in the entity's accounting system. This requires that an accounting connection has been previously established. Refer to the [Accounting integration guide](https://docs.monite.com/accounting/integration/index) for details.

        This endpoint only provides read-only access to the accounting system's data but does not pull those invoices into Monite. You can use it to review the data in the accounting system and find out which of those invoices already exist or do not exist in Monite.

        Data is actual as of the date and time of the last accounting synchronization, which is specified by the `last_pull` value in the response from `GET /accounting_connections/{connection_id}`. To make sure you are accessing the most up-to-date accounting data, you can use `POST /accounting_connections/{connection_id}/sync` to trigger on-demand synchronization before getting the invoice list.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of results per page.

        offset : typing.Optional[int]
            Number of results to skip before selecting items to return.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingReceivableList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.accounting.receivables.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(limit=limit, offset=offset, request_options=request_options)
        return _response.data

    async def get_by_id(
        self, invoice_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AccountingReceivable:
        """
        Returns information about an individual invoice that exists in the entity's accounting system. This invoice may or may not also exist in Monite.

        Parameters
        ----------
        invoice_id : str
            An internal ID of the invoice in the accounting system. You can get these IDs from `GET /accounting/receivables`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingReceivable
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.accounting.receivables.get_by_id(invoice_id='invoice_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(invoice_id, request_options=request_options)
        return _response.data
