# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.object_match_types import ObjectMatchTypes
from ...types.order_enum import OrderEnum
from ...types.sync_record_cursor_fields import SyncRecordCursorFields
from ...types.sync_record_resource import SyncRecordResource
from ...types.sync_record_resource_list import SyncRecordResourceList
from .raw_client import AsyncRawSyncedRecordsClient, RawSyncedRecordsClient


class SyncedRecordsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSyncedRecordsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSyncedRecordsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSyncedRecordsClient
        """
        return self._raw_client

    def get(
        self,
        *,
        object_type: ObjectMatchTypes,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[SyncRecordCursorFields] = None,
        object_id: typing.Optional[str] = None,
        object_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        updated_at_gt: typing.Optional[dt.datetime] = None,
        updated_at_lt: typing.Optional[dt.datetime] = None,
        updated_at_gte: typing.Optional[dt.datetime] = None,
        updated_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncRecordResourceList:
        """
        Get synchronized records

        Parameters
        ----------
        object_type : ObjectMatchTypes

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[SyncRecordCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        object_id : typing.Optional[str]

        object_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        updated_at_gt : typing.Optional[dt.datetime]

        updated_at_lt : typing.Optional[dt.datetime]

        updated_at_gte : typing.Optional[dt.datetime]

        updated_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncRecordResourceList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.accounting.synced_records.get(object_type="product", )
        """
        _response = self._raw_client.get(
            object_type=object_type,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            object_id=object_id,
            object_id_in=object_id_in,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            updated_at_gt=updated_at_gt,
            updated_at_lt=updated_at_lt,
            updated_at_gte=updated_at_gte,
            updated_at_lte=updated_at_lte,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(
        self, synced_record_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SyncRecordResource:
        """
        Get synchronized record by id

        Parameters
        ----------
        synced_record_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncRecordResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.accounting.synced_records.get_by_id(synced_record_id='synced_record_id', )
        """
        _response = self._raw_client.get_by_id(synced_record_id, request_options=request_options)
        return _response.data

    def push_by_id(
        self, synced_record_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SyncRecordResource:
        """
        Push object to the accounting system manually

        Parameters
        ----------
        synced_record_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncRecordResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.accounting.synced_records.push_by_id(synced_record_id='synced_record_id', )
        """
        _response = self._raw_client.push_by_id(synced_record_id, request_options=request_options)
        return _response.data


class AsyncSyncedRecordsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSyncedRecordsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSyncedRecordsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSyncedRecordsClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        object_type: ObjectMatchTypes,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[SyncRecordCursorFields] = None,
        object_id: typing.Optional[str] = None,
        object_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        updated_at_gt: typing.Optional[dt.datetime] = None,
        updated_at_lt: typing.Optional[dt.datetime] = None,
        updated_at_gte: typing.Optional[dt.datetime] = None,
        updated_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncRecordResourceList:
        """
        Get synchronized records

        Parameters
        ----------
        object_type : ObjectMatchTypes

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[SyncRecordCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        object_id : typing.Optional[str]

        object_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        updated_at_gt : typing.Optional[dt.datetime]

        updated_at_lt : typing.Optional[dt.datetime]

        updated_at_gte : typing.Optional[dt.datetime]

        updated_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncRecordResourceList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.accounting.synced_records.get(object_type="product", )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            object_type=object_type,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            object_id=object_id,
            object_id_in=object_id_in,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            updated_at_gt=updated_at_gt,
            updated_at_lt=updated_at_lt,
            updated_at_gte=updated_at_gte,
            updated_at_lte=updated_at_lte,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, synced_record_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SyncRecordResource:
        """
        Get synchronized record by id

        Parameters
        ----------
        synced_record_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncRecordResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.accounting.synced_records.get_by_id(synced_record_id='synced_record_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(synced_record_id, request_options=request_options)
        return _response.data

    async def push_by_id(
        self, synced_record_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SyncRecordResource:
        """
        Push object to the accounting system manually

        Parameters
        ----------
        synced_record_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncRecordResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.accounting.synced_records.push_by_id(synced_record_id='synced_record_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.push_by_id(synced_record_id, request_options=request_options)
        return _response.data
