# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.accounting_tax_rate_list_response import AccountingTaxRateListResponse
from ...types.accounting_tax_rate_response import AccountingTaxRateResponse
from ...types.order_enum import OrderEnum
from ...types.tax_rate_account_cursor_fields import TaxRateAccountCursorFields
from .raw_client import AsyncRawTaxRatesClient, RawTaxRatesClient


class TaxRatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTaxRatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTaxRatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTaxRatesClient
        """
        return self._raw_client

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[TaxRateAccountCursorFields] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AccountingTaxRateListResponse:
        """
        Get all tax rate accounts

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[TaxRateAccountCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingTaxRateListResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.accounting.tax_rates.get()
        """
        _response = self._raw_client.get(
            order=order, limit=limit, pagination_token=pagination_token, sort=sort, request_options=request_options
        )
        return _response.data

    def get_by_id(
        self, tax_rate_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AccountingTaxRateResponse:
        """
        Get tax rate account by id

        Parameters
        ----------
        tax_rate_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingTaxRateResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.accounting.tax_rates.get_by_id(tax_rate_id='tax_rate_id', )
        """
        _response = self._raw_client.get_by_id(tax_rate_id, request_options=request_options)
        return _response.data


class AsyncTaxRatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTaxRatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTaxRatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTaxRatesClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[TaxRateAccountCursorFields] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AccountingTaxRateListResponse:
        """
        Get all tax rate accounts

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[TaxRateAccountCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingTaxRateListResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.accounting.tax_rates.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            order=order, limit=limit, pagination_token=pagination_token, sort=sort, request_options=request_options
        )
        return _response.data

    async def get_by_id(
        self, tax_rate_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AccountingTaxRateResponse:
        """
        Get tax rate account by id

        Parameters
        ----------
        tax_rate_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AccountingTaxRateResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.accounting.tax_rates.get_by_id(tax_rate_id='tax_rate_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(tax_rate_id, request_options=request_options)
        return _response.data
