# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.aggregation_function_enum import AggregationFunctionEnum
from ..types.credit_note_dimension_enum import CreditNoteDimensionEnum
from ..types.credit_note_metric_enum import CreditNoteMetricEnum
from ..types.currency_enum import CurrencyEnum
from ..types.date_dimension_breakdown_enum import DateDimensionBreakdownEnum
from ..types.ocr_status_enum import OcrStatusEnum
from ..types.order_enum import OrderEnum
from ..types.origin_enum import OriginEnum
from ..types.payable_analytics_response import PayableAnalyticsResponse
from ..types.payable_credit_note_state_enum import PayableCreditNoteStateEnum
from ..types.payable_dimension_enum import PayableDimensionEnum
from ..types.payable_metric_enum import PayableMetricEnum
from ..types.payable_origin_enum import PayableOriginEnum
from ..types.payable_state_enum import PayableStateEnum
from ..types.receivable_cursor_fields import ReceivableCursorFields
from ..types.receivable_dimension_enum import ReceivableDimensionEnum
from ..types.receivable_metric_enum import ReceivableMetricEnum
from ..types.receivable_type import ReceivableType
from ..types.receivables_analytics_response import ReceivablesAnalyticsResponse
from ..types.source_of_payable_data_enum import SourceOfPayableDataEnum
from .raw_client import AsyncRawAnalyticsClient, RawAnalyticsClient
from .types.get_analytics_receivables_request_status import GetAnalyticsReceivablesRequestStatus
from .types.get_analytics_receivables_request_status_in_item import GetAnalyticsReceivablesRequestStatusInItem


class AnalyticsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAnalyticsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAnalyticsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAnalyticsClient
        """
        return self._raw_client

    def get_analytics_credit_notes(
        self,
        *,
        metric: CreditNoteMetricEnum,
        aggregation_function: AggregationFunctionEnum,
        dimension: typing.Optional[CreditNoteDimensionEnum] = None,
        date_dimension_breakdown: typing.Optional[DateDimensionBreakdownEnum] = None,
        limit: typing.Optional[int] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        issued_at: typing.Optional[str] = None,
        issued_at_gt: typing.Optional[str] = None,
        issued_at_lt: typing.Optional[str] = None,
        issued_at_gte: typing.Optional[str] = None,
        issued_at_lte: typing.Optional[str] = None,
        document_id: typing.Optional[str] = None,
        document_id_iexact: typing.Optional[str] = None,
        document_id_contains: typing.Optional[str] = None,
        document_id_icontains: typing.Optional[str] = None,
        has_file: typing.Optional[bool] = None,
        total_amount_gt: typing.Optional[int] = None,
        total_amount_lt: typing.Optional[int] = None,
        total_amount_gte: typing.Optional[int] = None,
        total_amount_lte: typing.Optional[int] = None,
        subtotal_gt: typing.Optional[int] = None,
        subtotal_lt: typing.Optional[int] = None,
        subtotal_gte: typing.Optional[int] = None,
        subtotal_lte: typing.Optional[int] = None,
        based_on: typing.Optional[str] = None,
        counterpart_id: typing.Optional[str] = None,
        created_by_entity_user_id: typing.Optional[str] = None,
        status: typing.Optional[PayableCreditNoteStateEnum] = None,
        status_in: typing.Optional[
            typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]
        ] = None,
        status_not_in: typing.Optional[
            typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]
        ] = None,
        origin: typing.Optional[OriginEnum] = None,
        currency: typing.Optional[CurrencyEnum] = None,
        project_id: typing.Optional[str] = None,
        project_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PayableAnalyticsResponse:
        """
        Retrieve aggregated statistics for payables with different breakdowns.

        Parameters
        ----------
        metric : CreditNoteMetricEnum

        aggregation_function : AggregationFunctionEnum

        dimension : typing.Optional[CreditNoteDimensionEnum]

        date_dimension_breakdown : typing.Optional[DateDimensionBreakdownEnum]

        limit : typing.Optional[int]
            The number of items (0 .. 400) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        issued_at : typing.Optional[str]

        issued_at_gt : typing.Optional[str]

        issued_at_lt : typing.Optional[str]

        issued_at_gte : typing.Optional[str]

        issued_at_lte : typing.Optional[str]

        document_id : typing.Optional[str]

        document_id_iexact : typing.Optional[str]

        document_id_contains : typing.Optional[str]

        document_id_icontains : typing.Optional[str]

        has_file : typing.Optional[bool]

        total_amount_gt : typing.Optional[int]

        total_amount_lt : typing.Optional[int]

        total_amount_gte : typing.Optional[int]

        total_amount_lte : typing.Optional[int]

        subtotal_gt : typing.Optional[int]

        subtotal_lt : typing.Optional[int]

        subtotal_gte : typing.Optional[int]

        subtotal_lte : typing.Optional[int]

        based_on : typing.Optional[str]

        counterpart_id : typing.Optional[str]

        created_by_entity_user_id : typing.Optional[str]

        status : typing.Optional[PayableCreditNoteStateEnum]

        status_in : typing.Optional[typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]]

        status_not_in : typing.Optional[typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]]

        origin : typing.Optional[OriginEnum]

        currency : typing.Optional[CurrencyEnum]

        project_id : typing.Optional[str]

        project_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PayableAnalyticsResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.analytics.get_analytics_credit_notes(metric="id", aggregation_function="count", )
        """
        _response = self._raw_client.get_analytics_credit_notes(
            metric=metric,
            aggregation_function=aggregation_function,
            dimension=dimension,
            date_dimension_breakdown=date_dimension_breakdown,
            limit=limit,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            issued_at=issued_at,
            issued_at_gt=issued_at_gt,
            issued_at_lt=issued_at_lt,
            issued_at_gte=issued_at_gte,
            issued_at_lte=issued_at_lte,
            document_id=document_id,
            document_id_iexact=document_id_iexact,
            document_id_contains=document_id_contains,
            document_id_icontains=document_id_icontains,
            has_file=has_file,
            total_amount_gt=total_amount_gt,
            total_amount_lt=total_amount_lt,
            total_amount_gte=total_amount_gte,
            total_amount_lte=total_amount_lte,
            subtotal_gt=subtotal_gt,
            subtotal_lt=subtotal_lt,
            subtotal_gte=subtotal_gte,
            subtotal_lte=subtotal_lte,
            based_on=based_on,
            counterpart_id=counterpart_id,
            created_by_entity_user_id=created_by_entity_user_id,
            status=status,
            status_in=status_in,
            status_not_in=status_not_in,
            origin=origin,
            currency=currency,
            project_id=project_id,
            project_id_in=project_id_in,
            request_options=request_options,
        )
        return _response.data

    def get_analytics_payables(
        self,
        *,
        metric: PayableMetricEnum,
        aggregation_function: AggregationFunctionEnum,
        dimension: typing.Optional[PayableDimensionEnum] = None,
        date_dimension_breakdown: typing.Optional[DateDimensionBreakdownEnum] = None,
        limit: typing.Optional[int] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        status: typing.Optional[PayableStateEnum] = None,
        status_in: typing.Optional[typing.Union[PayableStateEnum, typing.Sequence[PayableStateEnum]]] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        total_amount: typing.Optional[int] = None,
        total_amount_gt: typing.Optional[int] = None,
        total_amount_lt: typing.Optional[int] = None,
        total_amount_gte: typing.Optional[int] = None,
        total_amount_lte: typing.Optional[int] = None,
        amount: typing.Optional[int] = None,
        amount_gt: typing.Optional[int] = None,
        amount_lt: typing.Optional[int] = None,
        amount_gte: typing.Optional[int] = None,
        amount_lte: typing.Optional[int] = None,
        currency: typing.Optional[CurrencyEnum] = None,
        counterpart_name: typing.Optional[str] = None,
        counterpart_name_contains: typing.Optional[str] = None,
        counterpart_name_icontains: typing.Optional[str] = None,
        search_text: typing.Optional[str] = None,
        due_date: typing.Optional[str] = None,
        due_date_gt: typing.Optional[str] = None,
        due_date_lt: typing.Optional[str] = None,
        due_date_gte: typing.Optional[str] = None,
        due_date_lte: typing.Optional[str] = None,
        issued_at: typing.Optional[str] = None,
        issued_at_gt: typing.Optional[str] = None,
        issued_at_lt: typing.Optional[str] = None,
        issued_at_gte: typing.Optional[str] = None,
        issued_at_lte: typing.Optional[str] = None,
        document_id: typing.Optional[str] = None,
        document_id_contains: typing.Optional[str] = None,
        document_id_icontains: typing.Optional[str] = None,
        was_created_by_user_id: typing.Optional[str] = None,
        counterpart_id: typing.Optional[str] = None,
        source_of_payable_data: typing.Optional[SourceOfPayableDataEnum] = None,
        ocr_status: typing.Optional[OcrStatusEnum] = None,
        line_item_id: typing.Optional[str] = None,
        purchase_order_id: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        project_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        tag_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        tag_ids_not_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        origin: typing.Optional[PayableOriginEnum] = None,
        has_file: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PayableAnalyticsResponse:
        """
        Retrieve aggregated statistics for payables with different breakdowns.

        Parameters
        ----------
        metric : PayableMetricEnum

        aggregation_function : AggregationFunctionEnum

        dimension : typing.Optional[PayableDimensionEnum]

        date_dimension_breakdown : typing.Optional[DateDimensionBreakdownEnum]

        limit : typing.Optional[int]
            The number of items (0 .. 400) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        created_at_gt : typing.Optional[dt.datetime]
            Return only payables created in Monite after the specified date and time. The value must be in the ISO 8601 format YYYY-MM-DDThh:mm[:ss[.ffffff]][Z|±hh:mm].

        created_at_lt : typing.Optional[dt.datetime]
            Return only payables created in Monite before the specified date and time.

        created_at_gte : typing.Optional[dt.datetime]
            Return only payables created in Monite on or after the specified date and time.

        created_at_lte : typing.Optional[dt.datetime]
            Return only payables created in Monite before or on the specified date and time.

        status : typing.Optional[PayableStateEnum]
            Return only payables that have the specified [status](https://docs.monite.com/accounts-payable/payables/index).

            To query multiple statuses at once, use the `status__in` parameter instead.

        status_in : typing.Optional[typing.Union[PayableStateEnum, typing.Sequence[PayableStateEnum]]]
            Return only payables that have the specified [statuses](https://docs.monite.com/accounts-payable/payables/index).

            To specify multiple statuses, repeat this parameter for each value: `status__in=draft&status__in=new`

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only payables with specified IDs. Valid but nonexistent IDs do not raise errors but produce no results.

            To specify multiple IDs, repeat this parameter for each value: `id__in=<id1>&id__in=<id2>`

        total_amount : typing.Optional[int]
            Return only payables with the exact specified total amount. The amount must be specified in the minor units of currency. For example, $12.5 is represented as 1250.

        total_amount_gt : typing.Optional[int]
            Return only payables whose total amount (in minor units) exceeds the specified value.

        total_amount_lt : typing.Optional[int]
            Return only payables whose total amount (in minor units) is less than the specified value.

        total_amount_gte : typing.Optional[int]
            Return only payables whose total amount (in minor units) is greater than or equal to the specified value.

        total_amount_lte : typing.Optional[int]
            Return only payables whose total amount (in minor units) is less than or equal to the specified value.

        amount : typing.Optional[int]
            Return only payables with the specified amount.

        amount_gt : typing.Optional[int]
            Return only payables whose amount (in minor units) exceeds the specified value.

        amount_lt : typing.Optional[int]
            Return only payables whose amount (in minor units) is less than the specified value.

        amount_gte : typing.Optional[int]
            Return only payables whose amount (in minor units) is greater than or equal to the specified value.

        amount_lte : typing.Optional[int]
            Return only payables whose amount (in minor units) is less than or equal to the specified value.

        currency : typing.Optional[CurrencyEnum]
            Return only payables that use the specified currency.

        counterpart_name : typing.Optional[str]
            Return only payables received from counterparts with the specified name (exact match, case-sensitive).

            For counterparts of `type = individual`, the full name is formatted as `first_name last_name`.

        counterpart_name_contains : typing.Optional[str]
            Return only payables received from counterparts whose name contains the specified string (case-sensitive).

        counterpart_name_icontains : typing.Optional[str]
            Return only payables received from counterparts whose name contains the specified string (case-insensitive).

        search_text : typing.Optional[str]
            Apply the `icontains` condition to search for the specified text in the `document_id` and `counterpart_name` fields in the payables.

        due_date : typing.Optional[str]
            Return payables that are due on the specified date (YYYY-MM-DD)

        due_date_gt : typing.Optional[str]
            Return payables that are due after the specified date (exclusive, YYYY-MM-DD).

        due_date_lt : typing.Optional[str]
            Return payables that are due before the specified date (exclusive, YYYY-MM-DD).

        due_date_gte : typing.Optional[str]
            Return payables that are due on or after the specified date (YYYY-MM-DD).

        due_date_lte : typing.Optional[str]
            Return payables that are due before or on the specified date (YYYY-MM-DD).

        issued_at : typing.Optional[str]
            Return payables that are issued at the specified date (YYYY-MM-DD)

        issued_at_gt : typing.Optional[str]
            Return payables that are issued after the specified date (exclusive, YYYY-MM-DD).

        issued_at_lt : typing.Optional[str]
            Return payables that are issued before the specified date (exclusive, YYYY-MM-DD).

        issued_at_gte : typing.Optional[str]
            Return payables that are issued on or after the specified date (YYYY-MM-DD).

        issued_at_lte : typing.Optional[str]
            Return payables that are issued before or on the specified date (YYYY-MM-DD).

        document_id : typing.Optional[str]
            Return a payable with the exact specified document number (case-sensitive).

            The `document_id` is the user-facing document number such as INV-00042, not to be confused with Monite resource IDs (`id`).

        document_id_contains : typing.Optional[str]
            Return only payables whose document number (`document_id`) contains the specified string (case-sensitive).

        document_id_icontains : typing.Optional[str]
            Return only payables whose document number (`document_id`) contains the specified string (case-insensitive).

        was_created_by_user_id : typing.Optional[str]
            Return only payables created in Monite by the entity user with the specified ID.

        counterpart_id : typing.Optional[str]
            Return only payables received from the counterpart with the specified ID.

            Counterparts that have been deleted but have associated payables will still return results here because the payables contain a frozen copy of the counterpart data.

            If the specified counterpart ID does not exist and never existed, no results are returned.

        source_of_payable_data : typing.Optional[SourceOfPayableDataEnum]
            Return only payables coming from the specified source.

        ocr_status : typing.Optional[OcrStatusEnum]
            Return only payables with specific OCR statuses.

        line_item_id : typing.Optional[str]
            Search for a payable by the identifier of the line item associated with it.

        purchase_order_id : typing.Optional[str]
            Search for a payable by the identifier of the purchase order associated with it.

        project_id : typing.Optional[str]
            Return only payables assigned to the project with the specified ID.

            Valid but nonexistent project IDs do not raise errors but return no results.

        project_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only payables whose `project_id` include at least one of the project_id with the specified IDs. Valid but nonexistent project IDs do not raise errors but produce no results.

        tag_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only payables whose `tags` include at least one of the tags with the specified IDs. Valid but nonexistent tag IDs do not raise errors but produce no results.

        tag_ids_not_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only payables whose `tags` do not include any of the tags with the specified IDs. Valid but nonexistent tag IDs do not raise errors but produce the results.

        origin : typing.Optional[PayableOriginEnum]
            Return only payables from a given origin ['einvoice', 'upload', 'email']

        has_file : typing.Optional[bool]
            Return only payables with or without attachments (files)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PayableAnalyticsResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.analytics.get_analytics_payables(metric="id", aggregation_function="count", )
        """
        _response = self._raw_client.get_analytics_payables(
            metric=metric,
            aggregation_function=aggregation_function,
            dimension=dimension,
            date_dimension_breakdown=date_dimension_breakdown,
            limit=limit,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            status=status,
            status_in=status_in,
            id_in=id_in,
            total_amount=total_amount,
            total_amount_gt=total_amount_gt,
            total_amount_lt=total_amount_lt,
            total_amount_gte=total_amount_gte,
            total_amount_lte=total_amount_lte,
            amount=amount,
            amount_gt=amount_gt,
            amount_lt=amount_lt,
            amount_gte=amount_gte,
            amount_lte=amount_lte,
            currency=currency,
            counterpart_name=counterpart_name,
            counterpart_name_contains=counterpart_name_contains,
            counterpart_name_icontains=counterpart_name_icontains,
            search_text=search_text,
            due_date=due_date,
            due_date_gt=due_date_gt,
            due_date_lt=due_date_lt,
            due_date_gte=due_date_gte,
            due_date_lte=due_date_lte,
            issued_at=issued_at,
            issued_at_gt=issued_at_gt,
            issued_at_lt=issued_at_lt,
            issued_at_gte=issued_at_gte,
            issued_at_lte=issued_at_lte,
            document_id=document_id,
            document_id_contains=document_id_contains,
            document_id_icontains=document_id_icontains,
            was_created_by_user_id=was_created_by_user_id,
            counterpart_id=counterpart_id,
            source_of_payable_data=source_of_payable_data,
            ocr_status=ocr_status,
            line_item_id=line_item_id,
            purchase_order_id=purchase_order_id,
            project_id=project_id,
            project_id_in=project_id_in,
            tag_ids=tag_ids,
            tag_ids_not_in=tag_ids_not_in,
            origin=origin,
            has_file=has_file,
            request_options=request_options,
        )
        return _response.data

    def get_analytics_receivables(
        self,
        *,
        metric: ReceivableMetricEnum,
        aggregation_function: AggregationFunctionEnum,
        dimension: typing.Optional[ReceivableDimensionEnum] = None,
        date_dimension_breakdown: typing.Optional[DateDimensionBreakdownEnum] = None,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status_in: typing.Optional[
            typing.Union[
                GetAnalyticsReceivablesRequestStatusInItem, typing.Sequence[GetAnalyticsReceivablesRequestStatusInItem]
            ]
        ] = None,
        entity_user_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        sort: typing.Optional[ReceivableCursorFields] = None,
        tag_ids_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        tag_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        product_ids_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        product_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        project_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        type: typing.Optional[ReceivableType] = None,
        document_id: typing.Optional[str] = None,
        document_id_contains: typing.Optional[str] = None,
        document_id_icontains: typing.Optional[str] = None,
        issue_date_gt: typing.Optional[dt.datetime] = None,
        issue_date_lt: typing.Optional[dt.datetime] = None,
        issue_date_gte: typing.Optional[dt.datetime] = None,
        issue_date_lte: typing.Optional[dt.datetime] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        counterpart_id: typing.Optional[str] = None,
        counterpart_name: typing.Optional[str] = None,
        counterpart_name_contains: typing.Optional[str] = None,
        counterpart_name_icontains: typing.Optional[str] = None,
        total_amount: typing.Optional[int] = None,
        total_amount_gt: typing.Optional[int] = None,
        total_amount_lt: typing.Optional[int] = None,
        total_amount_gte: typing.Optional[int] = None,
        total_amount_lte: typing.Optional[int] = None,
        status: typing.Optional[GetAnalyticsReceivablesRequestStatus] = None,
        entity_user_id: typing.Optional[str] = None,
        based_on: typing.Optional[str] = None,
        due_date_gt: typing.Optional[str] = None,
        due_date_lt: typing.Optional[str] = None,
        due_date_gte: typing.Optional[str] = None,
        due_date_lte: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivablesAnalyticsResponse:
        """
        Retrieve aggregated statistics for receivables with different breakdowns.

        Parameters
        ----------
        metric : ReceivableMetricEnum

        aggregation_function : AggregationFunctionEnum

        dimension : typing.Optional[ReceivableDimensionEnum]

        date_dimension_breakdown : typing.Optional[DateDimensionBreakdownEnum]

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 250) to return in a single page of the response. Default is 100. The response may contain fewer items if it is the last or only page.

            When using pagination with a non-default `limit`, you must provide the `limit` value alongside `pagination_token` in all subsequent pagination requests. Unlike other query parameters, `limit` is not inferred from `pagination_token`.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters except `limit` are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables with the specified IDs. Valid but nonexistent IDs do not raise errors but produce no results.

            To specify multiple IDs, repeat this parameter for each value:
            `id__in=<id1>&id__in=<id2>`

        status_in : typing.Optional[typing.Union[GetAnalyticsReceivablesRequestStatusInItem, typing.Sequence[GetAnalyticsReceivablesRequestStatusInItem]]]
            Return only receivables that have the specified statuses. See the applicable [invoice statuses](https://docs.monite.com/accounts-receivable/invoices/index), [quote statuses](https://docs.monite.com/accounts-receivable/quotes/index), and [credit note statuses](https://docs.monite.com/accounts-receivable/credit-notes#credit-note-lifecycle).

            To specify multiple statuses, repeat this parameter for each value:
            `status__in=draft&status__in=issued`

        entity_user_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables created by the entity users with the specified IDs.To specify multiple user IDs, repeat this parameter for each ID:
            `entity_user_id__in=<user1>&entity_user_id__in=<user2>`

            If the request is authenticated using an entity user token, this user must have the `receivable.read.allowed` (rather than `allowed_for_own`) permission to be able to query receivables created by other users.

            IDs of deleted users will still produce results here if those users had associated receivables. Valid but nonexistent user IDs do not raise errors but produce no results.

        sort : typing.Optional[ReceivableCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        tag_ids_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose [tags](https://docs.monite.com/common/tags) include at least one of the tags with the specified IDs.

            For example, given receivables with the following tags:
            1. tagA
            2. tagB
            3. tagA, tagB
            4. tagC
            5. tagB, tagC


            `tag_ids__in=<tagA>&tag_ids__in=<tagB>` will return receivables 1, 2, 3, and 5.

            Valid but nonexistent tag IDs do not raise errors but produce no results.

        tag_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose [tags](https://docs.monite.com/common/tags) include all of the tags with the specified IDs and optionally other tags that are not specified.

            For example, given receivables with the following tags:
            1. tagA
            2. tagB
            3. tagA, tagB
            4. tagC
            5. tagA, tagB, tagC


            `tag_ids=<tagA>&tag_ids=<tagB>` will return receivables 3 and 5.

        product_ids_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose line items include at least one of the product IDs with the specified IDs.

            To specify multiple product IDs, repeat this parameter for each ID:
            `product_ids__in=<product1>&product_ids__in=<product2>`

            For example, given receivables with the following product IDs:
            1. productA
            2. productB
            3. productA, productB
            4. productC
            5. productB, productC


            `product_ids__in=<productA>&product_ids__in=<productB>` will return receivables 1, 2, 3, and 5.Valid but nonexistent product IDs do not raise errors but produce no results.

        product_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose line items include all of the product IDs with the specified IDs and optionally other products that are not specified.

            To specify multiple product IDs, repeat this parameter for each ID:
            `product_ids=<product1>&product_ids=<product2>`

            For example, given receivables with the following product IDs:
            1. productA
            2. productB
            3. productA, productB
            4. productC
            5. productA, productB, productC


            `product_ids=<productA>&product_ids=<productB>` will return receivables 3 and 5.

        project_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose `project_id` include at least one of the project_id with the specified IDs. Valid but nonexistent project IDs do not raise errors but produce no results.

        type : typing.Optional[ReceivableType]

        document_id : typing.Optional[str]

        document_id_contains : typing.Optional[str]

        document_id_icontains : typing.Optional[str]

        issue_date_gt : typing.Optional[dt.datetime]

        issue_date_lt : typing.Optional[dt.datetime]

        issue_date_gte : typing.Optional[dt.datetime]

        issue_date_lte : typing.Optional[dt.datetime]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        counterpart_id : typing.Optional[str]

        counterpart_name : typing.Optional[str]

        counterpart_name_contains : typing.Optional[str]

        counterpart_name_icontains : typing.Optional[str]

        total_amount : typing.Optional[int]

        total_amount_gt : typing.Optional[int]

        total_amount_lt : typing.Optional[int]

        total_amount_gte : typing.Optional[int]

        total_amount_lte : typing.Optional[int]

        status : typing.Optional[GetAnalyticsReceivablesRequestStatus]

        entity_user_id : typing.Optional[str]

        based_on : typing.Optional[str]

        due_date_gt : typing.Optional[str]

        due_date_lt : typing.Optional[str]

        due_date_gte : typing.Optional[str]

        due_date_lte : typing.Optional[str]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivablesAnalyticsResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.analytics.get_analytics_receivables(metric="id", aggregation_function="count", )
        """
        _response = self._raw_client.get_analytics_receivables(
            metric=metric,
            aggregation_function=aggregation_function,
            dimension=dimension,
            date_dimension_breakdown=date_dimension_breakdown,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            id_in=id_in,
            status_in=status_in,
            entity_user_id_in=entity_user_id_in,
            sort=sort,
            tag_ids_in=tag_ids_in,
            tag_ids=tag_ids,
            product_ids_in=product_ids_in,
            product_ids=product_ids,
            project_id_in=project_id_in,
            type=type,
            document_id=document_id,
            document_id_contains=document_id_contains,
            document_id_icontains=document_id_icontains,
            issue_date_gt=issue_date_gt,
            issue_date_lt=issue_date_lt,
            issue_date_gte=issue_date_gte,
            issue_date_lte=issue_date_lte,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            counterpart_id=counterpart_id,
            counterpart_name=counterpart_name,
            counterpart_name_contains=counterpart_name_contains,
            counterpart_name_icontains=counterpart_name_icontains,
            total_amount=total_amount,
            total_amount_gt=total_amount_gt,
            total_amount_lt=total_amount_lt,
            total_amount_gte=total_amount_gte,
            total_amount_lte=total_amount_lte,
            status=status,
            entity_user_id=entity_user_id,
            based_on=based_on,
            due_date_gt=due_date_gt,
            due_date_lt=due_date_lt,
            due_date_gte=due_date_gte,
            due_date_lte=due_date_lte,
            project_id=project_id,
            request_options=request_options,
        )
        return _response.data


class AsyncAnalyticsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAnalyticsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAnalyticsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAnalyticsClient
        """
        return self._raw_client

    async def get_analytics_credit_notes(
        self,
        *,
        metric: CreditNoteMetricEnum,
        aggregation_function: AggregationFunctionEnum,
        dimension: typing.Optional[CreditNoteDimensionEnum] = None,
        date_dimension_breakdown: typing.Optional[DateDimensionBreakdownEnum] = None,
        limit: typing.Optional[int] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        issued_at: typing.Optional[str] = None,
        issued_at_gt: typing.Optional[str] = None,
        issued_at_lt: typing.Optional[str] = None,
        issued_at_gte: typing.Optional[str] = None,
        issued_at_lte: typing.Optional[str] = None,
        document_id: typing.Optional[str] = None,
        document_id_iexact: typing.Optional[str] = None,
        document_id_contains: typing.Optional[str] = None,
        document_id_icontains: typing.Optional[str] = None,
        has_file: typing.Optional[bool] = None,
        total_amount_gt: typing.Optional[int] = None,
        total_amount_lt: typing.Optional[int] = None,
        total_amount_gte: typing.Optional[int] = None,
        total_amount_lte: typing.Optional[int] = None,
        subtotal_gt: typing.Optional[int] = None,
        subtotal_lt: typing.Optional[int] = None,
        subtotal_gte: typing.Optional[int] = None,
        subtotal_lte: typing.Optional[int] = None,
        based_on: typing.Optional[str] = None,
        counterpart_id: typing.Optional[str] = None,
        created_by_entity_user_id: typing.Optional[str] = None,
        status: typing.Optional[PayableCreditNoteStateEnum] = None,
        status_in: typing.Optional[
            typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]
        ] = None,
        status_not_in: typing.Optional[
            typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]
        ] = None,
        origin: typing.Optional[OriginEnum] = None,
        currency: typing.Optional[CurrencyEnum] = None,
        project_id: typing.Optional[str] = None,
        project_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PayableAnalyticsResponse:
        """
        Retrieve aggregated statistics for payables with different breakdowns.

        Parameters
        ----------
        metric : CreditNoteMetricEnum

        aggregation_function : AggregationFunctionEnum

        dimension : typing.Optional[CreditNoteDimensionEnum]

        date_dimension_breakdown : typing.Optional[DateDimensionBreakdownEnum]

        limit : typing.Optional[int]
            The number of items (0 .. 400) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        issued_at : typing.Optional[str]

        issued_at_gt : typing.Optional[str]

        issued_at_lt : typing.Optional[str]

        issued_at_gte : typing.Optional[str]

        issued_at_lte : typing.Optional[str]

        document_id : typing.Optional[str]

        document_id_iexact : typing.Optional[str]

        document_id_contains : typing.Optional[str]

        document_id_icontains : typing.Optional[str]

        has_file : typing.Optional[bool]

        total_amount_gt : typing.Optional[int]

        total_amount_lt : typing.Optional[int]

        total_amount_gte : typing.Optional[int]

        total_amount_lte : typing.Optional[int]

        subtotal_gt : typing.Optional[int]

        subtotal_lt : typing.Optional[int]

        subtotal_gte : typing.Optional[int]

        subtotal_lte : typing.Optional[int]

        based_on : typing.Optional[str]

        counterpart_id : typing.Optional[str]

        created_by_entity_user_id : typing.Optional[str]

        status : typing.Optional[PayableCreditNoteStateEnum]

        status_in : typing.Optional[typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]]

        status_not_in : typing.Optional[typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]]

        origin : typing.Optional[OriginEnum]

        currency : typing.Optional[CurrencyEnum]

        project_id : typing.Optional[str]

        project_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PayableAnalyticsResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.analytics.get_analytics_credit_notes(metric="id", aggregation_function="count", )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_analytics_credit_notes(
            metric=metric,
            aggregation_function=aggregation_function,
            dimension=dimension,
            date_dimension_breakdown=date_dimension_breakdown,
            limit=limit,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            issued_at=issued_at,
            issued_at_gt=issued_at_gt,
            issued_at_lt=issued_at_lt,
            issued_at_gte=issued_at_gte,
            issued_at_lte=issued_at_lte,
            document_id=document_id,
            document_id_iexact=document_id_iexact,
            document_id_contains=document_id_contains,
            document_id_icontains=document_id_icontains,
            has_file=has_file,
            total_amount_gt=total_amount_gt,
            total_amount_lt=total_amount_lt,
            total_amount_gte=total_amount_gte,
            total_amount_lte=total_amount_lte,
            subtotal_gt=subtotal_gt,
            subtotal_lt=subtotal_lt,
            subtotal_gte=subtotal_gte,
            subtotal_lte=subtotal_lte,
            based_on=based_on,
            counterpart_id=counterpart_id,
            created_by_entity_user_id=created_by_entity_user_id,
            status=status,
            status_in=status_in,
            status_not_in=status_not_in,
            origin=origin,
            currency=currency,
            project_id=project_id,
            project_id_in=project_id_in,
            request_options=request_options,
        )
        return _response.data

    async def get_analytics_payables(
        self,
        *,
        metric: PayableMetricEnum,
        aggregation_function: AggregationFunctionEnum,
        dimension: typing.Optional[PayableDimensionEnum] = None,
        date_dimension_breakdown: typing.Optional[DateDimensionBreakdownEnum] = None,
        limit: typing.Optional[int] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        status: typing.Optional[PayableStateEnum] = None,
        status_in: typing.Optional[typing.Union[PayableStateEnum, typing.Sequence[PayableStateEnum]]] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        total_amount: typing.Optional[int] = None,
        total_amount_gt: typing.Optional[int] = None,
        total_amount_lt: typing.Optional[int] = None,
        total_amount_gte: typing.Optional[int] = None,
        total_amount_lte: typing.Optional[int] = None,
        amount: typing.Optional[int] = None,
        amount_gt: typing.Optional[int] = None,
        amount_lt: typing.Optional[int] = None,
        amount_gte: typing.Optional[int] = None,
        amount_lte: typing.Optional[int] = None,
        currency: typing.Optional[CurrencyEnum] = None,
        counterpart_name: typing.Optional[str] = None,
        counterpart_name_contains: typing.Optional[str] = None,
        counterpart_name_icontains: typing.Optional[str] = None,
        search_text: typing.Optional[str] = None,
        due_date: typing.Optional[str] = None,
        due_date_gt: typing.Optional[str] = None,
        due_date_lt: typing.Optional[str] = None,
        due_date_gte: typing.Optional[str] = None,
        due_date_lte: typing.Optional[str] = None,
        issued_at: typing.Optional[str] = None,
        issued_at_gt: typing.Optional[str] = None,
        issued_at_lt: typing.Optional[str] = None,
        issued_at_gte: typing.Optional[str] = None,
        issued_at_lte: typing.Optional[str] = None,
        document_id: typing.Optional[str] = None,
        document_id_contains: typing.Optional[str] = None,
        document_id_icontains: typing.Optional[str] = None,
        was_created_by_user_id: typing.Optional[str] = None,
        counterpart_id: typing.Optional[str] = None,
        source_of_payable_data: typing.Optional[SourceOfPayableDataEnum] = None,
        ocr_status: typing.Optional[OcrStatusEnum] = None,
        line_item_id: typing.Optional[str] = None,
        purchase_order_id: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        project_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        tag_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        tag_ids_not_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        origin: typing.Optional[PayableOriginEnum] = None,
        has_file: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PayableAnalyticsResponse:
        """
        Retrieve aggregated statistics for payables with different breakdowns.

        Parameters
        ----------
        metric : PayableMetricEnum

        aggregation_function : AggregationFunctionEnum

        dimension : typing.Optional[PayableDimensionEnum]

        date_dimension_breakdown : typing.Optional[DateDimensionBreakdownEnum]

        limit : typing.Optional[int]
            The number of items (0 .. 400) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        created_at_gt : typing.Optional[dt.datetime]
            Return only payables created in Monite after the specified date and time. The value must be in the ISO 8601 format YYYY-MM-DDThh:mm[:ss[.ffffff]][Z|±hh:mm].

        created_at_lt : typing.Optional[dt.datetime]
            Return only payables created in Monite before the specified date and time.

        created_at_gte : typing.Optional[dt.datetime]
            Return only payables created in Monite on or after the specified date and time.

        created_at_lte : typing.Optional[dt.datetime]
            Return only payables created in Monite before or on the specified date and time.

        status : typing.Optional[PayableStateEnum]
            Return only payables that have the specified [status](https://docs.monite.com/accounts-payable/payables/index).

            To query multiple statuses at once, use the `status__in` parameter instead.

        status_in : typing.Optional[typing.Union[PayableStateEnum, typing.Sequence[PayableStateEnum]]]
            Return only payables that have the specified [statuses](https://docs.monite.com/accounts-payable/payables/index).

            To specify multiple statuses, repeat this parameter for each value: `status__in=draft&status__in=new`

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only payables with specified IDs. Valid but nonexistent IDs do not raise errors but produce no results.

            To specify multiple IDs, repeat this parameter for each value: `id__in=<id1>&id__in=<id2>`

        total_amount : typing.Optional[int]
            Return only payables with the exact specified total amount. The amount must be specified in the minor units of currency. For example, $12.5 is represented as 1250.

        total_amount_gt : typing.Optional[int]
            Return only payables whose total amount (in minor units) exceeds the specified value.

        total_amount_lt : typing.Optional[int]
            Return only payables whose total amount (in minor units) is less than the specified value.

        total_amount_gte : typing.Optional[int]
            Return only payables whose total amount (in minor units) is greater than or equal to the specified value.

        total_amount_lte : typing.Optional[int]
            Return only payables whose total amount (in minor units) is less than or equal to the specified value.

        amount : typing.Optional[int]
            Return only payables with the specified amount.

        amount_gt : typing.Optional[int]
            Return only payables whose amount (in minor units) exceeds the specified value.

        amount_lt : typing.Optional[int]
            Return only payables whose amount (in minor units) is less than the specified value.

        amount_gte : typing.Optional[int]
            Return only payables whose amount (in minor units) is greater than or equal to the specified value.

        amount_lte : typing.Optional[int]
            Return only payables whose amount (in minor units) is less than or equal to the specified value.

        currency : typing.Optional[CurrencyEnum]
            Return only payables that use the specified currency.

        counterpart_name : typing.Optional[str]
            Return only payables received from counterparts with the specified name (exact match, case-sensitive).

            For counterparts of `type = individual`, the full name is formatted as `first_name last_name`.

        counterpart_name_contains : typing.Optional[str]
            Return only payables received from counterparts whose name contains the specified string (case-sensitive).

        counterpart_name_icontains : typing.Optional[str]
            Return only payables received from counterparts whose name contains the specified string (case-insensitive).

        search_text : typing.Optional[str]
            Apply the `icontains` condition to search for the specified text in the `document_id` and `counterpart_name` fields in the payables.

        due_date : typing.Optional[str]
            Return payables that are due on the specified date (YYYY-MM-DD)

        due_date_gt : typing.Optional[str]
            Return payables that are due after the specified date (exclusive, YYYY-MM-DD).

        due_date_lt : typing.Optional[str]
            Return payables that are due before the specified date (exclusive, YYYY-MM-DD).

        due_date_gte : typing.Optional[str]
            Return payables that are due on or after the specified date (YYYY-MM-DD).

        due_date_lte : typing.Optional[str]
            Return payables that are due before or on the specified date (YYYY-MM-DD).

        issued_at : typing.Optional[str]
            Return payables that are issued at the specified date (YYYY-MM-DD)

        issued_at_gt : typing.Optional[str]
            Return payables that are issued after the specified date (exclusive, YYYY-MM-DD).

        issued_at_lt : typing.Optional[str]
            Return payables that are issued before the specified date (exclusive, YYYY-MM-DD).

        issued_at_gte : typing.Optional[str]
            Return payables that are issued on or after the specified date (YYYY-MM-DD).

        issued_at_lte : typing.Optional[str]
            Return payables that are issued before or on the specified date (YYYY-MM-DD).

        document_id : typing.Optional[str]
            Return a payable with the exact specified document number (case-sensitive).

            The `document_id` is the user-facing document number such as INV-00042, not to be confused with Monite resource IDs (`id`).

        document_id_contains : typing.Optional[str]
            Return only payables whose document number (`document_id`) contains the specified string (case-sensitive).

        document_id_icontains : typing.Optional[str]
            Return only payables whose document number (`document_id`) contains the specified string (case-insensitive).

        was_created_by_user_id : typing.Optional[str]
            Return only payables created in Monite by the entity user with the specified ID.

        counterpart_id : typing.Optional[str]
            Return only payables received from the counterpart with the specified ID.

            Counterparts that have been deleted but have associated payables will still return results here because the payables contain a frozen copy of the counterpart data.

            If the specified counterpart ID does not exist and never existed, no results are returned.

        source_of_payable_data : typing.Optional[SourceOfPayableDataEnum]
            Return only payables coming from the specified source.

        ocr_status : typing.Optional[OcrStatusEnum]
            Return only payables with specific OCR statuses.

        line_item_id : typing.Optional[str]
            Search for a payable by the identifier of the line item associated with it.

        purchase_order_id : typing.Optional[str]
            Search for a payable by the identifier of the purchase order associated with it.

        project_id : typing.Optional[str]
            Return only payables assigned to the project with the specified ID.

            Valid but nonexistent project IDs do not raise errors but return no results.

        project_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only payables whose `project_id` include at least one of the project_id with the specified IDs. Valid but nonexistent project IDs do not raise errors but produce no results.

        tag_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only payables whose `tags` include at least one of the tags with the specified IDs. Valid but nonexistent tag IDs do not raise errors but produce no results.

        tag_ids_not_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only payables whose `tags` do not include any of the tags with the specified IDs. Valid but nonexistent tag IDs do not raise errors but produce the results.

        origin : typing.Optional[PayableOriginEnum]
            Return only payables from a given origin ['einvoice', 'upload', 'email']

        has_file : typing.Optional[bool]
            Return only payables with or without attachments (files)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PayableAnalyticsResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.analytics.get_analytics_payables(metric="id", aggregation_function="count", )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_analytics_payables(
            metric=metric,
            aggregation_function=aggregation_function,
            dimension=dimension,
            date_dimension_breakdown=date_dimension_breakdown,
            limit=limit,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            status=status,
            status_in=status_in,
            id_in=id_in,
            total_amount=total_amount,
            total_amount_gt=total_amount_gt,
            total_amount_lt=total_amount_lt,
            total_amount_gte=total_amount_gte,
            total_amount_lte=total_amount_lte,
            amount=amount,
            amount_gt=amount_gt,
            amount_lt=amount_lt,
            amount_gte=amount_gte,
            amount_lte=amount_lte,
            currency=currency,
            counterpart_name=counterpart_name,
            counterpart_name_contains=counterpart_name_contains,
            counterpart_name_icontains=counterpart_name_icontains,
            search_text=search_text,
            due_date=due_date,
            due_date_gt=due_date_gt,
            due_date_lt=due_date_lt,
            due_date_gte=due_date_gte,
            due_date_lte=due_date_lte,
            issued_at=issued_at,
            issued_at_gt=issued_at_gt,
            issued_at_lt=issued_at_lt,
            issued_at_gte=issued_at_gte,
            issued_at_lte=issued_at_lte,
            document_id=document_id,
            document_id_contains=document_id_contains,
            document_id_icontains=document_id_icontains,
            was_created_by_user_id=was_created_by_user_id,
            counterpart_id=counterpart_id,
            source_of_payable_data=source_of_payable_data,
            ocr_status=ocr_status,
            line_item_id=line_item_id,
            purchase_order_id=purchase_order_id,
            project_id=project_id,
            project_id_in=project_id_in,
            tag_ids=tag_ids,
            tag_ids_not_in=tag_ids_not_in,
            origin=origin,
            has_file=has_file,
            request_options=request_options,
        )
        return _response.data

    async def get_analytics_receivables(
        self,
        *,
        metric: ReceivableMetricEnum,
        aggregation_function: AggregationFunctionEnum,
        dimension: typing.Optional[ReceivableDimensionEnum] = None,
        date_dimension_breakdown: typing.Optional[DateDimensionBreakdownEnum] = None,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status_in: typing.Optional[
            typing.Union[
                GetAnalyticsReceivablesRequestStatusInItem, typing.Sequence[GetAnalyticsReceivablesRequestStatusInItem]
            ]
        ] = None,
        entity_user_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        sort: typing.Optional[ReceivableCursorFields] = None,
        tag_ids_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        tag_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        product_ids_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        product_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        project_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        type: typing.Optional[ReceivableType] = None,
        document_id: typing.Optional[str] = None,
        document_id_contains: typing.Optional[str] = None,
        document_id_icontains: typing.Optional[str] = None,
        issue_date_gt: typing.Optional[dt.datetime] = None,
        issue_date_lt: typing.Optional[dt.datetime] = None,
        issue_date_gte: typing.Optional[dt.datetime] = None,
        issue_date_lte: typing.Optional[dt.datetime] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        counterpart_id: typing.Optional[str] = None,
        counterpart_name: typing.Optional[str] = None,
        counterpart_name_contains: typing.Optional[str] = None,
        counterpart_name_icontains: typing.Optional[str] = None,
        total_amount: typing.Optional[int] = None,
        total_amount_gt: typing.Optional[int] = None,
        total_amount_lt: typing.Optional[int] = None,
        total_amount_gte: typing.Optional[int] = None,
        total_amount_lte: typing.Optional[int] = None,
        status: typing.Optional[GetAnalyticsReceivablesRequestStatus] = None,
        entity_user_id: typing.Optional[str] = None,
        based_on: typing.Optional[str] = None,
        due_date_gt: typing.Optional[str] = None,
        due_date_lt: typing.Optional[str] = None,
        due_date_gte: typing.Optional[str] = None,
        due_date_lte: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivablesAnalyticsResponse:
        """
        Retrieve aggregated statistics for receivables with different breakdowns.

        Parameters
        ----------
        metric : ReceivableMetricEnum

        aggregation_function : AggregationFunctionEnum

        dimension : typing.Optional[ReceivableDimensionEnum]

        date_dimension_breakdown : typing.Optional[DateDimensionBreakdownEnum]

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 250) to return in a single page of the response. Default is 100. The response may contain fewer items if it is the last or only page.

            When using pagination with a non-default `limit`, you must provide the `limit` value alongside `pagination_token` in all subsequent pagination requests. Unlike other query parameters, `limit` is not inferred from `pagination_token`.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters except `limit` are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables with the specified IDs. Valid but nonexistent IDs do not raise errors but produce no results.

            To specify multiple IDs, repeat this parameter for each value:
            `id__in=<id1>&id__in=<id2>`

        status_in : typing.Optional[typing.Union[GetAnalyticsReceivablesRequestStatusInItem, typing.Sequence[GetAnalyticsReceivablesRequestStatusInItem]]]
            Return only receivables that have the specified statuses. See the applicable [invoice statuses](https://docs.monite.com/accounts-receivable/invoices/index), [quote statuses](https://docs.monite.com/accounts-receivable/quotes/index), and [credit note statuses](https://docs.monite.com/accounts-receivable/credit-notes#credit-note-lifecycle).

            To specify multiple statuses, repeat this parameter for each value:
            `status__in=draft&status__in=issued`

        entity_user_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables created by the entity users with the specified IDs.To specify multiple user IDs, repeat this parameter for each ID:
            `entity_user_id__in=<user1>&entity_user_id__in=<user2>`

            If the request is authenticated using an entity user token, this user must have the `receivable.read.allowed` (rather than `allowed_for_own`) permission to be able to query receivables created by other users.

            IDs of deleted users will still produce results here if those users had associated receivables. Valid but nonexistent user IDs do not raise errors but produce no results.

        sort : typing.Optional[ReceivableCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        tag_ids_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose [tags](https://docs.monite.com/common/tags) include at least one of the tags with the specified IDs.

            For example, given receivables with the following tags:
            1. tagA
            2. tagB
            3. tagA, tagB
            4. tagC
            5. tagB, tagC


            `tag_ids__in=<tagA>&tag_ids__in=<tagB>` will return receivables 1, 2, 3, and 5.

            Valid but nonexistent tag IDs do not raise errors but produce no results.

        tag_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose [tags](https://docs.monite.com/common/tags) include all of the tags with the specified IDs and optionally other tags that are not specified.

            For example, given receivables with the following tags:
            1. tagA
            2. tagB
            3. tagA, tagB
            4. tagC
            5. tagA, tagB, tagC


            `tag_ids=<tagA>&tag_ids=<tagB>` will return receivables 3 and 5.

        product_ids_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose line items include at least one of the product IDs with the specified IDs.

            To specify multiple product IDs, repeat this parameter for each ID:
            `product_ids__in=<product1>&product_ids__in=<product2>`

            For example, given receivables with the following product IDs:
            1. productA
            2. productB
            3. productA, productB
            4. productC
            5. productB, productC


            `product_ids__in=<productA>&product_ids__in=<productB>` will return receivables 1, 2, 3, and 5.Valid but nonexistent product IDs do not raise errors but produce no results.

        product_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose line items include all of the product IDs with the specified IDs and optionally other products that are not specified.

            To specify multiple product IDs, repeat this parameter for each ID:
            `product_ids=<product1>&product_ids=<product2>`

            For example, given receivables with the following product IDs:
            1. productA
            2. productB
            3. productA, productB
            4. productC
            5. productA, productB, productC


            `product_ids=<productA>&product_ids=<productB>` will return receivables 3 and 5.

        project_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose `project_id` include at least one of the project_id with the specified IDs. Valid but nonexistent project IDs do not raise errors but produce no results.

        type : typing.Optional[ReceivableType]

        document_id : typing.Optional[str]

        document_id_contains : typing.Optional[str]

        document_id_icontains : typing.Optional[str]

        issue_date_gt : typing.Optional[dt.datetime]

        issue_date_lt : typing.Optional[dt.datetime]

        issue_date_gte : typing.Optional[dt.datetime]

        issue_date_lte : typing.Optional[dt.datetime]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        counterpart_id : typing.Optional[str]

        counterpart_name : typing.Optional[str]

        counterpart_name_contains : typing.Optional[str]

        counterpart_name_icontains : typing.Optional[str]

        total_amount : typing.Optional[int]

        total_amount_gt : typing.Optional[int]

        total_amount_lt : typing.Optional[int]

        total_amount_gte : typing.Optional[int]

        total_amount_lte : typing.Optional[int]

        status : typing.Optional[GetAnalyticsReceivablesRequestStatus]

        entity_user_id : typing.Optional[str]

        based_on : typing.Optional[str]

        due_date_gt : typing.Optional[str]

        due_date_lt : typing.Optional[str]

        due_date_gte : typing.Optional[str]

        due_date_lte : typing.Optional[str]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivablesAnalyticsResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.analytics.get_analytics_receivables(metric="id", aggregation_function="count", )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_analytics_receivables(
            metric=metric,
            aggregation_function=aggregation_function,
            dimension=dimension,
            date_dimension_breakdown=date_dimension_breakdown,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            id_in=id_in,
            status_in=status_in,
            entity_user_id_in=entity_user_id_in,
            sort=sort,
            tag_ids_in=tag_ids_in,
            tag_ids=tag_ids,
            product_ids_in=product_ids_in,
            product_ids=product_ids,
            project_id_in=project_id_in,
            type=type,
            document_id=document_id,
            document_id_contains=document_id_contains,
            document_id_icontains=document_id_icontains,
            issue_date_gt=issue_date_gt,
            issue_date_lt=issue_date_lt,
            issue_date_gte=issue_date_gte,
            issue_date_lte=issue_date_lte,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            counterpart_id=counterpart_id,
            counterpart_name=counterpart_name,
            counterpart_name_contains=counterpart_name_contains,
            counterpart_name_icontains=counterpart_name_icontains,
            total_amount=total_amount,
            total_amount_gt=total_amount_gt,
            total_amount_lt=total_amount_lt,
            total_amount_gte=total_amount_gte,
            total_amount_lte=total_amount_lte,
            status=status,
            entity_user_id=entity_user_id,
            based_on=based_on,
            due_date_gt=due_date_gt,
            due_date_lt=due_date_lt,
            due_date_gte=due_date_gte,
            due_date_lte=due_date_lte,
            project_id=project_id,
            request_options=request_options,
        )
        return _response.data
