# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.approval_policy_cursor_fields import ApprovalPolicyCursorFields
from ..types.approval_policy_resource import ApprovalPolicyResource
from ..types.approval_policy_resource_list import ApprovalPolicyResourceList
from ..types.approval_policy_status import ApprovalPolicyStatus
from ..types.order_enum import OrderEnum
from .processes.client import AsyncProcessesClient, ProcessesClient
from .raw_client import AsyncRawApprovalPoliciesClient, RawApprovalPoliciesClient
from .types.approval_policies_get_request_status import ApprovalPoliciesGetRequestStatus
from .types.approval_policies_get_request_status_in_item import ApprovalPoliciesGetRequestStatusInItem
from .types.approval_policy_create_script_item import ApprovalPolicyCreateScriptItem
from .types.approval_policy_create_trigger import ApprovalPolicyCreateTrigger
from .types.approval_policy_update_script_item import ApprovalPolicyUpdateScriptItem
from .types.approval_policy_update_trigger import ApprovalPolicyUpdateTrigger

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ApprovalPoliciesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawApprovalPoliciesClient(client_wrapper=client_wrapper)
        self.processes = ProcessesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawApprovalPoliciesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawApprovalPoliciesClient
        """
        return self._raw_client

    def get(
        self,
        *,
        process_id: typing.Optional[str] = None,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[ApprovalPolicyCursorFields] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[ApprovalPoliciesGetRequestStatus] = None,
        status_in: typing.Optional[
            typing.Union[
                ApprovalPoliciesGetRequestStatusInItem, typing.Sequence[ApprovalPoliciesGetRequestStatusInItem]
            ]
        ] = None,
        name: typing.Optional[str] = None,
        name_contains: typing.Optional[str] = None,
        name_ncontains: typing.Optional[str] = None,
        created_by: typing.Optional[str] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        updated_at_gt: typing.Optional[dt.datetime] = None,
        updated_at_lt: typing.Optional[dt.datetime] = None,
        updated_at_gte: typing.Optional[dt.datetime] = None,
        updated_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApprovalPolicyResourceList:
        """
        Retrieve a list of all approval policies with pagination.

        Parameters
        ----------
        process_id : typing.Optional[str]

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[ApprovalPolicyCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        status : typing.Optional[ApprovalPoliciesGetRequestStatus]

        status_in : typing.Optional[typing.Union[ApprovalPoliciesGetRequestStatusInItem, typing.Sequence[ApprovalPoliciesGetRequestStatusInItem]]]

        name : typing.Optional[str]

        name_contains : typing.Optional[str]

        name_ncontains : typing.Optional[str]

        created_by : typing.Optional[str]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        updated_at_gt : typing.Optional[dt.datetime]

        updated_at_lt : typing.Optional[dt.datetime]

        updated_at_gte : typing.Optional[dt.datetime]

        updated_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalPolicyResourceList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.approval_policies.get()
        """
        _response = self._raw_client.get(
            process_id=process_id,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            id_in=id_in,
            status=status,
            status_in=status_in,
            name=name,
            name_contains=name_contains,
            name_ncontains=name_ncontains,
            created_by=created_by,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            updated_at_gt=updated_at_gt,
            updated_at_lt=updated_at_lt,
            updated_at_gte=updated_at_gte,
            updated_at_lte=updated_at_lte,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        name: str,
        script: typing.Sequence[ApprovalPolicyCreateScriptItem],
        description: typing.Optional[str] = OMIT,
        ends_at: typing.Optional[dt.datetime] = OMIT,
        starts_at: typing.Optional[dt.datetime] = OMIT,
        trigger: typing.Optional[ApprovalPolicyCreateTrigger] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApprovalPolicyResource:
        """
        Create a new approval policy.

        Parameters
        ----------
        name : str
            The name of the approval policy.

        script : typing.Sequence[ApprovalPolicyCreateScriptItem]
            A list of JSON objects that represents the approval policy script. The script contains the logic that determines whether an action should be sent to approval. This field is required, and it should contain at least one script object.

        description : typing.Optional[str]
            A brief description of the approval policy.

        ends_at : typing.Optional[dt.datetime]
            The date and time (in the ISO 8601 format) when the approval policy stops being active and stops triggering approval workflows.If `ends_at` is provided in the request, then `starts_at` must also be provided and `ends_at` must be later than `starts_at`. The value will be converted to UTC.

        starts_at : typing.Optional[dt.datetime]
            The date and time (in the ISO 8601 format) when the approval policy becomes active. Only payables submitted for approval during the policy's active period will trigger this policy. If omitted or `null`, the policy is effective immediately. The value will be converted to UTC.

        trigger : typing.Optional[ApprovalPolicyCreateTrigger]
            A JSON object that represents the trigger for the approval policy. The trigger specifies the event that will trigger the policy to be evaluated.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalPolicyResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.approval_policies.create(name='name', script=[True], )
        """
        _response = self._raw_client.create(
            name=name,
            script=script,
            description=description,
            ends_at=ends_at,
            starts_at=starts_at,
            trigger=trigger,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(
        self, approval_policy_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalPolicyResource:
        """
        Retrieve a specific approval policy.

        Parameters
        ----------
        approval_policy_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalPolicyResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.approval_policies.get_by_id(approval_policy_id='approval_policy_id', )
        """
        _response = self._raw_client.get_by_id(approval_policy_id, request_options=request_options)
        return _response.data

    def delete_by_id(self, approval_policy_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete an existing approval policy.

        Parameters
        ----------
        approval_policy_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.approval_policies.delete_by_id(approval_policy_id='approval_policy_id', )
        """
        _response = self._raw_client.delete_by_id(approval_policy_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        approval_policy_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        ends_at: typing.Optional[dt.datetime] = OMIT,
        name: typing.Optional[str] = OMIT,
        script: typing.Optional[typing.Sequence[ApprovalPolicyUpdateScriptItem]] = OMIT,
        starts_at: typing.Optional[dt.datetime] = OMIT,
        status: typing.Optional[ApprovalPolicyStatus] = OMIT,
        trigger: typing.Optional[ApprovalPolicyUpdateTrigger] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApprovalPolicyResource:
        """
        Update an existing approval policy.

        Parameters
        ----------
        approval_policy_id : str

        description : typing.Optional[str]
            A brief description of the approval policy.

        ends_at : typing.Optional[dt.datetime]
            The date and time (in the ISO 8601 format) when the approval policy stops being active and stops triggering approval workflows.If `ends_at` is provided in the request, then `starts_at` must also be provided and `ends_at` must be later than `starts_at`. The value will be converted to UTC.

        name : typing.Optional[str]
            The name of the approval policy.

        script : typing.Optional[typing.Sequence[ApprovalPolicyUpdateScriptItem]]
            A list of JSON objects that represents the approval policy script. The script contains the logic that determines whether an action should be sent to approval. This field is required, and it should contain at least one script object.

        starts_at : typing.Optional[dt.datetime]
            The date and time (in the ISO 8601 format) when the approval policy becomes active. Only payables submitted for approval during the policy's active period will trigger this policy. If omitted or `null`, the policy is effective immediately. The value will be converted to UTC.

        status : typing.Optional[ApprovalPolicyStatus]
            A string that represents the current status of the approval policy.

        trigger : typing.Optional[ApprovalPolicyUpdateTrigger]
            A JSON object that represents the trigger for the approval policy. The trigger specifies the event that will trigger the policy to be evaluated.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalPolicyResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.approval_policies.update_by_id(approval_policy_id='approval_policy_id', )
        """
        _response = self._raw_client.update_by_id(
            approval_policy_id,
            description=description,
            ends_at=ends_at,
            name=name,
            script=script,
            starts_at=starts_at,
            status=status,
            trigger=trigger,
            request_options=request_options,
        )
        return _response.data


class AsyncApprovalPoliciesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawApprovalPoliciesClient(client_wrapper=client_wrapper)
        self.processes = AsyncProcessesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawApprovalPoliciesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawApprovalPoliciesClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        process_id: typing.Optional[str] = None,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[ApprovalPolicyCursorFields] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[ApprovalPoliciesGetRequestStatus] = None,
        status_in: typing.Optional[
            typing.Union[
                ApprovalPoliciesGetRequestStatusInItem, typing.Sequence[ApprovalPoliciesGetRequestStatusInItem]
            ]
        ] = None,
        name: typing.Optional[str] = None,
        name_contains: typing.Optional[str] = None,
        name_ncontains: typing.Optional[str] = None,
        created_by: typing.Optional[str] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        updated_at_gt: typing.Optional[dt.datetime] = None,
        updated_at_lt: typing.Optional[dt.datetime] = None,
        updated_at_gte: typing.Optional[dt.datetime] = None,
        updated_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApprovalPolicyResourceList:
        """
        Retrieve a list of all approval policies with pagination.

        Parameters
        ----------
        process_id : typing.Optional[str]

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[ApprovalPolicyCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        status : typing.Optional[ApprovalPoliciesGetRequestStatus]

        status_in : typing.Optional[typing.Union[ApprovalPoliciesGetRequestStatusInItem, typing.Sequence[ApprovalPoliciesGetRequestStatusInItem]]]

        name : typing.Optional[str]

        name_contains : typing.Optional[str]

        name_ncontains : typing.Optional[str]

        created_by : typing.Optional[str]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        updated_at_gt : typing.Optional[dt.datetime]

        updated_at_lt : typing.Optional[dt.datetime]

        updated_at_gte : typing.Optional[dt.datetime]

        updated_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalPolicyResourceList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.approval_policies.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            process_id=process_id,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            id_in=id_in,
            status=status,
            status_in=status_in,
            name=name,
            name_contains=name_contains,
            name_ncontains=name_ncontains,
            created_by=created_by,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            updated_at_gt=updated_at_gt,
            updated_at_lt=updated_at_lt,
            updated_at_gte=updated_at_gte,
            updated_at_lte=updated_at_lte,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        name: str,
        script: typing.Sequence[ApprovalPolicyCreateScriptItem],
        description: typing.Optional[str] = OMIT,
        ends_at: typing.Optional[dt.datetime] = OMIT,
        starts_at: typing.Optional[dt.datetime] = OMIT,
        trigger: typing.Optional[ApprovalPolicyCreateTrigger] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApprovalPolicyResource:
        """
        Create a new approval policy.

        Parameters
        ----------
        name : str
            The name of the approval policy.

        script : typing.Sequence[ApprovalPolicyCreateScriptItem]
            A list of JSON objects that represents the approval policy script. The script contains the logic that determines whether an action should be sent to approval. This field is required, and it should contain at least one script object.

        description : typing.Optional[str]
            A brief description of the approval policy.

        ends_at : typing.Optional[dt.datetime]
            The date and time (in the ISO 8601 format) when the approval policy stops being active and stops triggering approval workflows.If `ends_at` is provided in the request, then `starts_at` must also be provided and `ends_at` must be later than `starts_at`. The value will be converted to UTC.

        starts_at : typing.Optional[dt.datetime]
            The date and time (in the ISO 8601 format) when the approval policy becomes active. Only payables submitted for approval during the policy's active period will trigger this policy. If omitted or `null`, the policy is effective immediately. The value will be converted to UTC.

        trigger : typing.Optional[ApprovalPolicyCreateTrigger]
            A JSON object that represents the trigger for the approval policy. The trigger specifies the event that will trigger the policy to be evaluated.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalPolicyResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.approval_policies.create(name='name', script=[True], )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            script=script,
            description=description,
            ends_at=ends_at,
            starts_at=starts_at,
            trigger=trigger,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, approval_policy_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalPolicyResource:
        """
        Retrieve a specific approval policy.

        Parameters
        ----------
        approval_policy_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalPolicyResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.approval_policies.get_by_id(approval_policy_id='approval_policy_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(approval_policy_id, request_options=request_options)
        return _response.data

    async def delete_by_id(
        self, approval_policy_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete an existing approval policy.

        Parameters
        ----------
        approval_policy_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.approval_policies.delete_by_id(approval_policy_id='approval_policy_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(approval_policy_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        approval_policy_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        ends_at: typing.Optional[dt.datetime] = OMIT,
        name: typing.Optional[str] = OMIT,
        script: typing.Optional[typing.Sequence[ApprovalPolicyUpdateScriptItem]] = OMIT,
        starts_at: typing.Optional[dt.datetime] = OMIT,
        status: typing.Optional[ApprovalPolicyStatus] = OMIT,
        trigger: typing.Optional[ApprovalPolicyUpdateTrigger] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApprovalPolicyResource:
        """
        Update an existing approval policy.

        Parameters
        ----------
        approval_policy_id : str

        description : typing.Optional[str]
            A brief description of the approval policy.

        ends_at : typing.Optional[dt.datetime]
            The date and time (in the ISO 8601 format) when the approval policy stops being active and stops triggering approval workflows.If `ends_at` is provided in the request, then `starts_at` must also be provided and `ends_at` must be later than `starts_at`. The value will be converted to UTC.

        name : typing.Optional[str]
            The name of the approval policy.

        script : typing.Optional[typing.Sequence[ApprovalPolicyUpdateScriptItem]]
            A list of JSON objects that represents the approval policy script. The script contains the logic that determines whether an action should be sent to approval. This field is required, and it should contain at least one script object.

        starts_at : typing.Optional[dt.datetime]
            The date and time (in the ISO 8601 format) when the approval policy becomes active. Only payables submitted for approval during the policy's active period will trigger this policy. If omitted or `null`, the policy is effective immediately. The value will be converted to UTC.

        status : typing.Optional[ApprovalPolicyStatus]
            A string that represents the current status of the approval policy.

        trigger : typing.Optional[ApprovalPolicyUpdateTrigger]
            A JSON object that represents the trigger for the approval policy. The trigger specifies the event that will trigger the policy to be evaluated.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalPolicyResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.approval_policies.update_by_id(approval_policy_id='approval_policy_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            approval_policy_id,
            description=description,
            ends_at=ends_at,
            name=name,
            script=script,
            starts_at=starts_at,
            status=status,
            trigger=trigger,
            request_options=request_options,
        )
        return _response.data
