# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.approval_process_resource_list import ApprovalProcessResourceList
from ...types.approval_process_step_resource_list import ApprovalProcessStepResourceList
from ...types.process_resource import ProcessResource
from .raw_client import AsyncRawProcessesClient, RawProcessesClient


class ProcessesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawProcessesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawProcessesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawProcessesClient
        """
        return self._raw_client

    def get(
        self, approval_policy_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalProcessResourceList:
        """
        Retrieve a list of all approval policy processes.

        Parameters
        ----------
        approval_policy_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalProcessResourceList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.approval_policies.processes.get(approval_policy_id='approval_policy_id', )
        """
        _response = self._raw_client.get(approval_policy_id, request_options=request_options)
        return _response.data

    def get_by_id(
        self, approval_policy_id: str, process_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProcessResource:
        """
        Retrieve a specific approval policy process.

        Parameters
        ----------
        approval_policy_id : str

        process_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.approval_policies.processes.get_by_id(approval_policy_id='approval_policy_id', process_id='process_id', )
        """
        _response = self._raw_client.get_by_id(approval_policy_id, process_id, request_options=request_options)
        return _response.data

    def cancel_by_id(
        self, approval_policy_id: str, process_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProcessResource:
        """
        Cancel an ongoing approval process for a specific approval policy.

        Parameters
        ----------
        approval_policy_id : str

        process_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.approval_policies.processes.cancel_by_id(approval_policy_id='approval_policy_id', process_id='process_id', )
        """
        _response = self._raw_client.cancel_by_id(approval_policy_id, process_id, request_options=request_options)
        return _response.data

    def get_steps(
        self, approval_policy_id: str, process_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalProcessStepResourceList:
        """
        Retrieve a list of approval policy process steps.

        Parameters
        ----------
        approval_policy_id : str

        process_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalProcessStepResourceList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.approval_policies.processes.get_steps(approval_policy_id='approval_policy_id', process_id='process_id', )
        """
        _response = self._raw_client.get_steps(approval_policy_id, process_id, request_options=request_options)
        return _response.data


class AsyncProcessesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawProcessesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawProcessesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawProcessesClient
        """
        return self._raw_client

    async def get(
        self, approval_policy_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalProcessResourceList:
        """
        Retrieve a list of all approval policy processes.

        Parameters
        ----------
        approval_policy_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalProcessResourceList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.approval_policies.processes.get(approval_policy_id='approval_policy_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(approval_policy_id, request_options=request_options)
        return _response.data

    async def get_by_id(
        self, approval_policy_id: str, process_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProcessResource:
        """
        Retrieve a specific approval policy process.

        Parameters
        ----------
        approval_policy_id : str

        process_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.approval_policies.processes.get_by_id(approval_policy_id='approval_policy_id', process_id='process_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(approval_policy_id, process_id, request_options=request_options)
        return _response.data

    async def cancel_by_id(
        self, approval_policy_id: str, process_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProcessResource:
        """
        Cancel an ongoing approval process for a specific approval policy.

        Parameters
        ----------
        approval_policy_id : str

        process_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.approval_policies.processes.cancel_by_id(approval_policy_id='approval_policy_id', process_id='process_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.cancel_by_id(approval_policy_id, process_id, request_options=request_options)
        return _response.data

    async def get_steps(
        self, approval_policy_id: str, process_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalProcessStepResourceList:
        """
        Retrieve a list of approval policy process steps.

        Parameters
        ----------
        approval_policy_id : str

        process_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalProcessStepResourceList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.approval_policies.processes.get_steps(approval_policy_id='approval_policy_id', process_id='process_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_steps(approval_policy_id, process_id, request_options=request_options)
        return _response.data
