# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.approval_request_create_request import ApprovalRequestCreateRequest
from ..types.approval_request_cursor_fields import ApprovalRequestCursorFields
from ..types.approval_request_resource_list import ApprovalRequestResourceList
from ..types.approval_request_resource_with_metadata import ApprovalRequestResourceWithMetadata
from ..types.approval_request_status import ApprovalRequestStatus
from ..types.object_type import ObjectType
from ..types.order_enum import OrderEnum
from .raw_client import AsyncRawApprovalRequestsClient, RawApprovalRequestsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ApprovalRequestsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawApprovalRequestsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawApprovalRequestsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawApprovalRequestsClient
        """
        return self._raw_client

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[ApprovalRequestCursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        updated_at_gt: typing.Optional[dt.datetime] = None,
        updated_at_lt: typing.Optional[dt.datetime] = None,
        updated_at_gte: typing.Optional[dt.datetime] = None,
        updated_at_lte: typing.Optional[dt.datetime] = None,
        object_id: typing.Optional[str] = None,
        object_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[ApprovalRequestStatus] = None,
        status_in: typing.Optional[typing.Union[ApprovalRequestStatus, typing.Sequence[ApprovalRequestStatus]]] = None,
        user_id: typing.Optional[str] = None,
        role_id: typing.Optional[str] = None,
        object_type: typing.Optional[ObjectType] = None,
        object_type_in: typing.Optional[typing.Union[ObjectType, typing.Sequence[ObjectType]]] = None,
        created_by: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApprovalRequestResourceList:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[ApprovalRequestCursorFields]
            Allowed sort fields

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        updated_at_gt : typing.Optional[dt.datetime]

        updated_at_lt : typing.Optional[dt.datetime]

        updated_at_gte : typing.Optional[dt.datetime]

        updated_at_lte : typing.Optional[dt.datetime]

        object_id : typing.Optional[str]

        object_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        status : typing.Optional[ApprovalRequestStatus]

        status_in : typing.Optional[typing.Union[ApprovalRequestStatus, typing.Sequence[ApprovalRequestStatus]]]

        user_id : typing.Optional[str]

        role_id : typing.Optional[str]

        object_type : typing.Optional[ObjectType]

        object_type_in : typing.Optional[typing.Union[ObjectType, typing.Sequence[ObjectType]]]

        created_by : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalRequestResourceList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.approval_requests.get()
        """
        _response = self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            updated_at_gt=updated_at_gt,
            updated_at_lt=updated_at_lt,
            updated_at_gte=updated_at_gte,
            updated_at_lte=updated_at_lte,
            object_id=object_id,
            object_id_in=object_id_in,
            status=status,
            status_in=status_in,
            user_id=user_id,
            role_id=role_id,
            object_type=object_type,
            object_type_in=object_type_in,
            created_by=created_by,
            request_options=request_options,
        )
        return _response.data

    def create(
        self, *, request: ApprovalRequestCreateRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalRequestResourceWithMetadata:
        """
        Parameters
        ----------
        request : ApprovalRequestCreateRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalRequestResourceWithMetadata
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import ApprovalRequestCreateByRoleRequest
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.approval_requests.create(request=ApprovalRequestCreateByRoleRequest(object_id='object_id', object_type="account", required_approval_count=1, role_ids=['role_ids'], ), )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def get_by_id(
        self, approval_request_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalRequestResourceWithMetadata:
        """
        Parameters
        ----------
        approval_request_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalRequestResourceWithMetadata
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.approval_requests.get_by_id(approval_request_id='approval_request_id', )
        """
        _response = self._raw_client.get_by_id(approval_request_id, request_options=request_options)
        return _response.data

    def approve_by_id(
        self, approval_request_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalRequestResourceWithMetadata:
        """
        Parameters
        ----------
        approval_request_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalRequestResourceWithMetadata
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.approval_requests.approve_by_id(approval_request_id='approval_request_id', )
        """
        _response = self._raw_client.approve_by_id(approval_request_id, request_options=request_options)
        return _response.data

    def cancel_by_id(
        self, approval_request_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalRequestResourceWithMetadata:
        """
        Parameters
        ----------
        approval_request_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalRequestResourceWithMetadata
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.approval_requests.cancel_by_id(approval_request_id='approval_request_id', )
        """
        _response = self._raw_client.cancel_by_id(approval_request_id, request_options=request_options)
        return _response.data

    def reject_by_id(
        self, approval_request_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalRequestResourceWithMetadata:
        """
        Parameters
        ----------
        approval_request_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalRequestResourceWithMetadata
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.approval_requests.reject_by_id(approval_request_id='approval_request_id', )
        """
        _response = self._raw_client.reject_by_id(approval_request_id, request_options=request_options)
        return _response.data


class AsyncApprovalRequestsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawApprovalRequestsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawApprovalRequestsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawApprovalRequestsClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[ApprovalRequestCursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        updated_at_gt: typing.Optional[dt.datetime] = None,
        updated_at_lt: typing.Optional[dt.datetime] = None,
        updated_at_gte: typing.Optional[dt.datetime] = None,
        updated_at_lte: typing.Optional[dt.datetime] = None,
        object_id: typing.Optional[str] = None,
        object_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[ApprovalRequestStatus] = None,
        status_in: typing.Optional[typing.Union[ApprovalRequestStatus, typing.Sequence[ApprovalRequestStatus]]] = None,
        user_id: typing.Optional[str] = None,
        role_id: typing.Optional[str] = None,
        object_type: typing.Optional[ObjectType] = None,
        object_type_in: typing.Optional[typing.Union[ObjectType, typing.Sequence[ObjectType]]] = None,
        created_by: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ApprovalRequestResourceList:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[ApprovalRequestCursorFields]
            Allowed sort fields

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        updated_at_gt : typing.Optional[dt.datetime]

        updated_at_lt : typing.Optional[dt.datetime]

        updated_at_gte : typing.Optional[dt.datetime]

        updated_at_lte : typing.Optional[dt.datetime]

        object_id : typing.Optional[str]

        object_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        status : typing.Optional[ApprovalRequestStatus]

        status_in : typing.Optional[typing.Union[ApprovalRequestStatus, typing.Sequence[ApprovalRequestStatus]]]

        user_id : typing.Optional[str]

        role_id : typing.Optional[str]

        object_type : typing.Optional[ObjectType]

        object_type_in : typing.Optional[typing.Union[ObjectType, typing.Sequence[ObjectType]]]

        created_by : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalRequestResourceList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.approval_requests.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            updated_at_gt=updated_at_gt,
            updated_at_lt=updated_at_lt,
            updated_at_gte=updated_at_gte,
            updated_at_lte=updated_at_lte,
            object_id=object_id,
            object_id_in=object_id_in,
            status=status,
            status_in=status_in,
            user_id=user_id,
            role_id=role_id,
            object_type=object_type,
            object_type_in=object_type_in,
            created_by=created_by,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self, *, request: ApprovalRequestCreateRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalRequestResourceWithMetadata:
        """
        Parameters
        ----------
        request : ApprovalRequestCreateRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalRequestResourceWithMetadata
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import ApprovalRequestCreateByRoleRequest
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.approval_requests.create(request=ApprovalRequestCreateByRoleRequest(object_id='object_id', object_type="account", required_approval_count=1, role_ids=['role_ids'], ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def get_by_id(
        self, approval_request_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalRequestResourceWithMetadata:
        """
        Parameters
        ----------
        approval_request_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalRequestResourceWithMetadata
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.approval_requests.get_by_id(approval_request_id='approval_request_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(approval_request_id, request_options=request_options)
        return _response.data

    async def approve_by_id(
        self, approval_request_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalRequestResourceWithMetadata:
        """
        Parameters
        ----------
        approval_request_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalRequestResourceWithMetadata
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.approval_requests.approve_by_id(approval_request_id='approval_request_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.approve_by_id(approval_request_id, request_options=request_options)
        return _response.data

    async def cancel_by_id(
        self, approval_request_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalRequestResourceWithMetadata:
        """
        Parameters
        ----------
        approval_request_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalRequestResourceWithMetadata
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.approval_requests.cancel_by_id(approval_request_id='approval_request_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.cancel_by_id(approval_request_id, request_options=request_options)
        return _response.data

    async def reject_by_id(
        self, approval_request_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ApprovalRequestResourceWithMetadata:
        """
        Parameters
        ----------
        approval_request_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApprovalRequestResourceWithMetadata
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.approval_requests.reject_by_id(approval_request_id='approval_request_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.reject_by_id(approval_request_id, request_options=request_options)
        return _response.data
