# This file was auto-generated by Fern from our API Definition.

import typing

import httpx
from .access_tokens.client import AccessTokensClient, AsyncAccessTokensClient
from .accounting.client import AccountingClient, AsyncAccountingClient
from .analytics.client import AnalyticsClient, AsyncAnalyticsClient
from .approval_policies.client import ApprovalPoliciesClient, AsyncApprovalPoliciesClient
from .approval_requests.client import ApprovalRequestsClient, AsyncApprovalRequestsClient
from .comments.client import AsyncCommentsClient, CommentsClient
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .counterpart_e_invoicing_credentials.client import (
    AsyncCounterpartEInvoicingCredentialsClient,
    CounterpartEInvoicingCredentialsClient,
)
from .counterparts.client import AsyncCounterpartsClient, CounterpartsClient
from .credit_notes.client import AsyncCreditNotesClient, CreditNotesClient
from .data_exports.client import AsyncDataExportsClient, DataExportsClient
from .delivery_notes.client import AsyncDeliveryNotesClient, DeliveryNotesClient
from .e_invoicing_connections.client import AsyncEInvoicingConnectionsClient, EInvoicingConnectionsClient
from .entities.client import AsyncEntitiesClient, EntitiesClient
from .entity_users.client import AsyncEntityUsersClient, EntityUsersClient
from .environment import MoniteEnvironment
from .events.client import AsyncEventsClient, EventsClient
from .files.client import AsyncFilesClient, FilesClient
from .financing.client import AsyncFinancingClient, FinancingClient
from .mail_templates.client import AsyncMailTemplatesClient, MailTemplatesClient
from .mailbox_domains.client import AsyncMailboxDomainsClient, MailboxDomainsClient
from .mailboxes.client import AsyncMailboxesClient, MailboxesClient
from .measure_units.client import AsyncMeasureUnitsClient, MeasureUnitsClient
from .ocr.client import AsyncOcrClient, OcrClient
from .overdue_reminders.client import AsyncOverdueRemindersClient, OverdueRemindersClient
from .partner_settings.client import AsyncPartnerSettingsClient, PartnerSettingsClient
from .payables.client import AsyncPayablesClient, PayablesClient
from .payment_intents.client import AsyncPaymentIntentsClient, PaymentIntentsClient
from .payment_links.client import AsyncPaymentLinksClient, PaymentLinksClient
from .payment_records.client import AsyncPaymentRecordsClient, PaymentRecordsClient
from .payment_reminders.client import AsyncPaymentRemindersClient, PaymentRemindersClient
from .payment_terms.client import AsyncPaymentTermsClient, PaymentTermsClient
from .pdf_templates.client import AsyncPdfTemplatesClient, PdfTemplatesClient
from .products.client import AsyncProductsClient, ProductsClient
from .projects.client import AsyncProjectsClient, ProjectsClient
from .purchase_orders.client import AsyncPurchaseOrdersClient, PurchaseOrdersClient
from .receivables.client import AsyncReceivablesClient, ReceivablesClient
from .recurrences.client import AsyncRecurrencesClient, RecurrencesClient
from .roles.client import AsyncRolesClient, RolesClient
from .tags.client import AsyncTagsClient, TagsClient
from .text_templates.client import AsyncTextTemplatesClient, TextTemplatesClient
from .vat_rates.client import AsyncVatRatesClient, VatRatesClient
from .webhook_deliveries.client import AsyncWebhookDeliveriesClient, WebhookDeliveriesClient
from .webhook_subscriptions.client import AsyncWebhookSubscriptionsClient, WebhookSubscriptionsClient


class Monite:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : MoniteEnvironment
        The environment to use for requests from the client. from .environment import MoniteEnvironment

        Defaults to MoniteEnvironment.SANDBOX



    monite_version : str
    monite_entity_id : typing.Optional[str]
    token : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from monite import Monite
    client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: MoniteEnvironment = MoniteEnvironment.SANDBOX,
        monite_version: str,
        monite_entity_id: typing.Optional[str] = None,
        token: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            monite_version=monite_version,
            monite_entity_id=monite_entity_id,
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.analytics = AnalyticsClient(client_wrapper=self._client_wrapper)
        self.approval_policies = ApprovalPoliciesClient(client_wrapper=self._client_wrapper)
        self.approval_requests = ApprovalRequestsClient(client_wrapper=self._client_wrapper)
        self.access_tokens = AccessTokensClient(client_wrapper=self._client_wrapper)
        self.comments = CommentsClient(client_wrapper=self._client_wrapper)
        self.counterparts = CounterpartsClient(client_wrapper=self._client_wrapper)
        self.counterpart_e_invoicing_credentials = CounterpartEInvoicingCredentialsClient(
            client_wrapper=self._client_wrapper
        )
        self.data_exports = DataExportsClient(client_wrapper=self._client_wrapper)
        self.delivery_notes = DeliveryNotesClient(client_wrapper=self._client_wrapper)
        self.pdf_templates = PdfTemplatesClient(client_wrapper=self._client_wrapper)
        self.e_invoicing_connections = EInvoicingConnectionsClient(client_wrapper=self._client_wrapper)
        self.entities = EntitiesClient(client_wrapper=self._client_wrapper)
        self.entity_users = EntityUsersClient(client_wrapper=self._client_wrapper)
        self.events = EventsClient(client_wrapper=self._client_wrapper)
        self.files = FilesClient(client_wrapper=self._client_wrapper)
        self.financing = FinancingClient(client_wrapper=self._client_wrapper)
        self.mail_templates = MailTemplatesClient(client_wrapper=self._client_wrapper)
        self.mailbox_domains = MailboxDomainsClient(client_wrapper=self._client_wrapper)
        self.mailboxes = MailboxesClient(client_wrapper=self._client_wrapper)
        self.measure_units = MeasureUnitsClient(client_wrapper=self._client_wrapper)
        self.ocr = OcrClient(client_wrapper=self._client_wrapper)
        self.overdue_reminders = OverdueRemindersClient(client_wrapper=self._client_wrapper)
        self.credit_notes = CreditNotesClient(client_wrapper=self._client_wrapper)
        self.purchase_orders = PurchaseOrdersClient(client_wrapper=self._client_wrapper)
        self.payables = PayablesClient(client_wrapper=self._client_wrapper)
        self.payment_intents = PaymentIntentsClient(client_wrapper=self._client_wrapper)
        self.payment_links = PaymentLinksClient(client_wrapper=self._client_wrapper)
        self.payment_records = PaymentRecordsClient(client_wrapper=self._client_wrapper)
        self.payment_reminders = PaymentRemindersClient(client_wrapper=self._client_wrapper)
        self.payment_terms = PaymentTermsClient(client_wrapper=self._client_wrapper)
        self.products = ProductsClient(client_wrapper=self._client_wrapper)
        self.projects = ProjectsClient(client_wrapper=self._client_wrapper)
        self.receivables = ReceivablesClient(client_wrapper=self._client_wrapper)
        self.recurrences = RecurrencesClient(client_wrapper=self._client_wrapper)
        self.roles = RolesClient(client_wrapper=self._client_wrapper)
        self.partner_settings = PartnerSettingsClient(client_wrapper=self._client_wrapper)
        self.tags = TagsClient(client_wrapper=self._client_wrapper)
        self.text_templates = TextTemplatesClient(client_wrapper=self._client_wrapper)
        self.vat_rates = VatRatesClient(client_wrapper=self._client_wrapper)
        self.webhook_deliveries = WebhookDeliveriesClient(client_wrapper=self._client_wrapper)
        self.webhook_subscriptions = WebhookSubscriptionsClient(client_wrapper=self._client_wrapper)
        self.accounting = AccountingClient(client_wrapper=self._client_wrapper)


class AsyncMonite:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : MoniteEnvironment
        The environment to use for requests from the client. from .environment import MoniteEnvironment

        Defaults to MoniteEnvironment.SANDBOX



    monite_version : str
    monite_entity_id : typing.Optional[str]
    token : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from monite import AsyncMonite
    client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: MoniteEnvironment = MoniteEnvironment.SANDBOX,
        monite_version: str,
        monite_entity_id: typing.Optional[str] = None,
        token: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            monite_version=monite_version,
            monite_entity_id=monite_entity_id,
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.analytics = AsyncAnalyticsClient(client_wrapper=self._client_wrapper)
        self.approval_policies = AsyncApprovalPoliciesClient(client_wrapper=self._client_wrapper)
        self.approval_requests = AsyncApprovalRequestsClient(client_wrapper=self._client_wrapper)
        self.access_tokens = AsyncAccessTokensClient(client_wrapper=self._client_wrapper)
        self.comments = AsyncCommentsClient(client_wrapper=self._client_wrapper)
        self.counterparts = AsyncCounterpartsClient(client_wrapper=self._client_wrapper)
        self.counterpart_e_invoicing_credentials = AsyncCounterpartEInvoicingCredentialsClient(
            client_wrapper=self._client_wrapper
        )
        self.data_exports = AsyncDataExportsClient(client_wrapper=self._client_wrapper)
        self.delivery_notes = AsyncDeliveryNotesClient(client_wrapper=self._client_wrapper)
        self.pdf_templates = AsyncPdfTemplatesClient(client_wrapper=self._client_wrapper)
        self.e_invoicing_connections = AsyncEInvoicingConnectionsClient(client_wrapper=self._client_wrapper)
        self.entities = AsyncEntitiesClient(client_wrapper=self._client_wrapper)
        self.entity_users = AsyncEntityUsersClient(client_wrapper=self._client_wrapper)
        self.events = AsyncEventsClient(client_wrapper=self._client_wrapper)
        self.files = AsyncFilesClient(client_wrapper=self._client_wrapper)
        self.financing = AsyncFinancingClient(client_wrapper=self._client_wrapper)
        self.mail_templates = AsyncMailTemplatesClient(client_wrapper=self._client_wrapper)
        self.mailbox_domains = AsyncMailboxDomainsClient(client_wrapper=self._client_wrapper)
        self.mailboxes = AsyncMailboxesClient(client_wrapper=self._client_wrapper)
        self.measure_units = AsyncMeasureUnitsClient(client_wrapper=self._client_wrapper)
        self.ocr = AsyncOcrClient(client_wrapper=self._client_wrapper)
        self.overdue_reminders = AsyncOverdueRemindersClient(client_wrapper=self._client_wrapper)
        self.credit_notes = AsyncCreditNotesClient(client_wrapper=self._client_wrapper)
        self.purchase_orders = AsyncPurchaseOrdersClient(client_wrapper=self._client_wrapper)
        self.payables = AsyncPayablesClient(client_wrapper=self._client_wrapper)
        self.payment_intents = AsyncPaymentIntentsClient(client_wrapper=self._client_wrapper)
        self.payment_links = AsyncPaymentLinksClient(client_wrapper=self._client_wrapper)
        self.payment_records = AsyncPaymentRecordsClient(client_wrapper=self._client_wrapper)
        self.payment_reminders = AsyncPaymentRemindersClient(client_wrapper=self._client_wrapper)
        self.payment_terms = AsyncPaymentTermsClient(client_wrapper=self._client_wrapper)
        self.products = AsyncProductsClient(client_wrapper=self._client_wrapper)
        self.projects = AsyncProjectsClient(client_wrapper=self._client_wrapper)
        self.receivables = AsyncReceivablesClient(client_wrapper=self._client_wrapper)
        self.recurrences = AsyncRecurrencesClient(client_wrapper=self._client_wrapper)
        self.roles = AsyncRolesClient(client_wrapper=self._client_wrapper)
        self.partner_settings = AsyncPartnerSettingsClient(client_wrapper=self._client_wrapper)
        self.tags = AsyncTagsClient(client_wrapper=self._client_wrapper)
        self.text_templates = AsyncTextTemplatesClient(client_wrapper=self._client_wrapper)
        self.vat_rates = AsyncVatRatesClient(client_wrapper=self._client_wrapper)
        self.webhook_deliveries = AsyncWebhookDeliveriesClient(client_wrapper=self._client_wrapper)
        self.webhook_subscriptions = AsyncWebhookSubscriptionsClient(client_wrapper=self._client_wrapper)
        self.accounting = AsyncAccountingClient(client_wrapper=self._client_wrapper)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: MoniteEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
