# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.comment_cursor_fields import CommentCursorFields
from ..types.comment_resource import CommentResource
from ..types.comment_resource_list import CommentResourceList
from ..types.order_enum import OrderEnum
from .raw_client import AsyncRawCommentsClient, RawCommentsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CommentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCommentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCommentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCommentsClient
        """
        return self._raw_client

    def get(
        self,
        *,
        object_id: str,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[CommentCursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CommentResourceList:
        """
        Get comments

        Parameters
        ----------
        object_id : str

        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[CommentCursorFields]
            Allowed sort fields

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CommentResourceList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.comments.get(object_id='object_id', )
        """
        _response = self._raw_client.get(
            object_id=object_id,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        object_id: str,
        object_type: str,
        text: str,
        reply_to_entity_user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CommentResource:
        """
        Create new comment

        Parameters
        ----------
        object_id : str

        object_type : str

        text : str

        reply_to_entity_user_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CommentResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.comments.create(object_id='object_id', object_type='object_type', text='text', )
        """
        _response = self._raw_client.create(
            object_id=object_id,
            object_type=object_type,
            text=text,
            reply_to_entity_user_id=reply_to_entity_user_id,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(self, comment_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> CommentResource:
        """
        Get comment

        Parameters
        ----------
        comment_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CommentResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.comments.get_by_id(comment_id='comment_id', )
        """
        _response = self._raw_client.get_by_id(comment_id, request_options=request_options)
        return _response.data

    def delete_by_id(self, comment_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete comment

        Parameters
        ----------
        comment_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.comments.delete_by_id(comment_id='comment_id', )
        """
        _response = self._raw_client.delete_by_id(comment_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        comment_id: str,
        *,
        reply_to_entity_user_id: typing.Optional[str] = OMIT,
        text: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CommentResource:
        """
        Update comment

        Parameters
        ----------
        comment_id : str

        reply_to_entity_user_id : typing.Optional[str]

        text : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CommentResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.comments.update_by_id(comment_id='comment_id', )
        """
        _response = self._raw_client.update_by_id(
            comment_id, reply_to_entity_user_id=reply_to_entity_user_id, text=text, request_options=request_options
        )
        return _response.data


class AsyncCommentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCommentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCommentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCommentsClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        object_id: str,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[CommentCursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CommentResourceList:
        """
        Get comments

        Parameters
        ----------
        object_id : str

        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[CommentCursorFields]
            Allowed sort fields

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CommentResourceList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.comments.get(object_id='object_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            object_id=object_id,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        object_id: str,
        object_type: str,
        text: str,
        reply_to_entity_user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CommentResource:
        """
        Create new comment

        Parameters
        ----------
        object_id : str

        object_type : str

        text : str

        reply_to_entity_user_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CommentResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.comments.create(object_id='object_id', object_type='object_type', text='text', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            object_id=object_id,
            object_type=object_type,
            text=text,
            reply_to_entity_user_id=reply_to_entity_user_id,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, comment_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CommentResource:
        """
        Get comment

        Parameters
        ----------
        comment_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CommentResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.comments.get_by_id(comment_id='comment_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(comment_id, request_options=request_options)
        return _response.data

    async def delete_by_id(self, comment_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete comment

        Parameters
        ----------
        comment_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.comments.delete_by_id(comment_id='comment_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(comment_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        comment_id: str,
        *,
        reply_to_entity_user_id: typing.Optional[str] = OMIT,
        text: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CommentResource:
        """
        Update comment

        Parameters
        ----------
        comment_id : str

        reply_to_entity_user_id : typing.Optional[str]

        text : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CommentResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.comments.update_by_id(comment_id='comment_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            comment_id, reply_to_entity_user_id=reply_to_entity_user_id, text=text, request_options=request_options
        )
        return _response.data
