# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.counterpart_einvoicing_credential_response import CounterpartEinvoicingCredentialResponse
from ..types.counterpart_einvoicing_credential_response_list import CounterpartEinvoicingCredentialResponseList
from ..types.create_counterpart_einvoicing_credential_payload import CreateCounterpartEinvoicingCredentialPayload
from ..types.einvoice_schema_type_enum import EinvoiceSchemaTypeEnum
from .raw_client import AsyncRawCounterpartEInvoicingCredentialsClient, RawCounterpartEInvoicingCredentialsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CounterpartEInvoicingCredentialsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCounterpartEInvoicingCredentialsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCounterpartEInvoicingCredentialsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCounterpartEInvoicingCredentialsClient
        """
        return self._raw_client

    def get_counterparts_id_einvoicing_credentials(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartEinvoicingCredentialResponseList:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartEinvoicingCredentialResponseList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterpart_e_invoicing_credentials.get_counterparts_id_einvoicing_credentials(counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.get_counterparts_id_einvoicing_credentials(
            counterpart_id, request_options=request_options
        )
        return _response.data

    def post_counterparts_id_einvoicing_credentials(
        self,
        counterpart_id: str,
        *,
        request: CreateCounterpartEinvoicingCredentialPayload,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartEinvoicingCredentialResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        request : CreateCounterpartEinvoicingCredentialPayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartEinvoicingCredentialResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import CreateCounterpartEinvoicingCredentialCounterpartVatId
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterpart_e_invoicing_credentials.post_counterparts_id_einvoicing_credentials(counterpart_id='counterpart_id', request=CreateCounterpartEinvoicingCredentialCounterpartVatId(counterpart_vat_id_id='counterpart_vat_id_id', ), )
        """
        _response = self._raw_client.post_counterparts_id_einvoicing_credentials(
            counterpart_id, request=request, request_options=request_options
        )
        return _response.data

    def get_counterparts_id_einvoicing_credentials_id(
        self, credential_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartEinvoicingCredentialResponse:
        """
        Parameters
        ----------
        credential_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartEinvoicingCredentialResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterpart_e_invoicing_credentials.get_counterparts_id_einvoicing_credentials_id(credential_id='credential_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.get_counterparts_id_einvoicing_credentials_id(
            credential_id, counterpart_id, request_options=request_options
        )
        return _response.data

    def delete_counterparts_id_einvoicing_credentials_id(
        self, credential_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        credential_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterpart_e_invoicing_credentials.delete_counterparts_id_einvoicing_credentials_id(credential_id='credential_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.delete_counterparts_id_einvoicing_credentials_id(
            credential_id, counterpart_id, request_options=request_options
        )
        return _response.data

    def patch_counterparts_id_einvoicing_credentials_id(
        self,
        credential_id: str,
        counterpart_id: str,
        *,
        network_identifier: typing.Optional[str] = OMIT,
        network_schema: typing.Optional[EinvoiceSchemaTypeEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartEinvoicingCredentialResponse:
        """
        Parameters
        ----------
        credential_id : str

        counterpart_id : str

        network_identifier : typing.Optional[str]

        network_schema : typing.Optional[EinvoiceSchemaTypeEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartEinvoicingCredentialResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterpart_e_invoicing_credentials.patch_counterparts_id_einvoicing_credentials_id(credential_id='credential_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.patch_counterparts_id_einvoicing_credentials_id(
            credential_id,
            counterpart_id,
            network_identifier=network_identifier,
            network_schema=network_schema,
            request_options=request_options,
        )
        return _response.data


class AsyncCounterpartEInvoicingCredentialsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCounterpartEInvoicingCredentialsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCounterpartEInvoicingCredentialsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCounterpartEInvoicingCredentialsClient
        """
        return self._raw_client

    async def get_counterparts_id_einvoicing_credentials(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartEinvoicingCredentialResponseList:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartEinvoicingCredentialResponseList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterpart_e_invoicing_credentials.get_counterparts_id_einvoicing_credentials(counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_counterparts_id_einvoicing_credentials(
            counterpart_id, request_options=request_options
        )
        return _response.data

    async def post_counterparts_id_einvoicing_credentials(
        self,
        counterpart_id: str,
        *,
        request: CreateCounterpartEinvoicingCredentialPayload,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartEinvoicingCredentialResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        request : CreateCounterpartEinvoicingCredentialPayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartEinvoicingCredentialResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import CreateCounterpartEinvoicingCredentialCounterpartVatId
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterpart_e_invoicing_credentials.post_counterparts_id_einvoicing_credentials(counterpart_id='counterpart_id', request=CreateCounterpartEinvoicingCredentialCounterpartVatId(counterpart_vat_id_id='counterpart_vat_id_id', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_counterparts_id_einvoicing_credentials(
            counterpart_id, request=request, request_options=request_options
        )
        return _response.data

    async def get_counterparts_id_einvoicing_credentials_id(
        self, credential_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartEinvoicingCredentialResponse:
        """
        Parameters
        ----------
        credential_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartEinvoicingCredentialResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterpart_e_invoicing_credentials.get_counterparts_id_einvoicing_credentials_id(credential_id='credential_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_counterparts_id_einvoicing_credentials_id(
            credential_id, counterpart_id, request_options=request_options
        )
        return _response.data

    async def delete_counterparts_id_einvoicing_credentials_id(
        self, credential_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        credential_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterpart_e_invoicing_credentials.delete_counterparts_id_einvoicing_credentials_id(credential_id='credential_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_counterparts_id_einvoicing_credentials_id(
            credential_id, counterpart_id, request_options=request_options
        )
        return _response.data

    async def patch_counterparts_id_einvoicing_credentials_id(
        self,
        credential_id: str,
        counterpart_id: str,
        *,
        network_identifier: typing.Optional[str] = OMIT,
        network_schema: typing.Optional[EinvoiceSchemaTypeEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartEinvoicingCredentialResponse:
        """
        Parameters
        ----------
        credential_id : str

        counterpart_id : str

        network_identifier : typing.Optional[str]

        network_schema : typing.Optional[EinvoiceSchemaTypeEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartEinvoicingCredentialResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterpart_e_invoicing_credentials.patch_counterparts_id_einvoicing_credentials_id(credential_id='credential_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.patch_counterparts_id_einvoicing_credentials_id(
            credential_id,
            counterpart_id,
            network_identifier=network_identifier,
            network_schema=network_schema,
            request_options=request_options,
        )
        return _response.data
