# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.allowed_countries import AllowedCountries
from ...types.counterpart_address_resource_list import CounterpartAddressResourceList
from ...types.counterpart_address_response_with_counterpart_id import CounterpartAddressResponseWithCounterpartId
from .raw_client import AsyncRawAddressesClient, RawAddressesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AddressesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAddressesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAddressesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAddressesClient
        """
        return self._raw_client

    def get(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartAddressResourceList:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartAddressResourceList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.addresses.get(counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.get(counterpart_id, request_options=request_options)
        return _response.data

    def create(
        self,
        counterpart_id: str,
        *,
        city: str,
        country: AllowedCountries,
        line1: str,
        postal_code: str,
        line2: typing.Optional[str] = OMIT,
        state: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartAddressResponseWithCounterpartId:
        """
        Parameters
        ----------
        counterpart_id : str

        city : str
            City name.

        country : AllowedCountries
            Two-letter ISO country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).

        line1 : str
            Street address.

        postal_code : str
            ZIP or postal code.

        line2 : typing.Optional[str]
            Additional address information (if any).

        state : typing.Optional[str]
            State, region, province, or county.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartAddressResponseWithCounterpartId
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.addresses.create(counterpart_id='counterpart_id', city='Berlin', country="AF", line1='Flughafenstrasse 52', postal_code='10115', )
        """
        _response = self._raw_client.create(
            counterpart_id,
            city=city,
            country=country,
            line1=line1,
            postal_code=postal_code,
            line2=line2,
            state=state,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(
        self, address_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartAddressResponseWithCounterpartId:
        """
        Parameters
        ----------
        address_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartAddressResponseWithCounterpartId
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.addresses.get_by_id(address_id='address_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.get_by_id(address_id, counterpart_id, request_options=request_options)
        return _response.data

    def delete_by_id(
        self, address_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        address_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.addresses.delete_by_id(address_id='address_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.delete_by_id(address_id, counterpart_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        address_id: str,
        counterpart_id: str,
        *,
        city: typing.Optional[str] = OMIT,
        country: typing.Optional[AllowedCountries] = OMIT,
        line1: typing.Optional[str] = OMIT,
        line2: typing.Optional[str] = OMIT,
        postal_code: typing.Optional[str] = OMIT,
        state: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartAddressResponseWithCounterpartId:
        """
        Parameters
        ----------
        address_id : str

        counterpart_id : str

        city : typing.Optional[str]
            City name.

        country : typing.Optional[AllowedCountries]
            Two-letter ISO country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).

        line1 : typing.Optional[str]
            Street address.

        line2 : typing.Optional[str]
            Additional address information (if any).

        postal_code : typing.Optional[str]
            ZIP or postal code.

        state : typing.Optional[str]
            State, region, province, or county.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartAddressResponseWithCounterpartId
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.addresses.update_by_id(address_id='address_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.update_by_id(
            address_id,
            counterpart_id,
            city=city,
            country=country,
            line1=line1,
            line2=line2,
            postal_code=postal_code,
            state=state,
            request_options=request_options,
        )
        return _response.data


class AsyncAddressesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAddressesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAddressesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAddressesClient
        """
        return self._raw_client

    async def get(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartAddressResourceList:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartAddressResourceList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.addresses.get(counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(counterpart_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        counterpart_id: str,
        *,
        city: str,
        country: AllowedCountries,
        line1: str,
        postal_code: str,
        line2: typing.Optional[str] = OMIT,
        state: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartAddressResponseWithCounterpartId:
        """
        Parameters
        ----------
        counterpart_id : str

        city : str
            City name.

        country : AllowedCountries
            Two-letter ISO country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).

        line1 : str
            Street address.

        postal_code : str
            ZIP or postal code.

        line2 : typing.Optional[str]
            Additional address information (if any).

        state : typing.Optional[str]
            State, region, province, or county.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartAddressResponseWithCounterpartId
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.addresses.create(counterpart_id='counterpart_id', city='Berlin', country="AF", line1='Flughafenstrasse 52', postal_code='10115', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            counterpart_id,
            city=city,
            country=country,
            line1=line1,
            postal_code=postal_code,
            line2=line2,
            state=state,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, address_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartAddressResponseWithCounterpartId:
        """
        Parameters
        ----------
        address_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartAddressResponseWithCounterpartId
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.addresses.get_by_id(address_id='address_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(address_id, counterpart_id, request_options=request_options)
        return _response.data

    async def delete_by_id(
        self, address_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        address_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.addresses.delete_by_id(address_id='address_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(address_id, counterpart_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        address_id: str,
        counterpart_id: str,
        *,
        city: typing.Optional[str] = OMIT,
        country: typing.Optional[AllowedCountries] = OMIT,
        line1: typing.Optional[str] = OMIT,
        line2: typing.Optional[str] = OMIT,
        postal_code: typing.Optional[str] = OMIT,
        state: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartAddressResponseWithCounterpartId:
        """
        Parameters
        ----------
        address_id : str

        counterpart_id : str

        city : typing.Optional[str]
            City name.

        country : typing.Optional[AllowedCountries]
            Two-letter ISO country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).

        line1 : typing.Optional[str]
            Street address.

        line2 : typing.Optional[str]
            Additional address information (if any).

        postal_code : typing.Optional[str]
            ZIP or postal code.

        state : typing.Optional[str]
            State, region, province, or county.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartAddressResponseWithCounterpartId
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.addresses.update_by_id(address_id='address_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            address_id,
            counterpart_id,
            city=city,
            country=country,
            line1=line1,
            line2=line2,
            postal_code=postal_code,
            state=state,
            request_options=request_options,
        )
        return _response.data
