# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.allowed_countries import AllowedCountries
from ...types.counterpart_bank_account_resource_list import CounterpartBankAccountResourceList
from ...types.counterpart_bank_account_response import CounterpartBankAccountResponse
from ...types.currency_enum import CurrencyEnum
from .raw_client import AsyncRawBankAccountsClient, RawBankAccountsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class BankAccountsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawBankAccountsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawBankAccountsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBankAccountsClient
        """
        return self._raw_client

    def get(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartBankAccountResourceList:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartBankAccountResourceList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.bank_accounts.get(counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.get(counterpart_id, request_options=request_options)
        return _response.data

    def create(
        self,
        counterpart_id: str,
        *,
        country: AllowedCountries,
        currency: CurrencyEnum,
        account_holder_name: typing.Optional[str] = OMIT,
        account_number: typing.Optional[str] = OMIT,
        bic: typing.Optional[str] = OMIT,
        iban: typing.Optional[str] = OMIT,
        is_default_for_currency: typing.Optional[bool] = OMIT,
        name: typing.Optional[str] = OMIT,
        partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        routing_number: typing.Optional[str] = OMIT,
        sort_code: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartBankAccountResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        country : AllowedCountries

        currency : CurrencyEnum

        account_holder_name : typing.Optional[str]
            The name of the person or business that owns this bank account. Required for US bank accounts to accept ACH payments.

        account_number : typing.Optional[str]
            The bank account number. Required for US bank accounts to accept ACH payments. US account numbers contain 9 to 12 digits. UK account numbers typically contain 8 digits.

        bic : typing.Optional[str]
            The BIC/SWIFT code of the bank.

        iban : typing.Optional[str]
            The IBAN of the bank account.

        is_default_for_currency : typing.Optional[bool]

        name : typing.Optional[str]

        partner_metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Metadata for partner needs.

        routing_number : typing.Optional[str]
            The bank's routing transit number (RTN). Required for US bank accounts to accept ACH payments. US routing numbers consist of 9 digits.

        sort_code : typing.Optional[str]
            The bank's sort code.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartBankAccountResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.bank_accounts.create(counterpart_id='counterpart_id', country="AF", currency="AED", )
        """
        _response = self._raw_client.create(
            counterpart_id,
            country=country,
            currency=currency,
            account_holder_name=account_holder_name,
            account_number=account_number,
            bic=bic,
            iban=iban,
            is_default_for_currency=is_default_for_currency,
            name=name,
            partner_metadata=partner_metadata,
            routing_number=routing_number,
            sort_code=sort_code,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(
        self, bank_account_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartBankAccountResponse:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartBankAccountResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.bank_accounts.get_by_id(bank_account_id='bank_account_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.get_by_id(bank_account_id, counterpart_id, request_options=request_options)
        return _response.data

    def delete_by_id(
        self, bank_account_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.bank_accounts.delete_by_id(bank_account_id='bank_account_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.delete_by_id(bank_account_id, counterpart_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        bank_account_id: str,
        counterpart_id: str,
        *,
        account_holder_name: typing.Optional[str] = OMIT,
        account_number: typing.Optional[str] = OMIT,
        bic: typing.Optional[str] = OMIT,
        country: typing.Optional[AllowedCountries] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        iban: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        routing_number: typing.Optional[str] = OMIT,
        sort_code: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartBankAccountResponse:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        account_holder_name : typing.Optional[str]
            The name of the person or business that owns this bank account. Required for US bank accounts to accept ACH payments.

        account_number : typing.Optional[str]
            The bank account number. Required for US bank accounts to accept ACH payments. US account numbers contain 9 to 12 digits. UK account numbers typically contain 8 digits.

        bic : typing.Optional[str]
            The BIC/SWIFT code of the bank.

        country : typing.Optional[AllowedCountries]

        currency : typing.Optional[CurrencyEnum]

        iban : typing.Optional[str]
            The IBAN of the bank account.

        name : typing.Optional[str]

        partner_metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Metadata for partner needs.

        routing_number : typing.Optional[str]
            The bank's routing transit number (RTN). Required for US bank accounts to accept ACH payments. US routing numbers consist of 9 digits.

        sort_code : typing.Optional[str]
            The bank's sort code.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartBankAccountResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.bank_accounts.update_by_id(bank_account_id='bank_account_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.update_by_id(
            bank_account_id,
            counterpart_id,
            account_holder_name=account_holder_name,
            account_number=account_number,
            bic=bic,
            country=country,
            currency=currency,
            iban=iban,
            name=name,
            partner_metadata=partner_metadata,
            routing_number=routing_number,
            sort_code=sort_code,
            request_options=request_options,
        )
        return _response.data

    def make_default_by_id(
        self, bank_account_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.bank_accounts.make_default_by_id(bank_account_id='bank_account_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.make_default_by_id(
            bank_account_id, counterpart_id, request_options=request_options
        )
        return _response.data


class AsyncBankAccountsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawBankAccountsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawBankAccountsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBankAccountsClient
        """
        return self._raw_client

    async def get(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartBankAccountResourceList:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartBankAccountResourceList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.bank_accounts.get(counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(counterpart_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        counterpart_id: str,
        *,
        country: AllowedCountries,
        currency: CurrencyEnum,
        account_holder_name: typing.Optional[str] = OMIT,
        account_number: typing.Optional[str] = OMIT,
        bic: typing.Optional[str] = OMIT,
        iban: typing.Optional[str] = OMIT,
        is_default_for_currency: typing.Optional[bool] = OMIT,
        name: typing.Optional[str] = OMIT,
        partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        routing_number: typing.Optional[str] = OMIT,
        sort_code: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartBankAccountResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        country : AllowedCountries

        currency : CurrencyEnum

        account_holder_name : typing.Optional[str]
            The name of the person or business that owns this bank account. Required for US bank accounts to accept ACH payments.

        account_number : typing.Optional[str]
            The bank account number. Required for US bank accounts to accept ACH payments. US account numbers contain 9 to 12 digits. UK account numbers typically contain 8 digits.

        bic : typing.Optional[str]
            The BIC/SWIFT code of the bank.

        iban : typing.Optional[str]
            The IBAN of the bank account.

        is_default_for_currency : typing.Optional[bool]

        name : typing.Optional[str]

        partner_metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Metadata for partner needs.

        routing_number : typing.Optional[str]
            The bank's routing transit number (RTN). Required for US bank accounts to accept ACH payments. US routing numbers consist of 9 digits.

        sort_code : typing.Optional[str]
            The bank's sort code.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartBankAccountResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.bank_accounts.create(counterpart_id='counterpart_id', country="AF", currency="AED", )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            counterpart_id,
            country=country,
            currency=currency,
            account_holder_name=account_holder_name,
            account_number=account_number,
            bic=bic,
            iban=iban,
            is_default_for_currency=is_default_for_currency,
            name=name,
            partner_metadata=partner_metadata,
            routing_number=routing_number,
            sort_code=sort_code,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, bank_account_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartBankAccountResponse:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartBankAccountResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.bank_accounts.get_by_id(bank_account_id='bank_account_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(bank_account_id, counterpart_id, request_options=request_options)
        return _response.data

    async def delete_by_id(
        self, bank_account_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.bank_accounts.delete_by_id(bank_account_id='bank_account_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(
            bank_account_id, counterpart_id, request_options=request_options
        )
        return _response.data

    async def update_by_id(
        self,
        bank_account_id: str,
        counterpart_id: str,
        *,
        account_holder_name: typing.Optional[str] = OMIT,
        account_number: typing.Optional[str] = OMIT,
        bic: typing.Optional[str] = OMIT,
        country: typing.Optional[AllowedCountries] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        iban: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        routing_number: typing.Optional[str] = OMIT,
        sort_code: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartBankAccountResponse:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        account_holder_name : typing.Optional[str]
            The name of the person or business that owns this bank account. Required for US bank accounts to accept ACH payments.

        account_number : typing.Optional[str]
            The bank account number. Required for US bank accounts to accept ACH payments. US account numbers contain 9 to 12 digits. UK account numbers typically contain 8 digits.

        bic : typing.Optional[str]
            The BIC/SWIFT code of the bank.

        country : typing.Optional[AllowedCountries]

        currency : typing.Optional[CurrencyEnum]

        iban : typing.Optional[str]
            The IBAN of the bank account.

        name : typing.Optional[str]

        partner_metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Metadata for partner needs.

        routing_number : typing.Optional[str]
            The bank's routing transit number (RTN). Required for US bank accounts to accept ACH payments. US routing numbers consist of 9 digits.

        sort_code : typing.Optional[str]
            The bank's sort code.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartBankAccountResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.bank_accounts.update_by_id(bank_account_id='bank_account_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            bank_account_id,
            counterpart_id,
            account_holder_name=account_holder_name,
            account_number=account_number,
            bic=bic,
            country=country,
            currency=currency,
            iban=iban,
            name=name,
            partner_metadata=partner_metadata,
            routing_number=routing_number,
            sort_code=sort_code,
            request_options=request_options,
        )
        return _response.data

    async def make_default_by_id(
        self, bank_account_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.bank_accounts.make_default_by_id(bank_account_id='bank_account_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.make_default_by_id(
            bank_account_id, counterpart_id, request_options=request_options
        )
        return _response.data
