# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.internal_server_error import InternalServerError
from ...errors.not_found_error import NotFoundError
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.allowed_countries import AllowedCountries
from ...types.counterpart_bank_account_resource_list import CounterpartBankAccountResourceList
from ...types.counterpart_bank_account_response import CounterpartBankAccountResponse
from ...types.currency_enum import CurrencyEnum

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawBankAccountsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CounterpartBankAccountResourceList]:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CounterpartBankAccountResourceList]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/bank_accounts",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartBankAccountResourceList,
                    parse_obj_as(
                        type_=CounterpartBankAccountResourceList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        counterpart_id: str,
        *,
        country: AllowedCountries,
        currency: CurrencyEnum,
        account_holder_name: typing.Optional[str] = OMIT,
        account_number: typing.Optional[str] = OMIT,
        bic: typing.Optional[str] = OMIT,
        iban: typing.Optional[str] = OMIT,
        is_default_for_currency: typing.Optional[bool] = OMIT,
        name: typing.Optional[str] = OMIT,
        partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        routing_number: typing.Optional[str] = OMIT,
        sort_code: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CounterpartBankAccountResponse]:
        """
        Parameters
        ----------
        counterpart_id : str

        country : AllowedCountries

        currency : CurrencyEnum

        account_holder_name : typing.Optional[str]
            The name of the person or business that owns this bank account. Required for US bank accounts to accept ACH payments.

        account_number : typing.Optional[str]
            The bank account number. Required for US bank accounts to accept ACH payments. US account numbers contain 9 to 12 digits. UK account numbers typically contain 8 digits.

        bic : typing.Optional[str]
            The BIC/SWIFT code of the bank.

        iban : typing.Optional[str]
            The IBAN of the bank account.

        is_default_for_currency : typing.Optional[bool]

        name : typing.Optional[str]

        partner_metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Metadata for partner needs.

        routing_number : typing.Optional[str]
            The bank's routing transit number (RTN). Required for US bank accounts to accept ACH payments. US routing numbers consist of 9 digits.

        sort_code : typing.Optional[str]
            The bank's sort code.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CounterpartBankAccountResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/bank_accounts",
            method="POST",
            json={
                "account_holder_name": account_holder_name,
                "account_number": account_number,
                "bic": bic,
                "country": country,
                "currency": currency,
                "iban": iban,
                "is_default_for_currency": is_default_for_currency,
                "name": name,
                "partner_metadata": partner_metadata,
                "routing_number": routing_number,
                "sort_code": sort_code,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartBankAccountResponse,
                    parse_obj_as(
                        type_=CounterpartBankAccountResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_by_id(
        self, bank_account_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CounterpartBankAccountResponse]:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CounterpartBankAccountResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/bank_accounts/{jsonable_encoder(bank_account_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartBankAccountResponse,
                    parse_obj_as(
                        type_=CounterpartBankAccountResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_by_id(
        self, bank_account_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/bank_accounts/{jsonable_encoder(bank_account_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_by_id(
        self,
        bank_account_id: str,
        counterpart_id: str,
        *,
        account_holder_name: typing.Optional[str] = OMIT,
        account_number: typing.Optional[str] = OMIT,
        bic: typing.Optional[str] = OMIT,
        country: typing.Optional[AllowedCountries] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        iban: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        routing_number: typing.Optional[str] = OMIT,
        sort_code: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CounterpartBankAccountResponse]:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        account_holder_name : typing.Optional[str]
            The name of the person or business that owns this bank account. Required for US bank accounts to accept ACH payments.

        account_number : typing.Optional[str]
            The bank account number. Required for US bank accounts to accept ACH payments. US account numbers contain 9 to 12 digits. UK account numbers typically contain 8 digits.

        bic : typing.Optional[str]
            The BIC/SWIFT code of the bank.

        country : typing.Optional[AllowedCountries]

        currency : typing.Optional[CurrencyEnum]

        iban : typing.Optional[str]
            The IBAN of the bank account.

        name : typing.Optional[str]

        partner_metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Metadata for partner needs.

        routing_number : typing.Optional[str]
            The bank's routing transit number (RTN). Required for US bank accounts to accept ACH payments. US routing numbers consist of 9 digits.

        sort_code : typing.Optional[str]
            The bank's sort code.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CounterpartBankAccountResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/bank_accounts/{jsonable_encoder(bank_account_id)}",
            method="PATCH",
            json={
                "account_holder_name": account_holder_name,
                "account_number": account_number,
                "bic": bic,
                "country": country,
                "currency": currency,
                "iban": iban,
                "name": name,
                "partner_metadata": partner_metadata,
                "routing_number": routing_number,
                "sort_code": sort_code,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartBankAccountResponse,
                    parse_obj_as(
                        type_=CounterpartBankAccountResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def make_default_by_id(
        self, bank_account_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/bank_accounts/{jsonable_encoder(bank_account_id)}/make_default",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawBankAccountsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CounterpartBankAccountResourceList]:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CounterpartBankAccountResourceList]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/bank_accounts",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartBankAccountResourceList,
                    parse_obj_as(
                        type_=CounterpartBankAccountResourceList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        counterpart_id: str,
        *,
        country: AllowedCountries,
        currency: CurrencyEnum,
        account_holder_name: typing.Optional[str] = OMIT,
        account_number: typing.Optional[str] = OMIT,
        bic: typing.Optional[str] = OMIT,
        iban: typing.Optional[str] = OMIT,
        is_default_for_currency: typing.Optional[bool] = OMIT,
        name: typing.Optional[str] = OMIT,
        partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        routing_number: typing.Optional[str] = OMIT,
        sort_code: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CounterpartBankAccountResponse]:
        """
        Parameters
        ----------
        counterpart_id : str

        country : AllowedCountries

        currency : CurrencyEnum

        account_holder_name : typing.Optional[str]
            The name of the person or business that owns this bank account. Required for US bank accounts to accept ACH payments.

        account_number : typing.Optional[str]
            The bank account number. Required for US bank accounts to accept ACH payments. US account numbers contain 9 to 12 digits. UK account numbers typically contain 8 digits.

        bic : typing.Optional[str]
            The BIC/SWIFT code of the bank.

        iban : typing.Optional[str]
            The IBAN of the bank account.

        is_default_for_currency : typing.Optional[bool]

        name : typing.Optional[str]

        partner_metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Metadata for partner needs.

        routing_number : typing.Optional[str]
            The bank's routing transit number (RTN). Required for US bank accounts to accept ACH payments. US routing numbers consist of 9 digits.

        sort_code : typing.Optional[str]
            The bank's sort code.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CounterpartBankAccountResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/bank_accounts",
            method="POST",
            json={
                "account_holder_name": account_holder_name,
                "account_number": account_number,
                "bic": bic,
                "country": country,
                "currency": currency,
                "iban": iban,
                "is_default_for_currency": is_default_for_currency,
                "name": name,
                "partner_metadata": partner_metadata,
                "routing_number": routing_number,
                "sort_code": sort_code,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartBankAccountResponse,
                    parse_obj_as(
                        type_=CounterpartBankAccountResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_by_id(
        self, bank_account_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CounterpartBankAccountResponse]:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CounterpartBankAccountResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/bank_accounts/{jsonable_encoder(bank_account_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartBankAccountResponse,
                    parse_obj_as(
                        type_=CounterpartBankAccountResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_by_id(
        self, bank_account_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/bank_accounts/{jsonable_encoder(bank_account_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_by_id(
        self,
        bank_account_id: str,
        counterpart_id: str,
        *,
        account_holder_name: typing.Optional[str] = OMIT,
        account_number: typing.Optional[str] = OMIT,
        bic: typing.Optional[str] = OMIT,
        country: typing.Optional[AllowedCountries] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        iban: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        routing_number: typing.Optional[str] = OMIT,
        sort_code: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CounterpartBankAccountResponse]:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        account_holder_name : typing.Optional[str]
            The name of the person or business that owns this bank account. Required for US bank accounts to accept ACH payments.

        account_number : typing.Optional[str]
            The bank account number. Required for US bank accounts to accept ACH payments. US account numbers contain 9 to 12 digits. UK account numbers typically contain 8 digits.

        bic : typing.Optional[str]
            The BIC/SWIFT code of the bank.

        country : typing.Optional[AllowedCountries]

        currency : typing.Optional[CurrencyEnum]

        iban : typing.Optional[str]
            The IBAN of the bank account.

        name : typing.Optional[str]

        partner_metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Metadata for partner needs.

        routing_number : typing.Optional[str]
            The bank's routing transit number (RTN). Required for US bank accounts to accept ACH payments. US routing numbers consist of 9 digits.

        sort_code : typing.Optional[str]
            The bank's sort code.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CounterpartBankAccountResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/bank_accounts/{jsonable_encoder(bank_account_id)}",
            method="PATCH",
            json={
                "account_holder_name": account_holder_name,
                "account_number": account_number,
                "bic": bic,
                "country": country,
                "currency": currency,
                "iban": iban,
                "name": name,
                "partner_metadata": partner_metadata,
                "routing_number": routing_number,
                "sort_code": sort_code,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartBankAccountResponse,
                    parse_obj_as(
                        type_=CounterpartBankAccountResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def make_default_by_id(
        self, bank_account_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        bank_account_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/bank_accounts/{jsonable_encoder(bank_account_id)}/make_default",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
