# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.counterpart_create_payload import CounterpartCreatePayload
from ..types.counterpart_cursor_fields import CounterpartCursorFields
from ..types.counterpart_pagination_response import CounterpartPaginationResponse
from ..types.counterpart_response import CounterpartResponse
from ..types.counterpart_type import CounterpartType
from ..types.counterpart_update_payload import CounterpartUpdatePayload
from ..types.order_enum import OrderEnum
from ..types.partner_metadata_response import PartnerMetadataResponse
from .addresses.client import AddressesClient, AsyncAddressesClient
from .bank_accounts.client import AsyncBankAccountsClient, BankAccountsClient
from .contacts.client import AsyncContactsClient, ContactsClient
from .raw_client import AsyncRawCounterpartsClient, RawCounterpartsClient
from .vat_ids.client import AsyncVatIdsClient, VatIdsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CounterpartsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCounterpartsClient(client_wrapper=client_wrapper)
        self.addresses = AddressesClient(client_wrapper=client_wrapper)

        self.bank_accounts = BankAccountsClient(client_wrapper=client_wrapper)

        self.contacts = ContactsClient(client_wrapper=client_wrapper)

        self.vat_ids = VatIdsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCounterpartsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCounterpartsClient
        """
        return self._raw_client

    def get(
        self,
        *,
        iban: typing.Optional[str] = None,
        sort_code: typing.Optional[str] = None,
        account_number: typing.Optional[str] = None,
        tax_id: typing.Optional[str] = None,
        vat_id: typing.Optional[str] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[CounterpartCursorFields] = None,
        type: typing.Optional[CounterpartType] = None,
        counterpart_name: typing.Optional[str] = None,
        counterpart_name_iexact: typing.Optional[str] = None,
        counterpart_name_contains: typing.Optional[str] = None,
        counterpart_name_icontains: typing.Optional[str] = None,
        is_vendor: typing.Optional[bool] = None,
        is_customer: typing.Optional[bool] = None,
        email: typing.Optional[str] = None,
        email_contains: typing.Optional[str] = None,
        email_icontains: typing.Optional[str] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        address_country: typing.Optional[str] = None,
        address_city: typing.Optional[str] = None,
        address_postal_code: typing.Optional[str] = None,
        address_state: typing.Optional[str] = None,
        address_line1: typing.Optional[str] = None,
        address_line2: typing.Optional[str] = None,
        tag_ids_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartPaginationResponse:
        """
        Parameters
        ----------
        iban : typing.Optional[str]
            The IBAN of the counterpart's bank account.

        sort_code : typing.Optional[str]
            The bank's sort code.

        account_number : typing.Optional[str]
            The bank account number. Required for US bank accounts to accept ACH payments. US account numbers contain 9 to 12 digits. UK account numbers typically contain 8 digits.

        tax_id : typing.Optional[str]
            The tax ID of the counterpart.

        vat_id : typing.Optional[str]
            The VAT ID of the counterpart.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of counterpart IDs to search through.

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[CounterpartCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        type : typing.Optional[CounterpartType]

        counterpart_name : typing.Optional[str]

        counterpart_name_iexact : typing.Optional[str]

        counterpart_name_contains : typing.Optional[str]

        counterpart_name_icontains : typing.Optional[str]

        is_vendor : typing.Optional[bool]

        is_customer : typing.Optional[bool]

        email : typing.Optional[str]

        email_contains : typing.Optional[str]

        email_icontains : typing.Optional[str]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        address_country : typing.Optional[str]

        address_city : typing.Optional[str]

        address_postal_code : typing.Optional[str]

        address_state : typing.Optional[str]

        address_line1 : typing.Optional[str]

        address_line2 : typing.Optional[str]

        tag_ids_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartPaginationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.get(sort_code='123456', )
        """
        _response = self._raw_client.get(
            iban=iban,
            sort_code=sort_code,
            account_number=account_number,
            tax_id=tax_id,
            vat_id=vat_id,
            id_in=id_in,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            type=type,
            counterpart_name=counterpart_name,
            counterpart_name_iexact=counterpart_name_iexact,
            counterpart_name_contains=counterpart_name_contains,
            counterpart_name_icontains=counterpart_name_icontains,
            is_vendor=is_vendor,
            is_customer=is_customer,
            email=email,
            email_contains=email_contains,
            email_icontains=email_icontains,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            address_country=address_country,
            address_city=address_city,
            address_postal_code=address_postal_code,
            address_state=address_state,
            address_line1=address_line1,
            address_line2=address_line2,
            tag_ids_in=tag_ids_in,
            request_options=request_options,
        )
        return _response.data

    def create(
        self, *, request: CounterpartCreatePayload, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartResponse:
        """
        Parameters
        ----------
        request : CounterpartCreatePayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import CounterpartCreatePayload_Organization
        from monite import CounterpartOrganizationCreatePayload
        from monite import CounterpartAddress
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.create(request=CounterpartCreatePayload_Organization(organization=CounterpartOrganizationCreatePayload(address=CounterpartAddress(city='Berlin', country="AF", line1='Flughafenstrasse 52', postal_code='10115', ), is_customer=True, is_vendor=True, legal_name='Acme Inc.', ), ), )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def get_by_id(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.get_by_id(counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.get_by_id(counterpart_id, request_options=request_options)
        return _response.data

    def delete_by_id(self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.delete_by_id(counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.delete_by_id(counterpart_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        counterpart_id: str,
        *,
        request: CounterpartUpdatePayload,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        request : CounterpartUpdatePayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import CounterpartIndividualRootUpdatePayload
        from monite import CounterpartIndividualUpdatePayload
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.update_by_id(counterpart_id='counterpart_id', request=CounterpartIndividualRootUpdatePayload(individual=CounterpartIndividualUpdatePayload(), ), )
        """
        _response = self._raw_client.update_by_id(counterpart_id, request=request, request_options=request_options)
        return _response.data

    def get_partner_metadata_by_id(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PartnerMetadataResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PartnerMetadataResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.get_partner_metadata_by_id(counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.get_partner_metadata_by_id(counterpart_id, request_options=request_options)
        return _response.data

    def update_partner_metadata_by_id(
        self,
        counterpart_id: str,
        *,
        metadata: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PartnerMetadataResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        metadata : typing.Dict[str, typing.Optional[typing.Any]]
            Metadata for partner needs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PartnerMetadataResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.update_partner_metadata_by_id(counterpart_id='counterpart_id', metadata={'key': 'value'
        }, )
        """
        _response = self._raw_client.update_partner_metadata_by_id(
            counterpart_id, metadata=metadata, request_options=request_options
        )
        return _response.data


class AsyncCounterpartsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCounterpartsClient(client_wrapper=client_wrapper)
        self.addresses = AsyncAddressesClient(client_wrapper=client_wrapper)

        self.bank_accounts = AsyncBankAccountsClient(client_wrapper=client_wrapper)

        self.contacts = AsyncContactsClient(client_wrapper=client_wrapper)

        self.vat_ids = AsyncVatIdsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCounterpartsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCounterpartsClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        iban: typing.Optional[str] = None,
        sort_code: typing.Optional[str] = None,
        account_number: typing.Optional[str] = None,
        tax_id: typing.Optional[str] = None,
        vat_id: typing.Optional[str] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[CounterpartCursorFields] = None,
        type: typing.Optional[CounterpartType] = None,
        counterpart_name: typing.Optional[str] = None,
        counterpart_name_iexact: typing.Optional[str] = None,
        counterpart_name_contains: typing.Optional[str] = None,
        counterpart_name_icontains: typing.Optional[str] = None,
        is_vendor: typing.Optional[bool] = None,
        is_customer: typing.Optional[bool] = None,
        email: typing.Optional[str] = None,
        email_contains: typing.Optional[str] = None,
        email_icontains: typing.Optional[str] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        address_country: typing.Optional[str] = None,
        address_city: typing.Optional[str] = None,
        address_postal_code: typing.Optional[str] = None,
        address_state: typing.Optional[str] = None,
        address_line1: typing.Optional[str] = None,
        address_line2: typing.Optional[str] = None,
        tag_ids_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartPaginationResponse:
        """
        Parameters
        ----------
        iban : typing.Optional[str]
            The IBAN of the counterpart's bank account.

        sort_code : typing.Optional[str]
            The bank's sort code.

        account_number : typing.Optional[str]
            The bank account number. Required for US bank accounts to accept ACH payments. US account numbers contain 9 to 12 digits. UK account numbers typically contain 8 digits.

        tax_id : typing.Optional[str]
            The tax ID of the counterpart.

        vat_id : typing.Optional[str]
            The VAT ID of the counterpart.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of counterpart IDs to search through.

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[CounterpartCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        type : typing.Optional[CounterpartType]

        counterpart_name : typing.Optional[str]

        counterpart_name_iexact : typing.Optional[str]

        counterpart_name_contains : typing.Optional[str]

        counterpart_name_icontains : typing.Optional[str]

        is_vendor : typing.Optional[bool]

        is_customer : typing.Optional[bool]

        email : typing.Optional[str]

        email_contains : typing.Optional[str]

        email_icontains : typing.Optional[str]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        address_country : typing.Optional[str]

        address_city : typing.Optional[str]

        address_postal_code : typing.Optional[str]

        address_state : typing.Optional[str]

        address_line1 : typing.Optional[str]

        address_line2 : typing.Optional[str]

        tag_ids_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartPaginationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.get(sort_code='123456', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            iban=iban,
            sort_code=sort_code,
            account_number=account_number,
            tax_id=tax_id,
            vat_id=vat_id,
            id_in=id_in,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            type=type,
            counterpart_name=counterpart_name,
            counterpart_name_iexact=counterpart_name_iexact,
            counterpart_name_contains=counterpart_name_contains,
            counterpart_name_icontains=counterpart_name_icontains,
            is_vendor=is_vendor,
            is_customer=is_customer,
            email=email,
            email_contains=email_contains,
            email_icontains=email_icontains,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            address_country=address_country,
            address_city=address_city,
            address_postal_code=address_postal_code,
            address_state=address_state,
            address_line1=address_line1,
            address_line2=address_line2,
            tag_ids_in=tag_ids_in,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self, *, request: CounterpartCreatePayload, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartResponse:
        """
        Parameters
        ----------
        request : CounterpartCreatePayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import CounterpartCreatePayload_Organization
        from monite import CounterpartOrganizationCreatePayload
        from monite import CounterpartAddress
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.create(request=CounterpartCreatePayload_Organization(organization=CounterpartOrganizationCreatePayload(address=CounterpartAddress(city='Berlin', country="AF", line1='Flughafenstrasse 52', postal_code='10115', ), is_customer=True, is_vendor=True, legal_name='Acme Inc.', ), ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def get_by_id(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.get_by_id(counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(counterpart_id, request_options=request_options)
        return _response.data

    async def delete_by_id(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.delete_by_id(counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(counterpart_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        counterpart_id: str,
        *,
        request: CounterpartUpdatePayload,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        request : CounterpartUpdatePayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import CounterpartIndividualRootUpdatePayload
        from monite import CounterpartIndividualUpdatePayload
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.update_by_id(counterpart_id='counterpart_id', request=CounterpartIndividualRootUpdatePayload(individual=CounterpartIndividualUpdatePayload(), ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            counterpart_id, request=request, request_options=request_options
        )
        return _response.data

    async def get_partner_metadata_by_id(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PartnerMetadataResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PartnerMetadataResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.get_partner_metadata_by_id(counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_partner_metadata_by_id(counterpart_id, request_options=request_options)
        return _response.data

    async def update_partner_metadata_by_id(
        self,
        counterpart_id: str,
        *,
        metadata: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PartnerMetadataResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        metadata : typing.Dict[str, typing.Optional[typing.Any]]
            Metadata for partner needs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PartnerMetadataResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.update_partner_metadata_by_id(counterpart_id='counterpart_id', metadata={'key': 'value'
            }, )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_partner_metadata_by_id(
            counterpart_id, metadata=metadata, request_options=request_options
        )
        return _response.data
