# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.counterpart_address import CounterpartAddress
from ...types.counterpart_contact_response import CounterpartContactResponse
from ...types.counterpart_contacts_resource_list import CounterpartContactsResourceList
from .raw_client import AsyncRawContactsClient, RawContactsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ContactsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawContactsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawContactsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawContactsClient
        """
        return self._raw_client

    def get(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartContactsResourceList:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartContactsResourceList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.contacts.get(counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.get(counterpart_id, request_options=request_options)
        return _response.data

    def create(
        self,
        counterpart_id: str,
        *,
        address: CounterpartAddress,
        first_name: str,
        last_name: str,
        email: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        title: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartContactResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        address : CounterpartAddress
            The address of a contact person.

        first_name : str
            The first name of a contact person.

        last_name : str
            The last name of a contact person.

        email : typing.Optional[str]
            The email address of a contact person.

        phone : typing.Optional[str]
            The phone number of a contact person

        title : typing.Optional[str]
            The title or honorific of a contact person. Examples: Mr., Ms., Dr., Prof.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartContactResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import CounterpartAddress
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.contacts.create(counterpart_id='counterpart_id', address=CounterpartAddress(city='Berlin', country="AF", line1='Flughafenstrasse 52', postal_code='10115', ), first_name='Mary', last_name="O'Brien", )
        """
        _response = self._raw_client.create(
            counterpart_id,
            address=address,
            first_name=first_name,
            last_name=last_name,
            email=email,
            phone=phone,
            title=title,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(
        self, contact_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartContactResponse:
        """
        Parameters
        ----------
        contact_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartContactResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.contacts.get_by_id(contact_id='contact_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.get_by_id(contact_id, counterpart_id, request_options=request_options)
        return _response.data

    def delete_by_id(
        self, contact_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        contact_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.contacts.delete_by_id(contact_id='contact_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.delete_by_id(contact_id, counterpart_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        contact_id: str,
        counterpart_id: str,
        *,
        address: typing.Optional[CounterpartAddress] = OMIT,
        email: typing.Optional[str] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        title: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartContactResponse:
        """
        Parameters
        ----------
        contact_id : str

        counterpart_id : str

        address : typing.Optional[CounterpartAddress]
            The address of a contact person.

        email : typing.Optional[str]
            The email address of a contact person.

        first_name : typing.Optional[str]
            The first name of a contact person.

        last_name : typing.Optional[str]
            The last name of a contact person.

        phone : typing.Optional[str]
            The phone number of a contact person

        title : typing.Optional[str]
            The title or honorific of a contact person. Examples: Mr., Ms., Dr., Prof.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartContactResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.contacts.update_by_id(contact_id='contact_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.update_by_id(
            contact_id,
            counterpart_id,
            address=address,
            email=email,
            first_name=first_name,
            last_name=last_name,
            phone=phone,
            title=title,
            request_options=request_options,
        )
        return _response.data

    def make_default_by_id(
        self, contact_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartContactResponse:
        """
        Parameters
        ----------
        contact_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartContactResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.contacts.make_default_by_id(contact_id='contact_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.make_default_by_id(contact_id, counterpart_id, request_options=request_options)
        return _response.data


class AsyncContactsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawContactsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawContactsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawContactsClient
        """
        return self._raw_client

    async def get(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartContactsResourceList:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartContactsResourceList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.contacts.get(counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(counterpart_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        counterpart_id: str,
        *,
        address: CounterpartAddress,
        first_name: str,
        last_name: str,
        email: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        title: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartContactResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        address : CounterpartAddress
            The address of a contact person.

        first_name : str
            The first name of a contact person.

        last_name : str
            The last name of a contact person.

        email : typing.Optional[str]
            The email address of a contact person.

        phone : typing.Optional[str]
            The phone number of a contact person

        title : typing.Optional[str]
            The title or honorific of a contact person. Examples: Mr., Ms., Dr., Prof.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartContactResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import CounterpartAddress
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.contacts.create(counterpart_id='counterpart_id', address=CounterpartAddress(city='Berlin', country="AF", line1='Flughafenstrasse 52', postal_code='10115', ), first_name='Mary', last_name="O'Brien", )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            counterpart_id,
            address=address,
            first_name=first_name,
            last_name=last_name,
            email=email,
            phone=phone,
            title=title,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, contact_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartContactResponse:
        """
        Parameters
        ----------
        contact_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartContactResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.contacts.get_by_id(contact_id='contact_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(contact_id, counterpart_id, request_options=request_options)
        return _response.data

    async def delete_by_id(
        self, contact_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        contact_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.contacts.delete_by_id(contact_id='contact_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(contact_id, counterpart_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        contact_id: str,
        counterpart_id: str,
        *,
        address: typing.Optional[CounterpartAddress] = OMIT,
        email: typing.Optional[str] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        title: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartContactResponse:
        """
        Parameters
        ----------
        contact_id : str

        counterpart_id : str

        address : typing.Optional[CounterpartAddress]
            The address of a contact person.

        email : typing.Optional[str]
            The email address of a contact person.

        first_name : typing.Optional[str]
            The first name of a contact person.

        last_name : typing.Optional[str]
            The last name of a contact person.

        phone : typing.Optional[str]
            The phone number of a contact person

        title : typing.Optional[str]
            The title or honorific of a contact person. Examples: Mr., Ms., Dr., Prof.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartContactResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.contacts.update_by_id(contact_id='contact_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            contact_id,
            counterpart_id,
            address=address,
            email=email,
            first_name=first_name,
            last_name=last_name,
            phone=phone,
            title=title,
            request_options=request_options,
        )
        return _response.data

    async def make_default_by_id(
        self, contact_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartContactResponse:
        """
        Parameters
        ----------
        contact_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartContactResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.contacts.make_default_by_id(contact_id='contact_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.make_default_by_id(
            contact_id, counterpart_id, request_options=request_options
        )
        return _response.data
