# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.datetime_utils import serialize_datetime
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.internal_server_error import InternalServerError
from ..errors.not_found_error import NotFoundError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.counterpart_create_payload import CounterpartCreatePayload
from ..types.counterpart_cursor_fields import CounterpartCursorFields
from ..types.counterpart_pagination_response import CounterpartPaginationResponse
from ..types.counterpart_response import CounterpartResponse
from ..types.counterpart_type import CounterpartType
from ..types.counterpart_update_payload import CounterpartUpdatePayload
from ..types.order_enum import OrderEnum
from ..types.partner_metadata_response import PartnerMetadataResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawCounterpartsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        *,
        iban: typing.Optional[str] = None,
        sort_code: typing.Optional[str] = None,
        account_number: typing.Optional[str] = None,
        tax_id: typing.Optional[str] = None,
        vat_id: typing.Optional[str] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[CounterpartCursorFields] = None,
        type: typing.Optional[CounterpartType] = None,
        counterpart_name: typing.Optional[str] = None,
        counterpart_name_iexact: typing.Optional[str] = None,
        counterpart_name_contains: typing.Optional[str] = None,
        counterpart_name_icontains: typing.Optional[str] = None,
        is_vendor: typing.Optional[bool] = None,
        is_customer: typing.Optional[bool] = None,
        email: typing.Optional[str] = None,
        email_contains: typing.Optional[str] = None,
        email_icontains: typing.Optional[str] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        address_country: typing.Optional[str] = None,
        address_city: typing.Optional[str] = None,
        address_postal_code: typing.Optional[str] = None,
        address_state: typing.Optional[str] = None,
        address_line1: typing.Optional[str] = None,
        address_line2: typing.Optional[str] = None,
        tag_ids_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CounterpartPaginationResponse]:
        """
        Parameters
        ----------
        iban : typing.Optional[str]
            The IBAN of the counterpart's bank account.

        sort_code : typing.Optional[str]
            The bank's sort code.

        account_number : typing.Optional[str]
            The bank account number. Required for US bank accounts to accept ACH payments. US account numbers contain 9 to 12 digits. UK account numbers typically contain 8 digits.

        tax_id : typing.Optional[str]
            The tax ID of the counterpart.

        vat_id : typing.Optional[str]
            The VAT ID of the counterpart.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of counterpart IDs to search through.

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[CounterpartCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        type : typing.Optional[CounterpartType]

        counterpart_name : typing.Optional[str]

        counterpart_name_iexact : typing.Optional[str]

        counterpart_name_contains : typing.Optional[str]

        counterpart_name_icontains : typing.Optional[str]

        is_vendor : typing.Optional[bool]

        is_customer : typing.Optional[bool]

        email : typing.Optional[str]

        email_contains : typing.Optional[str]

        email_icontains : typing.Optional[str]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        address_country : typing.Optional[str]

        address_city : typing.Optional[str]

        address_postal_code : typing.Optional[str]

        address_state : typing.Optional[str]

        address_line1 : typing.Optional[str]

        address_line2 : typing.Optional[str]

        tag_ids_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CounterpartPaginationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "counterparts",
            method="GET",
            params={
                "iban": iban,
                "sort_code": sort_code,
                "account_number": account_number,
                "tax_id": tax_id,
                "vat_id": vat_id,
                "id__in": id_in,
                "order": order,
                "limit": limit,
                "pagination_token": pagination_token,
                "sort": sort,
                "type": type,
                "counterpart_name": counterpart_name,
                "counterpart_name__iexact": counterpart_name_iexact,
                "counterpart_name__contains": counterpart_name_contains,
                "counterpart_name__icontains": counterpart_name_icontains,
                "is_vendor": is_vendor,
                "is_customer": is_customer,
                "email": email,
                "email__contains": email_contains,
                "email__icontains": email_icontains,
                "created_at__gt": serialize_datetime(created_at_gt) if created_at_gt is not None else None,
                "created_at__lt": serialize_datetime(created_at_lt) if created_at_lt is not None else None,
                "created_at__gte": serialize_datetime(created_at_gte) if created_at_gte is not None else None,
                "created_at__lte": serialize_datetime(created_at_lte) if created_at_lte is not None else None,
                "address.country": address_country,
                "address.city": address_city,
                "address.postal_code": address_postal_code,
                "address.state": address_state,
                "address.line1": address_line1,
                "address.line2": address_line2,
                "tag_ids__in": tag_ids_in,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartPaginationResponse,
                    parse_obj_as(
                        type_=CounterpartPaginationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self, *, request: CounterpartCreatePayload, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CounterpartResponse]:
        """
        Parameters
        ----------
        request : CounterpartCreatePayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CounterpartResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "counterparts",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=CounterpartCreatePayload, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartResponse,
                    parse_obj_as(
                        type_=CounterpartResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_by_id(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CounterpartResponse]:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CounterpartResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartResponse,
                    parse_obj_as(
                        type_=CounterpartResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_by_id(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_by_id(
        self,
        counterpart_id: str,
        *,
        request: CounterpartUpdatePayload,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CounterpartResponse]:
        """
        Parameters
        ----------
        counterpart_id : str

        request : CounterpartUpdatePayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CounterpartResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}",
            method="PATCH",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=CounterpartUpdatePayload, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartResponse,
                    parse_obj_as(
                        type_=CounterpartResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_partner_metadata_by_id(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PartnerMetadataResponse]:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PartnerMetadataResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/partner_metadata",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PartnerMetadataResponse,
                    parse_obj_as(
                        type_=PartnerMetadataResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_partner_metadata_by_id(
        self,
        counterpart_id: str,
        *,
        metadata: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PartnerMetadataResponse]:
        """
        Parameters
        ----------
        counterpart_id : str

        metadata : typing.Dict[str, typing.Optional[typing.Any]]
            Metadata for partner needs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PartnerMetadataResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/partner_metadata",
            method="PUT",
            json={
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PartnerMetadataResponse,
                    parse_obj_as(
                        type_=PartnerMetadataResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawCounterpartsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        *,
        iban: typing.Optional[str] = None,
        sort_code: typing.Optional[str] = None,
        account_number: typing.Optional[str] = None,
        tax_id: typing.Optional[str] = None,
        vat_id: typing.Optional[str] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[CounterpartCursorFields] = None,
        type: typing.Optional[CounterpartType] = None,
        counterpart_name: typing.Optional[str] = None,
        counterpart_name_iexact: typing.Optional[str] = None,
        counterpart_name_contains: typing.Optional[str] = None,
        counterpart_name_icontains: typing.Optional[str] = None,
        is_vendor: typing.Optional[bool] = None,
        is_customer: typing.Optional[bool] = None,
        email: typing.Optional[str] = None,
        email_contains: typing.Optional[str] = None,
        email_icontains: typing.Optional[str] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        address_country: typing.Optional[str] = None,
        address_city: typing.Optional[str] = None,
        address_postal_code: typing.Optional[str] = None,
        address_state: typing.Optional[str] = None,
        address_line1: typing.Optional[str] = None,
        address_line2: typing.Optional[str] = None,
        tag_ids_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CounterpartPaginationResponse]:
        """
        Parameters
        ----------
        iban : typing.Optional[str]
            The IBAN of the counterpart's bank account.

        sort_code : typing.Optional[str]
            The bank's sort code.

        account_number : typing.Optional[str]
            The bank account number. Required for US bank accounts to accept ACH payments. US account numbers contain 9 to 12 digits. UK account numbers typically contain 8 digits.

        tax_id : typing.Optional[str]
            The tax ID of the counterpart.

        vat_id : typing.Optional[str]
            The VAT ID of the counterpart.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of counterpart IDs to search through.

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[CounterpartCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        type : typing.Optional[CounterpartType]

        counterpart_name : typing.Optional[str]

        counterpart_name_iexact : typing.Optional[str]

        counterpart_name_contains : typing.Optional[str]

        counterpart_name_icontains : typing.Optional[str]

        is_vendor : typing.Optional[bool]

        is_customer : typing.Optional[bool]

        email : typing.Optional[str]

        email_contains : typing.Optional[str]

        email_icontains : typing.Optional[str]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        address_country : typing.Optional[str]

        address_city : typing.Optional[str]

        address_postal_code : typing.Optional[str]

        address_state : typing.Optional[str]

        address_line1 : typing.Optional[str]

        address_line2 : typing.Optional[str]

        tag_ids_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CounterpartPaginationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "counterparts",
            method="GET",
            params={
                "iban": iban,
                "sort_code": sort_code,
                "account_number": account_number,
                "tax_id": tax_id,
                "vat_id": vat_id,
                "id__in": id_in,
                "order": order,
                "limit": limit,
                "pagination_token": pagination_token,
                "sort": sort,
                "type": type,
                "counterpart_name": counterpart_name,
                "counterpart_name__iexact": counterpart_name_iexact,
                "counterpart_name__contains": counterpart_name_contains,
                "counterpart_name__icontains": counterpart_name_icontains,
                "is_vendor": is_vendor,
                "is_customer": is_customer,
                "email": email,
                "email__contains": email_contains,
                "email__icontains": email_icontains,
                "created_at__gt": serialize_datetime(created_at_gt) if created_at_gt is not None else None,
                "created_at__lt": serialize_datetime(created_at_lt) if created_at_lt is not None else None,
                "created_at__gte": serialize_datetime(created_at_gte) if created_at_gte is not None else None,
                "created_at__lte": serialize_datetime(created_at_lte) if created_at_lte is not None else None,
                "address.country": address_country,
                "address.city": address_city,
                "address.postal_code": address_postal_code,
                "address.state": address_state,
                "address.line1": address_line1,
                "address.line2": address_line2,
                "tag_ids__in": tag_ids_in,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartPaginationResponse,
                    parse_obj_as(
                        type_=CounterpartPaginationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self, *, request: CounterpartCreatePayload, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CounterpartResponse]:
        """
        Parameters
        ----------
        request : CounterpartCreatePayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CounterpartResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "counterparts",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=CounterpartCreatePayload, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartResponse,
                    parse_obj_as(
                        type_=CounterpartResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_by_id(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CounterpartResponse]:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CounterpartResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartResponse,
                    parse_obj_as(
                        type_=CounterpartResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_by_id(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_by_id(
        self,
        counterpart_id: str,
        *,
        request: CounterpartUpdatePayload,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CounterpartResponse]:
        """
        Parameters
        ----------
        counterpart_id : str

        request : CounterpartUpdatePayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CounterpartResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}",
            method="PATCH",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=CounterpartUpdatePayload, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CounterpartResponse,
                    parse_obj_as(
                        type_=CounterpartResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_partner_metadata_by_id(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PartnerMetadataResponse]:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PartnerMetadataResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/partner_metadata",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PartnerMetadataResponse,
                    parse_obj_as(
                        type_=PartnerMetadataResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_partner_metadata_by_id(
        self,
        counterpart_id: str,
        *,
        metadata: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PartnerMetadataResponse]:
        """
        Parameters
        ----------
        counterpart_id : str

        metadata : typing.Dict[str, typing.Optional[typing.Any]]
            Metadata for partner needs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PartnerMetadataResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"counterparts/{jsonable_encoder(counterpart_id)}/partner_metadata",
            method="PUT",
            json={
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PartnerMetadataResponse,
                    parse_obj_as(
                        type_=PartnerMetadataResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
