# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.allowed_countries import AllowedCountries
from ...types.counterpart_vat_id_resource_list import CounterpartVatIdResourceList
from ...types.counterpart_vat_id_response import CounterpartVatIdResponse
from ...types.vat_id_type_enum import VatIdTypeEnum
from .raw_client import AsyncRawVatIdsClient, RawVatIdsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class VatIdsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawVatIdsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawVatIdsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawVatIdsClient
        """
        return self._raw_client

    def get(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartVatIdResourceList:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartVatIdResourceList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.vat_ids.get(counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.get(counterpart_id, request_options=request_options)
        return _response.data

    def create(
        self,
        counterpart_id: str,
        *,
        value: str,
        country: typing.Optional[AllowedCountries] = OMIT,
        type: typing.Optional[VatIdTypeEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartVatIdResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        value : str

        country : typing.Optional[AllowedCountries]

        type : typing.Optional[VatIdTypeEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartVatIdResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.vat_ids.create(counterpart_id='counterpart_id', value='123456789', )
        """
        _response = self._raw_client.create(
            counterpart_id, value=value, country=country, type=type, request_options=request_options
        )
        return _response.data

    def get_by_id(
        self, vat_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartVatIdResponse:
        """
        Parameters
        ----------
        vat_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartVatIdResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.vat_ids.get_by_id(vat_id='vat_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.get_by_id(vat_id, counterpart_id, request_options=request_options)
        return _response.data

    def delete_by_id(
        self, vat_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        vat_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.vat_ids.delete_by_id(vat_id='vat_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.delete_by_id(vat_id, counterpart_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        vat_id: str,
        counterpart_id: str,
        *,
        country: typing.Optional[AllowedCountries] = OMIT,
        type: typing.Optional[VatIdTypeEnum] = OMIT,
        value: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartVatIdResponse:
        """
        Parameters
        ----------
        vat_id : str

        counterpart_id : str

        country : typing.Optional[AllowedCountries]

        type : typing.Optional[VatIdTypeEnum]

        value : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartVatIdResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.counterparts.vat_ids.update_by_id(vat_id='vat_id', counterpart_id='counterpart_id', )
        """
        _response = self._raw_client.update_by_id(
            vat_id, counterpart_id, country=country, type=type, value=value, request_options=request_options
        )
        return _response.data


class AsyncVatIdsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawVatIdsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawVatIdsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawVatIdsClient
        """
        return self._raw_client

    async def get(
        self, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartVatIdResourceList:
        """
        Parameters
        ----------
        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartVatIdResourceList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.vat_ids.get(counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(counterpart_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        counterpart_id: str,
        *,
        value: str,
        country: typing.Optional[AllowedCountries] = OMIT,
        type: typing.Optional[VatIdTypeEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartVatIdResponse:
        """
        Parameters
        ----------
        counterpart_id : str

        value : str

        country : typing.Optional[AllowedCountries]

        type : typing.Optional[VatIdTypeEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartVatIdResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.vat_ids.create(counterpart_id='counterpart_id', value='123456789', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            counterpart_id, value=value, country=country, type=type, request_options=request_options
        )
        return _response.data

    async def get_by_id(
        self, vat_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CounterpartVatIdResponse:
        """
        Parameters
        ----------
        vat_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartVatIdResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.vat_ids.get_by_id(vat_id='vat_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(vat_id, counterpart_id, request_options=request_options)
        return _response.data

    async def delete_by_id(
        self, vat_id: str, counterpart_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        vat_id : str

        counterpart_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.vat_ids.delete_by_id(vat_id='vat_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(vat_id, counterpart_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        vat_id: str,
        counterpart_id: str,
        *,
        country: typing.Optional[AllowedCountries] = OMIT,
        type: typing.Optional[VatIdTypeEnum] = OMIT,
        value: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CounterpartVatIdResponse:
        """
        Parameters
        ----------
        vat_id : str

        counterpart_id : str

        country : typing.Optional[AllowedCountries]

        type : typing.Optional[VatIdTypeEnum]

        value : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CounterpartVatIdResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.counterparts.vat_ids.update_by_id(vat_id='vat_id', counterpart_id='counterpart_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            vat_id, counterpart_id, country=country, type=type, value=value, request_options=request_options
        )
        return _response.data
