# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .. import core
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.credit_note_cursor_fields import CreditNoteCursorFields
from ..types.credit_note_fields_allowed_for_validate import CreditNoteFieldsAllowedForValidate
from ..types.credit_note_line_item_create_request import CreditNoteLineItemCreateRequest
from ..types.credit_note_line_item_cursor_fields import CreditNoteLineItemCursorFields
from ..types.credit_note_line_item_pagination_response import CreditNoteLineItemPaginationResponse
from ..types.credit_note_line_item_response import CreditNoteLineItemResponse
from ..types.credit_note_pagination_response import CreditNotePaginationResponse
from ..types.credit_note_response import CreditNoteResponse
from ..types.credit_note_validation_response import CreditNoteValidationResponse
from ..types.credit_note_validations_resource import CreditNoteValidationsResource
from ..types.currency_enum import CurrencyEnum
from ..types.order_enum import OrderEnum
from ..types.origin_enum import OriginEnum
from ..types.payable_credit_note_state_enum import PayableCreditNoteStateEnum
from .raw_client import AsyncRawCreditNotesClient, RawCreditNotesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CreditNotesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCreditNotesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCreditNotesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCreditNotesClient
        """
        return self._raw_client

    def get_payable_credit_notes(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[CreditNoteCursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        issued_at: typing.Optional[str] = None,
        issued_at_gt: typing.Optional[str] = None,
        issued_at_lt: typing.Optional[str] = None,
        issued_at_gte: typing.Optional[str] = None,
        issued_at_lte: typing.Optional[str] = None,
        document_id: typing.Optional[str] = None,
        document_id_iexact: typing.Optional[str] = None,
        document_id_contains: typing.Optional[str] = None,
        document_id_icontains: typing.Optional[str] = None,
        has_file: typing.Optional[bool] = None,
        total_amount_gt: typing.Optional[int] = None,
        total_amount_lt: typing.Optional[int] = None,
        total_amount_gte: typing.Optional[int] = None,
        total_amount_lte: typing.Optional[int] = None,
        subtotal_gt: typing.Optional[int] = None,
        subtotal_lt: typing.Optional[int] = None,
        subtotal_gte: typing.Optional[int] = None,
        subtotal_lte: typing.Optional[int] = None,
        based_on: typing.Optional[str] = None,
        counterpart_id: typing.Optional[str] = None,
        created_by_entity_user_id: typing.Optional[str] = None,
        status: typing.Optional[PayableCreditNoteStateEnum] = None,
        status_in: typing.Optional[
            typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]
        ] = None,
        status_not_in: typing.Optional[
            typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]
        ] = None,
        origin: typing.Optional[OriginEnum] = None,
        currency: typing.Optional[CurrencyEnum] = None,
        project_id: typing.Optional[str] = None,
        project_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNotePaginationResponse:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[CreditNoteCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        issued_at : typing.Optional[str]

        issued_at_gt : typing.Optional[str]

        issued_at_lt : typing.Optional[str]

        issued_at_gte : typing.Optional[str]

        issued_at_lte : typing.Optional[str]

        document_id : typing.Optional[str]

        document_id_iexact : typing.Optional[str]

        document_id_contains : typing.Optional[str]

        document_id_icontains : typing.Optional[str]

        has_file : typing.Optional[bool]

        total_amount_gt : typing.Optional[int]

        total_amount_lt : typing.Optional[int]

        total_amount_gte : typing.Optional[int]

        total_amount_lte : typing.Optional[int]

        subtotal_gt : typing.Optional[int]

        subtotal_lt : typing.Optional[int]

        subtotal_gte : typing.Optional[int]

        subtotal_lte : typing.Optional[int]

        based_on : typing.Optional[str]

        counterpart_id : typing.Optional[str]

        created_by_entity_user_id : typing.Optional[str]

        status : typing.Optional[PayableCreditNoteStateEnum]

        status_in : typing.Optional[typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]]

        status_not_in : typing.Optional[typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]]

        origin : typing.Optional[OriginEnum]

        currency : typing.Optional[CurrencyEnum]

        project_id : typing.Optional[str]

        project_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNotePaginationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.get_payable_credit_notes()
        """
        _response = self._raw_client.get_payable_credit_notes(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            issued_at=issued_at,
            issued_at_gt=issued_at_gt,
            issued_at_lt=issued_at_lt,
            issued_at_gte=issued_at_gte,
            issued_at_lte=issued_at_lte,
            document_id=document_id,
            document_id_iexact=document_id_iexact,
            document_id_contains=document_id_contains,
            document_id_icontains=document_id_icontains,
            has_file=has_file,
            total_amount_gt=total_amount_gt,
            total_amount_lt=total_amount_lt,
            total_amount_gte=total_amount_gte,
            total_amount_lte=total_amount_lte,
            subtotal_gt=subtotal_gt,
            subtotal_lt=subtotal_lt,
            subtotal_gte=subtotal_gte,
            subtotal_lte=subtotal_lte,
            based_on=based_on,
            counterpart_id=counterpart_id,
            created_by_entity_user_id=created_by_entity_user_id,
            status=status,
            status_in=status_in,
            status_not_in=status_not_in,
            origin=origin,
            currency=currency,
            project_id=project_id,
            project_id_in=project_id_in,
            request_options=request_options,
        )
        return _response.data

    def post_payable_credit_notes(
        self,
        *,
        document_id: str,
        issued_at: str,
        based_on: typing.Optional[str] = OMIT,
        based_on_document_id: typing.Optional[str] = OMIT,
        counterpart_address_id: typing.Optional[str] = OMIT,
        counterpart_bank_account_id: typing.Optional[str] = OMIT,
        counterpart_id: typing.Optional[str] = OMIT,
        counterpart_vat_id_id: typing.Optional[str] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        description: typing.Optional[str] = OMIT,
        project_id: typing.Optional[str] = OMIT,
        sender: typing.Optional[str] = OMIT,
        subtotal: typing.Optional[int] = OMIT,
        tag_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        tax: typing.Optional[int] = OMIT,
        tax_amount: typing.Optional[int] = OMIT,
        total_amount: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNoteResponse:
        """
        Parameters
        ----------
        document_id : str
            A unique credit note number assigned by the credit note issuer for tracking purposes

        issued_at : str
            The date when the credit note was issued, in the YYYY-MM-DD format

        based_on : typing.Optional[str]
            ID of the payable this credit note is based on. The credit note will be linked to this payable

        based_on_document_id : typing.Optional[str]
            The document ID of the original payable that this credit note refers to

        counterpart_address_id : typing.Optional[str]
            The ID of the counterpart's address

        counterpart_bank_account_id : typing.Optional[str]
            The ID of the counterpart's bank account

        counterpart_id : typing.Optional[str]
            The ID of the counterpart (vendor/supplier)

        counterpart_vat_id_id : typing.Optional[str]
            The ID of the counterpart's VAT registration

        currency : typing.Optional[CurrencyEnum]
            The currency code of the credit note

        description : typing.Optional[str]
            An arbitrary description of this credit note

        project_id : typing.Optional[str]
            The ID of the project this credit note belongs to

        sender : typing.Optional[str]
            The email address from which the credit note was received

        subtotal : typing.Optional[int]
            The subtotal amount before taxes

        tag_ids : typing.Optional[typing.Sequence[str]]
            List of tag IDs associated with this credit note

        tax : typing.Optional[int]
            The tax percentage applied to the subtotal

        tax_amount : typing.Optional[int]
            The calculated tax amount

        total_amount : typing.Optional[int]
            The total amount including taxes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.post_payable_credit_notes(document_id='CN-2287', issued_at='2024-01-15', )
        """
        _response = self._raw_client.post_payable_credit_notes(
            document_id=document_id,
            issued_at=issued_at,
            based_on=based_on,
            based_on_document_id=based_on_document_id,
            counterpart_address_id=counterpart_address_id,
            counterpart_bank_account_id=counterpart_bank_account_id,
            counterpart_id=counterpart_id,
            counterpart_vat_id_id=counterpart_vat_id_id,
            currency=currency,
            description=description,
            project_id=project_id,
            sender=sender,
            subtotal=subtotal,
            tag_ids=tag_ids,
            tax=tax,
            tax_amount=tax_amount,
            total_amount=total_amount,
            request_options=request_options,
        )
        return _response.data

    def post_payable_credit_notes_upload_from_file(
        self, *, file: core.File, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteResponse:
        """
        Upload an incoming credit note (payable) in PDF, PNG, JPEG, or TIFF format and scan its contents. The maximum file size is 10MB.

        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.post_payable_credit_notes_upload_from_file()
        """
        _response = self._raw_client.post_payable_credit_notes_upload_from_file(
            file=file, request_options=request_options
        )
        return _response.data

    def get_payable_credit_notes_validations(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteValidationsResource:
        """
        Get credit notes validations.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteValidationsResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.get_payable_credit_notes_validations()
        """
        _response = self._raw_client.get_payable_credit_notes_validations(request_options=request_options)
        return _response.data

    def put_payable_credit_notes_validations(
        self,
        *,
        required_fields: typing.Sequence[CreditNoteFieldsAllowedForValidate],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNoteValidationsResource:
        """
        Update credit notes validations.

        Parameters
        ----------
        required_fields : typing.Sequence[CreditNoteFieldsAllowedForValidate]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteValidationsResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.put_payable_credit_notes_validations(required_fields=["currency"], )
        """
        _response = self._raw_client.put_payable_credit_notes_validations(
            required_fields=required_fields, request_options=request_options
        )
        return _response.data

    def post_payable_credit_notes_validations_reset(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteValidationsResource:
        """
        Reset credit notes validations.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteValidationsResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.post_payable_credit_notes_validations_reset()
        """
        _response = self._raw_client.post_payable_credit_notes_validations_reset(request_options=request_options)
        return _response.data

    def get_payable_credit_notes_id(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.get_payable_credit_notes_id(credit_note_id='credit_note_id', )
        """
        _response = self._raw_client.get_payable_credit_notes_id(credit_note_id, request_options=request_options)
        return _response.data

    def delete_payable_credit_notes_id(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.delete_payable_credit_notes_id(credit_note_id='credit_note_id', )
        """
        _response = self._raw_client.delete_payable_credit_notes_id(credit_note_id, request_options=request_options)
        return _response.data

    def patch_payable_credit_notes_id(
        self,
        credit_note_id: str,
        *,
        based_on: typing.Optional[str] = OMIT,
        based_on_document_id: typing.Optional[str] = OMIT,
        counterpart_address_id: typing.Optional[str] = OMIT,
        counterpart_bank_account_id: typing.Optional[str] = OMIT,
        counterpart_id: typing.Optional[str] = OMIT,
        counterpart_vat_id_id: typing.Optional[str] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        description: typing.Optional[str] = OMIT,
        document_id: typing.Optional[str] = OMIT,
        issued_at: typing.Optional[str] = OMIT,
        project_id: typing.Optional[str] = OMIT,
        sender: typing.Optional[str] = OMIT,
        subtotal: typing.Optional[int] = OMIT,
        tag_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        tax: typing.Optional[int] = OMIT,
        tax_amount: typing.Optional[int] = OMIT,
        total_amount: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNoteResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        based_on : typing.Optional[str]
            ID of the payable this credit note is based on. The credit note will be linked to this payable

        based_on_document_id : typing.Optional[str]
            The document ID of the original payable

        counterpart_address_id : typing.Optional[str]
            ID of the counterpart's address

        counterpart_bank_account_id : typing.Optional[str]
            ID of the counterpart's bank account

        counterpart_id : typing.Optional[str]
            ID of the counterpart

        counterpart_vat_id_id : typing.Optional[str]
            ID of the counterpart's VAT registration

        currency : typing.Optional[CurrencyEnum]
            The currency code of the credit note

        description : typing.Optional[str]
            An arbitrary description of this credit note

        document_id : typing.Optional[str]
            A unique credit note number assigned by the credit note issuer for tracking purposes

        issued_at : typing.Optional[str]
            The date when the credit note was issued, in the YYYY-MM-DD format

        project_id : typing.Optional[str]
            The ID of the project this credit note belongs to

        sender : typing.Optional[str]
            Email address of the sender

        subtotal : typing.Optional[int]
            The subtotal amount before taxes

        tag_ids : typing.Optional[typing.Sequence[str]]
            List of tag IDs associated with this credit note

        tax : typing.Optional[int]
            The tax percentage applied to the subtotal

        tax_amount : typing.Optional[int]
            The calculated tax amount

        total_amount : typing.Optional[int]
            The total amount including taxes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.patch_payable_credit_notes_id(credit_note_id='credit_note_id', )
        """
        _response = self._raw_client.patch_payable_credit_notes_id(
            credit_note_id,
            based_on=based_on,
            based_on_document_id=based_on_document_id,
            counterpart_address_id=counterpart_address_id,
            counterpart_bank_account_id=counterpart_bank_account_id,
            counterpart_id=counterpart_id,
            counterpart_vat_id_id=counterpart_vat_id_id,
            currency=currency,
            description=description,
            document_id=document_id,
            issued_at=issued_at,
            project_id=project_id,
            sender=sender,
            subtotal=subtotal,
            tag_ids=tag_ids,
            tax=tax,
            tax_amount=tax_amount,
            total_amount=total_amount,
            request_options=request_options,
        )
        return _response.data

    def post_payable_credit_notes_id_approve(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteResponse:
        """
        Approve the credit note for appliance.

        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.post_payable_credit_notes_id_approve(credit_note_id='credit_note_id', )
        """
        _response = self._raw_client.post_payable_credit_notes_id_approve(
            credit_note_id, request_options=request_options
        )
        return _response.data

    def post_payable_credit_notes_id_cancel(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteResponse:
        """
        Cancel the credit note that was not confirmed during the review.

        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.post_payable_credit_notes_id_cancel(credit_note_id='credit_note_id', )
        """
        _response = self._raw_client.post_payable_credit_notes_id_cancel(
            credit_note_id, request_options=request_options
        )
        return _response.data

    def post_payable_credit_notes_id_cancel_ocr(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteResponse:
        """
        Request to cancel the OCR processing of the specified credit note.

        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.post_payable_credit_notes_id_cancel_ocr(credit_note_id='credit_note_id', )
        """
        _response = self._raw_client.post_payable_credit_notes_id_cancel_ocr(
            credit_note_id, request_options=request_options
        )
        return _response.data

    def get_payable_credit_notes_id_line_items(
        self,
        credit_note_id: str,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[CreditNoteLineItemCursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        name: typing.Optional[str] = None,
        name_iexact: typing.Optional[str] = None,
        name_contains: typing.Optional[str] = None,
        name_icontains: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        description_contains: typing.Optional[str] = None,
        description_icontains: typing.Optional[str] = None,
        total_gt: typing.Optional[int] = None,
        total_lt: typing.Optional[int] = None,
        total_gte: typing.Optional[int] = None,
        total_lte: typing.Optional[int] = None,
        subtotal_gt: typing.Optional[int] = None,
        subtotal_lt: typing.Optional[int] = None,
        subtotal_gte: typing.Optional[int] = None,
        subtotal_lte: typing.Optional[int] = None,
        unit_price_gt: typing.Optional[int] = None,
        unit_price_lt: typing.Optional[int] = None,
        unit_price_gte: typing.Optional[int] = None,
        unit_price_lte: typing.Optional[int] = None,
        quantity_gt: typing.Optional[float] = None,
        quantity_lt: typing.Optional[float] = None,
        quantity_gte: typing.Optional[float] = None,
        quantity_lte: typing.Optional[float] = None,
        tax_gt: typing.Optional[int] = None,
        tax_lt: typing.Optional[int] = None,
        tax_gte: typing.Optional[int] = None,
        tax_lte: typing.Optional[int] = None,
        tax_amount_gt: typing.Optional[int] = None,
        tax_amount_lt: typing.Optional[int] = None,
        tax_amount_gte: typing.Optional[int] = None,
        tax_amount_lte: typing.Optional[int] = None,
        created_by_user_id: typing.Optional[str] = None,
        unit: typing.Optional[str] = None,
        unit_iexact: typing.Optional[str] = None,
        source: typing.Optional[str] = None,
        source_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNoteLineItemPaginationResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[CreditNoteLineItemCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        name : typing.Optional[str]

        name_iexact : typing.Optional[str]

        name_contains : typing.Optional[str]

        name_icontains : typing.Optional[str]

        description : typing.Optional[str]

        description_contains : typing.Optional[str]

        description_icontains : typing.Optional[str]

        total_gt : typing.Optional[int]

        total_lt : typing.Optional[int]

        total_gte : typing.Optional[int]

        total_lte : typing.Optional[int]

        subtotal_gt : typing.Optional[int]

        subtotal_lt : typing.Optional[int]

        subtotal_gte : typing.Optional[int]

        subtotal_lte : typing.Optional[int]

        unit_price_gt : typing.Optional[int]

        unit_price_lt : typing.Optional[int]

        unit_price_gte : typing.Optional[int]

        unit_price_lte : typing.Optional[int]

        quantity_gt : typing.Optional[float]

        quantity_lt : typing.Optional[float]

        quantity_gte : typing.Optional[float]

        quantity_lte : typing.Optional[float]

        tax_gt : typing.Optional[int]

        tax_lt : typing.Optional[int]

        tax_gte : typing.Optional[int]

        tax_lte : typing.Optional[int]

        tax_amount_gt : typing.Optional[int]

        tax_amount_lt : typing.Optional[int]

        tax_amount_gte : typing.Optional[int]

        tax_amount_lte : typing.Optional[int]

        created_by_user_id : typing.Optional[str]

        unit : typing.Optional[str]

        unit_iexact : typing.Optional[str]

        source : typing.Optional[str]

        source_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteLineItemPaginationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.get_payable_credit_notes_id_line_items(credit_note_id='credit_note_id', )
        """
        _response = self._raw_client.get_payable_credit_notes_id_line_items(
            credit_note_id,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            name=name,
            name_iexact=name_iexact,
            name_contains=name_contains,
            name_icontains=name_icontains,
            description=description,
            description_contains=description_contains,
            description_icontains=description_icontains,
            total_gt=total_gt,
            total_lt=total_lt,
            total_gte=total_gte,
            total_lte=total_lte,
            subtotal_gt=subtotal_gt,
            subtotal_lt=subtotal_lt,
            subtotal_gte=subtotal_gte,
            subtotal_lte=subtotal_lte,
            unit_price_gt=unit_price_gt,
            unit_price_lt=unit_price_lt,
            unit_price_gte=unit_price_gte,
            unit_price_lte=unit_price_lte,
            quantity_gt=quantity_gt,
            quantity_lt=quantity_lt,
            quantity_gte=quantity_gte,
            quantity_lte=quantity_lte,
            tax_gt=tax_gt,
            tax_lt=tax_lt,
            tax_gte=tax_gte,
            tax_lte=tax_lte,
            tax_amount_gt=tax_amount_gt,
            tax_amount_lt=tax_amount_lt,
            tax_amount_gte=tax_amount_gte,
            tax_amount_lte=tax_amount_lte,
            created_by_user_id=created_by_user_id,
            unit=unit,
            unit_iexact=unit_iexact,
            source=source,
            source_id=source_id,
            request_options=request_options,
        )
        return _response.data

    def post_payable_credit_notes_id_line_items(
        self,
        credit_note_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        quantity: typing.Optional[float] = OMIT,
        tax: typing.Optional[int] = OMIT,
        unit: typing.Optional[str] = OMIT,
        unit_price: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNoteLineItemResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        description : typing.Optional[str]
            Detailed description of the line item

        name : typing.Optional[str]
            Name or title of the line item

        quantity : typing.Optional[float]
            Quantity of items

        tax : typing.Optional[int]
            VAT rate in percent [minor units](https://docs.monite.com/references/currencies#minor-units). Example: 12.5% is 1250.

        unit : typing.Optional[str]
            Unit of measurement

        unit_price : typing.Optional[int]
            Price per unit in smallest currency unit (e.g. cents)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteLineItemResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.post_payable_credit_notes_id_line_items(credit_note_id='credit_note_id', )
        """
        _response = self._raw_client.post_payable_credit_notes_id_line_items(
            credit_note_id,
            description=description,
            name=name,
            quantity=quantity,
            tax=tax,
            unit=unit,
            unit_price=unit_price,
            request_options=request_options,
        )
        return _response.data

    def put_payable_credit_notes_id_line_items(
        self,
        credit_note_id: str,
        *,
        data: typing.Sequence[CreditNoteLineItemCreateRequest],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNoteLineItemPaginationResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        data : typing.Sequence[CreditNoteLineItemCreateRequest]
            List of credit note line items to replace existing ones

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteLineItemPaginationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import CreditNoteLineItemCreateRequest
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.put_payable_credit_notes_id_line_items(credit_note_id='credit_note_id', data=[CreditNoteLineItemCreateRequest()], )
        """
        _response = self._raw_client.put_payable_credit_notes_id_line_items(
            credit_note_id, data=data, request_options=request_options
        )
        return _response.data

    def get_payable_credit_notes_id_line_items_id(
        self, credit_note_id: str, line_item_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteLineItemResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        line_item_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteLineItemResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.get_payable_credit_notes_id_line_items_id(credit_note_id='credit_note_id', line_item_id='line_item_id', )
        """
        _response = self._raw_client.get_payable_credit_notes_id_line_items_id(
            credit_note_id, line_item_id, request_options=request_options
        )
        return _response.data

    def delete_payable_credit_notes_id_line_items_id(
        self, credit_note_id: str, line_item_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteLineItemPaginationResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        line_item_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteLineItemPaginationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.delete_payable_credit_notes_id_line_items_id(credit_note_id='credit_note_id', line_item_id='line_item_id', )
        """
        _response = self._raw_client.delete_payable_credit_notes_id_line_items_id(
            credit_note_id, line_item_id, request_options=request_options
        )
        return _response.data

    def patch_payable_credit_notes_id_line_items_id(
        self,
        credit_note_id: str,
        line_item_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        quantity: typing.Optional[float] = OMIT,
        tax: typing.Optional[int] = OMIT,
        unit: typing.Optional[str] = OMIT,
        unit_price: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNoteLineItemResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        line_item_id : str

        description : typing.Optional[str]
            Detailed description of the line item

        name : typing.Optional[str]
            Name or title of the line item

        quantity : typing.Optional[float]
            Quantity of items

        tax : typing.Optional[int]
            VAT rate in percent [minor units](https://docs.monite.com/references/currencies#minor-units). Example: 12.5% is 1250.

        unit : typing.Optional[str]
            Unit of measurement

        unit_price : typing.Optional[int]
            Price per unit in smallest currency unit

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteLineItemResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.patch_payable_credit_notes_id_line_items_id(credit_note_id='credit_note_id', line_item_id='line_item_id', )
        """
        _response = self._raw_client.patch_payable_credit_notes_id_line_items_id(
            credit_note_id,
            line_item_id,
            description=description,
            name=name,
            quantity=quantity,
            tax=tax,
            unit=unit,
            unit_price=unit_price,
            request_options=request_options,
        )
        return _response.data

    def post_payable_credit_notes_id_reject(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteResponse:
        """
        Decline the credit note when an approver finds any mismatch or discrepancies.

        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.post_payable_credit_notes_id_reject(credit_note_id='credit_note_id', )
        """
        _response = self._raw_client.post_payable_credit_notes_id_reject(
            credit_note_id, request_options=request_options
        )
        return _response.data

    def post_payable_credit_notes_id_submit_for_approval(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteResponse:
        """
        Start the approval process once the uploaded credit note is validated.

        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.post_payable_credit_notes_id_submit_for_approval(credit_note_id='credit_note_id', )
        """
        _response = self._raw_client.post_payable_credit_notes_id_submit_for_approval(
            credit_note_id, request_options=request_options
        )
        return _response.data

    def get_payable_credit_notes_id_validate(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteValidationResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteValidationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.credit_notes.get_payable_credit_notes_id_validate(credit_note_id='credit_note_id', )
        """
        _response = self._raw_client.get_payable_credit_notes_id_validate(
            credit_note_id, request_options=request_options
        )
        return _response.data


class AsyncCreditNotesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCreditNotesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCreditNotesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCreditNotesClient
        """
        return self._raw_client

    async def get_payable_credit_notes(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[CreditNoteCursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        issued_at: typing.Optional[str] = None,
        issued_at_gt: typing.Optional[str] = None,
        issued_at_lt: typing.Optional[str] = None,
        issued_at_gte: typing.Optional[str] = None,
        issued_at_lte: typing.Optional[str] = None,
        document_id: typing.Optional[str] = None,
        document_id_iexact: typing.Optional[str] = None,
        document_id_contains: typing.Optional[str] = None,
        document_id_icontains: typing.Optional[str] = None,
        has_file: typing.Optional[bool] = None,
        total_amount_gt: typing.Optional[int] = None,
        total_amount_lt: typing.Optional[int] = None,
        total_amount_gte: typing.Optional[int] = None,
        total_amount_lte: typing.Optional[int] = None,
        subtotal_gt: typing.Optional[int] = None,
        subtotal_lt: typing.Optional[int] = None,
        subtotal_gte: typing.Optional[int] = None,
        subtotal_lte: typing.Optional[int] = None,
        based_on: typing.Optional[str] = None,
        counterpart_id: typing.Optional[str] = None,
        created_by_entity_user_id: typing.Optional[str] = None,
        status: typing.Optional[PayableCreditNoteStateEnum] = None,
        status_in: typing.Optional[
            typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]
        ] = None,
        status_not_in: typing.Optional[
            typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]
        ] = None,
        origin: typing.Optional[OriginEnum] = None,
        currency: typing.Optional[CurrencyEnum] = None,
        project_id: typing.Optional[str] = None,
        project_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNotePaginationResponse:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[CreditNoteCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        issued_at : typing.Optional[str]

        issued_at_gt : typing.Optional[str]

        issued_at_lt : typing.Optional[str]

        issued_at_gte : typing.Optional[str]

        issued_at_lte : typing.Optional[str]

        document_id : typing.Optional[str]

        document_id_iexact : typing.Optional[str]

        document_id_contains : typing.Optional[str]

        document_id_icontains : typing.Optional[str]

        has_file : typing.Optional[bool]

        total_amount_gt : typing.Optional[int]

        total_amount_lt : typing.Optional[int]

        total_amount_gte : typing.Optional[int]

        total_amount_lte : typing.Optional[int]

        subtotal_gt : typing.Optional[int]

        subtotal_lt : typing.Optional[int]

        subtotal_gte : typing.Optional[int]

        subtotal_lte : typing.Optional[int]

        based_on : typing.Optional[str]

        counterpart_id : typing.Optional[str]

        created_by_entity_user_id : typing.Optional[str]

        status : typing.Optional[PayableCreditNoteStateEnum]

        status_in : typing.Optional[typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]]

        status_not_in : typing.Optional[typing.Union[PayableCreditNoteStateEnum, typing.Sequence[PayableCreditNoteStateEnum]]]

        origin : typing.Optional[OriginEnum]

        currency : typing.Optional[CurrencyEnum]

        project_id : typing.Optional[str]

        project_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNotePaginationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.get_payable_credit_notes()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_payable_credit_notes(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            issued_at=issued_at,
            issued_at_gt=issued_at_gt,
            issued_at_lt=issued_at_lt,
            issued_at_gte=issued_at_gte,
            issued_at_lte=issued_at_lte,
            document_id=document_id,
            document_id_iexact=document_id_iexact,
            document_id_contains=document_id_contains,
            document_id_icontains=document_id_icontains,
            has_file=has_file,
            total_amount_gt=total_amount_gt,
            total_amount_lt=total_amount_lt,
            total_amount_gte=total_amount_gte,
            total_amount_lte=total_amount_lte,
            subtotal_gt=subtotal_gt,
            subtotal_lt=subtotal_lt,
            subtotal_gte=subtotal_gte,
            subtotal_lte=subtotal_lte,
            based_on=based_on,
            counterpart_id=counterpart_id,
            created_by_entity_user_id=created_by_entity_user_id,
            status=status,
            status_in=status_in,
            status_not_in=status_not_in,
            origin=origin,
            currency=currency,
            project_id=project_id,
            project_id_in=project_id_in,
            request_options=request_options,
        )
        return _response.data

    async def post_payable_credit_notes(
        self,
        *,
        document_id: str,
        issued_at: str,
        based_on: typing.Optional[str] = OMIT,
        based_on_document_id: typing.Optional[str] = OMIT,
        counterpart_address_id: typing.Optional[str] = OMIT,
        counterpart_bank_account_id: typing.Optional[str] = OMIT,
        counterpart_id: typing.Optional[str] = OMIT,
        counterpart_vat_id_id: typing.Optional[str] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        description: typing.Optional[str] = OMIT,
        project_id: typing.Optional[str] = OMIT,
        sender: typing.Optional[str] = OMIT,
        subtotal: typing.Optional[int] = OMIT,
        tag_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        tax: typing.Optional[int] = OMIT,
        tax_amount: typing.Optional[int] = OMIT,
        total_amount: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNoteResponse:
        """
        Parameters
        ----------
        document_id : str
            A unique credit note number assigned by the credit note issuer for tracking purposes

        issued_at : str
            The date when the credit note was issued, in the YYYY-MM-DD format

        based_on : typing.Optional[str]
            ID of the payable this credit note is based on. The credit note will be linked to this payable

        based_on_document_id : typing.Optional[str]
            The document ID of the original payable that this credit note refers to

        counterpart_address_id : typing.Optional[str]
            The ID of the counterpart's address

        counterpart_bank_account_id : typing.Optional[str]
            The ID of the counterpart's bank account

        counterpart_id : typing.Optional[str]
            The ID of the counterpart (vendor/supplier)

        counterpart_vat_id_id : typing.Optional[str]
            The ID of the counterpart's VAT registration

        currency : typing.Optional[CurrencyEnum]
            The currency code of the credit note

        description : typing.Optional[str]
            An arbitrary description of this credit note

        project_id : typing.Optional[str]
            The ID of the project this credit note belongs to

        sender : typing.Optional[str]
            The email address from which the credit note was received

        subtotal : typing.Optional[int]
            The subtotal amount before taxes

        tag_ids : typing.Optional[typing.Sequence[str]]
            List of tag IDs associated with this credit note

        tax : typing.Optional[int]
            The tax percentage applied to the subtotal

        tax_amount : typing.Optional[int]
            The calculated tax amount

        total_amount : typing.Optional[int]
            The total amount including taxes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.post_payable_credit_notes(document_id='CN-2287', issued_at='2024-01-15', )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_payable_credit_notes(
            document_id=document_id,
            issued_at=issued_at,
            based_on=based_on,
            based_on_document_id=based_on_document_id,
            counterpart_address_id=counterpart_address_id,
            counterpart_bank_account_id=counterpart_bank_account_id,
            counterpart_id=counterpart_id,
            counterpart_vat_id_id=counterpart_vat_id_id,
            currency=currency,
            description=description,
            project_id=project_id,
            sender=sender,
            subtotal=subtotal,
            tag_ids=tag_ids,
            tax=tax,
            tax_amount=tax_amount,
            total_amount=total_amount,
            request_options=request_options,
        )
        return _response.data

    async def post_payable_credit_notes_upload_from_file(
        self, *, file: core.File, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteResponse:
        """
        Upload an incoming credit note (payable) in PDF, PNG, JPEG, or TIFF format and scan its contents. The maximum file size is 10MB.

        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.post_payable_credit_notes_upload_from_file()
        asyncio.run(main())
        """
        _response = await self._raw_client.post_payable_credit_notes_upload_from_file(
            file=file, request_options=request_options
        )
        return _response.data

    async def get_payable_credit_notes_validations(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteValidationsResource:
        """
        Get credit notes validations.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteValidationsResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.get_payable_credit_notes_validations()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_payable_credit_notes_validations(request_options=request_options)
        return _response.data

    async def put_payable_credit_notes_validations(
        self,
        *,
        required_fields: typing.Sequence[CreditNoteFieldsAllowedForValidate],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNoteValidationsResource:
        """
        Update credit notes validations.

        Parameters
        ----------
        required_fields : typing.Sequence[CreditNoteFieldsAllowedForValidate]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteValidationsResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.put_payable_credit_notes_validations(required_fields=["currency"], )
        asyncio.run(main())
        """
        _response = await self._raw_client.put_payable_credit_notes_validations(
            required_fields=required_fields, request_options=request_options
        )
        return _response.data

    async def post_payable_credit_notes_validations_reset(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteValidationsResource:
        """
        Reset credit notes validations.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteValidationsResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.post_payable_credit_notes_validations_reset()
        asyncio.run(main())
        """
        _response = await self._raw_client.post_payable_credit_notes_validations_reset(request_options=request_options)
        return _response.data

    async def get_payable_credit_notes_id(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.get_payable_credit_notes_id(credit_note_id='credit_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_payable_credit_notes_id(credit_note_id, request_options=request_options)
        return _response.data

    async def delete_payable_credit_notes_id(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.delete_payable_credit_notes_id(credit_note_id='credit_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_payable_credit_notes_id(
            credit_note_id, request_options=request_options
        )
        return _response.data

    async def patch_payable_credit_notes_id(
        self,
        credit_note_id: str,
        *,
        based_on: typing.Optional[str] = OMIT,
        based_on_document_id: typing.Optional[str] = OMIT,
        counterpart_address_id: typing.Optional[str] = OMIT,
        counterpart_bank_account_id: typing.Optional[str] = OMIT,
        counterpart_id: typing.Optional[str] = OMIT,
        counterpart_vat_id_id: typing.Optional[str] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        description: typing.Optional[str] = OMIT,
        document_id: typing.Optional[str] = OMIT,
        issued_at: typing.Optional[str] = OMIT,
        project_id: typing.Optional[str] = OMIT,
        sender: typing.Optional[str] = OMIT,
        subtotal: typing.Optional[int] = OMIT,
        tag_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        tax: typing.Optional[int] = OMIT,
        tax_amount: typing.Optional[int] = OMIT,
        total_amount: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNoteResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        based_on : typing.Optional[str]
            ID of the payable this credit note is based on. The credit note will be linked to this payable

        based_on_document_id : typing.Optional[str]
            The document ID of the original payable

        counterpart_address_id : typing.Optional[str]
            ID of the counterpart's address

        counterpart_bank_account_id : typing.Optional[str]
            ID of the counterpart's bank account

        counterpart_id : typing.Optional[str]
            ID of the counterpart

        counterpart_vat_id_id : typing.Optional[str]
            ID of the counterpart's VAT registration

        currency : typing.Optional[CurrencyEnum]
            The currency code of the credit note

        description : typing.Optional[str]
            An arbitrary description of this credit note

        document_id : typing.Optional[str]
            A unique credit note number assigned by the credit note issuer for tracking purposes

        issued_at : typing.Optional[str]
            The date when the credit note was issued, in the YYYY-MM-DD format

        project_id : typing.Optional[str]
            The ID of the project this credit note belongs to

        sender : typing.Optional[str]
            Email address of the sender

        subtotal : typing.Optional[int]
            The subtotal amount before taxes

        tag_ids : typing.Optional[typing.Sequence[str]]
            List of tag IDs associated with this credit note

        tax : typing.Optional[int]
            The tax percentage applied to the subtotal

        tax_amount : typing.Optional[int]
            The calculated tax amount

        total_amount : typing.Optional[int]
            The total amount including taxes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.patch_payable_credit_notes_id(credit_note_id='credit_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.patch_payable_credit_notes_id(
            credit_note_id,
            based_on=based_on,
            based_on_document_id=based_on_document_id,
            counterpart_address_id=counterpart_address_id,
            counterpart_bank_account_id=counterpart_bank_account_id,
            counterpart_id=counterpart_id,
            counterpart_vat_id_id=counterpart_vat_id_id,
            currency=currency,
            description=description,
            document_id=document_id,
            issued_at=issued_at,
            project_id=project_id,
            sender=sender,
            subtotal=subtotal,
            tag_ids=tag_ids,
            tax=tax,
            tax_amount=tax_amount,
            total_amount=total_amount,
            request_options=request_options,
        )
        return _response.data

    async def post_payable_credit_notes_id_approve(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteResponse:
        """
        Approve the credit note for appliance.

        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.post_payable_credit_notes_id_approve(credit_note_id='credit_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_payable_credit_notes_id_approve(
            credit_note_id, request_options=request_options
        )
        return _response.data

    async def post_payable_credit_notes_id_cancel(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteResponse:
        """
        Cancel the credit note that was not confirmed during the review.

        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.post_payable_credit_notes_id_cancel(credit_note_id='credit_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_payable_credit_notes_id_cancel(
            credit_note_id, request_options=request_options
        )
        return _response.data

    async def post_payable_credit_notes_id_cancel_ocr(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteResponse:
        """
        Request to cancel the OCR processing of the specified credit note.

        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.post_payable_credit_notes_id_cancel_ocr(credit_note_id='credit_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_payable_credit_notes_id_cancel_ocr(
            credit_note_id, request_options=request_options
        )
        return _response.data

    async def get_payable_credit_notes_id_line_items(
        self,
        credit_note_id: str,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[CreditNoteLineItemCursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        name: typing.Optional[str] = None,
        name_iexact: typing.Optional[str] = None,
        name_contains: typing.Optional[str] = None,
        name_icontains: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        description_contains: typing.Optional[str] = None,
        description_icontains: typing.Optional[str] = None,
        total_gt: typing.Optional[int] = None,
        total_lt: typing.Optional[int] = None,
        total_gte: typing.Optional[int] = None,
        total_lte: typing.Optional[int] = None,
        subtotal_gt: typing.Optional[int] = None,
        subtotal_lt: typing.Optional[int] = None,
        subtotal_gte: typing.Optional[int] = None,
        subtotal_lte: typing.Optional[int] = None,
        unit_price_gt: typing.Optional[int] = None,
        unit_price_lt: typing.Optional[int] = None,
        unit_price_gte: typing.Optional[int] = None,
        unit_price_lte: typing.Optional[int] = None,
        quantity_gt: typing.Optional[float] = None,
        quantity_lt: typing.Optional[float] = None,
        quantity_gte: typing.Optional[float] = None,
        quantity_lte: typing.Optional[float] = None,
        tax_gt: typing.Optional[int] = None,
        tax_lt: typing.Optional[int] = None,
        tax_gte: typing.Optional[int] = None,
        tax_lte: typing.Optional[int] = None,
        tax_amount_gt: typing.Optional[int] = None,
        tax_amount_lt: typing.Optional[int] = None,
        tax_amount_gte: typing.Optional[int] = None,
        tax_amount_lte: typing.Optional[int] = None,
        created_by_user_id: typing.Optional[str] = None,
        unit: typing.Optional[str] = None,
        unit_iexact: typing.Optional[str] = None,
        source: typing.Optional[str] = None,
        source_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNoteLineItemPaginationResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[CreditNoteLineItemCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        name : typing.Optional[str]

        name_iexact : typing.Optional[str]

        name_contains : typing.Optional[str]

        name_icontains : typing.Optional[str]

        description : typing.Optional[str]

        description_contains : typing.Optional[str]

        description_icontains : typing.Optional[str]

        total_gt : typing.Optional[int]

        total_lt : typing.Optional[int]

        total_gte : typing.Optional[int]

        total_lte : typing.Optional[int]

        subtotal_gt : typing.Optional[int]

        subtotal_lt : typing.Optional[int]

        subtotal_gte : typing.Optional[int]

        subtotal_lte : typing.Optional[int]

        unit_price_gt : typing.Optional[int]

        unit_price_lt : typing.Optional[int]

        unit_price_gte : typing.Optional[int]

        unit_price_lte : typing.Optional[int]

        quantity_gt : typing.Optional[float]

        quantity_lt : typing.Optional[float]

        quantity_gte : typing.Optional[float]

        quantity_lte : typing.Optional[float]

        tax_gt : typing.Optional[int]

        tax_lt : typing.Optional[int]

        tax_gte : typing.Optional[int]

        tax_lte : typing.Optional[int]

        tax_amount_gt : typing.Optional[int]

        tax_amount_lt : typing.Optional[int]

        tax_amount_gte : typing.Optional[int]

        tax_amount_lte : typing.Optional[int]

        created_by_user_id : typing.Optional[str]

        unit : typing.Optional[str]

        unit_iexact : typing.Optional[str]

        source : typing.Optional[str]

        source_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteLineItemPaginationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.get_payable_credit_notes_id_line_items(credit_note_id='credit_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_payable_credit_notes_id_line_items(
            credit_note_id,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            name=name,
            name_iexact=name_iexact,
            name_contains=name_contains,
            name_icontains=name_icontains,
            description=description,
            description_contains=description_contains,
            description_icontains=description_icontains,
            total_gt=total_gt,
            total_lt=total_lt,
            total_gte=total_gte,
            total_lte=total_lte,
            subtotal_gt=subtotal_gt,
            subtotal_lt=subtotal_lt,
            subtotal_gte=subtotal_gte,
            subtotal_lte=subtotal_lte,
            unit_price_gt=unit_price_gt,
            unit_price_lt=unit_price_lt,
            unit_price_gte=unit_price_gte,
            unit_price_lte=unit_price_lte,
            quantity_gt=quantity_gt,
            quantity_lt=quantity_lt,
            quantity_gte=quantity_gte,
            quantity_lte=quantity_lte,
            tax_gt=tax_gt,
            tax_lt=tax_lt,
            tax_gte=tax_gte,
            tax_lte=tax_lte,
            tax_amount_gt=tax_amount_gt,
            tax_amount_lt=tax_amount_lt,
            tax_amount_gte=tax_amount_gte,
            tax_amount_lte=tax_amount_lte,
            created_by_user_id=created_by_user_id,
            unit=unit,
            unit_iexact=unit_iexact,
            source=source,
            source_id=source_id,
            request_options=request_options,
        )
        return _response.data

    async def post_payable_credit_notes_id_line_items(
        self,
        credit_note_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        quantity: typing.Optional[float] = OMIT,
        tax: typing.Optional[int] = OMIT,
        unit: typing.Optional[str] = OMIT,
        unit_price: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNoteLineItemResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        description : typing.Optional[str]
            Detailed description of the line item

        name : typing.Optional[str]
            Name or title of the line item

        quantity : typing.Optional[float]
            Quantity of items

        tax : typing.Optional[int]
            VAT rate in percent [minor units](https://docs.monite.com/references/currencies#minor-units). Example: 12.5% is 1250.

        unit : typing.Optional[str]
            Unit of measurement

        unit_price : typing.Optional[int]
            Price per unit in smallest currency unit (e.g. cents)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteLineItemResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.post_payable_credit_notes_id_line_items(credit_note_id='credit_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_payable_credit_notes_id_line_items(
            credit_note_id,
            description=description,
            name=name,
            quantity=quantity,
            tax=tax,
            unit=unit,
            unit_price=unit_price,
            request_options=request_options,
        )
        return _response.data

    async def put_payable_credit_notes_id_line_items(
        self,
        credit_note_id: str,
        *,
        data: typing.Sequence[CreditNoteLineItemCreateRequest],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNoteLineItemPaginationResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        data : typing.Sequence[CreditNoteLineItemCreateRequest]
            List of credit note line items to replace existing ones

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteLineItemPaginationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import CreditNoteLineItemCreateRequest
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.put_payable_credit_notes_id_line_items(credit_note_id='credit_note_id', data=[CreditNoteLineItemCreateRequest()], )
        asyncio.run(main())
        """
        _response = await self._raw_client.put_payable_credit_notes_id_line_items(
            credit_note_id, data=data, request_options=request_options
        )
        return _response.data

    async def get_payable_credit_notes_id_line_items_id(
        self, credit_note_id: str, line_item_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteLineItemResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        line_item_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteLineItemResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.get_payable_credit_notes_id_line_items_id(credit_note_id='credit_note_id', line_item_id='line_item_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_payable_credit_notes_id_line_items_id(
            credit_note_id, line_item_id, request_options=request_options
        )
        return _response.data

    async def delete_payable_credit_notes_id_line_items_id(
        self, credit_note_id: str, line_item_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteLineItemPaginationResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        line_item_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteLineItemPaginationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.delete_payable_credit_notes_id_line_items_id(credit_note_id='credit_note_id', line_item_id='line_item_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_payable_credit_notes_id_line_items_id(
            credit_note_id, line_item_id, request_options=request_options
        )
        return _response.data

    async def patch_payable_credit_notes_id_line_items_id(
        self,
        credit_note_id: str,
        line_item_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        quantity: typing.Optional[float] = OMIT,
        tax: typing.Optional[int] = OMIT,
        unit: typing.Optional[str] = OMIT,
        unit_price: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreditNoteLineItemResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        line_item_id : str

        description : typing.Optional[str]
            Detailed description of the line item

        name : typing.Optional[str]
            Name or title of the line item

        quantity : typing.Optional[float]
            Quantity of items

        tax : typing.Optional[int]
            VAT rate in percent [minor units](https://docs.monite.com/references/currencies#minor-units). Example: 12.5% is 1250.

        unit : typing.Optional[str]
            Unit of measurement

        unit_price : typing.Optional[int]
            Price per unit in smallest currency unit

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteLineItemResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.patch_payable_credit_notes_id_line_items_id(credit_note_id='credit_note_id', line_item_id='line_item_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.patch_payable_credit_notes_id_line_items_id(
            credit_note_id,
            line_item_id,
            description=description,
            name=name,
            quantity=quantity,
            tax=tax,
            unit=unit,
            unit_price=unit_price,
            request_options=request_options,
        )
        return _response.data

    async def post_payable_credit_notes_id_reject(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteResponse:
        """
        Decline the credit note when an approver finds any mismatch or discrepancies.

        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.post_payable_credit_notes_id_reject(credit_note_id='credit_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_payable_credit_notes_id_reject(
            credit_note_id, request_options=request_options
        )
        return _response.data

    async def post_payable_credit_notes_id_submit_for_approval(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteResponse:
        """
        Start the approval process once the uploaded credit note is validated.

        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.post_payable_credit_notes_id_submit_for_approval(credit_note_id='credit_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_payable_credit_notes_id_submit_for_approval(
            credit_note_id, request_options=request_options
        )
        return _response.data

    async def get_payable_credit_notes_id_validate(
        self, credit_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreditNoteValidationResponse:
        """
        Parameters
        ----------
        credit_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreditNoteValidationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.credit_notes.get_payable_credit_notes_id_validate(credit_note_id='credit_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_payable_credit_notes_id_validate(
            credit_note_id, request_options=request_options
        )
        return _response.data
