# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.all_document_export_response_schema import AllDocumentExportResponseSchema
from ..types.create_export_task_response_schema import CreateExportTaskResponseSchema
from ..types.data_export_cursor_fields import DataExportCursorFields
from ..types.document_export_response_schema import DocumentExportResponseSchema
from ..types.export_format import ExportFormat
from ..types.export_object_schema import ExportObjectSchema
from ..types.order_enum import OrderEnum
from ..types.supported_format_schema import SupportedFormatSchema
from .extra_data.client import AsyncExtraDataClient, ExtraDataClient
from .raw_client import AsyncRawDataExportsClient, RawDataExportsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DataExportsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDataExportsClient(client_wrapper=client_wrapper)
        self.extra_data = ExtraDataClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDataExportsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDataExportsClient
        """
        return self._raw_client

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[DataExportCursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        created_by_entity_user_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AllDocumentExportResponseSchema:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[DataExportCursorFields]
            Allowed sort fields

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        created_by_entity_user_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AllDocumentExportResponseSchema
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.data_exports.get()
        """
        _response = self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            created_by_entity_user_id=created_by_entity_user_id,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        date_from: str,
        date_to: str,
        format: ExportFormat,
        objects: typing.Sequence[ExportObjectSchema],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateExportTaskResponseSchema:
        """
        Request the export of payable and receivable documents with the specified statuses.

        Parameters
        ----------
        date_from : str

        date_to : str

        format : ExportFormat

        objects : typing.Sequence[ExportObjectSchema]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateExportTaskResponseSchema
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import ExportObjectSchema_Payable
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.data_exports.create(date_from='date_from', date_to='date_to', format="csv", objects=[ExportObjectSchema_Payable(statuses=["draft"], )], )
        """
        _response = self._raw_client.create(
            date_from=date_from, date_to=date_to, format=format, objects=objects, request_options=request_options
        )
        return _response.data

    def get_supported_formats(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[SupportedFormatSchema]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SupportedFormatSchema]
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.data_exports.get_supported_formats()
        """
        _response = self._raw_client.get_supported_formats(request_options=request_options)
        return _response.data

    def get_by_id(
        self, document_export_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DocumentExportResponseSchema:
        """
        Parameters
        ----------
        document_export_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentExportResponseSchema
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.data_exports.get_by_id(document_export_id='document_export_id', )
        """
        _response = self._raw_client.get_by_id(document_export_id, request_options=request_options)
        return _response.data


class AsyncDataExportsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDataExportsClient(client_wrapper=client_wrapper)
        self.extra_data = AsyncExtraDataClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDataExportsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDataExportsClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[DataExportCursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        created_by_entity_user_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AllDocumentExportResponseSchema:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[DataExportCursorFields]
            Allowed sort fields

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        created_by_entity_user_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AllDocumentExportResponseSchema
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.data_exports.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            created_by_entity_user_id=created_by_entity_user_id,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        date_from: str,
        date_to: str,
        format: ExportFormat,
        objects: typing.Sequence[ExportObjectSchema],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateExportTaskResponseSchema:
        """
        Request the export of payable and receivable documents with the specified statuses.

        Parameters
        ----------
        date_from : str

        date_to : str

        format : ExportFormat

        objects : typing.Sequence[ExportObjectSchema]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateExportTaskResponseSchema
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import ExportObjectSchema_Payable
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.data_exports.create(date_from='date_from', date_to='date_to', format="csv", objects=[ExportObjectSchema_Payable(statuses=["draft"], )], )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            date_from=date_from, date_to=date_to, format=format, objects=objects, request_options=request_options
        )
        return _response.data

    async def get_supported_formats(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[SupportedFormatSchema]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[SupportedFormatSchema]
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.data_exports.get_supported_formats()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_supported_formats(request_options=request_options)
        return _response.data

    async def get_by_id(
        self, document_export_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DocumentExportResponseSchema:
        """
        Parameters
        ----------
        document_export_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DocumentExportResponseSchema
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.data_exports.get_by_id(document_export_id='document_export_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(document_export_id, request_options=request_options)
        return _response.data
