# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.export_setting_cursor_fields import ExportSettingCursorFields
from ...types.extra_data_resource import ExtraDataResource
from ...types.extra_data_resource_list import ExtraDataResourceList
from ...types.order_enum import OrderEnum
from ...types.supported_field_names import SupportedFieldNames
from .raw_client import AsyncRawExtraDataClient, RawExtraDataClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ExtraDataClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawExtraDataClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawExtraDataClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawExtraDataClient
        """
        return self._raw_client

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[ExportSettingCursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        updated_at_gt: typing.Optional[dt.datetime] = None,
        updated_at_lt: typing.Optional[dt.datetime] = None,
        updated_at_gte: typing.Optional[dt.datetime] = None,
        updated_at_lte: typing.Optional[dt.datetime] = None,
        object_id: typing.Optional[str] = None,
        field_name: typing.Optional[str] = None,
        field_value: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtraDataResourceList:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[ExportSettingCursorFields]
            Allowed sort fields

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        updated_at_gt : typing.Optional[dt.datetime]

        updated_at_lt : typing.Optional[dt.datetime]

        updated_at_gte : typing.Optional[dt.datetime]

        updated_at_lte : typing.Optional[dt.datetime]

        object_id : typing.Optional[str]

        field_name : typing.Optional[str]

        field_value : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtraDataResourceList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.data_exports.extra_data.get()
        """
        _response = self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            updated_at_gt=updated_at_gt,
            updated_at_lt=updated_at_lt,
            updated_at_gte=updated_at_gte,
            updated_at_lte=updated_at_lte,
            object_id=object_id,
            field_name=field_name,
            field_value=field_value,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        field_name: SupportedFieldNames,
        field_value: str,
        object_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtraDataResource:
        """
        Parameters
        ----------
        field_name : SupportedFieldNames

        field_value : str

        object_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtraDataResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.data_exports.extra_data.create(field_name="default_account_code", field_value='field_value', object_id='object_id', )
        """
        _response = self._raw_client.create(
            field_name=field_name, field_value=field_value, object_id=object_id, request_options=request_options
        )
        return _response.data

    def get_by_id(
        self, extra_data_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ExtraDataResource:
        """
        Parameters
        ----------
        extra_data_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtraDataResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.data_exports.extra_data.get_by_id(extra_data_id='extra_data_id', )
        """
        _response = self._raw_client.get_by_id(extra_data_id, request_options=request_options)
        return _response.data

    def delete_by_id(
        self, extra_data_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ExtraDataResource:
        """
        Parameters
        ----------
        extra_data_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtraDataResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.data_exports.extra_data.delete_by_id(extra_data_id='extra_data_id', )
        """
        _response = self._raw_client.delete_by_id(extra_data_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        extra_data_id: str,
        *,
        field_name: typing.Optional[SupportedFieldNames] = OMIT,
        field_value: typing.Optional[str] = OMIT,
        object_id: typing.Optional[str] = OMIT,
        object_type: typing.Optional[typing.Literal["counterpart"]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtraDataResource:
        """
        Parameters
        ----------
        extra_data_id : str

        field_name : typing.Optional[SupportedFieldNames]

        field_value : typing.Optional[str]

        object_id : typing.Optional[str]

        object_type : typing.Optional[typing.Literal["counterpart"]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtraDataResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.data_exports.extra_data.update_by_id(extra_data_id='extra_data_id', )
        """
        _response = self._raw_client.update_by_id(
            extra_data_id,
            field_name=field_name,
            field_value=field_value,
            object_id=object_id,
            object_type=object_type,
            request_options=request_options,
        )
        return _response.data


class AsyncExtraDataClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawExtraDataClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawExtraDataClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawExtraDataClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[ExportSettingCursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        updated_at_gt: typing.Optional[dt.datetime] = None,
        updated_at_lt: typing.Optional[dt.datetime] = None,
        updated_at_gte: typing.Optional[dt.datetime] = None,
        updated_at_lte: typing.Optional[dt.datetime] = None,
        object_id: typing.Optional[str] = None,
        field_name: typing.Optional[str] = None,
        field_value: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtraDataResourceList:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[ExportSettingCursorFields]
            Allowed sort fields

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        updated_at_gt : typing.Optional[dt.datetime]

        updated_at_lt : typing.Optional[dt.datetime]

        updated_at_gte : typing.Optional[dt.datetime]

        updated_at_lte : typing.Optional[dt.datetime]

        object_id : typing.Optional[str]

        field_name : typing.Optional[str]

        field_value : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtraDataResourceList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.data_exports.extra_data.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            updated_at_gt=updated_at_gt,
            updated_at_lt=updated_at_lt,
            updated_at_gte=updated_at_gte,
            updated_at_lte=updated_at_lte,
            object_id=object_id,
            field_name=field_name,
            field_value=field_value,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        field_name: SupportedFieldNames,
        field_value: str,
        object_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtraDataResource:
        """
        Parameters
        ----------
        field_name : SupportedFieldNames

        field_value : str

        object_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtraDataResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.data_exports.extra_data.create(field_name="default_account_code", field_value='field_value', object_id='object_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            field_name=field_name, field_value=field_value, object_id=object_id, request_options=request_options
        )
        return _response.data

    async def get_by_id(
        self, extra_data_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ExtraDataResource:
        """
        Parameters
        ----------
        extra_data_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtraDataResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.data_exports.extra_data.get_by_id(extra_data_id='extra_data_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(extra_data_id, request_options=request_options)
        return _response.data

    async def delete_by_id(
        self, extra_data_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ExtraDataResource:
        """
        Parameters
        ----------
        extra_data_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtraDataResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.data_exports.extra_data.delete_by_id(extra_data_id='extra_data_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(extra_data_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        extra_data_id: str,
        *,
        field_name: typing.Optional[SupportedFieldNames] = OMIT,
        field_value: typing.Optional[str] = OMIT,
        object_id: typing.Optional[str] = OMIT,
        object_type: typing.Optional[typing.Literal["counterpart"]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtraDataResource:
        """
        Parameters
        ----------
        extra_data_id : str

        field_name : typing.Optional[SupportedFieldNames]

        field_value : typing.Optional[str]

        object_id : typing.Optional[str]

        object_type : typing.Optional[typing.Literal["counterpart"]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtraDataResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.data_exports.extra_data.update_by_id(extra_data_id='extra_data_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            extra_data_id,
            field_name=field_name,
            field_value=field_value,
            object_id=object_id,
            object_type=object_type,
            request_options=request_options,
        )
        return _response.data
