# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.delivery_note_create_line_item import DeliveryNoteCreateLineItem
from ..types.delivery_note_cursor_fields import DeliveryNoteCursorFields
from ..types.delivery_note_resource import DeliveryNoteResource
from ..types.delivery_note_resource_list import DeliveryNoteResourceList
from ..types.delivery_note_status_enum import DeliveryNoteStatusEnum
from ..types.order_enum import OrderEnum
from .raw_client import AsyncRawDeliveryNotesClient, RawDeliveryNotesClient
from .types.payload import Payload

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DeliveryNotesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDeliveryNotesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDeliveryNotesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDeliveryNotesClient
        """
        return self._raw_client

    def get_delivery_notes(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[DeliveryNoteCursorFields] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[DeliveryNoteStatusEnum] = None,
        status_in: typing.Optional[
            typing.Union[DeliveryNoteStatusEnum, typing.Sequence[DeliveryNoteStatusEnum]]
        ] = None,
        document_id: typing.Optional[str] = None,
        document_id_contains: typing.Optional[str] = None,
        document_id_icontains: typing.Optional[str] = None,
        created_by_entity_user_id: typing.Optional[str] = None,
        counterpart_id: typing.Optional[str] = None,
        based_on: typing.Optional[str] = None,
        based_on_document_id: typing.Optional[str] = None,
        based_on_document_id_contains: typing.Optional[str] = None,
        based_on_document_id_icontains: typing.Optional[str] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        delivery_date_gt: typing.Optional[str] = None,
        delivery_date_lt: typing.Optional[str] = None,
        delivery_date_gte: typing.Optional[str] = None,
        delivery_date_lte: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeliveryNoteResourceList:
        """
        Get all delivery notes with filtering and pagination.

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[DeliveryNoteCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        status : typing.Optional[DeliveryNoteStatusEnum]

        status_in : typing.Optional[typing.Union[DeliveryNoteStatusEnum, typing.Sequence[DeliveryNoteStatusEnum]]]

        document_id : typing.Optional[str]

        document_id_contains : typing.Optional[str]

        document_id_icontains : typing.Optional[str]

        created_by_entity_user_id : typing.Optional[str]

        counterpart_id : typing.Optional[str]

        based_on : typing.Optional[str]

        based_on_document_id : typing.Optional[str]

        based_on_document_id_contains : typing.Optional[str]

        based_on_document_id_icontains : typing.Optional[str]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        delivery_date_gt : typing.Optional[str]

        delivery_date_lt : typing.Optional[str]

        delivery_date_gte : typing.Optional[str]

        delivery_date_lte : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeliveryNoteResourceList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.delivery_notes.get_delivery_notes()
        """
        _response = self._raw_client.get_delivery_notes(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            id_in=id_in,
            status=status,
            status_in=status_in,
            document_id=document_id,
            document_id_contains=document_id_contains,
            document_id_icontains=document_id_icontains,
            created_by_entity_user_id=created_by_entity_user_id,
            counterpart_id=counterpart_id,
            based_on=based_on,
            based_on_document_id=based_on_document_id,
            based_on_document_id_contains=based_on_document_id_contains,
            based_on_document_id_icontains=based_on_document_id_icontains,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            delivery_date_gt=delivery_date_gt,
            delivery_date_lt=delivery_date_lt,
            delivery_date_gte=delivery_date_gte,
            delivery_date_lte=delivery_date_lte,
            request_options=request_options,
        )
        return _response.data

    def post_delivery_notes(
        self, *, request: Payload, request_options: typing.Optional[RequestOptions] = None
    ) -> DeliveryNoteResource:
        """
        Parameters
        ----------
        request : Payload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeliveryNoteResource
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import DeliveryNoteCreateRequest
        from monite import DeliveryNoteCreateLineItem
        from monite import DeliveryNoteLineItemProduct
        from monite import UnitRequest
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.delivery_notes.post_delivery_notes(request=DeliveryNoteCreateRequest(counterpart_address_id='a1b2c3d4-e5f6-g7h8-i9j0-k1l2m3n4o5p6', counterpart_id='a1b2c3d4-e5f6-g7h8-i9j0-k1l2m3n4o5p6', delivery_date='2025-01-01', delivery_number='102-2025-0987', display_signature_placeholder=True, line_items=[DeliveryNoteCreateLineItem(product_id='a1b2c3d4-e5f6-g7h8-i9j0-k1l2m3n4o5p6', quantity=10.0, ), DeliveryNoteCreateLineItem(product=DeliveryNoteLineItemProduct(description='Description of product 2', measure_unit=UnitRequest(description='pieces', name='pcs', ), name='Product 2', ), quantity=20.0, )], memo='This is a memo', ), )
        """
        _response = self._raw_client.post_delivery_notes(request=request, request_options=request_options)
        return _response.data

    def get_delivery_notes_id(
        self, delivery_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeliveryNoteResource:
        """
        Parameters
        ----------
        delivery_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeliveryNoteResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.delivery_notes.get_delivery_notes_id(delivery_note_id='delivery_note_id', )
        """
        _response = self._raw_client.get_delivery_notes_id(delivery_note_id, request_options=request_options)
        return _response.data

    def delete_delivery_notes_id(
        self, delivery_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        delivery_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.delivery_notes.delete_delivery_notes_id(delivery_note_id='delivery_note_id', )
        """
        _response = self._raw_client.delete_delivery_notes_id(delivery_note_id, request_options=request_options)
        return _response.data

    def patch_delivery_notes_id(
        self,
        delivery_note_id: str,
        *,
        counterpart_address_id: typing.Optional[str] = OMIT,
        counterpart_id: typing.Optional[str] = OMIT,
        delivery_date: typing.Optional[str] = OMIT,
        delivery_number: typing.Optional[str] = OMIT,
        display_signature_placeholder: typing.Optional[bool] = OMIT,
        line_items: typing.Optional[typing.Sequence[DeliveryNoteCreateLineItem]] = OMIT,
        memo: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeliveryNoteResource:
        """
        Parameters
        ----------
        delivery_note_id : str

        counterpart_address_id : typing.Optional[str]
            ID of the counterpart address selected for the delivery note

        counterpart_id : typing.Optional[str]
            ID of the counterpart

        delivery_date : typing.Optional[str]
            Date of delivery

        delivery_number : typing.Optional[str]
            Delivery number

        display_signature_placeholder : typing.Optional[bool]
            Whether to display a signature placeholder in the generated PDF

        line_items : typing.Optional[typing.Sequence[DeliveryNoteCreateLineItem]]
            List of line items in the delivery note

        memo : typing.Optional[str]
            Additional information regarding the delivery note

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeliveryNoteResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.delivery_notes.patch_delivery_notes_id(delivery_note_id='delivery_note_id', )
        """
        _response = self._raw_client.patch_delivery_notes_id(
            delivery_note_id,
            counterpart_address_id=counterpart_address_id,
            counterpart_id=counterpart_id,
            delivery_date=delivery_date,
            delivery_number=delivery_number,
            display_signature_placeholder=display_signature_placeholder,
            line_items=line_items,
            memo=memo,
            request_options=request_options,
        )
        return _response.data

    def post_delivery_notes_id_cancel(
        self, delivery_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeliveryNoteResource:
        """
        Parameters
        ----------
        delivery_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeliveryNoteResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.delivery_notes.post_delivery_notes_id_cancel(delivery_note_id='delivery_note_id', )
        """
        _response = self._raw_client.post_delivery_notes_id_cancel(delivery_note_id, request_options=request_options)
        return _response.data

    def post_delivery_notes_id_mark_as_delivered(
        self, delivery_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeliveryNoteResource:
        """
        Parameters
        ----------
        delivery_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeliveryNoteResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.delivery_notes.post_delivery_notes_id_mark_as_delivered(delivery_note_id='delivery_note_id', )
        """
        _response = self._raw_client.post_delivery_notes_id_mark_as_delivered(
            delivery_note_id, request_options=request_options
        )
        return _response.data


class AsyncDeliveryNotesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDeliveryNotesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDeliveryNotesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDeliveryNotesClient
        """
        return self._raw_client

    async def get_delivery_notes(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[DeliveryNoteCursorFields] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[DeliveryNoteStatusEnum] = None,
        status_in: typing.Optional[
            typing.Union[DeliveryNoteStatusEnum, typing.Sequence[DeliveryNoteStatusEnum]]
        ] = None,
        document_id: typing.Optional[str] = None,
        document_id_contains: typing.Optional[str] = None,
        document_id_icontains: typing.Optional[str] = None,
        created_by_entity_user_id: typing.Optional[str] = None,
        counterpart_id: typing.Optional[str] = None,
        based_on: typing.Optional[str] = None,
        based_on_document_id: typing.Optional[str] = None,
        based_on_document_id_contains: typing.Optional[str] = None,
        based_on_document_id_icontains: typing.Optional[str] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        delivery_date_gt: typing.Optional[str] = None,
        delivery_date_lt: typing.Optional[str] = None,
        delivery_date_gte: typing.Optional[str] = None,
        delivery_date_lte: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeliveryNoteResourceList:
        """
        Get all delivery notes with filtering and pagination.

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[DeliveryNoteCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        status : typing.Optional[DeliveryNoteStatusEnum]

        status_in : typing.Optional[typing.Union[DeliveryNoteStatusEnum, typing.Sequence[DeliveryNoteStatusEnum]]]

        document_id : typing.Optional[str]

        document_id_contains : typing.Optional[str]

        document_id_icontains : typing.Optional[str]

        created_by_entity_user_id : typing.Optional[str]

        counterpart_id : typing.Optional[str]

        based_on : typing.Optional[str]

        based_on_document_id : typing.Optional[str]

        based_on_document_id_contains : typing.Optional[str]

        based_on_document_id_icontains : typing.Optional[str]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        delivery_date_gt : typing.Optional[str]

        delivery_date_lt : typing.Optional[str]

        delivery_date_gte : typing.Optional[str]

        delivery_date_lte : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeliveryNoteResourceList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.delivery_notes.get_delivery_notes()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_delivery_notes(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            id_in=id_in,
            status=status,
            status_in=status_in,
            document_id=document_id,
            document_id_contains=document_id_contains,
            document_id_icontains=document_id_icontains,
            created_by_entity_user_id=created_by_entity_user_id,
            counterpart_id=counterpart_id,
            based_on=based_on,
            based_on_document_id=based_on_document_id,
            based_on_document_id_contains=based_on_document_id_contains,
            based_on_document_id_icontains=based_on_document_id_icontains,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            delivery_date_gt=delivery_date_gt,
            delivery_date_lt=delivery_date_lt,
            delivery_date_gte=delivery_date_gte,
            delivery_date_lte=delivery_date_lte,
            request_options=request_options,
        )
        return _response.data

    async def post_delivery_notes(
        self, *, request: Payload, request_options: typing.Optional[RequestOptions] = None
    ) -> DeliveryNoteResource:
        """
        Parameters
        ----------
        request : Payload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeliveryNoteResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import DeliveryNoteCreateRequest
        from monite import DeliveryNoteCreateLineItem
        from monite import DeliveryNoteLineItemProduct
        from monite import UnitRequest
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.delivery_notes.post_delivery_notes(request=DeliveryNoteCreateRequest(counterpart_address_id='a1b2c3d4-e5f6-g7h8-i9j0-k1l2m3n4o5p6', counterpart_id='a1b2c3d4-e5f6-g7h8-i9j0-k1l2m3n4o5p6', delivery_date='2025-01-01', delivery_number='102-2025-0987', display_signature_placeholder=True, line_items=[DeliveryNoteCreateLineItem(product_id='a1b2c3d4-e5f6-g7h8-i9j0-k1l2m3n4o5p6', quantity=10.0, ), DeliveryNoteCreateLineItem(product=DeliveryNoteLineItemProduct(description='Description of product 2', measure_unit=UnitRequest(description='pieces', name='pcs', ), name='Product 2', ), quantity=20.0, )], memo='This is a memo', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_delivery_notes(request=request, request_options=request_options)
        return _response.data

    async def get_delivery_notes_id(
        self, delivery_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeliveryNoteResource:
        """
        Parameters
        ----------
        delivery_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeliveryNoteResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.delivery_notes.get_delivery_notes_id(delivery_note_id='delivery_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_delivery_notes_id(delivery_note_id, request_options=request_options)
        return _response.data

    async def delete_delivery_notes_id(
        self, delivery_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        delivery_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.delivery_notes.delete_delivery_notes_id(delivery_note_id='delivery_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_delivery_notes_id(delivery_note_id, request_options=request_options)
        return _response.data

    async def patch_delivery_notes_id(
        self,
        delivery_note_id: str,
        *,
        counterpart_address_id: typing.Optional[str] = OMIT,
        counterpart_id: typing.Optional[str] = OMIT,
        delivery_date: typing.Optional[str] = OMIT,
        delivery_number: typing.Optional[str] = OMIT,
        display_signature_placeholder: typing.Optional[bool] = OMIT,
        line_items: typing.Optional[typing.Sequence[DeliveryNoteCreateLineItem]] = OMIT,
        memo: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeliveryNoteResource:
        """
        Parameters
        ----------
        delivery_note_id : str

        counterpart_address_id : typing.Optional[str]
            ID of the counterpart address selected for the delivery note

        counterpart_id : typing.Optional[str]
            ID of the counterpart

        delivery_date : typing.Optional[str]
            Date of delivery

        delivery_number : typing.Optional[str]
            Delivery number

        display_signature_placeholder : typing.Optional[bool]
            Whether to display a signature placeholder in the generated PDF

        line_items : typing.Optional[typing.Sequence[DeliveryNoteCreateLineItem]]
            List of line items in the delivery note

        memo : typing.Optional[str]
            Additional information regarding the delivery note

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeliveryNoteResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.delivery_notes.patch_delivery_notes_id(delivery_note_id='delivery_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.patch_delivery_notes_id(
            delivery_note_id,
            counterpart_address_id=counterpart_address_id,
            counterpart_id=counterpart_id,
            delivery_date=delivery_date,
            delivery_number=delivery_number,
            display_signature_placeholder=display_signature_placeholder,
            line_items=line_items,
            memo=memo,
            request_options=request_options,
        )
        return _response.data

    async def post_delivery_notes_id_cancel(
        self, delivery_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeliveryNoteResource:
        """
        Parameters
        ----------
        delivery_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeliveryNoteResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.delivery_notes.post_delivery_notes_id_cancel(delivery_note_id='delivery_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_delivery_notes_id_cancel(
            delivery_note_id, request_options=request_options
        )
        return _response.data

    async def post_delivery_notes_id_mark_as_delivered(
        self, delivery_note_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeliveryNoteResource:
        """
        Parameters
        ----------
        delivery_note_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeliveryNoteResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.delivery_notes.post_delivery_notes_id_mark_as_delivered(delivery_note_id='delivery_note_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_delivery_notes_id_mark_as_delivered(
            delivery_note_id, request_options=request_options
        )
        return _response.data
