# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.e_invoicing_retrieve_list_data import EInvoicingRetrieveListData
from ..types.einvoice_schema_type_enum import EinvoiceSchemaTypeEnum
from ..types.einvoicing_address import EinvoicingAddress
from ..types.einvoicing_connection_response import EinvoicingConnectionResponse
from ..types.einvoicing_network_credentials_response import EinvoicingNetworkCredentialsResponse
from .raw_client import AsyncRawEInvoicingConnectionsClient, RawEInvoicingConnectionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EInvoicingConnectionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEInvoicingConnectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEInvoicingConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEInvoicingConnectionsClient
        """
        return self._raw_client

    def get_einvoicing_connections(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EInvoicingRetrieveListData:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EInvoicingRetrieveListData
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.e_invoicing_connections.get_einvoicing_connections()
        """
        _response = self._raw_client.get_einvoicing_connections(request_options=request_options)
        return _response.data

    def post_einvoicing_connections(
        self,
        *,
        address: EinvoicingAddress,
        entity_vat_id_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EinvoicingConnectionResponse:
        """
        Parameters
        ----------
        address : EinvoicingAddress
            Integration Address

        entity_vat_id_id : typing.Optional[str]
            Entity VAT ID identifier for the integration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EinvoicingConnectionResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import EinvoicingAddress
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.e_invoicing_connections.post_einvoicing_connections(address=EinvoicingAddress(address_line1='address_line1', city='city', country="DE", postal_code='postal_code', ), )
        """
        _response = self._raw_client.post_einvoicing_connections(
            address=address, entity_vat_id_id=entity_vat_id_id, request_options=request_options
        )
        return _response.data

    def get_einvoicing_connections_id(
        self, einvoicing_connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EinvoicingConnectionResponse:
        """
        Parameters
        ----------
        einvoicing_connection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EinvoicingConnectionResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.e_invoicing_connections.get_einvoicing_connections_id(einvoicing_connection_id='einvoicing_connection_id', )
        """
        _response = self._raw_client.get_einvoicing_connections_id(
            einvoicing_connection_id, request_options=request_options
        )
        return _response.data

    def delete_einvoicing_connections_id(
        self, einvoicing_connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        einvoicing_connection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.e_invoicing_connections.delete_einvoicing_connections_id(einvoicing_connection_id='einvoicing_connection_id', )
        """
        _response = self._raw_client.delete_einvoicing_connections_id(
            einvoicing_connection_id, request_options=request_options
        )
        return _response.data

    def post_einvoicing_connections_id_network_credentials(
        self,
        einvoicing_connection_id: str,
        *,
        network_credentials_identifier: str,
        network_credentials_schema: EinvoiceSchemaTypeEnum,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EinvoicingNetworkCredentialsResponse:
        """
        Parameters
        ----------
        einvoicing_connection_id : str

        network_credentials_identifier : str
            Network participant identifier

        network_credentials_schema : EinvoiceSchemaTypeEnum
            Network scheme identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EinvoicingNetworkCredentialsResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.e_invoicing_connections.post_einvoicing_connections_id_network_credentials(einvoicing_connection_id='einvoicing_connection_id', network_credentials_identifier='12345678', network_credentials_schema="DE:VAT", )
        """
        _response = self._raw_client.post_einvoicing_connections_id_network_credentials(
            einvoicing_connection_id,
            network_credentials_identifier=network_credentials_identifier,
            network_credentials_schema=network_credentials_schema,
            request_options=request_options,
        )
        return _response.data


class AsyncEInvoicingConnectionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEInvoicingConnectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEInvoicingConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEInvoicingConnectionsClient
        """
        return self._raw_client

    async def get_einvoicing_connections(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EInvoicingRetrieveListData:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EInvoicingRetrieveListData
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.e_invoicing_connections.get_einvoicing_connections()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_einvoicing_connections(request_options=request_options)
        return _response.data

    async def post_einvoicing_connections(
        self,
        *,
        address: EinvoicingAddress,
        entity_vat_id_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EinvoicingConnectionResponse:
        """
        Parameters
        ----------
        address : EinvoicingAddress
            Integration Address

        entity_vat_id_id : typing.Optional[str]
            Entity VAT ID identifier for the integration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EinvoicingConnectionResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import EinvoicingAddress
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.e_invoicing_connections.post_einvoicing_connections(address=EinvoicingAddress(address_line1='address_line1', city='city', country="DE", postal_code='postal_code', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_einvoicing_connections(
            address=address, entity_vat_id_id=entity_vat_id_id, request_options=request_options
        )
        return _response.data

    async def get_einvoicing_connections_id(
        self, einvoicing_connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EinvoicingConnectionResponse:
        """
        Parameters
        ----------
        einvoicing_connection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EinvoicingConnectionResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.e_invoicing_connections.get_einvoicing_connections_id(einvoicing_connection_id='einvoicing_connection_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_einvoicing_connections_id(
            einvoicing_connection_id, request_options=request_options
        )
        return _response.data

    async def delete_einvoicing_connections_id(
        self, einvoicing_connection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        einvoicing_connection_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.e_invoicing_connections.delete_einvoicing_connections_id(einvoicing_connection_id='einvoicing_connection_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_einvoicing_connections_id(
            einvoicing_connection_id, request_options=request_options
        )
        return _response.data

    async def post_einvoicing_connections_id_network_credentials(
        self,
        einvoicing_connection_id: str,
        *,
        network_credentials_identifier: str,
        network_credentials_schema: EinvoiceSchemaTypeEnum,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EinvoicingNetworkCredentialsResponse:
        """
        Parameters
        ----------
        einvoicing_connection_id : str

        network_credentials_identifier : str
            Network participant identifier

        network_credentials_schema : EinvoiceSchemaTypeEnum
            Network scheme identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EinvoicingNetworkCredentialsResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.e_invoicing_connections.post_einvoicing_connections_id_network_credentials(einvoicing_connection_id='einvoicing_connection_id', network_credentials_identifier='12345678', network_credentials_schema="DE:VAT", )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_einvoicing_connections_id_network_credentials(
            einvoicing_connection_id,
            network_credentials_identifier=network_credentials_identifier,
            network_credentials_schema=network_credentials_schema,
            request_options=request_options,
        )
        return _response.data
