# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .. import core
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.accounting_settings import AccountingSettings
from ..types.currency_settings_input import CurrencySettingsInput
from ..types.document_i_ds_settings_request import DocumentIDsSettingsRequest
from ..types.document_rendering_settings import DocumentRenderingSettings
from ..types.entity_address_schema import EntityAddressSchema
from ..types.entity_cursor_fields import EntityCursorFields
from ..types.entity_pagination_response import EntityPaginationResponse
from ..types.entity_response import EntityResponse
from ..types.entity_status_enum import EntityStatusEnum
from ..types.entity_type_enum import EntityTypeEnum
from ..types.file_schema2 import FileSchema2
from ..types.get_onboarding_requirements_response import GetOnboardingRequirementsResponse
from ..types.individual_schema import IndividualSchema
from ..types.language_code_enum import LanguageCodeEnum
from ..types.ocr_auto_tagging_settings_request import OcrAutoTaggingSettingsRequest
from ..types.optional_individual_schema import OptionalIndividualSchema
from ..types.optional_organization_schema import OptionalOrganizationSchema
from ..types.order_enum import OrderEnum
from ..types.organization_schema import OrganizationSchema
from ..types.partner_metadata_response import PartnerMetadataResponse
from ..types.payment_priority_enum import PaymentPriorityEnum
from ..types.receivable_edit_flow import ReceivableEditFlow
from ..types.reminders_settings import RemindersSettings
from ..types.settings_response import SettingsResponse
from ..types.update_entity_address_schema import UpdateEntityAddressSchema
from ..types.vat_mode_enum import VatModeEnum
from .bank_accounts.client import AsyncBankAccountsClient, BankAccountsClient
from .onboarding_data.client import AsyncOnboardingDataClient, OnboardingDataClient
from .payment_methods.client import AsyncPaymentMethodsClient, PaymentMethodsClient
from .persons.client import AsyncPersonsClient, PersonsClient
from .raw_client import AsyncRawEntitiesClient, RawEntitiesClient
from .vat_ids.client import AsyncVatIdsClient, VatIdsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EntitiesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEntitiesClient(client_wrapper=client_wrapper)
        self.bank_accounts = BankAccountsClient(client_wrapper=client_wrapper)

        self.onboarding_data = OnboardingDataClient(client_wrapper=client_wrapper)

        self.payment_methods = PaymentMethodsClient(client_wrapper=client_wrapper)

        self.vat_ids = VatIdsClient(client_wrapper=client_wrapper)

        self.persons = PersonsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEntitiesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEntitiesClient
        """
        return self._raw_client

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[EntityCursorFields] = None,
        type: typing.Optional[EntityTypeEnum] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        id_not_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        email: typing.Optional[str] = None,
        email_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        email_not_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[EntityStatusEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityPaginationResponse:
        """
        Retrieve a list of all entities.

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[EntityCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        type : typing.Optional[EntityTypeEnum]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        id_not_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        email : typing.Optional[str]

        email_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        email_not_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        status : typing.Optional[EntityStatusEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityPaginationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.get()
        """
        _response = self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            type=type,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            id_in=id_in,
            id_not_in=id_not_in,
            email=email,
            email_in=email_in,
            email_not_in=email_not_in,
            status=status,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        address: EntityAddressSchema,
        email: str,
        type: EntityTypeEnum,
        phone: typing.Optional[str] = OMIT,
        website: typing.Optional[str] = OMIT,
        organization: typing.Optional[OrganizationSchema] = OMIT,
        individual: typing.Optional[IndividualSchema] = OMIT,
        tax_id: typing.Optional[str] = OMIT,
        registration_number: typing.Optional[str] = OMIT,
        registration_authority: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityResponse:
        """
        Create a new entity from the specified values.

        Parameters
        ----------
        address : EntityAddressSchema
            An address description of the entity

        email : str
            An official email address of the entity

        type : EntityTypeEnum
            A type for an entity

        phone : typing.Optional[str]
            The contact phone number of the entity. Required for US organizations to use payments.

        website : typing.Optional[str]
            A website of the entity

        organization : typing.Optional[OrganizationSchema]
            A set of meta data describing the organization

        individual : typing.Optional[IndividualSchema]
            A set of meta data describing the individual

        tax_id : typing.Optional[str]
            The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.

        registration_number : typing.Optional[str]
            (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.

        registration_authority : typing.Optional[str]
            (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import EntityAddressSchema
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.create(address=EntityAddressSchema(city='city', country="AF", line1='line1', postal_code='postal_code', ), email='email', type="individual", )
        """
        _response = self._raw_client.create(
            address=address,
            email=email,
            type=type,
            phone=phone,
            website=website,
            organization=organization,
            individual=individual,
            tax_id=tax_id,
            registration_number=registration_number,
            registration_authority=registration_authority,
            request_options=request_options,
        )
        return _response.data

    def get_entities_me(self, *, request_options: typing.Optional[RequestOptions] = None) -> EntityResponse:
        """
        Deprecated. Use `GET /entity_users/my_entity` instead.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.get_entities_me()
        """
        _response = self._raw_client.get_entities_me(request_options=request_options)
        return _response.data

    def patch_entities_me(
        self,
        *,
        address: typing.Optional[UpdateEntityAddressSchema] = OMIT,
        email: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        website: typing.Optional[str] = OMIT,
        tax_id: typing.Optional[str] = OMIT,
        registration_number: typing.Optional[str] = OMIT,
        registration_authority: typing.Optional[str] = OMIT,
        organization: typing.Optional[OptionalOrganizationSchema] = OMIT,
        individual: typing.Optional[OptionalIndividualSchema] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityResponse:
        """
        Deprecated. Use `PATCH /entity_users/my_entity` instead.

        Parameters
        ----------
        address : typing.Optional[UpdateEntityAddressSchema]
            An address description of the entity

        email : typing.Optional[str]
            An official email address of the entity

        phone : typing.Optional[str]
            The contact phone number of the entity. Required for US organizations to use payments.

        website : typing.Optional[str]
            A website of the entity

        tax_id : typing.Optional[str]
            The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.

        registration_number : typing.Optional[str]
            (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.

        registration_authority : typing.Optional[str]
            (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.

        organization : typing.Optional[OptionalOrganizationSchema]
            A set of meta data describing the organization

        individual : typing.Optional[OptionalIndividualSchema]
            A set of meta data describing the individual

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.patch_entities_me()
        """
        _response = self._raw_client.patch_entities_me(
            address=address,
            email=email,
            phone=phone,
            website=website,
            tax_id=tax_id,
            registration_number=registration_number,
            registration_authority=registration_authority,
            organization=organization,
            individual=individual,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> EntityResponse:
        """
        Retrieve an entity by its ID.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.get_by_id(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        """
        _response = self._raw_client.get_by_id(entity_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        entity_id: str,
        *,
        address: typing.Optional[UpdateEntityAddressSchema] = OMIT,
        email: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        website: typing.Optional[str] = OMIT,
        tax_id: typing.Optional[str] = OMIT,
        registration_number: typing.Optional[str] = OMIT,
        registration_authority: typing.Optional[str] = OMIT,
        organization: typing.Optional[OptionalOrganizationSchema] = OMIT,
        individual: typing.Optional[OptionalIndividualSchema] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityResponse:
        """
        Change the specified fields with the provided values.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        address : typing.Optional[UpdateEntityAddressSchema]
            An address description of the entity

        email : typing.Optional[str]
            An official email address of the entity

        phone : typing.Optional[str]
            The contact phone number of the entity. Required for US organizations to use payments.

        website : typing.Optional[str]
            A website of the entity

        tax_id : typing.Optional[str]
            The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.

        registration_number : typing.Optional[str]
            (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.

        registration_authority : typing.Optional[str]
            (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.

        organization : typing.Optional[OptionalOrganizationSchema]
            A set of meta data describing the organization

        individual : typing.Optional[OptionalIndividualSchema]
            A set of meta data describing the individual

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.update_by_id(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        """
        _response = self._raw_client.update_by_id(
            entity_id,
            address=address,
            email=email,
            phone=phone,
            website=website,
            tax_id=tax_id,
            registration_number=registration_number,
            registration_authority=registration_authority,
            organization=organization,
            individual=individual,
            request_options=request_options,
        )
        return _response.data

    def post_entities_id_activate(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EntityResponse:
        """
        Activate an entity to allow it to perform any operations.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.post_entities_id_activate(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        """
        _response = self._raw_client.post_entities_id_activate(entity_id, request_options=request_options)
        return _response.data

    def post_entities_id_deactivate(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EntityResponse:
        """
        Deactivate an entity to stop it from performing any operations.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.post_entities_id_deactivate(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        """
        _response = self._raw_client.post_entities_id_deactivate(entity_id, request_options=request_options)
        return _response.data

    def upload_logo_by_id(
        self, entity_id: str, *, file: core.File, request_options: typing.Optional[RequestOptions] = None
    ) -> FileSchema2:
        """
        Entity logo can be PNG, JPG, or GIF, up to 10 MB in size. The logo is used, for example, in PDF documents created by this entity.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        file : core.File
            See core.File for more documentation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileSchema2
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.upload_logo_by_id(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        """
        _response = self._raw_client.upload_logo_by_id(entity_id, file=file, request_options=request_options)
        return _response.data

    def delete_logo_by_id(self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.delete_logo_by_id(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        """
        _response = self._raw_client.delete_logo_by_id(entity_id, request_options=request_options)
        return _response.data

    def get_partner_metadata_by_id(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PartnerMetadataResponse:
        """
        Retrieve a metadata object associated with this entity, usually in a JSON format.

        Parameters
        ----------
        entity_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PartnerMetadataResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.get_partner_metadata_by_id(entity_id='entity_id', )
        """
        _response = self._raw_client.get_partner_metadata_by_id(entity_id, request_options=request_options)
        return _response.data

    def update_partner_metadata_by_id(
        self,
        entity_id: str,
        *,
        metadata: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PartnerMetadataResponse:
        """
        Fully replace the current metadata object with the specified instance.

        Parameters
        ----------
        entity_id : str

        metadata : typing.Dict[str, typing.Optional[typing.Any]]
            Metadata for partner needs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PartnerMetadataResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.update_partner_metadata_by_id(entity_id='entity_id', metadata={'key': 'value'
        }, )
        """
        _response = self._raw_client.update_partner_metadata_by_id(
            entity_id, metadata=metadata, request_options=request_options
        )
        return _response.data

    def get_settings_by_id(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SettingsResponse:
        """
        Retrieve all settings for this entity.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SettingsResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.get_settings_by_id(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        """
        _response = self._raw_client.get_settings_by_id(entity_id, request_options=request_options)
        return _response.data

    def update_settings_by_id(
        self,
        entity_id: str,
        *,
        language: typing.Optional[LanguageCodeEnum] = OMIT,
        currency: typing.Optional[CurrencySettingsInput] = OMIT,
        reminder: typing.Optional[RemindersSettings] = OMIT,
        vat_mode: typing.Optional[VatModeEnum] = OMIT,
        vat_inclusive_discount_mode: typing.Optional[VatModeEnum] = OMIT,
        payment_priority: typing.Optional[PaymentPriorityEnum] = OMIT,
        allow_purchase_order_autolinking: typing.Optional[bool] = OMIT,
        receivable_edit_flow: typing.Optional[ReceivableEditFlow] = OMIT,
        document_ids: typing.Optional[DocumentIDsSettingsRequest] = OMIT,
        payables_ocr_auto_tagging: typing.Optional[typing.Sequence[OcrAutoTaggingSettingsRequest]] = OMIT,
        quote_signature_required: typing.Optional[bool] = OMIT,
        generate_paid_invoice_pdf: typing.Optional[bool] = OMIT,
        accounting: typing.Optional[AccountingSettings] = OMIT,
        payables_skip_approval_flow: typing.Optional[bool] = OMIT,
        document_rendering: typing.Optional[DocumentRenderingSettings] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SettingsResponse:
        """
        Change the specified fields with the provided values.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        language : typing.Optional[LanguageCodeEnum]

        currency : typing.Optional[CurrencySettingsInput]

        reminder : typing.Optional[RemindersSettings]

        vat_mode : typing.Optional[VatModeEnum]
            Defines whether the prices of products in receivables will already include VAT or not.

        vat_inclusive_discount_mode : typing.Optional[VatModeEnum]
            Defines whether the amount discounts (for percentage discounts it does not matter) on VAT inclusive invoices will be applied on amounts including VAT or excluding VAT.

        payment_priority : typing.Optional[PaymentPriorityEnum]
            Payment preferences for entity to automate calculating suggested payment date based on payment terms and entity preferences.

        allow_purchase_order_autolinking : typing.Optional[bool]
            Automatically attempt to find a corresponding purchase order for all incoming payables.

        receivable_edit_flow : typing.Optional[ReceivableEditFlow]

        document_ids : typing.Optional[DocumentIDsSettingsRequest]

        payables_ocr_auto_tagging : typing.Optional[typing.Sequence[OcrAutoTaggingSettingsRequest]]
            Auto tagging settings for all incoming OCR payable documents.

        quote_signature_required : typing.Optional[bool]
            Sets the default behavior of whether a signature is required to accept quotes.

        generate_paid_invoice_pdf : typing.Optional[bool]
            This setting affects how PDF is generated for paid accounts receivable invoices. If set to `true`, once an invoice is fully paid its PDF version is updated to display the amount paid and the payment-related features are removed.

            The PDF file gets regenerated at the moment when an invoice becomes paid. It is not issued as a separate document, and the original PDF invoice is no longer available.

            This field is deprecated and will be replaced by `document_rendering.invoice.generate_paid_invoice_pdf`.

        accounting : typing.Optional[AccountingSettings]

        payables_skip_approval_flow : typing.Optional[bool]
            If enabled, the approval policy will be skipped and the payable will be moved to `waiting_to_be_paid` status.

        document_rendering : typing.Optional[DocumentRenderingSettings]
            Settings for rendering documents in PDF format.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SettingsResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.update_settings_by_id(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        """
        _response = self._raw_client.update_settings_by_id(
            entity_id,
            language=language,
            currency=currency,
            reminder=reminder,
            vat_mode=vat_mode,
            vat_inclusive_discount_mode=vat_inclusive_discount_mode,
            payment_priority=payment_priority,
            allow_purchase_order_autolinking=allow_purchase_order_autolinking,
            receivable_edit_flow=receivable_edit_flow,
            document_ids=document_ids,
            payables_ocr_auto_tagging=payables_ocr_auto_tagging,
            quote_signature_required=quote_signature_required,
            generate_paid_invoice_pdf=generate_paid_invoice_pdf,
            accounting=accounting,
            payables_skip_approval_flow=payables_skip_approval_flow,
            document_rendering=document_rendering,
            request_options=request_options,
        )
        return _response.data

    def upload_onboarding_documents(
        self,
        *,
        additional_verification_document_back: typing.Optional[str] = OMIT,
        additional_verification_document_front: typing.Optional[str] = OMIT,
        bank_account_ownership_verification: typing.Optional[typing.Sequence[str]] = OMIT,
        company_license: typing.Optional[typing.Sequence[str]] = OMIT,
        company_memorandum_of_association: typing.Optional[typing.Sequence[str]] = OMIT,
        company_ministerial_decree: typing.Optional[typing.Sequence[str]] = OMIT,
        company_registration_verification: typing.Optional[typing.Sequence[str]] = OMIT,
        company_tax_id_verification: typing.Optional[typing.Sequence[str]] = OMIT,
        proof_of_registration: typing.Optional[typing.Sequence[str]] = OMIT,
        verification_document_back: typing.Optional[str] = OMIT,
        verification_document_front: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Provide files for entity onboarding verification

        Parameters
        ----------
        additional_verification_document_back : typing.Optional[str]

        additional_verification_document_front : typing.Optional[str]

        bank_account_ownership_verification : typing.Optional[typing.Sequence[str]]

        company_license : typing.Optional[typing.Sequence[str]]

        company_memorandum_of_association : typing.Optional[typing.Sequence[str]]

        company_ministerial_decree : typing.Optional[typing.Sequence[str]]

        company_registration_verification : typing.Optional[typing.Sequence[str]]

        company_tax_id_verification : typing.Optional[typing.Sequence[str]]

        proof_of_registration : typing.Optional[typing.Sequence[str]]

        verification_document_back : typing.Optional[str]

        verification_document_front : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.upload_onboarding_documents()
        """
        _response = self._raw_client.upload_onboarding_documents(
            additional_verification_document_back=additional_verification_document_back,
            additional_verification_document_front=additional_verification_document_front,
            bank_account_ownership_verification=bank_account_ownership_verification,
            company_license=company_license,
            company_memorandum_of_association=company_memorandum_of_association,
            company_ministerial_decree=company_ministerial_decree,
            company_registration_verification=company_registration_verification,
            company_tax_id_verification=company_tax_id_verification,
            proof_of_registration=proof_of_registration,
            verification_document_back=verification_document_back,
            verification_document_front=verification_document_front,
            request_options=request_options,
        )
        return _response.data

    def get_onboarding_requirements(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetOnboardingRequirementsResponse:
        """
        Get onboarding requirements for the entity

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOnboardingRequirementsResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.get_onboarding_requirements()
        """
        _response = self._raw_client.get_onboarding_requirements(request_options=request_options)
        return _response.data


class AsyncEntitiesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEntitiesClient(client_wrapper=client_wrapper)
        self.bank_accounts = AsyncBankAccountsClient(client_wrapper=client_wrapper)

        self.onboarding_data = AsyncOnboardingDataClient(client_wrapper=client_wrapper)

        self.payment_methods = AsyncPaymentMethodsClient(client_wrapper=client_wrapper)

        self.vat_ids = AsyncVatIdsClient(client_wrapper=client_wrapper)

        self.persons = AsyncPersonsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEntitiesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEntitiesClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[EntityCursorFields] = None,
        type: typing.Optional[EntityTypeEnum] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        id_not_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        email: typing.Optional[str] = None,
        email_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        email_not_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[EntityStatusEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityPaginationResponse:
        """
        Retrieve a list of all entities.

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[EntityCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        type : typing.Optional[EntityTypeEnum]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        id_not_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        email : typing.Optional[str]

        email_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        email_not_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        status : typing.Optional[EntityStatusEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityPaginationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            type=type,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            id_in=id_in,
            id_not_in=id_not_in,
            email=email,
            email_in=email_in,
            email_not_in=email_not_in,
            status=status,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        address: EntityAddressSchema,
        email: str,
        type: EntityTypeEnum,
        phone: typing.Optional[str] = OMIT,
        website: typing.Optional[str] = OMIT,
        organization: typing.Optional[OrganizationSchema] = OMIT,
        individual: typing.Optional[IndividualSchema] = OMIT,
        tax_id: typing.Optional[str] = OMIT,
        registration_number: typing.Optional[str] = OMIT,
        registration_authority: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityResponse:
        """
        Create a new entity from the specified values.

        Parameters
        ----------
        address : EntityAddressSchema
            An address description of the entity

        email : str
            An official email address of the entity

        type : EntityTypeEnum
            A type for an entity

        phone : typing.Optional[str]
            The contact phone number of the entity. Required for US organizations to use payments.

        website : typing.Optional[str]
            A website of the entity

        organization : typing.Optional[OrganizationSchema]
            A set of meta data describing the organization

        individual : typing.Optional[IndividualSchema]
            A set of meta data describing the individual

        tax_id : typing.Optional[str]
            The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.

        registration_number : typing.Optional[str]
            (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.

        registration_authority : typing.Optional[str]
            (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import EntityAddressSchema
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.create(address=EntityAddressSchema(city='city', country="AF", line1='line1', postal_code='postal_code', ), email='email', type="individual", )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            address=address,
            email=email,
            type=type,
            phone=phone,
            website=website,
            organization=organization,
            individual=individual,
            tax_id=tax_id,
            registration_number=registration_number,
            registration_authority=registration_authority,
            request_options=request_options,
        )
        return _response.data

    async def get_entities_me(self, *, request_options: typing.Optional[RequestOptions] = None) -> EntityResponse:
        """
        Deprecated. Use `GET /entity_users/my_entity` instead.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.get_entities_me()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_entities_me(request_options=request_options)
        return _response.data

    async def patch_entities_me(
        self,
        *,
        address: typing.Optional[UpdateEntityAddressSchema] = OMIT,
        email: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        website: typing.Optional[str] = OMIT,
        tax_id: typing.Optional[str] = OMIT,
        registration_number: typing.Optional[str] = OMIT,
        registration_authority: typing.Optional[str] = OMIT,
        organization: typing.Optional[OptionalOrganizationSchema] = OMIT,
        individual: typing.Optional[OptionalIndividualSchema] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityResponse:
        """
        Deprecated. Use `PATCH /entity_users/my_entity` instead.

        Parameters
        ----------
        address : typing.Optional[UpdateEntityAddressSchema]
            An address description of the entity

        email : typing.Optional[str]
            An official email address of the entity

        phone : typing.Optional[str]
            The contact phone number of the entity. Required for US organizations to use payments.

        website : typing.Optional[str]
            A website of the entity

        tax_id : typing.Optional[str]
            The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.

        registration_number : typing.Optional[str]
            (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.

        registration_authority : typing.Optional[str]
            (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.

        organization : typing.Optional[OptionalOrganizationSchema]
            A set of meta data describing the organization

        individual : typing.Optional[OptionalIndividualSchema]
            A set of meta data describing the individual

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.patch_entities_me()
        asyncio.run(main())
        """
        _response = await self._raw_client.patch_entities_me(
            address=address,
            email=email,
            phone=phone,
            website=website,
            tax_id=tax_id,
            registration_number=registration_number,
            registration_authority=registration_authority,
            organization=organization,
            individual=individual,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EntityResponse:
        """
        Retrieve an entity by its ID.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.get_by_id(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(entity_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        entity_id: str,
        *,
        address: typing.Optional[UpdateEntityAddressSchema] = OMIT,
        email: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        website: typing.Optional[str] = OMIT,
        tax_id: typing.Optional[str] = OMIT,
        registration_number: typing.Optional[str] = OMIT,
        registration_authority: typing.Optional[str] = OMIT,
        organization: typing.Optional[OptionalOrganizationSchema] = OMIT,
        individual: typing.Optional[OptionalIndividualSchema] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityResponse:
        """
        Change the specified fields with the provided values.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        address : typing.Optional[UpdateEntityAddressSchema]
            An address description of the entity

        email : typing.Optional[str]
            An official email address of the entity

        phone : typing.Optional[str]
            The contact phone number of the entity. Required for US organizations to use payments.

        website : typing.Optional[str]
            A website of the entity

        tax_id : typing.Optional[str]
            The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.

        registration_number : typing.Optional[str]
            (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.

        registration_authority : typing.Optional[str]
            (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.

        organization : typing.Optional[OptionalOrganizationSchema]
            A set of meta data describing the organization

        individual : typing.Optional[OptionalIndividualSchema]
            A set of meta data describing the individual

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.update_by_id(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            entity_id,
            address=address,
            email=email,
            phone=phone,
            website=website,
            tax_id=tax_id,
            registration_number=registration_number,
            registration_authority=registration_authority,
            organization=organization,
            individual=individual,
            request_options=request_options,
        )
        return _response.data

    async def post_entities_id_activate(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EntityResponse:
        """
        Activate an entity to allow it to perform any operations.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.post_entities_id_activate(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_entities_id_activate(entity_id, request_options=request_options)
        return _response.data

    async def post_entities_id_deactivate(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EntityResponse:
        """
        Deactivate an entity to stop it from performing any operations.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.post_entities_id_deactivate(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_entities_id_deactivate(entity_id, request_options=request_options)
        return _response.data

    async def upload_logo_by_id(
        self, entity_id: str, *, file: core.File, request_options: typing.Optional[RequestOptions] = None
    ) -> FileSchema2:
        """
        Entity logo can be PNG, JPG, or GIF, up to 10 MB in size. The logo is used, for example, in PDF documents created by this entity.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        file : core.File
            See core.File for more documentation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileSchema2
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.upload_logo_by_id(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        asyncio.run(main())
        """
        _response = await self._raw_client.upload_logo_by_id(entity_id, file=file, request_options=request_options)
        return _response.data

    async def delete_logo_by_id(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.delete_logo_by_id(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_logo_by_id(entity_id, request_options=request_options)
        return _response.data

    async def get_partner_metadata_by_id(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PartnerMetadataResponse:
        """
        Retrieve a metadata object associated with this entity, usually in a JSON format.

        Parameters
        ----------
        entity_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PartnerMetadataResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.get_partner_metadata_by_id(entity_id='entity_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_partner_metadata_by_id(entity_id, request_options=request_options)
        return _response.data

    async def update_partner_metadata_by_id(
        self,
        entity_id: str,
        *,
        metadata: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PartnerMetadataResponse:
        """
        Fully replace the current metadata object with the specified instance.

        Parameters
        ----------
        entity_id : str

        metadata : typing.Dict[str, typing.Optional[typing.Any]]
            Metadata for partner needs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PartnerMetadataResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.update_partner_metadata_by_id(entity_id='entity_id', metadata={'key': 'value'
            }, )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_partner_metadata_by_id(
            entity_id, metadata=metadata, request_options=request_options
        )
        return _response.data

    async def get_settings_by_id(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SettingsResponse:
        """
        Retrieve all settings for this entity.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SettingsResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.get_settings_by_id(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_settings_by_id(entity_id, request_options=request_options)
        return _response.data

    async def update_settings_by_id(
        self,
        entity_id: str,
        *,
        language: typing.Optional[LanguageCodeEnum] = OMIT,
        currency: typing.Optional[CurrencySettingsInput] = OMIT,
        reminder: typing.Optional[RemindersSettings] = OMIT,
        vat_mode: typing.Optional[VatModeEnum] = OMIT,
        vat_inclusive_discount_mode: typing.Optional[VatModeEnum] = OMIT,
        payment_priority: typing.Optional[PaymentPriorityEnum] = OMIT,
        allow_purchase_order_autolinking: typing.Optional[bool] = OMIT,
        receivable_edit_flow: typing.Optional[ReceivableEditFlow] = OMIT,
        document_ids: typing.Optional[DocumentIDsSettingsRequest] = OMIT,
        payables_ocr_auto_tagging: typing.Optional[typing.Sequence[OcrAutoTaggingSettingsRequest]] = OMIT,
        quote_signature_required: typing.Optional[bool] = OMIT,
        generate_paid_invoice_pdf: typing.Optional[bool] = OMIT,
        accounting: typing.Optional[AccountingSettings] = OMIT,
        payables_skip_approval_flow: typing.Optional[bool] = OMIT,
        document_rendering: typing.Optional[DocumentRenderingSettings] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SettingsResponse:
        """
        Change the specified fields with the provided values.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        language : typing.Optional[LanguageCodeEnum]

        currency : typing.Optional[CurrencySettingsInput]

        reminder : typing.Optional[RemindersSettings]

        vat_mode : typing.Optional[VatModeEnum]
            Defines whether the prices of products in receivables will already include VAT or not.

        vat_inclusive_discount_mode : typing.Optional[VatModeEnum]
            Defines whether the amount discounts (for percentage discounts it does not matter) on VAT inclusive invoices will be applied on amounts including VAT or excluding VAT.

        payment_priority : typing.Optional[PaymentPriorityEnum]
            Payment preferences for entity to automate calculating suggested payment date based on payment terms and entity preferences.

        allow_purchase_order_autolinking : typing.Optional[bool]
            Automatically attempt to find a corresponding purchase order for all incoming payables.

        receivable_edit_flow : typing.Optional[ReceivableEditFlow]

        document_ids : typing.Optional[DocumentIDsSettingsRequest]

        payables_ocr_auto_tagging : typing.Optional[typing.Sequence[OcrAutoTaggingSettingsRequest]]
            Auto tagging settings for all incoming OCR payable documents.

        quote_signature_required : typing.Optional[bool]
            Sets the default behavior of whether a signature is required to accept quotes.

        generate_paid_invoice_pdf : typing.Optional[bool]
            This setting affects how PDF is generated for paid accounts receivable invoices. If set to `true`, once an invoice is fully paid its PDF version is updated to display the amount paid and the payment-related features are removed.

            The PDF file gets regenerated at the moment when an invoice becomes paid. It is not issued as a separate document, and the original PDF invoice is no longer available.

            This field is deprecated and will be replaced by `document_rendering.invoice.generate_paid_invoice_pdf`.

        accounting : typing.Optional[AccountingSettings]

        payables_skip_approval_flow : typing.Optional[bool]
            If enabled, the approval policy will be skipped and the payable will be moved to `waiting_to_be_paid` status.

        document_rendering : typing.Optional[DocumentRenderingSettings]
            Settings for rendering documents in PDF format.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SettingsResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.update_settings_by_id(entity_id='ea837e28-509b-4b6a-a600-d54b6aa0b1f5', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_settings_by_id(
            entity_id,
            language=language,
            currency=currency,
            reminder=reminder,
            vat_mode=vat_mode,
            vat_inclusive_discount_mode=vat_inclusive_discount_mode,
            payment_priority=payment_priority,
            allow_purchase_order_autolinking=allow_purchase_order_autolinking,
            receivable_edit_flow=receivable_edit_flow,
            document_ids=document_ids,
            payables_ocr_auto_tagging=payables_ocr_auto_tagging,
            quote_signature_required=quote_signature_required,
            generate_paid_invoice_pdf=generate_paid_invoice_pdf,
            accounting=accounting,
            payables_skip_approval_flow=payables_skip_approval_flow,
            document_rendering=document_rendering,
            request_options=request_options,
        )
        return _response.data

    async def upload_onboarding_documents(
        self,
        *,
        additional_verification_document_back: typing.Optional[str] = OMIT,
        additional_verification_document_front: typing.Optional[str] = OMIT,
        bank_account_ownership_verification: typing.Optional[typing.Sequence[str]] = OMIT,
        company_license: typing.Optional[typing.Sequence[str]] = OMIT,
        company_memorandum_of_association: typing.Optional[typing.Sequence[str]] = OMIT,
        company_ministerial_decree: typing.Optional[typing.Sequence[str]] = OMIT,
        company_registration_verification: typing.Optional[typing.Sequence[str]] = OMIT,
        company_tax_id_verification: typing.Optional[typing.Sequence[str]] = OMIT,
        proof_of_registration: typing.Optional[typing.Sequence[str]] = OMIT,
        verification_document_back: typing.Optional[str] = OMIT,
        verification_document_front: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Provide files for entity onboarding verification

        Parameters
        ----------
        additional_verification_document_back : typing.Optional[str]

        additional_verification_document_front : typing.Optional[str]

        bank_account_ownership_verification : typing.Optional[typing.Sequence[str]]

        company_license : typing.Optional[typing.Sequence[str]]

        company_memorandum_of_association : typing.Optional[typing.Sequence[str]]

        company_ministerial_decree : typing.Optional[typing.Sequence[str]]

        company_registration_verification : typing.Optional[typing.Sequence[str]]

        company_tax_id_verification : typing.Optional[typing.Sequence[str]]

        proof_of_registration : typing.Optional[typing.Sequence[str]]

        verification_document_back : typing.Optional[str]

        verification_document_front : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.upload_onboarding_documents()
        asyncio.run(main())
        """
        _response = await self._raw_client.upload_onboarding_documents(
            additional_verification_document_back=additional_verification_document_back,
            additional_verification_document_front=additional_verification_document_front,
            bank_account_ownership_verification=bank_account_ownership_verification,
            company_license=company_license,
            company_memorandum_of_association=company_memorandum_of_association,
            company_ministerial_decree=company_ministerial_decree,
            company_registration_verification=company_registration_verification,
            company_tax_id_verification=company_tax_id_verification,
            proof_of_registration=proof_of_registration,
            verification_document_back=verification_document_back,
            verification_document_front=verification_document_front,
            request_options=request_options,
        )
        return _response.data

    async def get_onboarding_requirements(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetOnboardingRequirementsResponse:
        """
        Get onboarding requirements for the entity

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetOnboardingRequirementsResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.get_onboarding_requirements()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_onboarding_requirements(request_options=request_options)
        return _response.data
