# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.business_profile_input import BusinessProfileInput
from ...types.entity_onboarding_data_response import EntityOnboardingDataResponse
from ...types.ownership_declaration_input import OwnershipDeclarationInput
from ...types.terms_of_service_acceptance_input import TermsOfServiceAcceptanceInput
from .raw_client import AsyncRawOnboardingDataClient, RawOnboardingDataClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OnboardingDataClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawOnboardingDataClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawOnboardingDataClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawOnboardingDataClient
        """
        return self._raw_client

    def get(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EntityOnboardingDataResponse:
        """
        Parameters
        ----------
        entity_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityOnboardingDataResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.onboarding_data.get(entity_id='entity_id', )
        """
        _response = self._raw_client.get(entity_id, request_options=request_options)
        return _response.data

    def update(
        self,
        entity_id: str,
        *,
        business_profile: typing.Optional[BusinessProfileInput] = OMIT,
        ownership_declaration: typing.Optional[OwnershipDeclarationInput] = OMIT,
        tos_acceptance: typing.Optional[TermsOfServiceAcceptanceInput] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityOnboardingDataResponse:
        """
        Parameters
        ----------
        entity_id : str

        business_profile : typing.Optional[BusinessProfileInput]
            Business information about the entity.

        ownership_declaration : typing.Optional[OwnershipDeclarationInput]
            Used to attest that the beneficial owner information provided is both current and correct.

        tos_acceptance : typing.Optional[TermsOfServiceAcceptanceInput]
            Details on the entity's acceptance of the service agreement.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityOnboardingDataResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.onboarding_data.update(entity_id='entity_id', )
        """
        _response = self._raw_client.update(
            entity_id,
            business_profile=business_profile,
            ownership_declaration=ownership_declaration,
            tos_acceptance=tos_acceptance,
            request_options=request_options,
        )
        return _response.data


class AsyncOnboardingDataClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawOnboardingDataClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawOnboardingDataClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawOnboardingDataClient
        """
        return self._raw_client

    async def get(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EntityOnboardingDataResponse:
        """
        Parameters
        ----------
        entity_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityOnboardingDataResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.onboarding_data.get(entity_id='entity_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(entity_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        entity_id: str,
        *,
        business_profile: typing.Optional[BusinessProfileInput] = OMIT,
        ownership_declaration: typing.Optional[OwnershipDeclarationInput] = OMIT,
        tos_acceptance: typing.Optional[TermsOfServiceAcceptanceInput] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityOnboardingDataResponse:
        """
        Parameters
        ----------
        entity_id : str

        business_profile : typing.Optional[BusinessProfileInput]
            Business information about the entity.

        ownership_declaration : typing.Optional[OwnershipDeclarationInput]
            Used to attest that the beneficial owner information provided is both current and correct.

        tos_acceptance : typing.Optional[TermsOfServiceAcceptanceInput]
            Details on the entity's acceptance of the service agreement.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityOnboardingDataResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.onboarding_data.update(entity_id='entity_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            entity_id,
            business_profile=business_profile,
            ownership_declaration=ownership_declaration,
            tos_acceptance=tos_acceptance,
            request_options=request_options,
        )
        return _response.data
