# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.monite_all_payment_methods_types import MoniteAllPaymentMethodsTypes
from ...types.onboarding_payment_methods_response import OnboardingPaymentMethodsResponse
from .raw_client import AsyncRawPaymentMethodsClient, RawPaymentMethodsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PaymentMethodsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPaymentMethodsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPaymentMethodsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPaymentMethodsClient
        """
        return self._raw_client

    def get(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> OnboardingPaymentMethodsResponse:
        """
        Get all enabled payment methods.

        Parameters
        ----------
        entity_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OnboardingPaymentMethodsResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.payment_methods.get(entity_id='entity_id', )
        """
        _response = self._raw_client.get(entity_id, request_options=request_options)
        return _response.data

    def set(
        self,
        entity_id: str,
        *,
        payment_methods: typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]] = OMIT,
        payment_methods_receive: typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]] = OMIT,
        payment_methods_send: typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OnboardingPaymentMethodsResponse:
        """
        Set which payment methods should be enabled.

        Parameters
        ----------
        entity_id : str

        payment_methods : typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]]
            Deprecated. Use payment_methods_receive instead.

        payment_methods_receive : typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]]
            Enable payment methods to receive money.

        payment_methods_send : typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]]
            Enable payment methods to send money.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OnboardingPaymentMethodsResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entities.payment_methods.set(entity_id='entity_id', )
        """
        _response = self._raw_client.set(
            entity_id,
            payment_methods=payment_methods,
            payment_methods_receive=payment_methods_receive,
            payment_methods_send=payment_methods_send,
            request_options=request_options,
        )
        return _response.data


class AsyncPaymentMethodsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPaymentMethodsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPaymentMethodsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPaymentMethodsClient
        """
        return self._raw_client

    async def get(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> OnboardingPaymentMethodsResponse:
        """
        Get all enabled payment methods.

        Parameters
        ----------
        entity_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OnboardingPaymentMethodsResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.payment_methods.get(entity_id='entity_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(entity_id, request_options=request_options)
        return _response.data

    async def set(
        self,
        entity_id: str,
        *,
        payment_methods: typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]] = OMIT,
        payment_methods_receive: typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]] = OMIT,
        payment_methods_send: typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OnboardingPaymentMethodsResponse:
        """
        Set which payment methods should be enabled.

        Parameters
        ----------
        entity_id : str

        payment_methods : typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]]
            Deprecated. Use payment_methods_receive instead.

        payment_methods_receive : typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]]
            Enable payment methods to receive money.

        payment_methods_send : typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]]
            Enable payment methods to send money.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OnboardingPaymentMethodsResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entities.payment_methods.set(entity_id='entity_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.set(
            entity_id,
            payment_methods=payment_methods,
            payment_methods_receive=payment_methods_receive,
            payment_methods_send=payment_methods_send,
            request_options=request_options,
        )
        return _response.data
