# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.internal_server_error import InternalServerError
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.monite_all_payment_methods_types import MoniteAllPaymentMethodsTypes
from ...types.onboarding_payment_methods_response import OnboardingPaymentMethodsResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawPaymentMethodsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[OnboardingPaymentMethodsResponse]:
        """
        Get all enabled payment methods.

        Parameters
        ----------
        entity_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[OnboardingPaymentMethodsResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/payment_methods",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    OnboardingPaymentMethodsResponse,
                    parse_obj_as(
                        type_=OnboardingPaymentMethodsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def set(
        self,
        entity_id: str,
        *,
        payment_methods: typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]] = OMIT,
        payment_methods_receive: typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]] = OMIT,
        payment_methods_send: typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[OnboardingPaymentMethodsResponse]:
        """
        Set which payment methods should be enabled.

        Parameters
        ----------
        entity_id : str

        payment_methods : typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]]
            Deprecated. Use payment_methods_receive instead.

        payment_methods_receive : typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]]
            Enable payment methods to receive money.

        payment_methods_send : typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]]
            Enable payment methods to send money.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[OnboardingPaymentMethodsResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/payment_methods",
            method="PUT",
            json={
                "payment_methods": payment_methods,
                "payment_methods_receive": payment_methods_receive,
                "payment_methods_send": payment_methods_send,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    OnboardingPaymentMethodsResponse,
                    parse_obj_as(
                        type_=OnboardingPaymentMethodsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawPaymentMethodsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[OnboardingPaymentMethodsResponse]:
        """
        Get all enabled payment methods.

        Parameters
        ----------
        entity_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[OnboardingPaymentMethodsResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/payment_methods",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    OnboardingPaymentMethodsResponse,
                    parse_obj_as(
                        type_=OnboardingPaymentMethodsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def set(
        self,
        entity_id: str,
        *,
        payment_methods: typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]] = OMIT,
        payment_methods_receive: typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]] = OMIT,
        payment_methods_send: typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[OnboardingPaymentMethodsResponse]:
        """
        Set which payment methods should be enabled.

        Parameters
        ----------
        entity_id : str

        payment_methods : typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]]
            Deprecated. Use payment_methods_receive instead.

        payment_methods_receive : typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]]
            Enable payment methods to receive money.

        payment_methods_send : typing.Optional[typing.Sequence[MoniteAllPaymentMethodsTypes]]
            Enable payment methods to send money.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[OnboardingPaymentMethodsResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/payment_methods",
            method="PUT",
            json={
                "payment_methods": payment_methods,
                "payment_methods_receive": payment_methods_receive,
                "payment_methods_send": payment_methods_send,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    OnboardingPaymentMethodsResponse,
                    parse_obj_as(
                        type_=OnboardingPaymentMethodsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
