# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.conflict_error import ConflictError
from ...errors.internal_server_error import InternalServerError
from ...errors.not_found_error import NotFoundError
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.allowed_countries import AllowedCountries
from ...types.optional_person_address_request import OptionalPersonAddressRequest
from ...types.optional_person_relationship import OptionalPersonRelationship
from ...types.person_address_request import PersonAddressRequest
from ...types.person_relationship_request import PersonRelationshipRequest
from ...types.person_response import PersonResponse
from ...types.persons_response import PersonsResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawPersonsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[PersonsResponse]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PersonsResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "persons",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PersonsResponse,
                    parse_obj_as(
                        type_=PersonsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        email: str,
        first_name: str,
        last_name: str,
        relationship: PersonRelationshipRequest,
        address: typing.Optional[PersonAddressRequest] = OMIT,
        citizenship: typing.Optional[AllowedCountries] = OMIT,
        date_of_birth: typing.Optional[str] = OMIT,
        id_number: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        ssn_last4: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PersonResponse]:
        """
        Parameters
        ----------
        email : str
            The person's email address

        first_name : str
            The person's first name

        last_name : str
            The person's last name

        relationship : PersonRelationshipRequest
            Describes the person's relationship to the entity

        address : typing.Optional[PersonAddressRequest]
            The person's address

        citizenship : typing.Optional[AllowedCountries]
            Required for persons of US entities. The country of the person's citizenship, as a two-letter country code (ISO 3166-1 alpha-2). In case of dual or multiple citizenship, specify any.

        date_of_birth : typing.Optional[str]
            The person's date of birth

        id_number : typing.Optional[str]
            The person's ID number, as appropriate for their country

        phone : typing.Optional[str]
            The person's phone number

        ssn_last4 : typing.Optional[str]
            The last four digits of the person's Social Security number

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PersonResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "persons",
            method="POST",
            json={
                "address": convert_and_respect_annotation_metadata(
                    object_=address, annotation=PersonAddressRequest, direction="write"
                ),
                "citizenship": citizenship,
                "date_of_birth": date_of_birth,
                "email": email,
                "first_name": first_name,
                "id_number": id_number,
                "last_name": last_name,
                "phone": phone,
                "relationship": convert_and_respect_annotation_metadata(
                    object_=relationship, annotation=PersonRelationshipRequest, direction="write"
                ),
                "ssn_last_4": ssn_last4,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PersonResponse,
                    parse_obj_as(
                        type_=PersonResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_by_id(
        self, person_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PersonResponse]:
        """
        Parameters
        ----------
        person_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PersonResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"persons/{jsonable_encoder(person_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PersonResponse,
                    parse_obj_as(
                        type_=PersonResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_by_id(
        self, person_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        person_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"persons/{jsonable_encoder(person_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_by_id(
        self,
        person_id: str,
        *,
        address: typing.Optional[OptionalPersonAddressRequest] = OMIT,
        citizenship: typing.Optional[AllowedCountries] = OMIT,
        date_of_birth: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        id_number: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        relationship: typing.Optional[OptionalPersonRelationship] = OMIT,
        ssn_last4: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PersonResponse]:
        """
        Parameters
        ----------
        person_id : str

        address : typing.Optional[OptionalPersonAddressRequest]
            The person's address

        citizenship : typing.Optional[AllowedCountries]
            Required for persons of US entities. The country of the person's citizenship, as a two-letter country code (ISO 3166-1 alpha-2). In case of dual or multiple citizenship, specify any.

        date_of_birth : typing.Optional[str]
            The person's date of birth

        email : typing.Optional[str]
            The person's email address

        first_name : typing.Optional[str]
            The person's first name

        id_number : typing.Optional[str]
            The person's ID number, as appropriate for their country

        last_name : typing.Optional[str]
            The person's last name

        phone : typing.Optional[str]
            The person's phone number

        relationship : typing.Optional[OptionalPersonRelationship]
            Describes the person's relationship to the entity

        ssn_last4 : typing.Optional[str]
            The last four digits of the person's Social Security number

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PersonResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"persons/{jsonable_encoder(person_id)}",
            method="PATCH",
            json={
                "address": convert_and_respect_annotation_metadata(
                    object_=address, annotation=OptionalPersonAddressRequest, direction="write"
                ),
                "citizenship": citizenship,
                "date_of_birth": date_of_birth,
                "email": email,
                "first_name": first_name,
                "id_number": id_number,
                "last_name": last_name,
                "phone": phone,
                "relationship": convert_and_respect_annotation_metadata(
                    object_=relationship, annotation=OptionalPersonRelationship, direction="write"
                ),
                "ssn_last_4": ssn_last4,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PersonResponse,
                    parse_obj_as(
                        type_=PersonResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def upload_onboarding_documents(
        self,
        person_id: str,
        *,
        additional_verification_document_back: typing.Optional[str] = OMIT,
        additional_verification_document_front: typing.Optional[str] = OMIT,
        verification_document_back: typing.Optional[str] = OMIT,
        verification_document_front: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Provide files for person onboarding verification

        Parameters
        ----------
        person_id : str

        additional_verification_document_back : typing.Optional[str]

        additional_verification_document_front : typing.Optional[str]

        verification_document_back : typing.Optional[str]

        verification_document_front : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"persons/{jsonable_encoder(person_id)}/onboarding_documents",
            method="POST",
            json={
                "additional_verification_document_back": additional_verification_document_back,
                "additional_verification_document_front": additional_verification_document_front,
                "verification_document_back": verification_document_back,
                "verification_document_front": verification_document_front,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawPersonsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PersonsResponse]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PersonsResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "persons",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PersonsResponse,
                    parse_obj_as(
                        type_=PersonsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        email: str,
        first_name: str,
        last_name: str,
        relationship: PersonRelationshipRequest,
        address: typing.Optional[PersonAddressRequest] = OMIT,
        citizenship: typing.Optional[AllowedCountries] = OMIT,
        date_of_birth: typing.Optional[str] = OMIT,
        id_number: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        ssn_last4: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PersonResponse]:
        """
        Parameters
        ----------
        email : str
            The person's email address

        first_name : str
            The person's first name

        last_name : str
            The person's last name

        relationship : PersonRelationshipRequest
            Describes the person's relationship to the entity

        address : typing.Optional[PersonAddressRequest]
            The person's address

        citizenship : typing.Optional[AllowedCountries]
            Required for persons of US entities. The country of the person's citizenship, as a two-letter country code (ISO 3166-1 alpha-2). In case of dual or multiple citizenship, specify any.

        date_of_birth : typing.Optional[str]
            The person's date of birth

        id_number : typing.Optional[str]
            The person's ID number, as appropriate for their country

        phone : typing.Optional[str]
            The person's phone number

        ssn_last4 : typing.Optional[str]
            The last four digits of the person's Social Security number

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PersonResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "persons",
            method="POST",
            json={
                "address": convert_and_respect_annotation_metadata(
                    object_=address, annotation=PersonAddressRequest, direction="write"
                ),
                "citizenship": citizenship,
                "date_of_birth": date_of_birth,
                "email": email,
                "first_name": first_name,
                "id_number": id_number,
                "last_name": last_name,
                "phone": phone,
                "relationship": convert_and_respect_annotation_metadata(
                    object_=relationship, annotation=PersonRelationshipRequest, direction="write"
                ),
                "ssn_last_4": ssn_last4,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PersonResponse,
                    parse_obj_as(
                        type_=PersonResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_by_id(
        self, person_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PersonResponse]:
        """
        Parameters
        ----------
        person_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PersonResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"persons/{jsonable_encoder(person_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PersonResponse,
                    parse_obj_as(
                        type_=PersonResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_by_id(
        self, person_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        person_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"persons/{jsonable_encoder(person_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_by_id(
        self,
        person_id: str,
        *,
        address: typing.Optional[OptionalPersonAddressRequest] = OMIT,
        citizenship: typing.Optional[AllowedCountries] = OMIT,
        date_of_birth: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        id_number: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        relationship: typing.Optional[OptionalPersonRelationship] = OMIT,
        ssn_last4: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PersonResponse]:
        """
        Parameters
        ----------
        person_id : str

        address : typing.Optional[OptionalPersonAddressRequest]
            The person's address

        citizenship : typing.Optional[AllowedCountries]
            Required for persons of US entities. The country of the person's citizenship, as a two-letter country code (ISO 3166-1 alpha-2). In case of dual or multiple citizenship, specify any.

        date_of_birth : typing.Optional[str]
            The person's date of birth

        email : typing.Optional[str]
            The person's email address

        first_name : typing.Optional[str]
            The person's first name

        id_number : typing.Optional[str]
            The person's ID number, as appropriate for their country

        last_name : typing.Optional[str]
            The person's last name

        phone : typing.Optional[str]
            The person's phone number

        relationship : typing.Optional[OptionalPersonRelationship]
            Describes the person's relationship to the entity

        ssn_last4 : typing.Optional[str]
            The last four digits of the person's Social Security number

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PersonResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"persons/{jsonable_encoder(person_id)}",
            method="PATCH",
            json={
                "address": convert_and_respect_annotation_metadata(
                    object_=address, annotation=OptionalPersonAddressRequest, direction="write"
                ),
                "citizenship": citizenship,
                "date_of_birth": date_of_birth,
                "email": email,
                "first_name": first_name,
                "id_number": id_number,
                "last_name": last_name,
                "phone": phone,
                "relationship": convert_and_respect_annotation_metadata(
                    object_=relationship, annotation=OptionalPersonRelationship, direction="write"
                ),
                "ssn_last_4": ssn_last4,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PersonResponse,
                    parse_obj_as(
                        type_=PersonResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def upload_onboarding_documents(
        self,
        person_id: str,
        *,
        additional_verification_document_back: typing.Optional[str] = OMIT,
        additional_verification_document_front: typing.Optional[str] = OMIT,
        verification_document_back: typing.Optional[str] = OMIT,
        verification_document_front: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Provide files for person onboarding verification

        Parameters
        ----------
        person_id : str

        additional_verification_document_back : typing.Optional[str]

        additional_verification_document_front : typing.Optional[str]

        verification_document_back : typing.Optional[str]

        verification_document_front : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"persons/{jsonable_encoder(person_id)}/onboarding_documents",
            method="POST",
            json={
                "additional_verification_document_back": additional_verification_document_back,
                "additional_verification_document_front": additional_verification_document_front,
                "verification_document_back": verification_document_back,
                "verification_document_front": verification_document_front,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
