# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from .. import core
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.datetime_utils import serialize_datetime
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.bad_request_error import BadRequestError
from ..errors.forbidden_error import ForbiddenError
from ..errors.internal_server_error import InternalServerError
from ..errors.not_acceptable_error import NotAcceptableError
from ..errors.not_found_error import NotFoundError
from ..errors.unauthorized_error import UnauthorizedError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.accounting_settings import AccountingSettings
from ..types.currency_settings_input import CurrencySettingsInput
from ..types.document_i_ds_settings_request import DocumentIDsSettingsRequest
from ..types.document_rendering_settings import DocumentRenderingSettings
from ..types.entity_address_schema import EntityAddressSchema
from ..types.entity_cursor_fields import EntityCursorFields
from ..types.entity_pagination_response import EntityPaginationResponse
from ..types.entity_response import EntityResponse
from ..types.entity_status_enum import EntityStatusEnum
from ..types.entity_type_enum import EntityTypeEnum
from ..types.file_schema2 import FileSchema2
from ..types.get_onboarding_requirements_response import GetOnboardingRequirementsResponse
from ..types.individual_schema import IndividualSchema
from ..types.language_code_enum import LanguageCodeEnum
from ..types.ocr_auto_tagging_settings_request import OcrAutoTaggingSettingsRequest
from ..types.optional_individual_schema import OptionalIndividualSchema
from ..types.optional_organization_schema import OptionalOrganizationSchema
from ..types.order_enum import OrderEnum
from ..types.organization_schema import OrganizationSchema
from ..types.partner_metadata_response import PartnerMetadataResponse
from ..types.payment_priority_enum import PaymentPriorityEnum
from ..types.receivable_edit_flow import ReceivableEditFlow
from ..types.reminders_settings import RemindersSettings
from ..types.settings_response import SettingsResponse
from ..types.update_entity_address_schema import UpdateEntityAddressSchema
from ..types.vat_mode_enum import VatModeEnum

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawEntitiesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[EntityCursorFields] = None,
        type: typing.Optional[EntityTypeEnum] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        id_not_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        email: typing.Optional[str] = None,
        email_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        email_not_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[EntityStatusEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[EntityPaginationResponse]:
        """
        Retrieve a list of all entities.

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[EntityCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        type : typing.Optional[EntityTypeEnum]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        id_not_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        email : typing.Optional[str]

        email_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        email_not_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        status : typing.Optional[EntityStatusEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EntityPaginationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "entities",
            method="GET",
            params={
                "order": order,
                "limit": limit,
                "pagination_token": pagination_token,
                "sort": sort,
                "type": type,
                "created_at__gt": serialize_datetime(created_at_gt) if created_at_gt is not None else None,
                "created_at__lt": serialize_datetime(created_at_lt) if created_at_lt is not None else None,
                "created_at__gte": serialize_datetime(created_at_gte) if created_at_gte is not None else None,
                "created_at__lte": serialize_datetime(created_at_lte) if created_at_lte is not None else None,
                "id__in": id_in,
                "id__not_in": id_not_in,
                "email": email,
                "email__in": email_in,
                "email__not_in": email_not_in,
                "status": status,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityPaginationResponse,
                    parse_obj_as(
                        type_=EntityPaginationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 406:
                raise NotAcceptableError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        address: EntityAddressSchema,
        email: str,
        type: EntityTypeEnum,
        phone: typing.Optional[str] = OMIT,
        website: typing.Optional[str] = OMIT,
        organization: typing.Optional[OrganizationSchema] = OMIT,
        individual: typing.Optional[IndividualSchema] = OMIT,
        tax_id: typing.Optional[str] = OMIT,
        registration_number: typing.Optional[str] = OMIT,
        registration_authority: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[EntityResponse]:
        """
        Create a new entity from the specified values.

        Parameters
        ----------
        address : EntityAddressSchema
            An address description of the entity

        email : str
            An official email address of the entity

        type : EntityTypeEnum
            A type for an entity

        phone : typing.Optional[str]
            The contact phone number of the entity. Required for US organizations to use payments.

        website : typing.Optional[str]
            A website of the entity

        organization : typing.Optional[OrganizationSchema]
            A set of meta data describing the organization

        individual : typing.Optional[IndividualSchema]
            A set of meta data describing the individual

        tax_id : typing.Optional[str]
            The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.

        registration_number : typing.Optional[str]
            (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.

        registration_authority : typing.Optional[str]
            (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EntityResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "entities",
            method="POST",
            json={
                "address": convert_and_respect_annotation_metadata(
                    object_=address, annotation=EntityAddressSchema, direction="write"
                ),
                "email": email,
                "phone": phone,
                "website": website,
                "organization": convert_and_respect_annotation_metadata(
                    object_=organization, annotation=OrganizationSchema, direction="write"
                ),
                "individual": convert_and_respect_annotation_metadata(
                    object_=individual, annotation=IndividualSchema, direction="write"
                ),
                "tax_id": tax_id,
                "registration_number": registration_number,
                "registration_authority": registration_authority,
                "type": type,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityResponse,
                    parse_obj_as(
                        type_=EntityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_entities_me(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[EntityResponse]:
        """
        Deprecated. Use `GET /entity_users/my_entity` instead.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EntityResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "entities/me",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityResponse,
                    parse_obj_as(
                        type_=EntityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def patch_entities_me(
        self,
        *,
        address: typing.Optional[UpdateEntityAddressSchema] = OMIT,
        email: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        website: typing.Optional[str] = OMIT,
        tax_id: typing.Optional[str] = OMIT,
        registration_number: typing.Optional[str] = OMIT,
        registration_authority: typing.Optional[str] = OMIT,
        organization: typing.Optional[OptionalOrganizationSchema] = OMIT,
        individual: typing.Optional[OptionalIndividualSchema] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[EntityResponse]:
        """
        Deprecated. Use `PATCH /entity_users/my_entity` instead.

        Parameters
        ----------
        address : typing.Optional[UpdateEntityAddressSchema]
            An address description of the entity

        email : typing.Optional[str]
            An official email address of the entity

        phone : typing.Optional[str]
            The contact phone number of the entity. Required for US organizations to use payments.

        website : typing.Optional[str]
            A website of the entity

        tax_id : typing.Optional[str]
            The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.

        registration_number : typing.Optional[str]
            (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.

        registration_authority : typing.Optional[str]
            (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.

        organization : typing.Optional[OptionalOrganizationSchema]
            A set of meta data describing the organization

        individual : typing.Optional[OptionalIndividualSchema]
            A set of meta data describing the individual

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EntityResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "entities/me",
            method="PATCH",
            json={
                "address": convert_and_respect_annotation_metadata(
                    object_=address, annotation=UpdateEntityAddressSchema, direction="write"
                ),
                "email": email,
                "phone": phone,
                "website": website,
                "tax_id": tax_id,
                "registration_number": registration_number,
                "registration_authority": registration_authority,
                "organization": convert_and_respect_annotation_metadata(
                    object_=organization, annotation=OptionalOrganizationSchema, direction="write"
                ),
                "individual": convert_and_respect_annotation_metadata(
                    object_=individual, annotation=OptionalIndividualSchema, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityResponse,
                    parse_obj_as(
                        type_=EntityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_by_id(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[EntityResponse]:
        """
        Retrieve an entity by its ID.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EntityResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityResponse,
                    parse_obj_as(
                        type_=EntityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_by_id(
        self,
        entity_id: str,
        *,
        address: typing.Optional[UpdateEntityAddressSchema] = OMIT,
        email: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        website: typing.Optional[str] = OMIT,
        tax_id: typing.Optional[str] = OMIT,
        registration_number: typing.Optional[str] = OMIT,
        registration_authority: typing.Optional[str] = OMIT,
        organization: typing.Optional[OptionalOrganizationSchema] = OMIT,
        individual: typing.Optional[OptionalIndividualSchema] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[EntityResponse]:
        """
        Change the specified fields with the provided values.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        address : typing.Optional[UpdateEntityAddressSchema]
            An address description of the entity

        email : typing.Optional[str]
            An official email address of the entity

        phone : typing.Optional[str]
            The contact phone number of the entity. Required for US organizations to use payments.

        website : typing.Optional[str]
            A website of the entity

        tax_id : typing.Optional[str]
            The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.

        registration_number : typing.Optional[str]
            (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.

        registration_authority : typing.Optional[str]
            (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.

        organization : typing.Optional[OptionalOrganizationSchema]
            A set of meta data describing the organization

        individual : typing.Optional[OptionalIndividualSchema]
            A set of meta data describing the individual

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EntityResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}",
            method="PATCH",
            json={
                "address": convert_and_respect_annotation_metadata(
                    object_=address, annotation=UpdateEntityAddressSchema, direction="write"
                ),
                "email": email,
                "phone": phone,
                "website": website,
                "tax_id": tax_id,
                "registration_number": registration_number,
                "registration_authority": registration_authority,
                "organization": convert_and_respect_annotation_metadata(
                    object_=organization, annotation=OptionalOrganizationSchema, direction="write"
                ),
                "individual": convert_and_respect_annotation_metadata(
                    object_=individual, annotation=OptionalIndividualSchema, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityResponse,
                    parse_obj_as(
                        type_=EntityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def post_entities_id_activate(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[EntityResponse]:
        """
        Activate an entity to allow it to perform any operations.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EntityResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/activate",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityResponse,
                    parse_obj_as(
                        type_=EntityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def post_entities_id_deactivate(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[EntityResponse]:
        """
        Deactivate an entity to stop it from performing any operations.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EntityResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/deactivate",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityResponse,
                    parse_obj_as(
                        type_=EntityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def upload_logo_by_id(
        self, entity_id: str, *, file: core.File, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[FileSchema2]:
        """
        Entity logo can be PNG, JPG, or GIF, up to 10 MB in size. The logo is used, for example, in PDF documents created by this entity.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        file : core.File
            See core.File for more documentation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[FileSchema2]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/logo",
            method="PUT",
            data={},
            files={
                "file": file,
            },
            headers={
                "content-type": "multipart/form-data",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FileSchema2,
                    parse_obj_as(
                        type_=FileSchema2,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_logo_by_id(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/logo",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_partner_metadata_by_id(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PartnerMetadataResponse]:
        """
        Retrieve a metadata object associated with this entity, usually in a JSON format.

        Parameters
        ----------
        entity_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PartnerMetadataResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/partner_metadata",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PartnerMetadataResponse,
                    parse_obj_as(
                        type_=PartnerMetadataResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_partner_metadata_by_id(
        self,
        entity_id: str,
        *,
        metadata: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PartnerMetadataResponse]:
        """
        Fully replace the current metadata object with the specified instance.

        Parameters
        ----------
        entity_id : str

        metadata : typing.Dict[str, typing.Optional[typing.Any]]
            Metadata for partner needs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PartnerMetadataResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/partner_metadata",
            method="PUT",
            json={
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PartnerMetadataResponse,
                    parse_obj_as(
                        type_=PartnerMetadataResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_settings_by_id(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[SettingsResponse]:
        """
        Retrieve all settings for this entity.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SettingsResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/settings",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SettingsResponse,
                    parse_obj_as(
                        type_=SettingsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_settings_by_id(
        self,
        entity_id: str,
        *,
        language: typing.Optional[LanguageCodeEnum] = OMIT,
        currency: typing.Optional[CurrencySettingsInput] = OMIT,
        reminder: typing.Optional[RemindersSettings] = OMIT,
        vat_mode: typing.Optional[VatModeEnum] = OMIT,
        vat_inclusive_discount_mode: typing.Optional[VatModeEnum] = OMIT,
        payment_priority: typing.Optional[PaymentPriorityEnum] = OMIT,
        allow_purchase_order_autolinking: typing.Optional[bool] = OMIT,
        receivable_edit_flow: typing.Optional[ReceivableEditFlow] = OMIT,
        document_ids: typing.Optional[DocumentIDsSettingsRequest] = OMIT,
        payables_ocr_auto_tagging: typing.Optional[typing.Sequence[OcrAutoTaggingSettingsRequest]] = OMIT,
        quote_signature_required: typing.Optional[bool] = OMIT,
        generate_paid_invoice_pdf: typing.Optional[bool] = OMIT,
        accounting: typing.Optional[AccountingSettings] = OMIT,
        payables_skip_approval_flow: typing.Optional[bool] = OMIT,
        document_rendering: typing.Optional[DocumentRenderingSettings] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SettingsResponse]:
        """
        Change the specified fields with the provided values.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        language : typing.Optional[LanguageCodeEnum]

        currency : typing.Optional[CurrencySettingsInput]

        reminder : typing.Optional[RemindersSettings]

        vat_mode : typing.Optional[VatModeEnum]
            Defines whether the prices of products in receivables will already include VAT or not.

        vat_inclusive_discount_mode : typing.Optional[VatModeEnum]
            Defines whether the amount discounts (for percentage discounts it does not matter) on VAT inclusive invoices will be applied on amounts including VAT or excluding VAT.

        payment_priority : typing.Optional[PaymentPriorityEnum]
            Payment preferences for entity to automate calculating suggested payment date based on payment terms and entity preferences.

        allow_purchase_order_autolinking : typing.Optional[bool]
            Automatically attempt to find a corresponding purchase order for all incoming payables.

        receivable_edit_flow : typing.Optional[ReceivableEditFlow]

        document_ids : typing.Optional[DocumentIDsSettingsRequest]

        payables_ocr_auto_tagging : typing.Optional[typing.Sequence[OcrAutoTaggingSettingsRequest]]
            Auto tagging settings for all incoming OCR payable documents.

        quote_signature_required : typing.Optional[bool]
            Sets the default behavior of whether a signature is required to accept quotes.

        generate_paid_invoice_pdf : typing.Optional[bool]
            This setting affects how PDF is generated for paid accounts receivable invoices. If set to `true`, once an invoice is fully paid its PDF version is updated to display the amount paid and the payment-related features are removed.

            The PDF file gets regenerated at the moment when an invoice becomes paid. It is not issued as a separate document, and the original PDF invoice is no longer available.

            This field is deprecated and will be replaced by `document_rendering.invoice.generate_paid_invoice_pdf`.

        accounting : typing.Optional[AccountingSettings]

        payables_skip_approval_flow : typing.Optional[bool]
            If enabled, the approval policy will be skipped and the payable will be moved to `waiting_to_be_paid` status.

        document_rendering : typing.Optional[DocumentRenderingSettings]
            Settings for rendering documents in PDF format.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SettingsResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/settings",
            method="PATCH",
            json={
                "language": language,
                "currency": convert_and_respect_annotation_metadata(
                    object_=currency, annotation=CurrencySettingsInput, direction="write"
                ),
                "reminder": convert_and_respect_annotation_metadata(
                    object_=reminder, annotation=RemindersSettings, direction="write"
                ),
                "vat_mode": vat_mode,
                "vat_inclusive_discount_mode": vat_inclusive_discount_mode,
                "payment_priority": payment_priority,
                "allow_purchase_order_autolinking": allow_purchase_order_autolinking,
                "receivable_edit_flow": receivable_edit_flow,
                "document_ids": convert_and_respect_annotation_metadata(
                    object_=document_ids, annotation=DocumentIDsSettingsRequest, direction="write"
                ),
                "payables_ocr_auto_tagging": convert_and_respect_annotation_metadata(
                    object_=payables_ocr_auto_tagging,
                    annotation=typing.Sequence[OcrAutoTaggingSettingsRequest],
                    direction="write",
                ),
                "quote_signature_required": quote_signature_required,
                "generate_paid_invoice_pdf": generate_paid_invoice_pdf,
                "accounting": convert_and_respect_annotation_metadata(
                    object_=accounting, annotation=AccountingSettings, direction="write"
                ),
                "payables_skip_approval_flow": payables_skip_approval_flow,
                "document_rendering": convert_and_respect_annotation_metadata(
                    object_=document_rendering, annotation=DocumentRenderingSettings, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SettingsResponse,
                    parse_obj_as(
                        type_=SettingsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def upload_onboarding_documents(
        self,
        *,
        additional_verification_document_back: typing.Optional[str] = OMIT,
        additional_verification_document_front: typing.Optional[str] = OMIT,
        bank_account_ownership_verification: typing.Optional[typing.Sequence[str]] = OMIT,
        company_license: typing.Optional[typing.Sequence[str]] = OMIT,
        company_memorandum_of_association: typing.Optional[typing.Sequence[str]] = OMIT,
        company_ministerial_decree: typing.Optional[typing.Sequence[str]] = OMIT,
        company_registration_verification: typing.Optional[typing.Sequence[str]] = OMIT,
        company_tax_id_verification: typing.Optional[typing.Sequence[str]] = OMIT,
        proof_of_registration: typing.Optional[typing.Sequence[str]] = OMIT,
        verification_document_back: typing.Optional[str] = OMIT,
        verification_document_front: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Provide files for entity onboarding verification

        Parameters
        ----------
        additional_verification_document_back : typing.Optional[str]

        additional_verification_document_front : typing.Optional[str]

        bank_account_ownership_verification : typing.Optional[typing.Sequence[str]]

        company_license : typing.Optional[typing.Sequence[str]]

        company_memorandum_of_association : typing.Optional[typing.Sequence[str]]

        company_ministerial_decree : typing.Optional[typing.Sequence[str]]

        company_registration_verification : typing.Optional[typing.Sequence[str]]

        company_tax_id_verification : typing.Optional[typing.Sequence[str]]

        proof_of_registration : typing.Optional[typing.Sequence[str]]

        verification_document_back : typing.Optional[str]

        verification_document_front : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "onboarding_documents",
            method="POST",
            json={
                "additional_verification_document_back": additional_verification_document_back,
                "additional_verification_document_front": additional_verification_document_front,
                "bank_account_ownership_verification": bank_account_ownership_verification,
                "company_license": company_license,
                "company_memorandum_of_association": company_memorandum_of_association,
                "company_ministerial_decree": company_ministerial_decree,
                "company_registration_verification": company_registration_verification,
                "company_tax_id_verification": company_tax_id_verification,
                "proof_of_registration": proof_of_registration,
                "verification_document_back": verification_document_back,
                "verification_document_front": verification_document_front,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_onboarding_requirements(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetOnboardingRequirementsResponse]:
        """
        Get onboarding requirements for the entity

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetOnboardingRequirementsResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "onboarding_requirements",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetOnboardingRequirementsResponse,
                    parse_obj_as(
                        type_=GetOnboardingRequirementsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawEntitiesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[EntityCursorFields] = None,
        type: typing.Optional[EntityTypeEnum] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        id_not_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        email: typing.Optional[str] = None,
        email_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        email_not_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[EntityStatusEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[EntityPaginationResponse]:
        """
        Retrieve a list of all entities.

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[EntityCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        type : typing.Optional[EntityTypeEnum]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        id_not_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        email : typing.Optional[str]

        email_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        email_not_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        status : typing.Optional[EntityStatusEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EntityPaginationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "entities",
            method="GET",
            params={
                "order": order,
                "limit": limit,
                "pagination_token": pagination_token,
                "sort": sort,
                "type": type,
                "created_at__gt": serialize_datetime(created_at_gt) if created_at_gt is not None else None,
                "created_at__lt": serialize_datetime(created_at_lt) if created_at_lt is not None else None,
                "created_at__gte": serialize_datetime(created_at_gte) if created_at_gte is not None else None,
                "created_at__lte": serialize_datetime(created_at_lte) if created_at_lte is not None else None,
                "id__in": id_in,
                "id__not_in": id_not_in,
                "email": email,
                "email__in": email_in,
                "email__not_in": email_not_in,
                "status": status,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityPaginationResponse,
                    parse_obj_as(
                        type_=EntityPaginationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 406:
                raise NotAcceptableError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        address: EntityAddressSchema,
        email: str,
        type: EntityTypeEnum,
        phone: typing.Optional[str] = OMIT,
        website: typing.Optional[str] = OMIT,
        organization: typing.Optional[OrganizationSchema] = OMIT,
        individual: typing.Optional[IndividualSchema] = OMIT,
        tax_id: typing.Optional[str] = OMIT,
        registration_number: typing.Optional[str] = OMIT,
        registration_authority: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[EntityResponse]:
        """
        Create a new entity from the specified values.

        Parameters
        ----------
        address : EntityAddressSchema
            An address description of the entity

        email : str
            An official email address of the entity

        type : EntityTypeEnum
            A type for an entity

        phone : typing.Optional[str]
            The contact phone number of the entity. Required for US organizations to use payments.

        website : typing.Optional[str]
            A website of the entity

        organization : typing.Optional[OrganizationSchema]
            A set of meta data describing the organization

        individual : typing.Optional[IndividualSchema]
            A set of meta data describing the individual

        tax_id : typing.Optional[str]
            The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.

        registration_number : typing.Optional[str]
            (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.

        registration_authority : typing.Optional[str]
            (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EntityResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "entities",
            method="POST",
            json={
                "address": convert_and_respect_annotation_metadata(
                    object_=address, annotation=EntityAddressSchema, direction="write"
                ),
                "email": email,
                "phone": phone,
                "website": website,
                "organization": convert_and_respect_annotation_metadata(
                    object_=organization, annotation=OrganizationSchema, direction="write"
                ),
                "individual": convert_and_respect_annotation_metadata(
                    object_=individual, annotation=IndividualSchema, direction="write"
                ),
                "tax_id": tax_id,
                "registration_number": registration_number,
                "registration_authority": registration_authority,
                "type": type,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityResponse,
                    parse_obj_as(
                        type_=EntityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_entities_me(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[EntityResponse]:
        """
        Deprecated. Use `GET /entity_users/my_entity` instead.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EntityResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "entities/me",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityResponse,
                    parse_obj_as(
                        type_=EntityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def patch_entities_me(
        self,
        *,
        address: typing.Optional[UpdateEntityAddressSchema] = OMIT,
        email: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        website: typing.Optional[str] = OMIT,
        tax_id: typing.Optional[str] = OMIT,
        registration_number: typing.Optional[str] = OMIT,
        registration_authority: typing.Optional[str] = OMIT,
        organization: typing.Optional[OptionalOrganizationSchema] = OMIT,
        individual: typing.Optional[OptionalIndividualSchema] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[EntityResponse]:
        """
        Deprecated. Use `PATCH /entity_users/my_entity` instead.

        Parameters
        ----------
        address : typing.Optional[UpdateEntityAddressSchema]
            An address description of the entity

        email : typing.Optional[str]
            An official email address of the entity

        phone : typing.Optional[str]
            The contact phone number of the entity. Required for US organizations to use payments.

        website : typing.Optional[str]
            A website of the entity

        tax_id : typing.Optional[str]
            The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.

        registration_number : typing.Optional[str]
            (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.

        registration_authority : typing.Optional[str]
            (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.

        organization : typing.Optional[OptionalOrganizationSchema]
            A set of meta data describing the organization

        individual : typing.Optional[OptionalIndividualSchema]
            A set of meta data describing the individual

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EntityResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "entities/me",
            method="PATCH",
            json={
                "address": convert_and_respect_annotation_metadata(
                    object_=address, annotation=UpdateEntityAddressSchema, direction="write"
                ),
                "email": email,
                "phone": phone,
                "website": website,
                "tax_id": tax_id,
                "registration_number": registration_number,
                "registration_authority": registration_authority,
                "organization": convert_and_respect_annotation_metadata(
                    object_=organization, annotation=OptionalOrganizationSchema, direction="write"
                ),
                "individual": convert_and_respect_annotation_metadata(
                    object_=individual, annotation=OptionalIndividualSchema, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityResponse,
                    parse_obj_as(
                        type_=EntityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_by_id(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[EntityResponse]:
        """
        Retrieve an entity by its ID.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EntityResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityResponse,
                    parse_obj_as(
                        type_=EntityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_by_id(
        self,
        entity_id: str,
        *,
        address: typing.Optional[UpdateEntityAddressSchema] = OMIT,
        email: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        website: typing.Optional[str] = OMIT,
        tax_id: typing.Optional[str] = OMIT,
        registration_number: typing.Optional[str] = OMIT,
        registration_authority: typing.Optional[str] = OMIT,
        organization: typing.Optional[OptionalOrganizationSchema] = OMIT,
        individual: typing.Optional[OptionalIndividualSchema] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[EntityResponse]:
        """
        Change the specified fields with the provided values.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        address : typing.Optional[UpdateEntityAddressSchema]
            An address description of the entity

        email : typing.Optional[str]
            An official email address of the entity

        phone : typing.Optional[str]
            The contact phone number of the entity. Required for US organizations to use payments.

        website : typing.Optional[str]
            A website of the entity

        tax_id : typing.Optional[str]
            The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.

        registration_number : typing.Optional[str]
            (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.

        registration_authority : typing.Optional[str]
            (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.

        organization : typing.Optional[OptionalOrganizationSchema]
            A set of meta data describing the organization

        individual : typing.Optional[OptionalIndividualSchema]
            A set of meta data describing the individual

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EntityResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}",
            method="PATCH",
            json={
                "address": convert_and_respect_annotation_metadata(
                    object_=address, annotation=UpdateEntityAddressSchema, direction="write"
                ),
                "email": email,
                "phone": phone,
                "website": website,
                "tax_id": tax_id,
                "registration_number": registration_number,
                "registration_authority": registration_authority,
                "organization": convert_and_respect_annotation_metadata(
                    object_=organization, annotation=OptionalOrganizationSchema, direction="write"
                ),
                "individual": convert_and_respect_annotation_metadata(
                    object_=individual, annotation=OptionalIndividualSchema, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityResponse,
                    parse_obj_as(
                        type_=EntityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def post_entities_id_activate(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[EntityResponse]:
        """
        Activate an entity to allow it to perform any operations.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EntityResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/activate",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityResponse,
                    parse_obj_as(
                        type_=EntityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def post_entities_id_deactivate(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[EntityResponse]:
        """
        Deactivate an entity to stop it from performing any operations.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EntityResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/deactivate",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityResponse,
                    parse_obj_as(
                        type_=EntityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def upload_logo_by_id(
        self, entity_id: str, *, file: core.File, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[FileSchema2]:
        """
        Entity logo can be PNG, JPG, or GIF, up to 10 MB in size. The logo is used, for example, in PDF documents created by this entity.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        file : core.File
            See core.File for more documentation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[FileSchema2]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/logo",
            method="PUT",
            data={},
            files={
                "file": file,
            },
            headers={
                "content-type": "multipart/form-data",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FileSchema2,
                    parse_obj_as(
                        type_=FileSchema2,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_logo_by_id(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/logo",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_partner_metadata_by_id(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PartnerMetadataResponse]:
        """
        Retrieve a metadata object associated with this entity, usually in a JSON format.

        Parameters
        ----------
        entity_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PartnerMetadataResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/partner_metadata",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PartnerMetadataResponse,
                    parse_obj_as(
                        type_=PartnerMetadataResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_partner_metadata_by_id(
        self,
        entity_id: str,
        *,
        metadata: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PartnerMetadataResponse]:
        """
        Fully replace the current metadata object with the specified instance.

        Parameters
        ----------
        entity_id : str

        metadata : typing.Dict[str, typing.Optional[typing.Any]]
            Metadata for partner needs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PartnerMetadataResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/partner_metadata",
            method="PUT",
            json={
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PartnerMetadataResponse,
                    parse_obj_as(
                        type_=PartnerMetadataResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_settings_by_id(
        self, entity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[SettingsResponse]:
        """
        Retrieve all settings for this entity.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SettingsResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/settings",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SettingsResponse,
                    parse_obj_as(
                        type_=SettingsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_settings_by_id(
        self,
        entity_id: str,
        *,
        language: typing.Optional[LanguageCodeEnum] = OMIT,
        currency: typing.Optional[CurrencySettingsInput] = OMIT,
        reminder: typing.Optional[RemindersSettings] = OMIT,
        vat_mode: typing.Optional[VatModeEnum] = OMIT,
        vat_inclusive_discount_mode: typing.Optional[VatModeEnum] = OMIT,
        payment_priority: typing.Optional[PaymentPriorityEnum] = OMIT,
        allow_purchase_order_autolinking: typing.Optional[bool] = OMIT,
        receivable_edit_flow: typing.Optional[ReceivableEditFlow] = OMIT,
        document_ids: typing.Optional[DocumentIDsSettingsRequest] = OMIT,
        payables_ocr_auto_tagging: typing.Optional[typing.Sequence[OcrAutoTaggingSettingsRequest]] = OMIT,
        quote_signature_required: typing.Optional[bool] = OMIT,
        generate_paid_invoice_pdf: typing.Optional[bool] = OMIT,
        accounting: typing.Optional[AccountingSettings] = OMIT,
        payables_skip_approval_flow: typing.Optional[bool] = OMIT,
        document_rendering: typing.Optional[DocumentRenderingSettings] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SettingsResponse]:
        """
        Change the specified fields with the provided values.

        Parameters
        ----------
        entity_id : str
            A unique ID to specify the entity.

        language : typing.Optional[LanguageCodeEnum]

        currency : typing.Optional[CurrencySettingsInput]

        reminder : typing.Optional[RemindersSettings]

        vat_mode : typing.Optional[VatModeEnum]
            Defines whether the prices of products in receivables will already include VAT or not.

        vat_inclusive_discount_mode : typing.Optional[VatModeEnum]
            Defines whether the amount discounts (for percentage discounts it does not matter) on VAT inclusive invoices will be applied on amounts including VAT or excluding VAT.

        payment_priority : typing.Optional[PaymentPriorityEnum]
            Payment preferences for entity to automate calculating suggested payment date based on payment terms and entity preferences.

        allow_purchase_order_autolinking : typing.Optional[bool]
            Automatically attempt to find a corresponding purchase order for all incoming payables.

        receivable_edit_flow : typing.Optional[ReceivableEditFlow]

        document_ids : typing.Optional[DocumentIDsSettingsRequest]

        payables_ocr_auto_tagging : typing.Optional[typing.Sequence[OcrAutoTaggingSettingsRequest]]
            Auto tagging settings for all incoming OCR payable documents.

        quote_signature_required : typing.Optional[bool]
            Sets the default behavior of whether a signature is required to accept quotes.

        generate_paid_invoice_pdf : typing.Optional[bool]
            This setting affects how PDF is generated for paid accounts receivable invoices. If set to `true`, once an invoice is fully paid its PDF version is updated to display the amount paid and the payment-related features are removed.

            The PDF file gets regenerated at the moment when an invoice becomes paid. It is not issued as a separate document, and the original PDF invoice is no longer available.

            This field is deprecated and will be replaced by `document_rendering.invoice.generate_paid_invoice_pdf`.

        accounting : typing.Optional[AccountingSettings]

        payables_skip_approval_flow : typing.Optional[bool]
            If enabled, the approval policy will be skipped and the payable will be moved to `waiting_to_be_paid` status.

        document_rendering : typing.Optional[DocumentRenderingSettings]
            Settings for rendering documents in PDF format.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SettingsResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entities/{jsonable_encoder(entity_id)}/settings",
            method="PATCH",
            json={
                "language": language,
                "currency": convert_and_respect_annotation_metadata(
                    object_=currency, annotation=CurrencySettingsInput, direction="write"
                ),
                "reminder": convert_and_respect_annotation_metadata(
                    object_=reminder, annotation=RemindersSettings, direction="write"
                ),
                "vat_mode": vat_mode,
                "vat_inclusive_discount_mode": vat_inclusive_discount_mode,
                "payment_priority": payment_priority,
                "allow_purchase_order_autolinking": allow_purchase_order_autolinking,
                "receivable_edit_flow": receivable_edit_flow,
                "document_ids": convert_and_respect_annotation_metadata(
                    object_=document_ids, annotation=DocumentIDsSettingsRequest, direction="write"
                ),
                "payables_ocr_auto_tagging": convert_and_respect_annotation_metadata(
                    object_=payables_ocr_auto_tagging,
                    annotation=typing.Sequence[OcrAutoTaggingSettingsRequest],
                    direction="write",
                ),
                "quote_signature_required": quote_signature_required,
                "generate_paid_invoice_pdf": generate_paid_invoice_pdf,
                "accounting": convert_and_respect_annotation_metadata(
                    object_=accounting, annotation=AccountingSettings, direction="write"
                ),
                "payables_skip_approval_flow": payables_skip_approval_flow,
                "document_rendering": convert_and_respect_annotation_metadata(
                    object_=document_rendering, annotation=DocumentRenderingSettings, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SettingsResponse,
                    parse_obj_as(
                        type_=SettingsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def upload_onboarding_documents(
        self,
        *,
        additional_verification_document_back: typing.Optional[str] = OMIT,
        additional_verification_document_front: typing.Optional[str] = OMIT,
        bank_account_ownership_verification: typing.Optional[typing.Sequence[str]] = OMIT,
        company_license: typing.Optional[typing.Sequence[str]] = OMIT,
        company_memorandum_of_association: typing.Optional[typing.Sequence[str]] = OMIT,
        company_ministerial_decree: typing.Optional[typing.Sequence[str]] = OMIT,
        company_registration_verification: typing.Optional[typing.Sequence[str]] = OMIT,
        company_tax_id_verification: typing.Optional[typing.Sequence[str]] = OMIT,
        proof_of_registration: typing.Optional[typing.Sequence[str]] = OMIT,
        verification_document_back: typing.Optional[str] = OMIT,
        verification_document_front: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Provide files for entity onboarding verification

        Parameters
        ----------
        additional_verification_document_back : typing.Optional[str]

        additional_verification_document_front : typing.Optional[str]

        bank_account_ownership_verification : typing.Optional[typing.Sequence[str]]

        company_license : typing.Optional[typing.Sequence[str]]

        company_memorandum_of_association : typing.Optional[typing.Sequence[str]]

        company_ministerial_decree : typing.Optional[typing.Sequence[str]]

        company_registration_verification : typing.Optional[typing.Sequence[str]]

        company_tax_id_verification : typing.Optional[typing.Sequence[str]]

        proof_of_registration : typing.Optional[typing.Sequence[str]]

        verification_document_back : typing.Optional[str]

        verification_document_front : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "onboarding_documents",
            method="POST",
            json={
                "additional_verification_document_back": additional_verification_document_back,
                "additional_verification_document_front": additional_verification_document_front,
                "bank_account_ownership_verification": bank_account_ownership_verification,
                "company_license": company_license,
                "company_memorandum_of_association": company_memorandum_of_association,
                "company_ministerial_decree": company_ministerial_decree,
                "company_registration_verification": company_registration_verification,
                "company_tax_id_verification": company_tax_id_verification,
                "proof_of_registration": proof_of_registration,
                "verification_document_back": verification_document_back,
                "verification_document_front": verification_document_front,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_onboarding_requirements(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetOnboardingRequirementsResponse]:
        """
        Get onboarding requirements for the entity

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetOnboardingRequirementsResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "onboarding_requirements",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetOnboardingRequirementsResponse,
                    parse_obj_as(
                        type_=GetOnboardingRequirementsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
