# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.entity_response import EntityResponse
from ..types.entity_user_cursor_fields import EntityUserCursorFields
from ..types.entity_user_pagination_response import EntityUserPaginationResponse
from ..types.entity_user_response import EntityUserResponse
from ..types.optional_individual_schema import OptionalIndividualSchema
from ..types.optional_organization_schema import OptionalOrganizationSchema
from ..types.order_enum import OrderEnum
from ..types.role_response import RoleResponse
from ..types.update_entity_address_schema import UpdateEntityAddressSchema
from .raw_client import AsyncRawEntityUsersClient, RawEntityUsersClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EntityUsersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEntityUsersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEntityUsersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEntityUsersClient
        """
        return self._raw_client

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[EntityUserCursorFields] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        id_not_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        role_id: typing.Optional[str] = None,
        role_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        login: typing.Optional[str] = None,
        status: typing.Optional[str] = None,
        first_name: typing.Optional[str] = None,
        name_istartswith: typing.Optional[str] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityUserPaginationResponse:
        """
        Retrieve a list of all entity users.

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[EntityUserCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        id_not_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        role_id : typing.Optional[str]

        role_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        login : typing.Optional[str]

        status : typing.Optional[str]

        first_name : typing.Optional[str]

        name_istartswith : typing.Optional[str]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityUserPaginationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entity_users.get()
        """
        _response = self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            id_in=id_in,
            id_not_in=id_not_in,
            role_id=role_id,
            role_id_in=role_id_in,
            login=login,
            status=status,
            first_name=first_name,
            name_istartswith=name_istartswith,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        first_name: str,
        login: str,
        email: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        role_id: typing.Optional[str] = OMIT,
        title: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityUserResponse:
        """
        Create a new entity user from the specified values.

        Parameters
        ----------
        first_name : str
            First name

        login : str

        email : typing.Optional[str]
            An entity user business email

        last_name : typing.Optional[str]
            Last name

        phone : typing.Optional[str]
            An entity user phone number in the international format

        role_id : typing.Optional[str]
            UUID of the role assigned to this entity user

        title : typing.Optional[str]
            Title

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityUserResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entity_users.create(first_name='Casey', login='login', )
        """
        _response = self._raw_client.create(
            first_name=first_name,
            login=login,
            email=email,
            last_name=last_name,
            phone=phone,
            role_id=role_id,
            title=title,
            request_options=request_options,
        )
        return _response.data

    def get_current(self, *, request_options: typing.Optional[RequestOptions] = None) -> EntityUserResponse:
        """
        Retrieve an entity user by its ID.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityUserResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entity_users.get_current()
        """
        _response = self._raw_client.get_current(request_options=request_options)
        return _response.data

    def update_current(
        self,
        *,
        email: typing.Optional[str] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        title: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityUserResponse:
        """
        Change the specified fields with provided values.

        Parameters
        ----------
        email : typing.Optional[str]
            An entity user business email

        first_name : typing.Optional[str]
            First name

        last_name : typing.Optional[str]
            Last name

        phone : typing.Optional[str]
            An entity user phone number in the international format

        title : typing.Optional[str]
            Title

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityUserResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entity_users.update_current()
        """
        _response = self._raw_client.update_current(
            email=email,
            first_name=first_name,
            last_name=last_name,
            phone=phone,
            title=title,
            request_options=request_options,
        )
        return _response.data

    def get_current_entity(self, *, request_options: typing.Optional[RequestOptions] = None) -> EntityResponse:
        """
        Retrieves information of an entity, which this entity user belongs to.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entity_users.get_current_entity()
        """
        _response = self._raw_client.get_current_entity(request_options=request_options)
        return _response.data

    def update_current_entity(
        self,
        *,
        address: typing.Optional[UpdateEntityAddressSchema] = OMIT,
        email: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        website: typing.Optional[str] = OMIT,
        tax_id: typing.Optional[str] = OMIT,
        registration_number: typing.Optional[str] = OMIT,
        registration_authority: typing.Optional[str] = OMIT,
        organization: typing.Optional[OptionalOrganizationSchema] = OMIT,
        individual: typing.Optional[OptionalIndividualSchema] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityResponse:
        """
        Update information of an entity, which this entity user belongs to.

        Parameters
        ----------
        address : typing.Optional[UpdateEntityAddressSchema]
            An address description of the entity

        email : typing.Optional[str]
            An official email address of the entity

        phone : typing.Optional[str]
            The contact phone number of the entity. Required for US organizations to use payments.

        website : typing.Optional[str]
            A website of the entity

        tax_id : typing.Optional[str]
            The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.

        registration_number : typing.Optional[str]
            (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.

        registration_authority : typing.Optional[str]
            (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.

        organization : typing.Optional[OptionalOrganizationSchema]
            A set of meta data describing the organization

        individual : typing.Optional[OptionalIndividualSchema]
            A set of meta data describing the individual

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entity_users.update_current_entity()
        """
        _response = self._raw_client.update_current_entity(
            address=address,
            email=email,
            phone=phone,
            website=website,
            tax_id=tax_id,
            registration_number=registration_number,
            registration_authority=registration_authority,
            organization=organization,
            individual=individual,
            request_options=request_options,
        )
        return _response.data

    def get_current_role(self, *, request_options: typing.Optional[RequestOptions] = None) -> RoleResponse:
        """
        Retrieves information of a role assigned to this entity user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RoleResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entity_users.get_current_role()
        """
        _response = self._raw_client.get_current_role(request_options=request_options)
        return _response.data

    def get_by_id(
        self, entity_user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EntityUserResponse:
        """
        Retrieve an entity user by its ID.

        Parameters
        ----------
        entity_user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityUserResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entity_users.get_by_id(entity_user_id='entity_user_id', )
        """
        _response = self._raw_client.get_by_id(entity_user_id, request_options=request_options)
        return _response.data

    def delete_by_id(self, entity_user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        entity_user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entity_users.delete_by_id(entity_user_id='entity_user_id', )
        """
        _response = self._raw_client.delete_by_id(entity_user_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        entity_user_id: str,
        *,
        email: typing.Optional[str] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        login: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        role_id: typing.Optional[str] = OMIT,
        title: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityUserResponse:
        """
        Change the specified fields with provided values.

        Parameters
        ----------
        entity_user_id : str

        email : typing.Optional[str]
            An entity user business email

        first_name : typing.Optional[str]
            First name

        last_name : typing.Optional[str]
            Last name

        login : typing.Optional[str]
            Login

        phone : typing.Optional[str]
            An entity user phone number in the international format

        role_id : typing.Optional[str]
            UUID of the role assigned to this entity user

        title : typing.Optional[str]
            Title

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityUserResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.entity_users.update_by_id(entity_user_id='entity_user_id', )
        """
        _response = self._raw_client.update_by_id(
            entity_user_id,
            email=email,
            first_name=first_name,
            last_name=last_name,
            login=login,
            phone=phone,
            role_id=role_id,
            title=title,
            request_options=request_options,
        )
        return _response.data


class AsyncEntityUsersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEntityUsersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEntityUsersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEntityUsersClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[EntityUserCursorFields] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        id_not_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        role_id: typing.Optional[str] = None,
        role_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        login: typing.Optional[str] = None,
        status: typing.Optional[str] = None,
        first_name: typing.Optional[str] = None,
        name_istartswith: typing.Optional[str] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityUserPaginationResponse:
        """
        Retrieve a list of all entity users.

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[EntityUserCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        id_not_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        role_id : typing.Optional[str]

        role_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        login : typing.Optional[str]

        status : typing.Optional[str]

        first_name : typing.Optional[str]

        name_istartswith : typing.Optional[str]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityUserPaginationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entity_users.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            id_in=id_in,
            id_not_in=id_not_in,
            role_id=role_id,
            role_id_in=role_id_in,
            login=login,
            status=status,
            first_name=first_name,
            name_istartswith=name_istartswith,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        first_name: str,
        login: str,
        email: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        role_id: typing.Optional[str] = OMIT,
        title: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityUserResponse:
        """
        Create a new entity user from the specified values.

        Parameters
        ----------
        first_name : str
            First name

        login : str

        email : typing.Optional[str]
            An entity user business email

        last_name : typing.Optional[str]
            Last name

        phone : typing.Optional[str]
            An entity user phone number in the international format

        role_id : typing.Optional[str]
            UUID of the role assigned to this entity user

        title : typing.Optional[str]
            Title

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityUserResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entity_users.create(first_name='Casey', login='login', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            first_name=first_name,
            login=login,
            email=email,
            last_name=last_name,
            phone=phone,
            role_id=role_id,
            title=title,
            request_options=request_options,
        )
        return _response.data

    async def get_current(self, *, request_options: typing.Optional[RequestOptions] = None) -> EntityUserResponse:
        """
        Retrieve an entity user by its ID.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityUserResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entity_users.get_current()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_current(request_options=request_options)
        return _response.data

    async def update_current(
        self,
        *,
        email: typing.Optional[str] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        title: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityUserResponse:
        """
        Change the specified fields with provided values.

        Parameters
        ----------
        email : typing.Optional[str]
            An entity user business email

        first_name : typing.Optional[str]
            First name

        last_name : typing.Optional[str]
            Last name

        phone : typing.Optional[str]
            An entity user phone number in the international format

        title : typing.Optional[str]
            Title

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityUserResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entity_users.update_current()
        asyncio.run(main())
        """
        _response = await self._raw_client.update_current(
            email=email,
            first_name=first_name,
            last_name=last_name,
            phone=phone,
            title=title,
            request_options=request_options,
        )
        return _response.data

    async def get_current_entity(self, *, request_options: typing.Optional[RequestOptions] = None) -> EntityResponse:
        """
        Retrieves information of an entity, which this entity user belongs to.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entity_users.get_current_entity()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_current_entity(request_options=request_options)
        return _response.data

    async def update_current_entity(
        self,
        *,
        address: typing.Optional[UpdateEntityAddressSchema] = OMIT,
        email: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        website: typing.Optional[str] = OMIT,
        tax_id: typing.Optional[str] = OMIT,
        registration_number: typing.Optional[str] = OMIT,
        registration_authority: typing.Optional[str] = OMIT,
        organization: typing.Optional[OptionalOrganizationSchema] = OMIT,
        individual: typing.Optional[OptionalIndividualSchema] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityResponse:
        """
        Update information of an entity, which this entity user belongs to.

        Parameters
        ----------
        address : typing.Optional[UpdateEntityAddressSchema]
            An address description of the entity

        email : typing.Optional[str]
            An official email address of the entity

        phone : typing.Optional[str]
            The contact phone number of the entity. Required for US organizations to use payments.

        website : typing.Optional[str]
            A website of the entity

        tax_id : typing.Optional[str]
            The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.

        registration_number : typing.Optional[str]
            (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.

        registration_authority : typing.Optional[str]
            (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.

        organization : typing.Optional[OptionalOrganizationSchema]
            A set of meta data describing the organization

        individual : typing.Optional[OptionalIndividualSchema]
            A set of meta data describing the individual

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entity_users.update_current_entity()
        asyncio.run(main())
        """
        _response = await self._raw_client.update_current_entity(
            address=address,
            email=email,
            phone=phone,
            website=website,
            tax_id=tax_id,
            registration_number=registration_number,
            registration_authority=registration_authority,
            organization=organization,
            individual=individual,
            request_options=request_options,
        )
        return _response.data

    async def get_current_role(self, *, request_options: typing.Optional[RequestOptions] = None) -> RoleResponse:
        """
        Retrieves information of a role assigned to this entity user.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RoleResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entity_users.get_current_role()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_current_role(request_options=request_options)
        return _response.data

    async def get_by_id(
        self, entity_user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EntityUserResponse:
        """
        Retrieve an entity user by its ID.

        Parameters
        ----------
        entity_user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityUserResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entity_users.get_by_id(entity_user_id='entity_user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(entity_user_id, request_options=request_options)
        return _response.data

    async def delete_by_id(
        self, entity_user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        entity_user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entity_users.delete_by_id(entity_user_id='entity_user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(entity_user_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        entity_user_id: str,
        *,
        email: typing.Optional[str] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        login: typing.Optional[str] = OMIT,
        phone: typing.Optional[str] = OMIT,
        role_id: typing.Optional[str] = OMIT,
        title: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EntityUserResponse:
        """
        Change the specified fields with provided values.

        Parameters
        ----------
        entity_user_id : str

        email : typing.Optional[str]
            An entity user business email

        first_name : typing.Optional[str]
            First name

        last_name : typing.Optional[str]
            Last name

        login : typing.Optional[str]
            Login

        phone : typing.Optional[str]
            An entity user phone number in the international format

        role_id : typing.Optional[str]
            UUID of the role assigned to this entity user

        title : typing.Optional[str]
            Title

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EntityUserResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.entity_users.update_by_id(entity_user_id='entity_user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            entity_user_id,
            email=email,
            first_name=first_name,
            last_name=last_name,
            login=login,
            phone=phone,
            role_id=role_id,
            title=title,
            request_options=request_options,
        )
        return _response.data
