# This file was auto-generated by Fern from our API Definition.

import typing

from .. import core
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.allowed_file_types import AllowedFileTypes
from ..types.file_response import FileResponse
from ..types.files_response import FilesResponse
from .raw_client import AsyncRawFilesClient, RawFilesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FilesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFilesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFilesClient
        """
        return self._raw_client

    def get(
        self,
        *,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FilesResponse:
        """
        Parameters
        ----------
        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.files.get()
        """
        _response = self._raw_client.get(id_in=id_in, request_options=request_options)
        return _response.data

    def upload(
        self, *, file: core.File, file_type: AllowedFileTypes, request_options: typing.Optional[RequestOptions] = None
    ) -> FileResponse:
        """
        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        file_type : AllowedFileTypes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.files.upload(file_type="ocr_results", )
        """
        _response = self._raw_client.upload(file=file, file_type=file_type, request_options=request_options)
        return _response.data

    def get_by_id(self, file_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> FileResponse:
        """
        Parameters
        ----------
        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.files.get_by_id(file_id='file_id', )
        """
        _response = self._raw_client.get_by_id(file_id, request_options=request_options)
        return _response.data

    def delete(self, file_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.files.delete(file_id='file_id', )
        """
        _response = self._raw_client.delete(file_id, request_options=request_options)
        return _response.data


class AsyncFilesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFilesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFilesClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FilesResponse:
        """
        Parameters
        ----------
        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FilesResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.files.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(id_in=id_in, request_options=request_options)
        return _response.data

    async def upload(
        self, *, file: core.File, file_type: AllowedFileTypes, request_options: typing.Optional[RequestOptions] = None
    ) -> FileResponse:
        """
        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        file_type : AllowedFileTypes

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.files.upload(file_type="ocr_results", )
        asyncio.run(main())
        """
        _response = await self._raw_client.upload(file=file, file_type=file_type, request_options=request_options)
        return _response.data

    async def get_by_id(self, file_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> FileResponse:
        """
        Parameters
        ----------
        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.files.get_by_id(file_id='file_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(file_id, request_options=request_options)
        return _response.data

    async def delete(self, file_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        file_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.files.delete(file_id='file_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete(file_id, request_options=request_options)
        return _response.data
