# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.datetime_utils import serialize_datetime
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.internal_server_error import InternalServerError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.financing_invoice_cursor_fields import FinancingInvoiceCursorFields
from ..types.financing_invoice_list_response import FinancingInvoiceListResponse
from ..types.financing_invoice_type import FinancingInvoiceType
from ..types.financing_offers_response import FinancingOffersResponse
from ..types.financing_push_invoices_request_invoice import FinancingPushInvoicesRequestInvoice
from ..types.financing_push_invoices_response import FinancingPushInvoicesResponse
from ..types.financing_token_response import FinancingTokenResponse
from ..types.order_enum import OrderEnum
from ..types.wc_invoice_status import WcInvoiceStatus

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawFinancingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_financing_invoices(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[FinancingInvoiceCursorFields] = None,
        invoice_id: typing.Optional[str] = None,
        invoice_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[WcInvoiceStatus] = None,
        status_in: typing.Optional[typing.Union[WcInvoiceStatus, typing.Sequence[WcInvoiceStatus]]] = None,
        type: typing.Optional[FinancingInvoiceType] = None,
        type_in: typing.Optional[typing.Union[FinancingInvoiceType, typing.Sequence[FinancingInvoiceType]]] = None,
        document_id: typing.Optional[str] = None,
        document_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        issue_date_gt: typing.Optional[dt.datetime] = None,
        issue_date_lt: typing.Optional[dt.datetime] = None,
        issue_date_gte: typing.Optional[dt.datetime] = None,
        issue_date_lte: typing.Optional[dt.datetime] = None,
        due_date_gt: typing.Optional[dt.datetime] = None,
        due_date_lt: typing.Optional[dt.datetime] = None,
        due_date_gte: typing.Optional[dt.datetime] = None,
        due_date_lte: typing.Optional[dt.datetime] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        total_amount: typing.Optional[int] = None,
        total_amount_gt: typing.Optional[int] = None,
        total_amount_lt: typing.Optional[int] = None,
        total_amount_gte: typing.Optional[int] = None,
        total_amount_lte: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[FinancingInvoiceListResponse]:
        """
        Returns a list of invoices requested for financing

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[FinancingInvoiceCursorFields]
            Allowed sort fields

        invoice_id : typing.Optional[str]
            ID of a payable or receivable invoice.

        invoice_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of invoice IDs.

        status : typing.Optional[WcInvoiceStatus]
            Status of the invoice.

        status_in : typing.Optional[typing.Union[WcInvoiceStatus, typing.Sequence[WcInvoiceStatus]]]
            List of invoice statuses.

        type : typing.Optional[FinancingInvoiceType]
            Type of the invoice. payable or receivable.

        type_in : typing.Optional[typing.Union[FinancingInvoiceType, typing.Sequence[FinancingInvoiceType]]]
            List of invoice types.

        document_id : typing.Optional[str]
            Document ID of the invoice.

        document_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of document IDs.

        issue_date_gt : typing.Optional[dt.datetime]
            Issue date greater than.

        issue_date_lt : typing.Optional[dt.datetime]
            Issue date less than.

        issue_date_gte : typing.Optional[dt.datetime]
            Issue date greater than or equal.

        issue_date_lte : typing.Optional[dt.datetime]
            Issue date less than or equal.

        due_date_gt : typing.Optional[dt.datetime]
            Due date greater than.

        due_date_lt : typing.Optional[dt.datetime]
            Due date less than.

        due_date_gte : typing.Optional[dt.datetime]
            Due date greater than or equal.

        due_date_lte : typing.Optional[dt.datetime]
            Due date less than or equal.

        created_at_gt : typing.Optional[dt.datetime]
            Created date greater than.

        created_at_lt : typing.Optional[dt.datetime]
            Created date less than.

        created_at_gte : typing.Optional[dt.datetime]
            Created date greater than or equal.

        created_at_lte : typing.Optional[dt.datetime]
            Created date less than or equal.

        total_amount : typing.Optional[int]
            Total amount of the invoice in minor units.

        total_amount_gt : typing.Optional[int]
            Total amount greater than.

        total_amount_lt : typing.Optional[int]
            Total amount less than.

        total_amount_gte : typing.Optional[int]
            Total amount greater than or equal.

        total_amount_lte : typing.Optional[int]
            Total amount less than or equal.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[FinancingInvoiceListResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "financing_invoices",
            method="GET",
            params={
                "order": order,
                "limit": limit,
                "pagination_token": pagination_token,
                "sort": sort,
                "invoice_id": invoice_id,
                "invoice_id__in": invoice_id_in,
                "status": status,
                "status__in": status_in,
                "type": type,
                "type__in": type_in,
                "document_id": document_id,
                "document_id__in": document_id_in,
                "issue_date__gt": serialize_datetime(issue_date_gt) if issue_date_gt is not None else None,
                "issue_date__lt": serialize_datetime(issue_date_lt) if issue_date_lt is not None else None,
                "issue_date__gte": serialize_datetime(issue_date_gte) if issue_date_gte is not None else None,
                "issue_date__lte": serialize_datetime(issue_date_lte) if issue_date_lte is not None else None,
                "due_date__gt": serialize_datetime(due_date_gt) if due_date_gt is not None else None,
                "due_date__lt": serialize_datetime(due_date_lt) if due_date_lt is not None else None,
                "due_date__gte": serialize_datetime(due_date_gte) if due_date_gte is not None else None,
                "due_date__lte": serialize_datetime(due_date_lte) if due_date_lte is not None else None,
                "created_at__gt": serialize_datetime(created_at_gt) if created_at_gt is not None else None,
                "created_at__lt": serialize_datetime(created_at_lt) if created_at_lt is not None else None,
                "created_at__gte": serialize_datetime(created_at_gte) if created_at_gte is not None else None,
                "created_at__lte": serialize_datetime(created_at_lte) if created_at_lte is not None else None,
                "total_amount": total_amount,
                "total_amount__gt": total_amount_gt,
                "total_amount__lt": total_amount_lt,
                "total_amount__gte": total_amount_gte,
                "total_amount__lte": total_amount_lte,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FinancingInvoiceListResponse,
                    parse_obj_as(
                        type_=FinancingInvoiceListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def post_financing_invoices(
        self,
        *,
        invoices: typing.Sequence[FinancingPushInvoicesRequestInvoice],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[FinancingPushInvoicesResponse]:
        """
        Returns a session token and a connect token to open Kanmon SDK for confirming invoice details.

        Parameters
        ----------
        invoices : typing.Sequence[FinancingPushInvoicesRequestInvoice]
            A list of invoices to request financing for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[FinancingPushInvoicesResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "financing_invoices",
            method="POST",
            json={
                "invoices": convert_and_respect_annotation_metadata(
                    object_=invoices, annotation=typing.Sequence[FinancingPushInvoicesRequestInvoice], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FinancingPushInvoicesResponse,
                    parse_obj_as(
                        type_=FinancingPushInvoicesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_financing_offers(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[FinancingOffersResponse]:
        """
        Returns a list of financing offers and the business's onboarding status

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[FinancingOffersResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "financing_offers",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FinancingOffersResponse,
                    parse_obj_as(
                        type_=FinancingOffersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def post_financing_tokens(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[FinancingTokenResponse]:
        """
        Returns a token for Kanmon SDK. Creates a business and user on Kanmon if not already exist.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[FinancingTokenResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "financing_tokens",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FinancingTokenResponse,
                    parse_obj_as(
                        type_=FinancingTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawFinancingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_financing_invoices(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[FinancingInvoiceCursorFields] = None,
        invoice_id: typing.Optional[str] = None,
        invoice_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status: typing.Optional[WcInvoiceStatus] = None,
        status_in: typing.Optional[typing.Union[WcInvoiceStatus, typing.Sequence[WcInvoiceStatus]]] = None,
        type: typing.Optional[FinancingInvoiceType] = None,
        type_in: typing.Optional[typing.Union[FinancingInvoiceType, typing.Sequence[FinancingInvoiceType]]] = None,
        document_id: typing.Optional[str] = None,
        document_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        issue_date_gt: typing.Optional[dt.datetime] = None,
        issue_date_lt: typing.Optional[dt.datetime] = None,
        issue_date_gte: typing.Optional[dt.datetime] = None,
        issue_date_lte: typing.Optional[dt.datetime] = None,
        due_date_gt: typing.Optional[dt.datetime] = None,
        due_date_lt: typing.Optional[dt.datetime] = None,
        due_date_gte: typing.Optional[dt.datetime] = None,
        due_date_lte: typing.Optional[dt.datetime] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        total_amount: typing.Optional[int] = None,
        total_amount_gt: typing.Optional[int] = None,
        total_amount_lt: typing.Optional[int] = None,
        total_amount_gte: typing.Optional[int] = None,
        total_amount_lte: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[FinancingInvoiceListResponse]:
        """
        Returns a list of invoices requested for financing

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[FinancingInvoiceCursorFields]
            Allowed sort fields

        invoice_id : typing.Optional[str]
            ID of a payable or receivable invoice.

        invoice_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of invoice IDs.

        status : typing.Optional[WcInvoiceStatus]
            Status of the invoice.

        status_in : typing.Optional[typing.Union[WcInvoiceStatus, typing.Sequence[WcInvoiceStatus]]]
            List of invoice statuses.

        type : typing.Optional[FinancingInvoiceType]
            Type of the invoice. payable or receivable.

        type_in : typing.Optional[typing.Union[FinancingInvoiceType, typing.Sequence[FinancingInvoiceType]]]
            List of invoice types.

        document_id : typing.Optional[str]
            Document ID of the invoice.

        document_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of document IDs.

        issue_date_gt : typing.Optional[dt.datetime]
            Issue date greater than.

        issue_date_lt : typing.Optional[dt.datetime]
            Issue date less than.

        issue_date_gte : typing.Optional[dt.datetime]
            Issue date greater than or equal.

        issue_date_lte : typing.Optional[dt.datetime]
            Issue date less than or equal.

        due_date_gt : typing.Optional[dt.datetime]
            Due date greater than.

        due_date_lt : typing.Optional[dt.datetime]
            Due date less than.

        due_date_gte : typing.Optional[dt.datetime]
            Due date greater than or equal.

        due_date_lte : typing.Optional[dt.datetime]
            Due date less than or equal.

        created_at_gt : typing.Optional[dt.datetime]
            Created date greater than.

        created_at_lt : typing.Optional[dt.datetime]
            Created date less than.

        created_at_gte : typing.Optional[dt.datetime]
            Created date greater than or equal.

        created_at_lte : typing.Optional[dt.datetime]
            Created date less than or equal.

        total_amount : typing.Optional[int]
            Total amount of the invoice in minor units.

        total_amount_gt : typing.Optional[int]
            Total amount greater than.

        total_amount_lt : typing.Optional[int]
            Total amount less than.

        total_amount_gte : typing.Optional[int]
            Total amount greater than or equal.

        total_amount_lte : typing.Optional[int]
            Total amount less than or equal.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[FinancingInvoiceListResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "financing_invoices",
            method="GET",
            params={
                "order": order,
                "limit": limit,
                "pagination_token": pagination_token,
                "sort": sort,
                "invoice_id": invoice_id,
                "invoice_id__in": invoice_id_in,
                "status": status,
                "status__in": status_in,
                "type": type,
                "type__in": type_in,
                "document_id": document_id,
                "document_id__in": document_id_in,
                "issue_date__gt": serialize_datetime(issue_date_gt) if issue_date_gt is not None else None,
                "issue_date__lt": serialize_datetime(issue_date_lt) if issue_date_lt is not None else None,
                "issue_date__gte": serialize_datetime(issue_date_gte) if issue_date_gte is not None else None,
                "issue_date__lte": serialize_datetime(issue_date_lte) if issue_date_lte is not None else None,
                "due_date__gt": serialize_datetime(due_date_gt) if due_date_gt is not None else None,
                "due_date__lt": serialize_datetime(due_date_lt) if due_date_lt is not None else None,
                "due_date__gte": serialize_datetime(due_date_gte) if due_date_gte is not None else None,
                "due_date__lte": serialize_datetime(due_date_lte) if due_date_lte is not None else None,
                "created_at__gt": serialize_datetime(created_at_gt) if created_at_gt is not None else None,
                "created_at__lt": serialize_datetime(created_at_lt) if created_at_lt is not None else None,
                "created_at__gte": serialize_datetime(created_at_gte) if created_at_gte is not None else None,
                "created_at__lte": serialize_datetime(created_at_lte) if created_at_lte is not None else None,
                "total_amount": total_amount,
                "total_amount__gt": total_amount_gt,
                "total_amount__lt": total_amount_lt,
                "total_amount__gte": total_amount_gte,
                "total_amount__lte": total_amount_lte,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FinancingInvoiceListResponse,
                    parse_obj_as(
                        type_=FinancingInvoiceListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def post_financing_invoices(
        self,
        *,
        invoices: typing.Sequence[FinancingPushInvoicesRequestInvoice],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[FinancingPushInvoicesResponse]:
        """
        Returns a session token and a connect token to open Kanmon SDK for confirming invoice details.

        Parameters
        ----------
        invoices : typing.Sequence[FinancingPushInvoicesRequestInvoice]
            A list of invoices to request financing for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[FinancingPushInvoicesResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "financing_invoices",
            method="POST",
            json={
                "invoices": convert_and_respect_annotation_metadata(
                    object_=invoices, annotation=typing.Sequence[FinancingPushInvoicesRequestInvoice], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FinancingPushInvoicesResponse,
                    parse_obj_as(
                        type_=FinancingPushInvoicesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_financing_offers(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[FinancingOffersResponse]:
        """
        Returns a list of financing offers and the business's onboarding status

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[FinancingOffersResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "financing_offers",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FinancingOffersResponse,
                    parse_obj_as(
                        type_=FinancingOffersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def post_financing_tokens(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[FinancingTokenResponse]:
        """
        Returns a token for Kanmon SDK. Creates a business and user on Kanmon if not already exist.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[FinancingTokenResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "financing_tokens",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    FinancingTokenResponse,
                    parse_obj_as(
                        type_=FinancingTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
