# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.internal_server_error import InternalServerError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.custom_template_data_schema import CustomTemplateDataSchema
from ..types.custom_templates_cursor_fields import CustomTemplatesCursorFields
from ..types.custom_templates_pagination_response import CustomTemplatesPaginationResponse
from ..types.document_object_type_request_enum import DocumentObjectTypeRequestEnum
from ..types.language_code_enum import LanguageCodeEnum
from ..types.order_enum import OrderEnum
from ..types.preview_template_response import PreviewTemplateResponse
from ..types.system_templates import SystemTemplates

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawMailTemplatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[CustomTemplatesCursorFields] = None,
        type: typing.Optional[DocumentObjectTypeRequestEnum] = None,
        type_in: typing.Optional[
            typing.Union[DocumentObjectTypeRequestEnum, typing.Sequence[DocumentObjectTypeRequestEnum]]
        ] = None,
        type_not_in: typing.Optional[
            typing.Union[DocumentObjectTypeRequestEnum, typing.Sequence[DocumentObjectTypeRequestEnum]]
        ] = None,
        is_default: typing.Optional[bool] = None,
        name: typing.Optional[str] = None,
        name_iexact: typing.Optional[str] = None,
        name_contains: typing.Optional[str] = None,
        name_icontains: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CustomTemplatesPaginationResponse]:
        """
        Get all custom templates

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[CustomTemplatesCursorFields]
            Allowed sort fields

        type : typing.Optional[DocumentObjectTypeRequestEnum]

        type_in : typing.Optional[typing.Union[DocumentObjectTypeRequestEnum, typing.Sequence[DocumentObjectTypeRequestEnum]]]

        type_not_in : typing.Optional[typing.Union[DocumentObjectTypeRequestEnum, typing.Sequence[DocumentObjectTypeRequestEnum]]]

        is_default : typing.Optional[bool]

        name : typing.Optional[str]

        name_iexact : typing.Optional[str]

        name_contains : typing.Optional[str]

        name_icontains : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CustomTemplatesPaginationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "mail_templates",
            method="GET",
            params={
                "order": order,
                "limit": limit,
                "pagination_token": pagination_token,
                "sort": sort,
                "type": type,
                "type__in": type_in,
                "type__not_in": type_not_in,
                "is_default": is_default,
                "name": name,
                "name__iexact": name_iexact,
                "name__contains": name_contains,
                "name__icontains": name_icontains,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomTemplatesPaginationResponse,
                    parse_obj_as(
                        type_=CustomTemplatesPaginationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        body_template: str,
        name: str,
        subject_template: str,
        type: DocumentObjectTypeRequestEnum,
        is_default: typing.Optional[bool] = OMIT,
        language: typing.Optional[LanguageCodeEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CustomTemplateDataSchema]:
        """
        Create custom template

        Parameters
        ----------
        body_template : str
            Jinja2 compatible string with email body

        name : str
            Custom template name

        subject_template : str
            Jinja2 compatible string with email subject

        type : DocumentObjectTypeRequestEnum
            Document type of content

        is_default : typing.Optional[bool]
            Is default template

        language : typing.Optional[LanguageCodeEnum]
            Lowercase ISO code of language

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CustomTemplateDataSchema]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "mail_templates",
            method="POST",
            json={
                "body_template": body_template,
                "is_default": is_default,
                "language": language,
                "name": name,
                "subject_template": subject_template,
                "type": type,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomTemplateDataSchema,
                    parse_obj_as(
                        type_=CustomTemplateDataSchema,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def preview(
        self,
        *,
        body: str,
        document_type: DocumentObjectTypeRequestEnum,
        language_code: LanguageCodeEnum,
        subject: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PreviewTemplateResponse]:
        """
        Preview rendered template

        Parameters
        ----------
        body : str
            Body text of the template

        document_type : DocumentObjectTypeRequestEnum
            Document type of content

        language_code : LanguageCodeEnum
            Lowercase ISO code of language

        subject : str
            Subject text of the template

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PreviewTemplateResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "mail_templates/preview",
            method="POST",
            json={
                "body": body,
                "document_type": document_type,
                "language_code": language_code,
                "subject": subject,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PreviewTemplateResponse,
                    parse_obj_as(
                        type_=PreviewTemplateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_system(self, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[SystemTemplates]:
        """
        Get all system templates

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SystemTemplates]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "mail_templates/system",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SystemTemplates,
                    parse_obj_as(
                        type_=SystemTemplates,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_by_id(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CustomTemplateDataSchema]:
        """
        Get custom template by ID

        Parameters
        ----------
        template_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CustomTemplateDataSchema]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"mail_templates/{jsonable_encoder(template_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomTemplateDataSchema,
                    parse_obj_as(
                        type_=CustomTemplateDataSchema,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_by_id(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Delete custom template bt ID

        Parameters
        ----------
        template_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"mail_templates/{jsonable_encoder(template_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_by_id(
        self,
        template_id: str,
        *,
        body_template: typing.Optional[str] = OMIT,
        language: typing.Optional[LanguageCodeEnum] = OMIT,
        name: typing.Optional[str] = OMIT,
        subject_template: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CustomTemplateDataSchema]:
        """
        Update custom template by ID

        Parameters
        ----------
        template_id : str

        body_template : typing.Optional[str]
            Jinja2 compatible string with email body

        language : typing.Optional[LanguageCodeEnum]
            Lowercase ISO code of language

        name : typing.Optional[str]
            Custom template name

        subject_template : typing.Optional[str]
            Jinja2 compatible string with email subject

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CustomTemplateDataSchema]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"mail_templates/{jsonable_encoder(template_id)}",
            method="PATCH",
            json={
                "body_template": body_template,
                "language": language,
                "name": name,
                "subject_template": subject_template,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomTemplateDataSchema,
                    parse_obj_as(
                        type_=CustomTemplateDataSchema,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def make_default_by_id(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CustomTemplateDataSchema]:
        """
        Make template default

        Parameters
        ----------
        template_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CustomTemplateDataSchema]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"mail_templates/{jsonable_encoder(template_id)}/make_default",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomTemplateDataSchema,
                    parse_obj_as(
                        type_=CustomTemplateDataSchema,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawMailTemplatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[CustomTemplatesCursorFields] = None,
        type: typing.Optional[DocumentObjectTypeRequestEnum] = None,
        type_in: typing.Optional[
            typing.Union[DocumentObjectTypeRequestEnum, typing.Sequence[DocumentObjectTypeRequestEnum]]
        ] = None,
        type_not_in: typing.Optional[
            typing.Union[DocumentObjectTypeRequestEnum, typing.Sequence[DocumentObjectTypeRequestEnum]]
        ] = None,
        is_default: typing.Optional[bool] = None,
        name: typing.Optional[str] = None,
        name_iexact: typing.Optional[str] = None,
        name_contains: typing.Optional[str] = None,
        name_icontains: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CustomTemplatesPaginationResponse]:
        """
        Get all custom templates

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[CustomTemplatesCursorFields]
            Allowed sort fields

        type : typing.Optional[DocumentObjectTypeRequestEnum]

        type_in : typing.Optional[typing.Union[DocumentObjectTypeRequestEnum, typing.Sequence[DocumentObjectTypeRequestEnum]]]

        type_not_in : typing.Optional[typing.Union[DocumentObjectTypeRequestEnum, typing.Sequence[DocumentObjectTypeRequestEnum]]]

        is_default : typing.Optional[bool]

        name : typing.Optional[str]

        name_iexact : typing.Optional[str]

        name_contains : typing.Optional[str]

        name_icontains : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CustomTemplatesPaginationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "mail_templates",
            method="GET",
            params={
                "order": order,
                "limit": limit,
                "pagination_token": pagination_token,
                "sort": sort,
                "type": type,
                "type__in": type_in,
                "type__not_in": type_not_in,
                "is_default": is_default,
                "name": name,
                "name__iexact": name_iexact,
                "name__contains": name_contains,
                "name__icontains": name_icontains,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomTemplatesPaginationResponse,
                    parse_obj_as(
                        type_=CustomTemplatesPaginationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        body_template: str,
        name: str,
        subject_template: str,
        type: DocumentObjectTypeRequestEnum,
        is_default: typing.Optional[bool] = OMIT,
        language: typing.Optional[LanguageCodeEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CustomTemplateDataSchema]:
        """
        Create custom template

        Parameters
        ----------
        body_template : str
            Jinja2 compatible string with email body

        name : str
            Custom template name

        subject_template : str
            Jinja2 compatible string with email subject

        type : DocumentObjectTypeRequestEnum
            Document type of content

        is_default : typing.Optional[bool]
            Is default template

        language : typing.Optional[LanguageCodeEnum]
            Lowercase ISO code of language

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CustomTemplateDataSchema]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "mail_templates",
            method="POST",
            json={
                "body_template": body_template,
                "is_default": is_default,
                "language": language,
                "name": name,
                "subject_template": subject_template,
                "type": type,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomTemplateDataSchema,
                    parse_obj_as(
                        type_=CustomTemplateDataSchema,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def preview(
        self,
        *,
        body: str,
        document_type: DocumentObjectTypeRequestEnum,
        language_code: LanguageCodeEnum,
        subject: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PreviewTemplateResponse]:
        """
        Preview rendered template

        Parameters
        ----------
        body : str
            Body text of the template

        document_type : DocumentObjectTypeRequestEnum
            Document type of content

        language_code : LanguageCodeEnum
            Lowercase ISO code of language

        subject : str
            Subject text of the template

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PreviewTemplateResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "mail_templates/preview",
            method="POST",
            json={
                "body": body,
                "document_type": document_type,
                "language_code": language_code,
                "subject": subject,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PreviewTemplateResponse,
                    parse_obj_as(
                        type_=PreviewTemplateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_system(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[SystemTemplates]:
        """
        Get all system templates

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SystemTemplates]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "mail_templates/system",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SystemTemplates,
                    parse_obj_as(
                        type_=SystemTemplates,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_by_id(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CustomTemplateDataSchema]:
        """
        Get custom template by ID

        Parameters
        ----------
        template_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CustomTemplateDataSchema]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"mail_templates/{jsonable_encoder(template_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomTemplateDataSchema,
                    parse_obj_as(
                        type_=CustomTemplateDataSchema,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_by_id(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Delete custom template bt ID

        Parameters
        ----------
        template_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"mail_templates/{jsonable_encoder(template_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_by_id(
        self,
        template_id: str,
        *,
        body_template: typing.Optional[str] = OMIT,
        language: typing.Optional[LanguageCodeEnum] = OMIT,
        name: typing.Optional[str] = OMIT,
        subject_template: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CustomTemplateDataSchema]:
        """
        Update custom template by ID

        Parameters
        ----------
        template_id : str

        body_template : typing.Optional[str]
            Jinja2 compatible string with email body

        language : typing.Optional[LanguageCodeEnum]
            Lowercase ISO code of language

        name : typing.Optional[str]
            Custom template name

        subject_template : typing.Optional[str]
            Jinja2 compatible string with email subject

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CustomTemplateDataSchema]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"mail_templates/{jsonable_encoder(template_id)}",
            method="PATCH",
            json={
                "body_template": body_template,
                "language": language,
                "name": name,
                "subject_template": subject_template,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomTemplateDataSchema,
                    parse_obj_as(
                        type_=CustomTemplateDataSchema,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def make_default_by_id(
        self, template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CustomTemplateDataSchema]:
        """
        Make template default

        Parameters
        ----------
        template_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CustomTemplateDataSchema]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"mail_templates/{jsonable_encoder(template_id)}/make_default",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomTemplateDataSchema,
                    parse_obj_as(
                        type_=CustomTemplateDataSchema,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
