# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.domain_list_response import DomainListResponse
from ..types.domain_response import DomainResponse
from ..types.verify_response import VerifyResponse
from .raw_client import AsyncRawMailboxDomainsClient, RawMailboxDomainsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MailboxDomainsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMailboxDomainsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMailboxDomainsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMailboxDomainsClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> DomainListResponse:
        """
        Get all domains owned by partner_id

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DomainListResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.mailbox_domains.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def create(self, *, domain: str, request_options: typing.Optional[RequestOptions] = None) -> DomainResponse:
        """
        Create domain for the partner_id

        Parameters
        ----------
        domain : str
            The domain name, such as `mail.mycompany.com`. Can contain only alphanumeric characters (A..Z a..z 0..9), dots (.), and hyphens (-). Each segment of the domain name must start and end with either a letter or a digit.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DomainResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.mailbox_domains.create(domain='domain', )
        """
        _response = self._raw_client.create(domain=domain, request_options=request_options)
        return _response.data

    def delete_by_id(self, domain_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete domain for the partner_id

        Parameters
        ----------
        domain_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.mailbox_domains.delete_by_id(domain_id='domain_id', )
        """
        _response = self._raw_client.delete_by_id(domain_id, request_options=request_options)
        return _response.data

    def verify_by_id(
        self, domain_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> VerifyResponse:
        """
        Verify domain for the partner_id

        Parameters
        ----------
        domain_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VerifyResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.mailbox_domains.verify_by_id(domain_id='domain_id', )
        """
        _response = self._raw_client.verify_by_id(domain_id, request_options=request_options)
        return _response.data


class AsyncMailboxDomainsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMailboxDomainsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMailboxDomainsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMailboxDomainsClient
        """
        return self._raw_client

    async def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> DomainListResponse:
        """
        Get all domains owned by partner_id

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DomainListResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.mailbox_domains.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def create(self, *, domain: str, request_options: typing.Optional[RequestOptions] = None) -> DomainResponse:
        """
        Create domain for the partner_id

        Parameters
        ----------
        domain : str
            The domain name, such as `mail.mycompany.com`. Can contain only alphanumeric characters (A..Z a..z 0..9), dots (.), and hyphens (-). Each segment of the domain name must start and end with either a letter or a digit.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DomainResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.mailbox_domains.create(domain='domain', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(domain=domain, request_options=request_options)
        return _response.data

    async def delete_by_id(self, domain_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete domain for the partner_id

        Parameters
        ----------
        domain_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.mailbox_domains.delete_by_id(domain_id='domain_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(domain_id, request_options=request_options)
        return _response.data

    async def verify_by_id(
        self, domain_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> VerifyResponse:
        """
        Verify domain for the partner_id

        Parameters
        ----------
        domain_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VerifyResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.mailbox_domains.verify_by_id(domain_id='domain_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.verify_by_id(domain_id, request_options=request_options)
        return _response.data
