# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.mailbox_data_response import MailboxDataResponse
from ..types.mailbox_response import MailboxResponse
from .raw_client import AsyncRawMailboxesClient, RawMailboxesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MailboxesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMailboxesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMailboxesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMailboxesClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> MailboxDataResponse:
        """
        Get all mailboxes owned by Entity

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MailboxDataResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.mailboxes.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def create(
        self, *, mailbox_domain_id: str, mailbox_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> MailboxResponse:
        """
        Create a new mailbox

        Parameters
        ----------
        mailbox_domain_id : str

        mailbox_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MailboxResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.mailboxes.create(mailbox_domain_id='mailbox_domain_id', mailbox_name='mailbox_name', )
        """
        _response = self._raw_client.create(
            mailbox_domain_id=mailbox_domain_id, mailbox_name=mailbox_name, request_options=request_options
        )
        return _response.data

    def search(
        self, *, entity_ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> MailboxDataResponse:
        """
        Get all mailboxes owned by Entity

        Parameters
        ----------
        entity_ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MailboxDataResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.mailboxes.search(entity_ids=['entity_ids'], )
        """
        _response = self._raw_client.search(entity_ids=entity_ids, request_options=request_options)
        return _response.data

    def delete_by_id(self, mailbox_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete mailbox

        Parameters
        ----------
        mailbox_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.mailboxes.delete_by_id(mailbox_id='mailbox_id', )
        """
        _response = self._raw_client.delete_by_id(mailbox_id, request_options=request_options)
        return _response.data


class AsyncMailboxesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMailboxesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMailboxesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMailboxesClient
        """
        return self._raw_client

    async def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> MailboxDataResponse:
        """
        Get all mailboxes owned by Entity

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MailboxDataResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.mailboxes.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def create(
        self, *, mailbox_domain_id: str, mailbox_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> MailboxResponse:
        """
        Create a new mailbox

        Parameters
        ----------
        mailbox_domain_id : str

        mailbox_name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MailboxResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.mailboxes.create(mailbox_domain_id='mailbox_domain_id', mailbox_name='mailbox_name', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            mailbox_domain_id=mailbox_domain_id, mailbox_name=mailbox_name, request_options=request_options
        )
        return _response.data

    async def search(
        self, *, entity_ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> MailboxDataResponse:
        """
        Get all mailboxes owned by Entity

        Parameters
        ----------
        entity_ids : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MailboxDataResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.mailboxes.search(entity_ids=['entity_ids'], )
        asyncio.run(main())
        """
        _response = await self._raw_client.search(entity_ids=entity_ids, request_options=request_options)
        return _response.data

    async def delete_by_id(self, mailbox_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete mailbox

        Parameters
        ----------
        mailbox_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.mailboxes.delete_by_id(mailbox_id='mailbox_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(mailbox_id, request_options=request_options)
        return _response.data
