# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.unit_list_response import UnitListResponse
from ..types.unit_response import UnitResponse
from .raw_client import AsyncRawMeasureUnitsClient, RawMeasureUnitsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MeasureUnitsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMeasureUnitsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMeasureUnitsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMeasureUnitsClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> UnitListResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UnitListResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.measure_units.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UnitResponse:
        """
        Parameters
        ----------
        name : str

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UnitResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.measure_units.create(name='name', )
        """
        _response = self._raw_client.create(name=name, description=description, request_options=request_options)
        return _response.data

    def get_by_id(self, unit_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> UnitResponse:
        """
        Parameters
        ----------
        unit_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UnitResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.measure_units.get_by_id(unit_id='unit_id', )
        """
        _response = self._raw_client.get_by_id(unit_id, request_options=request_options)
        return _response.data

    def delete_by_id(self, unit_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        unit_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.measure_units.delete_by_id(unit_id='unit_id', )
        """
        _response = self._raw_client.delete_by_id(unit_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        unit_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UnitResponse:
        """
        Parameters
        ----------
        unit_id : str

        description : typing.Optional[str]

        name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UnitResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.measure_units.update_by_id(unit_id='unit_id', )
        """
        _response = self._raw_client.update_by_id(
            unit_id, description=description, name=name, request_options=request_options
        )
        return _response.data


class AsyncMeasureUnitsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMeasureUnitsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMeasureUnitsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMeasureUnitsClient
        """
        return self._raw_client

    async def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> UnitListResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UnitListResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.measure_units.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UnitResponse:
        """
        Parameters
        ----------
        name : str

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UnitResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.measure_units.create(name='name', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(name=name, description=description, request_options=request_options)
        return _response.data

    async def get_by_id(self, unit_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> UnitResponse:
        """
        Parameters
        ----------
        unit_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UnitResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.measure_units.get_by_id(unit_id='unit_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(unit_id, request_options=request_options)
        return _response.data

    async def delete_by_id(self, unit_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        unit_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.measure_units.delete_by_id(unit_id='unit_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(unit_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        unit_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UnitResponse:
        """
        Parameters
        ----------
        unit_id : str

        description : typing.Optional[str]

        name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UnitResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.measure_units.update_by_id(unit_id='unit_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            unit_id, description=description, name=name, request_options=request_options
        )
        return _response.data
