# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .. import core
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.cursor_fields import CursorFields
from ..types.ocr_document_type_enum import OcrDocumentTypeEnum
from ..types.ocr_task_response_schema import OcrTaskResponseSchema
from ..types.ocr_task_status import OcrTaskStatus
from ..types.ocr_tasks_pagination_response import OcrTasksPaginationResponse
from ..types.order_enum import OrderEnum
from .raw_client import AsyncRawOcrClient, RawOcrClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OcrClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawOcrClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawOcrClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawOcrClient
        """
        return self._raw_client

    def get_ocr_tasks(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[CursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        status: typing.Optional[OcrTaskStatus] = None,
        document_type: typing.Optional[OcrDocumentTypeEnum] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OcrTasksPaginationResponse:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[CursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        created_at_gt : typing.Optional[dt.datetime]
            Return only ocr tasks created after the specified date and time. The value must be in the ISO 8601 format YYYY-MM-DDThh:mm[:ss[.ffffff]][Z|±hh:mm].

        created_at_lt : typing.Optional[dt.datetime]
            Return only ocr tasks created in Monite before the specified date and time.

        created_at_gte : typing.Optional[dt.datetime]
            Return only ocr tasks created on or after the specified date and time.

        created_at_lte : typing.Optional[dt.datetime]
            Return only ocr tasks created before or on the specified date and time.

        status : typing.Optional[OcrTaskStatus]
            Return only ocr tasks that have the specified status.

        document_type : typing.Optional[OcrDocumentTypeEnum]
            Return only OCR tasks related to documents of a specific type.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only ocr tasks with specified IDs. Valid but nonexistent IDs do not raise errors but produce no results.

            To specify multiple IDs, repeat this parameter for each value: `id__in=<id1>&id__in=<id2>`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OcrTasksPaginationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.ocr.get_ocr_tasks()
        """
        _response = self._raw_client.get_ocr_tasks(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            status=status,
            document_type=document_type,
            id_in=id_in,
            request_options=request_options,
        )
        return _response.data

    def post_ocr_tasks(
        self,
        *,
        file_url: str,
        document_type: typing.Optional[OcrDocumentTypeEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OcrTaskResponseSchema:
        """
        Parameters
        ----------
        file_url : str

        document_type : typing.Optional[OcrDocumentTypeEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OcrTaskResponseSchema
            OCR task has been accepted for execution.

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.ocr.post_ocr_tasks(file_url='file_url', )
        """
        _response = self._raw_client.post_ocr_tasks(
            file_url=file_url, document_type=document_type, request_options=request_options
        )
        return _response.data

    def post_ocr_tasks_upload_from_file(
        self,
        *,
        file: core.File,
        document_type: typing.Optional[OcrDocumentTypeEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OcrTaskResponseSchema:
        """
        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        document_type : typing.Optional[OcrDocumentTypeEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OcrTaskResponseSchema
            OCR task has been accepted for execution.

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.ocr.post_ocr_tasks_upload_from_file()
        """
        _response = self._raw_client.post_ocr_tasks_upload_from_file(
            file=file, document_type=document_type, request_options=request_options
        )
        return _response.data

    def get_ocr_tasks_id(
        self, task_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> OcrTaskResponseSchema:
        """
        Parameters
        ----------
        task_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OcrTaskResponseSchema
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.ocr.get_ocr_tasks_id(task_id='task_id', )
        """
        _response = self._raw_client.get_ocr_tasks_id(task_id, request_options=request_options)
        return _response.data


class AsyncOcrClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawOcrClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawOcrClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawOcrClient
        """
        return self._raw_client

    async def get_ocr_tasks(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[CursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        status: typing.Optional[OcrTaskStatus] = None,
        document_type: typing.Optional[OcrDocumentTypeEnum] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OcrTasksPaginationResponse:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[CursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        created_at_gt : typing.Optional[dt.datetime]
            Return only ocr tasks created after the specified date and time. The value must be in the ISO 8601 format YYYY-MM-DDThh:mm[:ss[.ffffff]][Z|±hh:mm].

        created_at_lt : typing.Optional[dt.datetime]
            Return only ocr tasks created in Monite before the specified date and time.

        created_at_gte : typing.Optional[dt.datetime]
            Return only ocr tasks created on or after the specified date and time.

        created_at_lte : typing.Optional[dt.datetime]
            Return only ocr tasks created before or on the specified date and time.

        status : typing.Optional[OcrTaskStatus]
            Return only ocr tasks that have the specified status.

        document_type : typing.Optional[OcrDocumentTypeEnum]
            Return only OCR tasks related to documents of a specific type.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only ocr tasks with specified IDs. Valid but nonexistent IDs do not raise errors but produce no results.

            To specify multiple IDs, repeat this parameter for each value: `id__in=<id1>&id__in=<id2>`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OcrTasksPaginationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.ocr.get_ocr_tasks()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_ocr_tasks(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            status=status,
            document_type=document_type,
            id_in=id_in,
            request_options=request_options,
        )
        return _response.data

    async def post_ocr_tasks(
        self,
        *,
        file_url: str,
        document_type: typing.Optional[OcrDocumentTypeEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OcrTaskResponseSchema:
        """
        Parameters
        ----------
        file_url : str

        document_type : typing.Optional[OcrDocumentTypeEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OcrTaskResponseSchema
            OCR task has been accepted for execution.

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.ocr.post_ocr_tasks(file_url='file_url', )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_ocr_tasks(
            file_url=file_url, document_type=document_type, request_options=request_options
        )
        return _response.data

    async def post_ocr_tasks_upload_from_file(
        self,
        *,
        file: core.File,
        document_type: typing.Optional[OcrDocumentTypeEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OcrTaskResponseSchema:
        """
        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        document_type : typing.Optional[OcrDocumentTypeEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OcrTaskResponseSchema
            OCR task has been accepted for execution.

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.ocr.post_ocr_tasks_upload_from_file()
        asyncio.run(main())
        """
        _response = await self._raw_client.post_ocr_tasks_upload_from_file(
            file=file, document_type=document_type, request_options=request_options
        )
        return _response.data

    async def get_ocr_tasks_id(
        self, task_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> OcrTaskResponseSchema:
        """
        Parameters
        ----------
        task_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OcrTaskResponseSchema
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.ocr.get_ocr_tasks_id(task_id='task_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_ocr_tasks_id(task_id, request_options=request_options)
        return _response.data
