# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.all_overdue_reminders_response import AllOverdueRemindersResponse
from ..types.overdue_reminder_response import OverdueReminderResponse
from ..types.overdue_reminder_term import OverdueReminderTerm
from ..types.recipients import Recipients
from .raw_client import AsyncRawOverdueRemindersClient, RawOverdueRemindersClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OverdueRemindersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawOverdueRemindersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawOverdueRemindersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawOverdueRemindersClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> AllOverdueRemindersResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AllOverdueRemindersResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.overdue_reminders.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        name: str,
        recipients: typing.Optional[Recipients] = OMIT,
        terms: typing.Optional[typing.Sequence[OverdueReminderTerm]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OverdueReminderResponse:
        """
        Parameters
        ----------
        name : str

        recipients : typing.Optional[Recipients]

        terms : typing.Optional[typing.Sequence[OverdueReminderTerm]]
            Overdue reminder terms to send for payment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OverdueReminderResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.overdue_reminders.create(name='name', )
        """
        _response = self._raw_client.create(
            name=name, recipients=recipients, terms=terms, request_options=request_options
        )
        return _response.data

    def get_by_id(
        self, overdue_reminder_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> OverdueReminderResponse:
        """
        Parameters
        ----------
        overdue_reminder_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OverdueReminderResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.overdue_reminders.get_by_id(overdue_reminder_id='overdue_reminder_id', )
        """
        _response = self._raw_client.get_by_id(overdue_reminder_id, request_options=request_options)
        return _response.data

    def delete_by_id(
        self, overdue_reminder_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        overdue_reminder_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.overdue_reminders.delete_by_id(overdue_reminder_id='overdue_reminder_id', )
        """
        _response = self._raw_client.delete_by_id(overdue_reminder_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        overdue_reminder_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        recipients: typing.Optional[Recipients] = OMIT,
        terms: typing.Optional[typing.Sequence[OverdueReminderTerm]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OverdueReminderResponse:
        """
        Parameters
        ----------
        overdue_reminder_id : str

        name : typing.Optional[str]

        recipients : typing.Optional[Recipients]

        terms : typing.Optional[typing.Sequence[OverdueReminderTerm]]
            Overdue reminder terms to send for payment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OverdueReminderResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.overdue_reminders.update_by_id(overdue_reminder_id='overdue_reminder_id', )
        """
        _response = self._raw_client.update_by_id(
            overdue_reminder_id, name=name, recipients=recipients, terms=terms, request_options=request_options
        )
        return _response.data


class AsyncOverdueRemindersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawOverdueRemindersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawOverdueRemindersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawOverdueRemindersClient
        """
        return self._raw_client

    async def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> AllOverdueRemindersResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AllOverdueRemindersResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.overdue_reminders.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        name: str,
        recipients: typing.Optional[Recipients] = OMIT,
        terms: typing.Optional[typing.Sequence[OverdueReminderTerm]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OverdueReminderResponse:
        """
        Parameters
        ----------
        name : str

        recipients : typing.Optional[Recipients]

        terms : typing.Optional[typing.Sequence[OverdueReminderTerm]]
            Overdue reminder terms to send for payment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OverdueReminderResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.overdue_reminders.create(name='name', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name, recipients=recipients, terms=terms, request_options=request_options
        )
        return _response.data

    async def get_by_id(
        self, overdue_reminder_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> OverdueReminderResponse:
        """
        Parameters
        ----------
        overdue_reminder_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OverdueReminderResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.overdue_reminders.get_by_id(overdue_reminder_id='overdue_reminder_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(overdue_reminder_id, request_options=request_options)
        return _response.data

    async def delete_by_id(
        self, overdue_reminder_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        overdue_reminder_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.overdue_reminders.delete_by_id(overdue_reminder_id='overdue_reminder_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(overdue_reminder_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        overdue_reminder_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        recipients: typing.Optional[Recipients] = OMIT,
        terms: typing.Optional[typing.Sequence[OverdueReminderTerm]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> OverdueReminderResponse:
        """
        Parameters
        ----------
        overdue_reminder_id : str

        name : typing.Optional[str]

        recipients : typing.Optional[Recipients]

        terms : typing.Optional[typing.Sequence[OverdueReminderTerm]]
            Overdue reminder terms to send for payment

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        OverdueReminderResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.overdue_reminders.update_by_id(overdue_reminder_id='overdue_reminder_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            overdue_reminder_id, name=name, recipients=recipients, terms=terms, request_options=request_options
        )
        return _response.data
