# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.api_version import ApiVersion
from ..types.currency_settings_input import CurrencySettingsInput
from ..types.mail_settings import MailSettings
from ..types.partner_project_settings_payload_output import PartnerProjectSettingsPayloadOutput
from ..types.payable_settings import PayableSettings
from ..types.payments_settings_input import PaymentsSettingsInput
from ..types.receivable_settings import ReceivableSettings
from ..types.unit import Unit
from .raw_client import AsyncRawPartnerSettingsClient, RawPartnerSettingsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PartnerSettingsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPartnerSettingsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPartnerSettingsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPartnerSettingsClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> PartnerProjectSettingsPayloadOutput:
        """
        Retrieve all settings for this partner.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PartnerProjectSettingsPayloadOutput
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.partner_settings.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def update(
        self,
        *,
        currency: typing.Optional[CurrencySettingsInput] = OMIT,
        payable: typing.Optional[PayableSettings] = OMIT,
        receivable: typing.Optional[ReceivableSettings] = OMIT,
        mail: typing.Optional[MailSettings] = OMIT,
        commercial_conditions: typing.Optional[typing.Sequence[str]] = OMIT,
        units: typing.Optional[typing.Sequence[Unit]] = OMIT,
        website: typing.Optional[str] = OMIT,
        default_role: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        payments: typing.Optional[PaymentsSettingsInput] = OMIT,
        api_version: typing.Optional[ApiVersion] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PartnerProjectSettingsPayloadOutput:
        """
        Change the specified fields with the provided values.

        Parameters
        ----------
        currency : typing.Optional[CurrencySettingsInput]
            Custom currency exchange rates.

        payable : typing.Optional[PayableSettings]
            Settings for the payables module.

        receivable : typing.Optional[ReceivableSettings]
            Settings for the receivables module.

        mail : typing.Optional[MailSettings]
            Settings for email and mailboxes.

        commercial_conditions : typing.Optional[typing.Sequence[str]]
            Commercial conditions for receivables.

        units : typing.Optional[typing.Sequence[Unit]]
            Measurement units.

        website : typing.Optional[str]

        default_role : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A default role to provision upon new entity creation.

        payments : typing.Optional[PaymentsSettingsInput]
            Settings for the payments module.

        api_version : typing.Optional[ApiVersion]
            Default API version for partner.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PartnerProjectSettingsPayloadOutput
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.partner_settings.update()
        """
        _response = self._raw_client.update(
            currency=currency,
            payable=payable,
            receivable=receivable,
            mail=mail,
            commercial_conditions=commercial_conditions,
            units=units,
            website=website,
            default_role=default_role,
            payments=payments,
            api_version=api_version,
            request_options=request_options,
        )
        return _response.data


class AsyncPartnerSettingsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPartnerSettingsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPartnerSettingsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPartnerSettingsClient
        """
        return self._raw_client

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PartnerProjectSettingsPayloadOutput:
        """
        Retrieve all settings for this partner.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PartnerProjectSettingsPayloadOutput
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.partner_settings.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def update(
        self,
        *,
        currency: typing.Optional[CurrencySettingsInput] = OMIT,
        payable: typing.Optional[PayableSettings] = OMIT,
        receivable: typing.Optional[ReceivableSettings] = OMIT,
        mail: typing.Optional[MailSettings] = OMIT,
        commercial_conditions: typing.Optional[typing.Sequence[str]] = OMIT,
        units: typing.Optional[typing.Sequence[Unit]] = OMIT,
        website: typing.Optional[str] = OMIT,
        default_role: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        payments: typing.Optional[PaymentsSettingsInput] = OMIT,
        api_version: typing.Optional[ApiVersion] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PartnerProjectSettingsPayloadOutput:
        """
        Change the specified fields with the provided values.

        Parameters
        ----------
        currency : typing.Optional[CurrencySettingsInput]
            Custom currency exchange rates.

        payable : typing.Optional[PayableSettings]
            Settings for the payables module.

        receivable : typing.Optional[ReceivableSettings]
            Settings for the receivables module.

        mail : typing.Optional[MailSettings]
            Settings for email and mailboxes.

        commercial_conditions : typing.Optional[typing.Sequence[str]]
            Commercial conditions for receivables.

        units : typing.Optional[typing.Sequence[Unit]]
            Measurement units.

        website : typing.Optional[str]

        default_role : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A default role to provision upon new entity creation.

        payments : typing.Optional[PaymentsSettingsInput]
            Settings for the payments module.

        api_version : typing.Optional[ApiVersion]
            Default API version for partner.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PartnerProjectSettingsPayloadOutput
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.partner_settings.update()
        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            currency=currency,
            payable=payable,
            receivable=receivable,
            mail=mail,
            commercial_conditions=commercial_conditions,
            units=units,
            website=website,
            default_role=default_role,
            payments=payments,
            api_version=api_version,
            request_options=request_options,
        )
        return _response.data
