# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.bad_request_error import BadRequestError
from ..errors.internal_server_error import InternalServerError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.api_version import ApiVersion
from ..types.currency_settings_input import CurrencySettingsInput
from ..types.mail_settings import MailSettings
from ..types.partner_project_settings_payload_output import PartnerProjectSettingsPayloadOutput
from ..types.payable_settings import PayableSettings
from ..types.payments_settings_input import PaymentsSettingsInput
from ..types.receivable_settings import ReceivableSettings
from ..types.unit import Unit

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawPartnerSettingsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PartnerProjectSettingsPayloadOutput]:
        """
        Retrieve all settings for this partner.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PartnerProjectSettingsPayloadOutput]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "settings",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PartnerProjectSettingsPayloadOutput,
                    parse_obj_as(
                        type_=PartnerProjectSettingsPayloadOutput,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        *,
        currency: typing.Optional[CurrencySettingsInput] = OMIT,
        payable: typing.Optional[PayableSettings] = OMIT,
        receivable: typing.Optional[ReceivableSettings] = OMIT,
        mail: typing.Optional[MailSettings] = OMIT,
        commercial_conditions: typing.Optional[typing.Sequence[str]] = OMIT,
        units: typing.Optional[typing.Sequence[Unit]] = OMIT,
        website: typing.Optional[str] = OMIT,
        default_role: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        payments: typing.Optional[PaymentsSettingsInput] = OMIT,
        api_version: typing.Optional[ApiVersion] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PartnerProjectSettingsPayloadOutput]:
        """
        Change the specified fields with the provided values.

        Parameters
        ----------
        currency : typing.Optional[CurrencySettingsInput]
            Custom currency exchange rates.

        payable : typing.Optional[PayableSettings]
            Settings for the payables module.

        receivable : typing.Optional[ReceivableSettings]
            Settings for the receivables module.

        mail : typing.Optional[MailSettings]
            Settings for email and mailboxes.

        commercial_conditions : typing.Optional[typing.Sequence[str]]
            Commercial conditions for receivables.

        units : typing.Optional[typing.Sequence[Unit]]
            Measurement units.

        website : typing.Optional[str]

        default_role : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A default role to provision upon new entity creation.

        payments : typing.Optional[PaymentsSettingsInput]
            Settings for the payments module.

        api_version : typing.Optional[ApiVersion]
            Default API version for partner.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PartnerProjectSettingsPayloadOutput]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "settings",
            method="PATCH",
            json={
                "currency": convert_and_respect_annotation_metadata(
                    object_=currency, annotation=CurrencySettingsInput, direction="write"
                ),
                "payable": convert_and_respect_annotation_metadata(
                    object_=payable, annotation=PayableSettings, direction="write"
                ),
                "receivable": convert_and_respect_annotation_metadata(
                    object_=receivable, annotation=ReceivableSettings, direction="write"
                ),
                "mail": convert_and_respect_annotation_metadata(
                    object_=mail, annotation=MailSettings, direction="write"
                ),
                "commercial_conditions": commercial_conditions,
                "units": convert_and_respect_annotation_metadata(
                    object_=units, annotation=typing.Sequence[Unit], direction="write"
                ),
                "website": website,
                "default_role": default_role,
                "payments": convert_and_respect_annotation_metadata(
                    object_=payments, annotation=PaymentsSettingsInput, direction="write"
                ),
                "api_version": api_version,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PartnerProjectSettingsPayloadOutput,
                    parse_obj_as(
                        type_=PartnerProjectSettingsPayloadOutput,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawPartnerSettingsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PartnerProjectSettingsPayloadOutput]:
        """
        Retrieve all settings for this partner.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PartnerProjectSettingsPayloadOutput]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "settings",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PartnerProjectSettingsPayloadOutput,
                    parse_obj_as(
                        type_=PartnerProjectSettingsPayloadOutput,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        *,
        currency: typing.Optional[CurrencySettingsInput] = OMIT,
        payable: typing.Optional[PayableSettings] = OMIT,
        receivable: typing.Optional[ReceivableSettings] = OMIT,
        mail: typing.Optional[MailSettings] = OMIT,
        commercial_conditions: typing.Optional[typing.Sequence[str]] = OMIT,
        units: typing.Optional[typing.Sequence[Unit]] = OMIT,
        website: typing.Optional[str] = OMIT,
        default_role: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        payments: typing.Optional[PaymentsSettingsInput] = OMIT,
        api_version: typing.Optional[ApiVersion] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PartnerProjectSettingsPayloadOutput]:
        """
        Change the specified fields with the provided values.

        Parameters
        ----------
        currency : typing.Optional[CurrencySettingsInput]
            Custom currency exchange rates.

        payable : typing.Optional[PayableSettings]
            Settings for the payables module.

        receivable : typing.Optional[ReceivableSettings]
            Settings for the receivables module.

        mail : typing.Optional[MailSettings]
            Settings for email and mailboxes.

        commercial_conditions : typing.Optional[typing.Sequence[str]]
            Commercial conditions for receivables.

        units : typing.Optional[typing.Sequence[Unit]]
            Measurement units.

        website : typing.Optional[str]

        default_role : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            A default role to provision upon new entity creation.

        payments : typing.Optional[PaymentsSettingsInput]
            Settings for the payments module.

        api_version : typing.Optional[ApiVersion]
            Default API version for partner.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PartnerProjectSettingsPayloadOutput]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "settings",
            method="PATCH",
            json={
                "currency": convert_and_respect_annotation_metadata(
                    object_=currency, annotation=CurrencySettingsInput, direction="write"
                ),
                "payable": convert_and_respect_annotation_metadata(
                    object_=payable, annotation=PayableSettings, direction="write"
                ),
                "receivable": convert_and_respect_annotation_metadata(
                    object_=receivable, annotation=ReceivableSettings, direction="write"
                ),
                "mail": convert_and_respect_annotation_metadata(
                    object_=mail, annotation=MailSettings, direction="write"
                ),
                "commercial_conditions": commercial_conditions,
                "units": convert_and_respect_annotation_metadata(
                    object_=units, annotation=typing.Sequence[Unit], direction="write"
                ),
                "website": website,
                "default_role": default_role,
                "payments": convert_and_respect_annotation_metadata(
                    object_=payments, annotation=PaymentsSettingsInput, direction="write"
                ),
                "api_version": api_version,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PartnerProjectSettingsPayloadOutput,
                    parse_obj_as(
                        type_=PartnerProjectSettingsPayloadOutput,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
